/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.cache.config;

import com.uniapis.cache.Cache;
import com.uniapis.cache.CacheManager;
import com.uniapis.cache.config.RedisPoolProperties;
import com.uniapis.cache.config.RedisProperties;
import com.uniapis.cache.redis.RedisCache;
import com.uniapis.utils.StrUtils;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={RedisCache.class})
@EnableConfigurationProperties(value={RedisPoolProperties.class, RedisProperties.class})
@AutoConfigureAfter(value={RedisPoolProperties.class, RedisProperties.class})
@ComponentScan(basePackages={"com.uniapis.cache"})
public class RedisConfig {
    @Autowired
    private RedisProperties redisProp;

    @Bean
    @ConditionalOnProperty(name={"spring.redis.mode"}, havingValue="cluster")
    public RedisConnectionFactory redisConnectionFactory4Cluster() {
        RedisClusterConfiguration config = new RedisClusterConfiguration();
        HashSet<String> serviceRedisNodes = new HashSet<String>(Arrays.asList(this.redisProp.getCluster().getNodes().split(",")));
        HashSet<RedisNode> clusterNodes = new HashSet<RedisNode>(serviceRedisNodes.size());
        for (String node : serviceRedisNodes) {
            String[] ipAndPort = StringUtils.split((String)node, (String)":");
            String ip = ipAndPort[0];
            Integer port = Integer.parseInt(ipAndPort[1]);
            clusterNodes.add(new RedisNode(ip, port.intValue()));
        }
        config.setClusterNodes(clusterNodes);
        if (!StrUtils.isNull((Object)this.redisProp.getPassword())) {
            config.setPassword(RedisPassword.of((String)this.redisProp.getPassword()));
        }
        LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder lettucePool = LettucePoolingClientConfiguration.builder();
        GenericObjectPoolConfig pool = new GenericObjectPoolConfig();
        pool.setMaxIdle(Integer.parseInt(this.redisProp.getPool().getMaxIdle()));
        pool.setMaxTotal(Integer.parseInt(this.redisProp.getPool().getMaxActive()));
        pool.setMinIdle(Integer.parseInt(this.redisProp.getPool().getMinIdle()));
        lettucePool.poolConfig(pool);
        LettuceConnectionFactory factory = new LettuceConnectionFactory(config, (LettuceClientConfiguration)lettucePool.build());
        if (StrUtils.isNull((Object)this.redisProp.getDatabase())) {
            factory.setDatabase(Integer.parseInt(this.redisProp.getDatabase()));
        }
        return factory;
    }

    @Bean
    @ConditionalOnProperty(name={"spring.redis.mode"}, havingValue="single")
    public RedisConnectionFactory redisConnectionFactory2Single() {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        config.setHostName(this.redisProp.getHost());
        config.setPort(Integer.parseInt(this.redisProp.getPort()));
        if (!StrUtils.isNull((Object)this.redisProp.getPassword())) {
            config.setPassword(RedisPassword.of((String)this.redisProp.getPassword()));
        }
        config.setDatabase(Integer.parseInt(this.redisProp.getDatabase()));
        LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder lettucePool = LettucePoolingClientConfiguration.builder();
        GenericObjectPoolConfig pool = new GenericObjectPoolConfig();
        pool.setMaxIdle(Integer.parseInt(this.redisProp.getPool().getMaxIdle()));
        pool.setMaxTotal(Integer.parseInt(this.redisProp.getPool().getMaxActive()));
        pool.setMinIdle(Integer.parseInt(this.redisProp.getPool().getMinIdle()));
        lettucePool.poolConfig(pool);
        return new LettuceConnectionFactory(config, (LettuceClientConfiguration)lettucePool.build());
    }

    @Bean
    @ConditionalOnProperty(name={"spring.redis.mode"}, havingValue="sentinel")
    public RedisConnectionFactory redisConnectionFactory2Sentinel() {
        RedisSentinelConfiguration config = new RedisSentinelConfiguration();
        config.master(this.redisProp.getSentinel().getMaster());
        HashSet redisNodeSet = new HashSet();
        HashSet<String> serviceRedisNodes = new HashSet<String>(Arrays.asList(this.redisProp.getSentinel().getNodes().split(",")));
        serviceRedisNodes.forEach(x -> redisNodeSet.add(new RedisNode(x.split(":")[0], Integer.parseInt(x.split(":")[1]))));
        if (!StrUtils.isNull((Object)this.redisProp.getPassword())) {
            config.setPassword(RedisPassword.of((String)this.redisProp.getPassword()));
        }
        config.setSentinels(redisNodeSet);
        LettucePoolingClientConfiguration.LettucePoolingClientConfigurationBuilder lettucePool = LettucePoolingClientConfiguration.builder();
        GenericObjectPoolConfig pool = new GenericObjectPoolConfig();
        pool.setMaxIdle(Integer.parseInt(this.redisProp.getPool().getMaxIdle()));
        pool.setMaxTotal(Integer.parseInt(this.redisProp.getPool().getMaxActive()));
        pool.setMinIdle(Integer.parseInt(this.redisProp.getPool().getMinIdle()));
        lettucePool.poolConfig(pool);
        return new LettuceConnectionFactory(config, (LettuceClientConfiguration)lettucePool.build());
    }

    @Bean(value={"jedisTemplate"})
    public RedisTemplate redisTemplate(RedisConnectionFactory factory) {
        RedisTemplate redis = new RedisTemplate();
        redis.setConnectionFactory(factory);
        StringRedisSerializer strSerializer = new StringRedisSerializer();
        GenericJackson2JsonRedisSerializer jsonSerializer = new GenericJackson2JsonRedisSerializer();
        redis.setKeySerializer((RedisSerializer)strSerializer);
        redis.setHashKeySerializer((RedisSerializer)strSerializer);
        redis.setValueSerializer((RedisSerializer)jsonSerializer);
        redis.setHashValueSerializer((RedisSerializer)jsonSerializer);
        return redis;
    }

    @Bean(value={"uniapiCacheManager"})
    public CacheManager cacheManager(Cache cache) {
        return new CacheManager(cache);
    }
}

