/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.cache.map;

import com.uniapis.cache.Cache;
import com.uniapis.utils.StrUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component(value="mapCache")
@ConditionalOnProperty(name={"spring.redis.cacheManager"}, havingValue="mapCache")
public class MapCache
implements Cache {
    private static final Map<String, Object> CACHE_MAP = new HashMap<String, Object>();
    private static final Map<String, BlockingQueue<Object>> QUEUE_MAP = new HashMap<String, BlockingQueue<Object>>();

    @Override
    public void put(String key, Object value) {
        CACHE_MAP.put(key, value);
    }

    @Override
    public void put(final String key, Object value, int timeout) {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                CACHE_MAP.remove(key);
            }
        }, timeout * 1000);
        CACHE_MAP.put(key, value);
    }

    @Override
    public Object get(String key) {
        return CACHE_MAP.get(key);
    }

    @Override
    public <T> T get(String key, Class<T> requiredType) {
        Object bean = this.get(key);
        if (bean == null) {
            return null;
        }
        if (requiredType != null && !requiredType.isAssignableFrom(bean.getClass())) {
            throw new BeanNotOfRequiredTypeException(key, requiredType, bean.getClass());
        }
        return (T)bean;
    }

    @Override
    public void remove(String key) {
        CACHE_MAP.remove(key);
    }

    @Override
    public Set<String> keys(String pattern) {
        if (pattern.indexOf("*") > -1) {
            pattern = pattern.replace("*", "");
        }
        if (StrUtils.isNull((Object)pattern)) {
            return CACHE_MAP.keySet();
        }
        HashSet<String> keyList = new HashSet<String>();
        for (String key : CACHE_MAP.keySet()) {
            if (key.indexOf(pattern) < 0) continue;
            keyList.add(key);
        }
        return keyList;
    }

    @Override
    public void put(Map<String, ?> data) {
        CACHE_MAP.putAll(data);
    }

    @Override
    public void putHash(String key, Map<?, ?> value) {
        CACHE_MAP.put(key, value);
    }

    @Override
    public void putHash(String key, String hashKey, Object value) {
        Map<String, Object> map = this.initHash(key);
        map.put(hashKey, value);
        CACHE_MAP.put(key, map);
    }

    @Override
    public Map<?, Object> getHash(String key) {
        return (Map)CACHE_MAP.get(key);
    }

    @Override
    public Object getHash(String key, String hashKey) {
        Map<String, Object> map = this.initHash(key);
        return map.get(hashKey);
    }

    @Override
    public <T> T getHash(String key, String hashKey, Class<T> requiredType) {
        Map<String, Object> map = this.initHash(key);
        return (T)map.get(hashKey);
    }

    @Override
    public void removeHash(String key) {
        CACHE_MAP.remove(key);
    }

    @Override
    public Long hashSize(String key) {
        return this.getHash(key).size();
    }

    @Override
    public void removeHash(String key, Object ... hashKeys) {
        Map<String, Object> map = this.initHash(key);
        for (Object aKey : hashKeys) {
            map.remove(aKey);
        }
    }

    private Map<String, Object> initHash(String key) {
        Map map = null;
        if (CACHE_MAP.containsKey(key) && CACHE_MAP.get(key) instanceof Map) {
            map = (Map)CACHE_MAP.get(key);
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    @Override
    public boolean zAdd(String key, Object value) {
        return false;
    }

    @Override
    public boolean zAdd(String key, Object value, double score) {
        return false;
    }

    @Override
    public Set<Object> zGetByRank(String key, long start, long end) {
        return null;
    }

    @Override
    public Set<Object> zGetByScore(String key, double min, double max) {
        return null;
    }

    @Override
    public Long zRemove(String key, Object ... values) {
        return null;
    }

    @Override
    public Long zRemoveByRank(String key, long start, long end) {
        return null;
    }

    @Override
    public Long zRemoveByScore(String key, double min, double max) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long leftPush(String key, Object value) {
        BlockingQueue<Object> queue;
        if (QUEUE_MAP.get(key) == null) {
            Map<String, BlockingQueue<Object>> map = QUEUE_MAP;
            synchronized (map) {
                if (QUEUE_MAP.get(key) == null) {
                    QUEUE_MAP.put(key, new ArrayBlockingQueue(200, true));
                }
            }
        }
        if ((queue = QUEUE_MAP.get(key)).offer(value)) {
            return queue.size();
        }
        return -1L;
    }

    @Override
    public Long rightPush(String key, Object value) {
        throw new RuntimeException("\u672a\u5b9e\u73b0\u65b9\u6cd5");
    }

    @Override
    public Object leftPop(String key) {
        throw new RuntimeException("\u672a\u5b9e\u73b0\u65b9\u6cd5");
    }

    @Override
    public Object blockLeftPop(String key) {
        throw new RuntimeException("\u672a\u5b9e\u73b0\u65b9\u6cd5");
    }

    @Override
    public Object blockLeftPop(String key, long timeout) {
        throw new RuntimeException("\u672a\u5b9e\u73b0\u65b9\u6cd5");
    }

    @Override
    public Object rightPop(String key) {
        BlockingQueue<Object> queue = QUEUE_MAP.get(key);
        if (queue == null) {
            return null;
        }
        return queue.poll();
    }

    @Override
    public Object blockRightPop(String key) {
        BlockingQueue<Object> queue = QUEUE_MAP.get(key);
        if (queue == null) {
            return null;
        }
        try {
            return queue.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object blockRightPop(String key, long timeout) {
        BlockingQueue<Object> queue = QUEUE_MAP.get(key);
        if (queue == null) {
            return null;
        }
        try {
            return queue.poll(timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Long listSize(String key) {
        BlockingQueue<Object> queue = QUEUE_MAP.get(key);
        if (queue == null) {
            return -1L;
        }
        return queue.size();
    }

    @Override
    public boolean expire(final String key, long timeout) {
        Timer timer = new Timer();
        TimerTask timerTask = null;
        timerTask = CACHE_MAP.containsKey(key) ? new TimerTask(){

            @Override
            public void run() {
                CACHE_MAP.remove(key);
            }
        } : new TimerTask(){

            @Override
            public void run() {
                QUEUE_MAP.remove(key);
            }
        };
        timer.schedule(timerTask, timeout * 1000L);
        return true;
    }

    @Override
    public List<Object> range(String key, long start, long end) {
        return null;
    }

    @Override
    public void listRemove(String key, long count, Object value) {
    }

    @Override
    public synchronized long incr(String key, long delta) {
        if (CACHE_MAP.containsKey(key)) {
            long value = Long.parseLong(CACHE_MAP.get(key).toString());
            CACHE_MAP.put(key, value += delta);
            return value;
        }
        CACHE_MAP.put(key, delta);
        return delta;
    }

    @Override
    public synchronized long decr(String key, long delta) {
        if (CACHE_MAP.containsKey(key)) {
            long value = Long.parseLong(CACHE_MAP.get(key).toString());
            CACHE_MAP.put(key, value -= delta);
            return value;
        }
        CACHE_MAP.put(key, 0L - delta);
        return 0L - delta;
    }

    @Override
    public void putSimple(String key, String value) {
        this.put(key, value);
    }

    @Override
    public void putSimple(String key, String value, int timeout) {
        this.put(key, value, timeout);
    }

    @Override
    public Object getSimple(String key) {
        return this.get(key);
    }
}

