/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.cache.redis;

import com.uniapis.cache.Cache;
import com.uniapis.logger.Ulog;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Component;

@Component(value="redisCache")
@ConditionalOnProperty(name={"spring.redis.cacheManager"}, havingValue="redisCache")
public class RedisCache
implements Cache {
    @Autowired
    @Qualifier(value="jedisTemplate")
    private RedisTemplate<String, Object> jedisTemplate;
    private RedisTemplate<String, String> jedisTemplateFCR;
    @Value(value="${spring.redis.host}")
    private String redisHost;

    @Override
    public void put(String key, Object value) {
        this.jedisTemplate.opsForValue().set((Object)key, value);
    }

    @Override
    public void put(String key, Object value, int timeout) {
        this.jedisTemplate.opsForValue().set((Object)key, value, (long)timeout, TimeUnit.SECONDS);
    }

    @Override
    public Object get(String key) {
        this.logRedisHost();
        return this.jedisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public <T> T get(String key, Class<T> requiredType) {
        return (T)this.jedisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public void remove(String key) {
        this.logRedisHost();
        this.jedisTemplate.delete((Object)key);
    }

    @Override
    public Set<String> keys(String pattern) {
        return this.jedisTemplate.keys((Object)pattern);
    }

    @Override
    public void putHash(String key, Map<?, ?> value) {
        this.jedisTemplate.opsForHash().putAll((Object)key, value);
    }

    @Override
    public void putHash(String key, String hashKey, Object value) {
        this.jedisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
    }

    @Override
    public Map<?, Object> getHash(String key) {
        this.logRedisHost();
        return this.jedisTemplate.opsForHash().entries((Object)key);
    }

    @Override
    public Object getHash(String key, String hashKey) {
        this.logRedisHost();
        return this.jedisTemplate.opsForHash().get((Object)key, (Object)hashKey);
    }

    @Override
    public <T> T getHash(String key, String hashKey, Class<T> requiredType) {
        this.logRedisHost();
        return (T)this.jedisTemplate.opsForHash().get((Object)key, (Object)hashKey);
    }

    @Override
    public void removeHash(String key) {
        this.removeHash(key, this.jedisTemplate.opsForHash().keys((Object)key).toArray());
    }

    @Override
    public void removeHash(String key, Object ... hashKeys) {
        if (hashKeys.length <= 0) {
            return;
        }
        this.jedisTemplate.opsForHash().delete((Object)key, hashKeys);
    }

    @Override
    public Long hashSize(String key) {
        return this.jedisTemplate.opsForHash().size((Object)key);
    }

    @Override
    public void put(Map<String, ?> data) {
        this.logRedisHost();
        RedisCallback pipCallBack = connection -> {
            connection.openPipeline();
            RedisSerializer rs = this.jedisTemplate.getKeySerializer();
            RedisSerializer sc = this.jedisTemplate.getValueSerializer();
            for (Map.Entry entry : data.entrySet()) {
                connection.append(rs.serialize(entry.getKey()), sc.serialize(entry.getValue()));
            }
            connection.closePipeline();
            return null;
        };
        this.jedisTemplate.execute(pipCallBack);
    }

    @Override
    public boolean zAdd(String key, Object value) {
        return this.zAdd(key, value, System.currentTimeMillis());
    }

    @Override
    public boolean zAdd(String key, Object value, double score) {
        return this.jedisTemplate.opsForZSet().add((Object)key, value, score);
    }

    @Override
    public Set<Object> zGetByRank(String key, long start, long end) {
        return this.jedisTemplate.opsForZSet().range((Object)key, start, end);
    }

    @Override
    public Set<Object> zGetByScore(String key, double min, double max) {
        return this.jedisTemplate.opsForZSet().rangeByScore((Object)key, min, max);
    }

    @Override
    public Long zRemove(String key, Object ... values) {
        return this.jedisTemplate.opsForZSet().remove((Object)key, values);
    }

    @Override
    public Long zRemoveByRank(String key, long start, long end) {
        return this.jedisTemplate.opsForZSet().removeRange((Object)key, start, end);
    }

    @Override
    public Long zRemoveByScore(String key, double min, double max) {
        return this.jedisTemplate.opsForZSet().removeRangeByScore((Object)key, min, max);
    }

    @Override
    public Long leftPush(String key, Object value) {
        return this.jedisTemplate.opsForList().leftPush((Object)key, value);
    }

    @Override
    public Long rightPush(String key, Object value) {
        return this.jedisTemplate.opsForList().rightPush((Object)key, value);
    }

    @Override
    public Object leftPop(String key) {
        return this.jedisTemplate.opsForList().leftPop((Object)key);
    }

    @Override
    public Object blockLeftPop(String key) {
        return this.blockLeftPop(key, 0L);
    }

    @Override
    public Object blockLeftPop(String key, long timeout) {
        return this.jedisTemplate.opsForList().leftPop((Object)key, timeout, TimeUnit.SECONDS);
    }

    @Override
    public Object rightPop(String key) {
        return this.jedisTemplate.opsForList().rightPop((Object)key);
    }

    @Override
    public Object blockRightPop(String key) {
        return this.blockRightPop(key, 0L);
    }

    @Override
    public Object blockRightPop(String key, long timeout) {
        return this.jedisTemplate.opsForList().rightPop((Object)key, timeout, TimeUnit.SECONDS);
    }

    @Override
    public Long listSize(String key) {
        return this.jedisTemplate.opsForList().size((Object)key);
    }

    @Override
    public List<Object> range(String key, long start, long end) {
        return this.jedisTemplate.opsForList().range((Object)key, start, end);
    }

    @Override
    public void listRemove(String key, long count, Object value) {
        this.jedisTemplate.opsForList().remove((Object)key, count, value);
    }

    public RedisTemplate<String, Object> getJedisTemplate() {
        return this.jedisTemplate;
    }

    public void setJedisTemplate(RedisTemplate<String, Object> jedisTemplate) {
        this.jedisTemplate = jedisTemplate;
    }

    private void logRedisHost() {
        if (Ulog.getLogLevel().intLevel() <= Level.INFO.intLevel()) {
            return;
        }
        System.out.println("redis.host=[" + this.redisHost + "]");
    }

    @Override
    public boolean expire(String key, long timeout) {
        return this.jedisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }

    public RedisTemplate<String, String> getJedisTemplateFCR() {
        return this.jedisTemplateFCR;
    }

    public void setJedisTemplateFCR(RedisTemplate<String, String> jedisTemplateFCR) {
        this.jedisTemplateFCR = jedisTemplateFCR;
    }

    @Override
    public long incr(String key, long delta) {
        return this.jedisTemplateFCR.opsForValue().increment((Object)key, delta);
    }

    @Override
    public long decr(String key, long delta) {
        return this.jedisTemplateFCR.opsForValue().increment((Object)key, -delta);
    }

    @Override
    public void putSimple(String key, String value) {
        this.jedisTemplateFCR.opsForValue().set((Object)key, (Object)value);
    }

    @Override
    public void putSimple(String key, String value, int timeout) {
        this.jedisTemplateFCR.opsForValue().set((Object)key, (Object)value, (long)timeout, TimeUnit.SECONDS);
    }

    @Override
    public Object getSimple(String key) {
        return this.jedisTemplateFCR.opsForValue().get((Object)key);
    }
}

