/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.web.controller;

import com.newtouch.base.model.DsnRulesTemplate;
import com.newtouch.base.param.DelRulesParam;
import com.newtouch.base.param.SaveParams;
import com.newtouch.base.service.RuleService;
import com.newtouch.base.vo.RulesInfoVo;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.utils.JsonUtils;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/ruleController"})
public class RuleController {
    @Autowired
    private RuleService ruleService;

    @RequestMapping(value={"/queryRules.do"})
    public String queryRules(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String ruleName = map.get("rule_name");
        ReturnMsg returnMsg = this.ruleService.queryRules(ruleName);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/queryRulesInfoAndParams.do"})
    public String queryRulesInfoAndParams(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String ruleId = map.get("rule_id");
        ReturnMsg returnMsg = this.ruleService.queryRulesInfoAndParams(ruleId);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/saveRules.do"})
    public String saveRules(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        RulesInfoVo rulesInfoVo = (RulesInfoVo)((Object)JsonUtils.map2Class((Map)param, RulesInfoVo.class));
        ReturnMsg returnMsg = this.ruleService.saveRules(rulesInfoVo);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/delRules.do"})
    public String delRules(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        DelRulesParam rulesReqParam = (DelRulesParam)JsonUtils.map2Class((Map)param, DelRulesParam.class);
        ReturnMsg returnMsg = this.ruleService.delRules(rulesReqParam.getRuleIds());
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/getRuleInfo.do"})
    public String getRuleInfo(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String ruleId = map.get("rule_id");
        ReturnMsg returnMsg = this.ruleService.getRuleInfo(ruleId);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/saveParamList.do"})
    public String saveParamList(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        SaveParams saveParams = (SaveParams)JsonUtils.map2Class((Map)param, SaveParams.class);
        ReturnMsg returnMsg = this.ruleService.saveParamList(saveParams);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/queryAllRule.do"})
    public String queryAllRule() {
        ReturnMsg returnMsg = this.ruleService.queryAllRule();
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/updateUsedRule.do"})
    public String updateUsedRule(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        DsnRulesTemplate dsnRulesTemplate = (DsnRulesTemplate)JsonUtils.map2Class((Map)param, DsnRulesTemplate.class);
        ReturnMsg returnMsg = this.ruleService.updateUsedRule(dsnRulesTemplate);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/exportRules.do"})
    public String exportRules(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String ruleIds = map.get("rule_ids");
        ReturnMsg returnMsg = this.ruleService.exportRules(ruleIds, response);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/uploadRules.do"})
    public String uploadRules(MultipartFile zipFile) {
        ReturnMsg returnMsg = this.ruleService.uploadRules(zipFile);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }
}

