/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.web.controller;

import com.newtouch.base.model.DsnRulesConfig;
import com.newtouch.base.param.ConfigReqParam;
import com.newtouch.base.service.ConfigSettingService;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.utils.JsonUtils;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/configSetting"})
public class ConfigSettingController {
    @Autowired
    private ConfigSettingService configSettingService;

    @RequestMapping(value={"/queryConfigList.do"})
    public String queryConfigList(HttpServletRequest request) {
        ConfigReqParam configReqParam = (ConfigReqParam)RequestUtils.getRequestMap((HttpServletRequest)request, ConfigReqParam.class);
        ReturnMsg returnMsg = this.configSettingService.queryConfigList(configReqParam);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/deleteConfig.do"})
    public String deleteConfig(HttpServletRequest request) {
        String configId = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"config_id");
        ReturnMsg returnMsg = this.configSettingService.deleteConfig(configId);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/queryConfigTreeById.do"})
    public String queryConfigTreeById(HttpServletRequest request) {
        String configId = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"config_id");
        ReturnMsg returnMsg = this.configSettingService.queryConfigTreeById(configId);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/queryConfigDetail.do"})
    public String queryConfigDetail(HttpServletRequest request) {
        String configId = RequestUtils.getRequestMap((HttpServletRequest)request, (String)"config_id");
        ReturnMsg returnMsg = this.configSettingService.queryConfigDetail(configId);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/addOrUpdateConfig.do"})
    public String addOrUpdateConfig(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        DsnRulesConfig dsnRulesConfig = (DsnRulesConfig)JsonUtils.map2Class((Map)param, DsnRulesConfig.class);
        ReturnMsg returnMsg = this.configSettingService.addOrUpdateConfig(dsnRulesConfig);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/addConfig.do"})
    public String addConfig(HttpServletRequest request) {
        DsnRulesConfig dsnRulesConfig = (DsnRulesConfig)RequestUtils.getRequestMap((HttpServletRequest)request, DsnRulesConfig.class);
        ReturnMsg returnMsg = this.configSettingService.addConfig(dsnRulesConfig);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/sortConfig.do"})
    public String sortConfig(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String configId = map.get("config_id");
        String direction = map.get("direction");
        ReturnMsg returnMsg = this.configSettingService.sortConfig(configId, direction);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/queryTreeByGroupType.do"})
    public String queryTreeByGroupType(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String groupType = map.get("group_type");
        String ruleId = map.get("rule_id");
        ReturnMsg returnMsg = this.configSettingService.queryTreeByGroupType(groupType, ruleId);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/queryTreeByConfigId.do"})
    public String queryTreeByConfigId(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        DsnRulesConfig dsnRulesConfig = (DsnRulesConfig)JsonUtils.map2Class((Map)param, DsnRulesConfig.class);
        ReturnMsg returnMsg = this.configSettingService.queryTreeByConfigId(dsnRulesConfig);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/exportRulesConfig.do", "/exportRulesConfig"})
    public void exportRulesConfig(HttpServletRequest request, HttpServletResponse response) {
        this.configSettingService.exportRulesConfig(request, response);
    }

    @RequestMapping(value={"/importRulesConfig.do"})
    public String importRulesConfig(@RequestParam(value="file") MultipartFile file) {
        ReturnMsg msg = this.configSettingService.importRulesConfig(file);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }
}

