/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.service.impl;

import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.DsnRulesConst;
import com.newtouch.base.model.DsnRulesParam;
import com.newtouch.base.param.FkRulesReqParam;
import com.newtouch.base.param.SaveRuleUsedParam;
import com.newtouch.base.service.RuleService;
import com.newtouch.base.service.RuleUsedService;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RuleUsedServiceImpl
implements RuleUsedService {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    private RuleService ruleService;

    @Override
    public ReturnMsg saveRuleUsed(SaveRuleUsedParam saveRuleUsedParam) {
        Return msg = new Return();
        String newRuleId = UUID.uuid();
        if (StrUtils.isNull((Object)saveRuleUsedParam.getRelateFk())) {
            msg.setFailMsg("\u8282\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        this.saveRules(saveRuleUsedParam, newRuleId);
        return msg.setSuccessMsg(new Message("2010005", "\u4fdd\u5b58\u6210\u529f")).msg();
    }

    private ReturnMsg saveRules(SaveRuleUsedParam saveRuleUsedParam, String newRuleId) {
        Return r = new Return();
        if (saveRuleUsedParam == null) {
            r.setFailMsg("\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return r.msg();
        }
        DsnRules ruleNew = new DsnRules();
        BeanUtils.copyProperties((Object)((Object)saveRuleUsedParam), (Object)ruleNew);
        if (StrUtils.isNull((Object)ruleNew.getRuleInfo())) {
            r.setFailMsg("[\u89c4\u5219\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a!");
            return r.msg();
        }
        String ruleExistID = saveRuleUsedParam.getRuleId();
        DsnRules ruleExist = (DsnRules)this.dao.findOne(DsnRules.n().where().addEq(DsnRules.RULE_ID, (Object)ruleExistID).model());
        if (StrUtils.isNull((Object)ruleExist)) {
            if (StrUtils.isNull((Object)ruleExistID)) {
                ruleNew.setRuleId(newRuleId);
            } else {
                ruleNew.setRuleId(ruleExistID);
            }
            ruleNew.setRuleTemplateId(saveRuleUsedParam.getRuleTemplateId());
            ruleNew.setSerno(null);
            ruleNew.setCrtDate(new Date());
            ruleNew.setMdfDate(new Date());
            this.dao.save((AbsModel)ruleNew);
            String ruleId = ruleNew.getRuleId();
            String ruleTemplateId = saveRuleUsedParam.getRuleTemplateId();
            this.ruleService.updateUseNumber(ruleTemplateId);
            if (CollectionUtils.isNotEmpty(saveRuleUsedParam.getParams())) {
                List<DsnRulesParam> params = saveRuleUsedParam.getParams();
                for (DsnRulesParam dsnRulesParam : params) {
                    dsnRulesParam.setSerno(null);
                    dsnRulesParam.setRuleId(ruleId);
                    dsnRulesParam.setCrtDate(new Date());
                    dsnRulesParam.setMdfDate(new Date());
                }
                this.dao.save(params);
            }
            if (CollectionUtils.isNotEmpty(saveRuleUsedParam.getConsts())) {
                List<DsnRulesConst> consts = saveRuleUsedParam.getConsts();
                for (DsnRulesConst dsnRulesConst : consts) {
                    dsnRulesConst.setSerno(null);
                    dsnRulesConst.setRuleId(ruleId);
                    dsnRulesConst.setCrtDate(new Date());
                    dsnRulesConst.setMdfDate(new Date());
                }
                this.dao.save(consts);
            }
        } else {
            if (CollectionUtils.isNotEmpty(saveRuleUsedParam.getParams())) {
                DsnRulesParam dsnRulesParam = new DsnRulesParam();
                dsnRulesParam.where().addEq(DsnRulesParam.RULE_ID, (Object)ruleExist.getRuleId());
                this.dao.delete((AbsModel)dsnRulesParam);
                saveRuleUsedParam.getParams().stream().forEach(o -> o.setRuleId(ruleExist.getRuleId()));
                this.dao.save(saveRuleUsedParam.getParams());
            }
            if (CollectionUtils.isNotEmpty(saveRuleUsedParam.getConsts())) {
                DsnRulesConst dsnRulesConst = new DsnRulesConst();
                dsnRulesConst.where().addEq(DsnRulesConst.RULE_ID, (Object)ruleExist.getRuleId());
                this.dao.delete((AbsModel)dsnRulesConst);
                saveRuleUsedParam.getConsts().stream().forEach(o -> o.setRuleId(ruleExist.getRuleId()));
                this.dao.save(saveRuleUsedParam.getConsts());
            }
            this.dao.delete(DsnRules.n().where().addEq(DsnRules.RULE_ID, (Object)ruleExist.getRuleId()).model());
            this.dao.save((AbsModel)ruleNew);
        }
        return r.msg();
    }

    @Override
    public ReturnMsg delRuleInfo(String relateFk) {
        Return msg = new Return();
        DsnRules ruleNo = (DsnRules)this.dao.findOne(DsnRules.n().where().addEq(DsnRules.RELATE_FK, (Object)relateFk).model());
        if (StrUtils.isNull((Object)ruleNo)) {
            msg.setWarnMsg("\u8be5\u89c4\u5219\u5185\u5bb9\u672a\u7f16\u8f91\uff01");
            return msg.msg();
        }
        this.dao.delete(DsnRules.n().where().addEq(DsnRules.RELATE_FK, (Object)ruleNo.getRelateFk()).addEq(DsnRules.RELATE_TAB, (Object)"dsn_rules").addEq(DsnRules.RELATE_FIELD, (Object)"node_no").model());
        this.dao.delete(DsnRulesConst.n().where().addEq(DsnRulesConst.RULE_ID, (Object)ruleNo.getRuleId()).model());
        this.dao.delete(DsnRulesParam.n().where().addEq(DsnRulesParam.RULE_ID, (Object)ruleNo.getRuleId()).model());
        msg.setSuccessMsg("\u89c4\u5219\u5220\u9664\u6210\u529f\uff01");
        return msg.msg();
    }

    @Override
    public ReturnMsg getProperty(Object map) {
        Return msg = new Return();
        return msg.msg();
    }

    @Override
    public ReturnMsg queryFkRules(FkRulesReqParam fkRulesReqParam) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)fkRulesReqParam.getRelateTab())) {
            msg.setFailMsg("\u5f53\u524drelate_tab\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)fkRulesReqParam.getRelateField())) {
            msg.setFailMsg("\u5f53\u524drelate_field\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)fkRulesReqParam.getRelateFk())) {
            msg.setFailMsg("\u5f53\u524drelate_fk\u4e3a\u7a7a");
            return msg.msg();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        DsnRules dsnRules = new DsnRules();
        dsnRules.where().addEq(DsnRules.RELATE_TAB, (Object)fkRulesReqParam.getRelateTab());
        dsnRules.where().addEq(DsnRules.RELATE_FIELD, (Object)fkRulesReqParam.getRelateField());
        dsnRules.where().addEq(DsnRules.RELATE_FK, (Object)fkRulesReqParam.getRelateFk());
        if (!StrUtils.isNull((Object)fkRulesReqParam.getAttributeCode())) {
            dsnRules.where().addEq(DsnRules.ATTRIBUTE_CODE, (Object)fkRulesReqParam.getAttributeCode());
        } else {
            dsnRules.where().addIsNull(DsnRules.ATTRIBUTE_CODE);
        }
        DsnRules dsnRule = (DsnRules)this.dao.findOne((AbsModel)dsnRules);
        map.put("dsn_rules", dsnRule);
        if (dsnRule == null) {
            map.put("dsn_rules", new DsnRules());
            map.put("dsn_rules_const", new ArrayList());
            map.put("dsn_rules_param", new ArrayList());
            msg.setDataTable(map);
            msg.setSuccessMsg(new Message("2010007", "\u67e5\u8be2\u6210\u529f\uff08\u65e0\u6570\u636e\uff09"));
            return msg.msg();
        }
        DsnRulesConst dsnRulesConst = new DsnRulesConst();
        dsnRulesConst.where().addEq(DsnRulesConst.RULE_ID, (Object)dsnRule.getRuleId());
        List dsnRulesConstList = this.dao.findAll((AbsModel)dsnRulesConst);
        map.put("dsn_rules_const", dsnRulesConstList);
        DsnRulesParam dsnRulesParam = new DsnRulesParam();
        dsnRulesParam.where().addEq(DsnRulesParam.RULE_ID, (Object)dsnRule.getRuleId());
        List dsnRulesParamList = this.dao.findAll((AbsModel)dsnRulesParam);
        map.put("dsn_rules_param", dsnRulesParamList);
        msg.setDataTable(map);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteByRelateFks(String relateFks, String relateTab) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)relateFks)) {
            msg.setFailMsg(new Message("3010005", "\u5173\u8054\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        String[] split = relateFks.split(",");
        List<String> relateFkList = Arrays.asList(split);
        if (CollectionUtils.isEmpty(relateFkList)) {
            msg.setFailMsg(new Message("3010005", "\u5173\u8054\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        List dsnRulesList = this.dao.findAll(DsnRules.n().where().addEq(DsnRules.RELATE_TAB, (Object)relateTab).addIn(DsnRules.RELATE_FK, relateFkList).model());
        if (CollectionUtils.isNotEmpty((Collection)dsnRulesList)) {
            this.dao.delete(DsnRules.n().where().addEq(DsnRules.RELATE_TAB, (Object)relateTab).addIn(DsnRules.RELATE_FK, relateFkList).model());
            List collect = dsnRulesList.stream().map(r -> r.getRuleId()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(collect)) {
                this.dao.delete(DsnRulesConst.n().where().addIn(DsnRulesConst.RULE_ID, collect).model());
                this.dao.delete(DsnRulesParam.n().where().addIn(DsnRulesParam.RULE_ID, collect).model());
            }
        }
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryAttrRuleInfo(DsnRules dsnRules) {
        Return msg = new Return();
        DsnRules dsnRules1 = new DsnRules();
        dsnRules1.where().addEq(DsnRules.RELATE_FK, (Object)dsnRules.getRelateFk());
        if (!StrUtils.isNull((Object)dsnRules.getRuleName())) {
            dsnRules1.where().addLike(DsnRules.RULE_NAME, (Object)dsnRules.getRuleName());
        }
        if (!StrUtils.isNull((Object)dsnRules.getRuleType())) {
            dsnRules1.where().addEq(DsnRules.RULE_TYPE, (Object)dsnRules.getRuleType());
        }
        if (!StrUtils.isNull((Object)dsnRules.getAttributeCode())) {
            dsnRules1.where().addEq(DsnRules.ATTRIBUTE_CODE, (Object)dsnRules.getAttributeCode());
        } else {
            dsnRules1.where().addIsNull(DsnRules.ATTRIBUTE_CODE);
        }
        List all = this.dao.findAll((AbsModel)dsnRules1, Boolean.valueOf(true));
        HashMap<String, List> map = new HashMap<String, List>();
        map.put("rules", all);
        msg.setDataTable(map);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRuleInfoByRuleId(String ruleId) {
        Return msg = new Return();
        HashMap<String, Object> map = new HashMap<String, Object>();
        DsnRules dsnRules = (DsnRules)this.dao.findOne(DsnRules.n().where().addEq(DsnRules.RULE_ID, (Object)ruleId).model());
        map.put("dsn_rules", dsnRules);
        List dsnRulesConstList = this.dao.findAll(DsnRulesConst.n().where().addEq(DsnRulesConst.RULE_ID, (Object)ruleId).model());
        map.put("dsn_rules_const", dsnRulesConstList);
        List dsnRulesParamList = this.dao.findAll(DsnRulesParam.n().where().addEq(DsnRulesParam.RULE_ID, (Object)ruleId).model());
        map.put("dsn_rules_param", dsnRulesParamList);
        msg.setDataTable(map);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteRuleInfoByRuleId(String ruleId) {
        Return msg = new Return();
        this.dao.delete(DsnRules.n().where().addEq(DsnRules.RULE_ID, (Object)ruleId).model());
        this.dao.delete(DsnRulesConst.n().where().addEq(DsnRulesConst.RULE_ID, (Object)ruleId).model());
        this.dao.delete(DsnRulesParam.n().where().addEq(DsnRulesParam.RULE_ID, (Object)ruleId).model());
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public List<SaveRuleUsedParam> queryRulesByFk(FkRulesReqParam fkRulesReqParam) {
        List dsnRulesList;
        DsnRules dsnRules = new DsnRules();
        dsnRules.where().addEq(DsnRules.RELATE_TAB, (Object)fkRulesReqParam.getRelateTab());
        dsnRules.where().addEq(DsnRules.RELATE_FIELD, (Object)fkRulesReqParam.getRelateField());
        dsnRules.where().addEq(DsnRules.RELATE_FK, (Object)fkRulesReqParam.getRelateFk());
        if (!StrUtils.isNull((Object)fkRulesReqParam.getAttributeCode())) {
            dsnRules.where().addEq(DsnRules.ATTRIBUTE_CODE, (Object)fkRulesReqParam.getAttributeCode());
        }
        if (!StrUtils.isNull((Object)fkRulesReqParam.getExcludeIds())) {
            dsnRules.where().addNotIn(DsnRules.RULE_ID, Arrays.asList(fkRulesReqParam.getExcludeIds()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(dsnRulesList = this.dao.findAll((AbsModel)dsnRules)))) {
            ArrayList<SaveRuleUsedParam> saveRuleUsedParamList = new ArrayList<SaveRuleUsedParam>();
            for (DsnRules rules : dsnRulesList) {
                SaveRuleUsedParam saveRuleUsedParam = new SaveRuleUsedParam();
                BeanUtils.copyProperties((Object)rules, (Object)((Object)saveRuleUsedParam));
                DsnRulesConst dsnRulesConst = new DsnRulesConst();
                dsnRulesConst.where().addEq(DsnRulesConst.RULE_ID, (Object)rules.getRuleId());
                List dsnRulesConstList = this.dao.findAll((AbsModel)dsnRulesConst);
                saveRuleUsedParam.setConsts(dsnRulesConstList);
                DsnRulesParam dsnRulesParam = new DsnRulesParam();
                dsnRulesParam.where().addEq(DsnRulesParam.RULE_ID, (Object)rules.getRuleId());
                List dsnRulesParamList = this.dao.findAll((AbsModel)dsnRulesParam);
                saveRuleUsedParam.setParams(dsnRulesParamList);
                saveRuleUsedParamList.add(saveRuleUsedParam);
            }
            return saveRuleUsedParamList;
        }
        return null;
    }
}

