/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import com.newtouch.base.enums.ConfigTypeEnum;
import com.newtouch.base.enums.MappingTypeEnum;
import com.newtouch.base.model.DsnRulesConfig;
import com.newtouch.base.model.DsnRulesConfigMapping;
import com.newtouch.base.model.DsnRulesConfigParam;
import com.newtouch.base.model.DsnRulesGroup;
import com.newtouch.base.model.DsnRulesTemplate;
import com.newtouch.base.model.DsnRulesTemplateParam;
import com.newtouch.base.param.ConfigReqParam;
import com.newtouch.base.service.ConfigSettingService;
import com.newtouch.base.utils.FilesUtil;
import com.newtouch.base.vo.ConfigTreeVo;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.Field;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.FileUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ConfigSettingServiceImpl
implements ConfigSettingService {
    @Value(value="${template.uploadFormCollectPath}")
    private String uploadFormCollectPath;
    @Autowired
    AbsModelRepository dao;

    @Override
    public ReturnMsg queryConfigList(ConfigReqParam configReqParam) {
        Return msg = new Return();
        DsnRulesConfig dsnRulesConfig = new DsnRulesConfig();
        dsnRulesConfig.setOrderBy(new Sort.Order[]{DsnRulesConfig.DISPLAY_ORDER.desc()}).where().addEq(DsnRulesConfig.UP_CONFIG, (Object)"0").addEq(DsnRulesConfig.DATA_FLAG, (Object)"1");
        if (!StrUtils.isNull((Object)configReqParam.getConfigCode())) {
            dsnRulesConfig.where().addLike(DsnRulesConfig.CONFIG_CODE, (Object)configReqParam.getConfigCode());
        }
        if (!StrUtils.isNull((Object)configReqParam.getConfigName())) {
            dsnRulesConfig.where().addLike(DsnRulesConfig.CONFIG_NAME, (Object)configReqParam.getConfigName());
        }
        if (!StrUtils.isNull((Object)configReqParam.getCrtDateStart())) {
            dsnRulesConfig.where().addGTEq(DsnRulesConfig.CRT_DATE, configReqParam.getCrtDateStart());
        }
        if (!StrUtils.isNull((Object)configReqParam.getCrtDateEnd())) {
            dsnRulesConfig.where().addLTEq(DsnRulesConfig.CRT_DATE, configReqParam.getCrtDateEnd());
        }
        if ("Y".equals(configReqParam.getIsPage())) {
            List dsnRulesConfigs = this.dao.findAll((AbsModel)dsnRulesConfig, Boolean.valueOf(true));
            msg.setDataList(dsnRulesConfigs, DsnRulesConfig.class);
        } else {
            List dsnRulesConfigs = this.dao.findAll((AbsModel)dsnRulesConfig);
            msg.setDataList(dsnRulesConfigs, DsnRulesConfig.class);
        }
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteConfig(String configId) {
        Return msg = new Return();
        DsnRulesConfig dsnRulesConfig = new DsnRulesConfig();
        dsnRulesConfig.where().addEq(DsnRulesConfig.CONFIG_ID, (Object)configId).addEq(DsnRulesConfig.DATA_FLAG, (Object)"1");
        DsnRulesConfig dsnRulesConfiga = (DsnRulesConfig)this.dao.findOne((AbsModel)dsnRulesConfig);
        if ("0".equals(dsnRulesConfiga.getUpConfig())) {
            DsnRulesGroup dsnRulesGroup = new DsnRulesGroup();
            dsnRulesGroup.where().addEq(DsnRulesGroup.CONFIG_ID, (Object)configId).addEq(DsnRulesGroup.DATA_FLAG, (Object)"1");
            List all = this.dao.findAll((AbsModel)dsnRulesGroup);
            if (CollectionUtils.isNotEmpty((Collection)all)) {
                msg.setFailMsg(new Message("5010007", "\u8be5\u9009\u9879\u7f16\u7801\u5df2\u7ecf\u5173\u8054\u5206\u7ec4\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664"));
                return msg.msg();
            }
        }
        dsnRulesConfig.where().addLikeR(DsnRulesConfig.CONFIG_SEQ, (Object)dsnRulesConfiga.getConfigSeq());
        this.dao.delete((AbsModel)dsnRulesConfig);
        dsnRulesConfiga.where().addGT(DsnRulesConfig.DISPLAY_ORDER, dsnRulesConfiga.getDisplayOrder().intValue()).addEq(DsnRulesConfig.DATA_FLAG, (Object)"1").addEq(DsnRulesConfig.UP_CONFIG, (Object)dsnRulesConfiga.getUpConfig());
        List dsnRulesConfigs = this.dao.findAll((AbsModel)dsnRulesConfiga);
        for (DsnRulesConfig dsnRulesCon : dsnRulesConfigs) {
            DsnRulesConfig dsnRule = new DsnRulesConfig();
            dsnRule.setDisplayOrder(Integer.valueOf(dsnRulesCon.getDisplayOrder() - 1));
            dsnRule.where().addEq(DsnRulesConfig.CONFIG_ID, (Object)dsnRulesCon.getConfigId());
            this.dao.update((AbsModel)dsnRule);
        }
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryConfigTreeById(String configId) {
        List<DsnRulesConfig> childs;
        Return msg = new Return();
        DsnRulesConfig dsnRulesConfig = new DsnRulesConfig();
        dsnRulesConfig.where().addEq(DsnRulesConfig.CONFIG_ID, (Object)configId);
        DsnRulesConfig dsnRulesConfigDb = (DsnRulesConfig)this.dao.findOne((AbsModel)dsnRulesConfig);
        if (null != dsnRulesConfigDb && null != (childs = this.getConfigTreeVo(configId, "N")) && childs.size() > 0) {
            dsnRulesConfigDb.setChildren(childs);
        }
        msg.setDataTable(new Object[]{dsnRulesConfigDb});
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    private List<DsnRulesConfig> getConfigTreeVo(String configId, String paramFlag) {
        DsnRulesConfig dsnRulesConfig = new DsnRulesConfig();
        dsnRulesConfig.where().addEq(DsnRulesConfig.UP_CONFIG, (Object)configId);
        dsnRulesConfig.setOrderBy(new Sort.Order[]{DsnRulesConfig.DISPLAY_ORDER.asc()});
        List childs = this.dao.findAll((AbsModel)dsnRulesConfig);
        if (null != childs && childs.size() > 0) {
            for (DsnRulesConfig c : childs) {
                List dsnRulesConfigMappings;
                DsnRulesConfig subChildConfig = new DsnRulesConfig();
                subChildConfig.where().addEq(DsnRulesConfig.UP_CONFIG, (Object)c.getConfigId());
                subChildConfig.setOrderBy(new Sort.Order[]{DsnRulesConfig.DISPLAY_ORDER.asc()});
                List subChilds = this.dao.findAll((AbsModel)subChildConfig);
                if (null != subChilds && subChilds.size() > 0) {
                    c.setChildren(subChilds);
                }
                if ("Y".equals(paramFlag)) {
                    this.getConfigParams(c.getConfigId(), c);
                }
                if (!ConfigTypeEnum.MAPPING.getCode().equals(c.getConfigType()) || !CollectionUtils.isNotEmpty((Collection)(dsnRulesConfigMappings = c.getDsnRulesConfigMappings()))) continue;
                DsnRulesConfigMapping dsnRulesConfigMapping = (DsnRulesConfigMapping)dsnRulesConfigMappings.get(0);
                String mappingType = dsnRulesConfigMapping.getMappingType();
                if (!MappingTypeEnum.tableMapping.getCode().equals(mappingType)) continue;
                this.getTableMapping(c, dsnRulesConfigMapping, "N");
            }
        }
        return childs;
    }

    private void getConfigParams(String configId, DsnRulesConfig dsnRulesConfigDb) {
        DsnRulesConfigMapping dsnRulesConfigMapping = new DsnRulesConfigMapping();
        dsnRulesConfigMapping.where().addEq(DsnRulesConfigMapping.CONFIG_ID, (Object)configId);
        List dsnRulesMaping = this.dao.findAll((AbsModel)dsnRulesConfigMapping);
        dsnRulesConfigDb.setDsnRulesConfigMappings(dsnRulesMaping);
        DsnRulesConfigParam dsnRulesConfigParam = new DsnRulesConfigParam();
        dsnRulesConfigParam.where().addEq(DsnRulesConfigParam.CONFIG_ID, (Object)configId);
        dsnRulesConfigParam.setOrderBy(new Sort.Order[]{DsnRulesConfigParam.DISPLAY_ORDER.asc()});
        List dsnRulesConfigParams = this.dao.findAll((AbsModel)dsnRulesConfigParam);
        dsnRulesConfigDb.setDsnRulesConfigParams(dsnRulesConfigParams);
    }

    @Override
    public ReturnMsg queryConfigDetail(String configId) {
        Return msg = new Return();
        DsnRulesConfig dsnRulesConfig = this.queryDetail(configId);
        if (null != dsnRulesConfig && !StrUtils.isNull((Object)dsnRulesConfig.getConfigExtends())) {
            dsnRulesConfig.where().addEq(DsnRulesConfig.CONFIG_ID, (Object)dsnRulesConfig.getConfigExtends()).addEq(DsnRulesConfig.DATA_FLAG, (Object)"1");
            DsnRulesConfig dsnRules = (DsnRulesConfig)this.dao.findOne((AbsModel)dsnRulesConfig);
            dsnRulesConfig.setConfigExtendsStr(dsnRules.getConfigName());
        }
        msg.setDataTable(new Object[]{dsnRulesConfig});
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    private DsnRulesConfig queryDetail(String configId) {
        DsnRulesConfig dsnRulesConfig = new DsnRulesConfig();
        dsnRulesConfig.where().addEq(DsnRulesConfig.CONFIG_ID, (Object)configId);
        DsnRulesConfig dsnRules = (DsnRulesConfig)this.dao.findOne((AbsModel)dsnRulesConfig);
        DsnRulesConfigMapping dsnRulesConfigMapping = new DsnRulesConfigMapping();
        dsnRulesConfigMapping.where().addEq(DsnRulesConfigMapping.CONFIG_ID, (Object)configId);
        List dsnRulesMaping = this.dao.findAll((AbsModel)dsnRulesConfigMapping);
        dsnRules.setDsnRulesConfigMappings(dsnRulesMaping);
        DsnRulesConfigParam dsnRulesConfigParam = new DsnRulesConfigParam();
        dsnRulesConfigParam.where().addEq(DsnRulesConfigParam.CONFIG_ID, (Object)configId);
        dsnRulesConfigParam.setOrderBy(new Sort.Order[]{DsnRulesConfigParam.DISPLAY_ORDER.asc()});
        List dsnRulesConfigParams = this.dao.findAll((AbsModel)dsnRulesConfigParam);
        dsnRules.setDsnRulesConfigParams(dsnRulesConfigParams);
        return dsnRules;
    }

    @Override
    public ReturnMsg addOrUpdateConfig(DsnRulesConfig dsnRulesConfig) {
        String upConfig;
        Return msg = new Return();
        this.checkInfo(dsnRulesConfig, msg);
        String configExtends = dsnRulesConfig.getConfigExtends();
        String configId = dsnRulesConfig.getConfigId();
        if (!StrUtils.isNull((Object)configId)) {
            dsnRulesConfig.where().addEq(DsnRulesConfig.CONFIG_ID, (Object)dsnRulesConfig.getConfigId());
            this.dao.delete((AbsModel)dsnRulesConfig);
            DsnRulesConfigParam p = new DsnRulesConfigParam();
            p.where().addEq(DsnRulesConfigParam.CONFIG_ID, (Object)dsnRulesConfig.getConfigId());
            this.dao.delete((AbsModel)p);
            DsnRulesConfigMapping m = new DsnRulesConfigMapping();
            m.where().addEq(DsnRulesConfigMapping.CONFIG_ID, (Object)dsnRulesConfig.getConfigId());
            this.dao.delete((AbsModel)m);
        }
        if (StrUtils.isNull((Object)(upConfig = dsnRulesConfig.getUpConfig()))) {
            msg.setFailMsg(new Message("5010001", "\u4e0a\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        DsnRulesConfig dsnRules = new DsnRulesConfig();
        dsnRules.where().addEq(DsnRulesConfig.DATA_FLAG, (Object)"1").addEq(DsnRulesConfig.UP_CONFIG, (Object)upConfig);
        dsnRules.groupBy().max(DsnRulesConfig.DISPLAY_ORDER);
        dsnRules = (DsnRulesConfig)this.dao.findOne((AbsModel)dsnRules);
        String configSeq = dsnRulesConfig.getConfigSeq();
        dsnRules.setConfigSeq(configSeq);
        if (StrUtils.isNull((Object)configId) && !StrUtils.isNull((Object)configExtends)) {
            if (configSeq.contains(configExtends)) {
                msg.setFailMsg(new Message("5010008", "\u8981\u7ee7\u627f\u7684\u8282\u70b9\u4e2d\u6709\u5f53\u524d\u8282\u70b9\u4e0a\u7ea7\u8282\u70b9"));
                return msg.msg();
            }
            List<ConfigTreeVo> configTreeVos = this.findConfigIds(configExtends);
            List configTreeDelete = configTreeVos.stream().filter(o -> upConfig.equals(o.getConfigExtends())).collect(Collectors.toList());
            DsnRulesConfig dsnRulesConfigNew = new DsnRulesConfig();
            dsnRulesConfigNew.where().addEq(DsnRulesConfig.CONFIG_ID, (Object)configExtends);
            List dsnRulesConfigs = this.dao.findAll((AbsModel)dsnRulesConfigNew);
            List configTreeDeletes = dsnRulesConfigs.stream().filter(o -> upConfig.equals(o.getConfigExtends())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(configTreeDelete) || CollectionUtils.isNotEmpty(configTreeDeletes)) {
                msg.setFailMsg(new Message("5010006", "\u8282\u70b9" + configExtends + "\u53ca\u5176\u5b50\u8282\u70b9\u4e2d\u5b58\u5728\u7ee7\u627f\u8282\u70b9" + upConfig + "\u7684\u60c5\u51b5\uff0c\u6545\u4e0d\u5141\u8bb8\u7ee7\u627f\u8be5\u8282\u70b9"));
                return msg.msg();
            }
        }
        this.saveConfig(dsnRulesConfig, dsnRules);
        msg.setDataTable(new Object[]{dsnRulesConfig});
        msg.setSuccessMsg(new Message("2010005", "\u4fdd\u5b58\u6210\u529f"));
        return msg.msg();
    }

    private ReturnMsg checkInfo(DsnRulesConfig dsnRulesConfig, Return msg) {
        if (StrUtils.isNull((Object)dsnRulesConfig.getConfigCode())) {
            msg.setFailMsg(new Message("5010002", "\u9009\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        if (StrUtils.isNull((Object)dsnRulesConfig.getConfigName())) {
            msg.setFailMsg(new Message("5010003", "\u9009\u9879\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        DsnRulesConfig checkConfig = new DsnRulesConfig();
        checkConfig.where().addEq(DsnRulesConfig.CONFIG_CODE, (Object)dsnRulesConfig.getConfigCode()).addEq(DsnRulesConfig.DATA_FLAG, (Object)"1").addEq(DsnRulesConfig.UP_CONFIG, (Object)dsnRulesConfig.getUpConfig()).addNotEq(DsnRulesConfig.CONFIG_ID, (Object)dsnRulesConfig.getConfigId());
        checkConfig = (DsnRulesConfig)this.dao.findOne((AbsModel)checkConfig);
        if (checkConfig != null) {
            msg.setFailMsg(new Message("5010004", "\u9009\u9879\u7f16\u7801\u4e0d\u80fd\u91cd\u590d"));
            return msg.msg();
        }
        DsnRulesConfig checkNameConfig = new DsnRulesConfig();
        checkNameConfig.where().addEq(DsnRulesConfig.CONFIG_NAME, (Object)dsnRulesConfig.getConfigName()).addEq(DsnRulesConfig.DATA_FLAG, (Object)"1").addEq(DsnRulesConfig.UP_CONFIG, (Object)dsnRulesConfig.getUpConfig()).addNotEq(DsnRulesConfig.CONFIG_ID, (Object)dsnRulesConfig.getConfigId());
        checkNameConfig = (DsnRulesConfig)this.dao.findOne((AbsModel)checkNameConfig);
        if (checkNameConfig != null) {
            msg.setFailMsg(new Message("5010005", "\u9009\u9879\u540d\u79f0\u4e0d\u80fd\u91cd\u590d"));
            return msg.msg();
        }
        return null;
    }

    private void saveConfig(DsnRulesConfig dsnRulesConfig, DsnRulesConfig dsnRules) {
        if (StrUtils.isNull((Object)dsnRulesConfig.getConfigId())) {
            dsnRulesConfig.setConfigId(UUID.shortUUID());
        }
        if (null == dsnRulesConfig.getDisplayOrder()) {
            dsnRulesConfig.setDisplayOrder(Integer.valueOf(!StrUtils.isNull((Object)dsnRules.getOtherProperty("max_display_order")) ? Integer.parseInt(dsnRules.getOtherProperty("max_display_order").toString()) + 1 : 0));
        }
        if (dsnRulesConfig.getConfigId().equals(dsnRules.getConfigSeq())) {
            dsnRulesConfig.setConfigSeq(dsnRules.getConfigSeq());
        } else {
            dsnRulesConfig.setConfigSeq(dsnRules.getConfigSeq() + "." + dsnRulesConfig.getConfigId());
        }
        List dsnRulesConfigMappings = dsnRulesConfig.getDsnRulesConfigMappings();
        List dsnRulesConfigParams = dsnRulesConfig.getDsnRulesConfigParams();
        dsnRulesConfig = (DsnRulesConfig)this.dao.save((AbsModel)dsnRulesConfig);
        String configId = dsnRulesConfig.getConfigId();
        if (CollectionUtils.isNotEmpty((Collection)dsnRulesConfigMappings)) {
            for (DsnRulesConfigMapping mapping : dsnRulesConfigMappings) {
                mapping.setConfigId(configId);
            }
            dsnRulesConfig.setDsnRulesConfigMappings(dsnRulesConfigMappings);
            this.dao.save(dsnRulesConfigMappings);
        }
        if (CollectionUtils.isNotEmpty((Collection)dsnRulesConfigParams)) {
            int order = 0;
            for (DsnRulesConfigParam param : dsnRulesConfigParams) {
                param.setDisplayOrder(Integer.valueOf(order++));
                param.setConfigId(configId);
            }
            dsnRulesConfig.setDsnRulesConfigParams(dsnRulesConfigParams);
            this.dao.save(dsnRulesConfigParams);
        }
        Ulog.info((String)("\u4fdd\u5b58\u7684\u4fe1\u606f\u4e3a--->" + JsonUtils.toJson((Object)dsnRulesConfig)));
    }

    @Override
    public ReturnMsg addConfig(DsnRulesConfig dsnRulesConfig) {
        Return msg = new Return();
        this.checkInfo(dsnRulesConfig, msg);
        DsnRulesConfig dsnRules = new DsnRulesConfig();
        dsnRules.where().addEq(DsnRulesConfig.DATA_FLAG, (Object)"1").addEq(DsnRulesConfig.UP_CONFIG, (Object)"0");
        dsnRules.groupBy().max(DsnRulesConfig.DISPLAY_ORDER);
        dsnRules = (DsnRulesConfig)this.dao.findOne((AbsModel)dsnRules);
        dsnRulesConfig.setConfigId(UUID.shortUUID());
        dsnRulesConfig.setConfigType("MENU");
        String order = dsnRules.getOtherProperty("max_display_order").toString();
        if (StrUtils.isNull((Object)order)) {
            dsnRulesConfig.setDisplayOrder(Integer.valueOf(1));
        } else {
            dsnRulesConfig.setDisplayOrder(Integer.valueOf(Integer.parseInt(order) + 1));
        }
        dsnRulesConfig.setShowLevel(Integer.valueOf(1));
        dsnRulesConfig.setIndentLevel(Integer.valueOf(1));
        dsnRulesConfig.setUpConfig("0");
        dsnRulesConfig.setValueType("string");
        dsnRulesConfig.setIsChoice("0");
        dsnRulesConfig.setConfigSeq(dsnRulesConfig.getConfigId());
        this.dao.save((AbsModel)dsnRulesConfig);
        msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg sortConfig(String configId, String direction) {
        Return msg = new Return();
        DsnRulesConfig dsnRulesConfig = new DsnRulesConfig();
        DsnRulesConfig dsnRulesResult = new DsnRulesConfig();
        int orderResult = 0;
        int orderCurrent = 0;
        dsnRulesConfig.where().addEq(DsnRulesConfig.CONFIG_ID, (Object)configId);
        dsnRulesConfig = (DsnRulesConfig)this.dao.findOne((AbsModel)dsnRulesConfig);
        orderCurrent = dsnRulesConfig.getDisplayOrder();
        if ("up".equals(direction)) {
            orderResult = orderCurrent - 1;
            dsnRulesConfig.setDisplayOrder(Integer.valueOf(orderResult));
        } else if ("down".equals(direction)) {
            orderResult = orderCurrent + 1;
            dsnRulesConfig.setDisplayOrder(Integer.valueOf(orderResult));
        }
        Ulog.info((String)("\u914d\u7f6e\u7f16\u7801--->" + configId + "--\u8c03\u6574\u524d\u987a\u5e8f\u4e3a--->" + orderCurrent + "--\u8c03\u6574\u540e\u987a\u5e8f\u4e3a--->" + orderResult));
        dsnRulesResult.where().addEq(DsnRulesConfig.DISPLAY_ORDER, (Object)orderResult).addEq(DsnRulesConfig.UP_CONFIG, (Object)dsnRulesConfig.getUpConfig()).addEq(DsnRulesConfig.DATA_FLAG, (Object)"1");
        dsnRulesResult = (DsnRulesConfig)this.dao.findOne((AbsModel)dsnRulesResult);
        Ulog.info((String)("\u914d\u7f6e\u7f16\u7801--->" + configId + "---\u76f8\u90bb\u7f16\u7801--->" + dsnRulesResult.getConfigId() + "--\u8c03\u6574\u524d\u987a\u5e8f\u4e3a--->" + orderResult + "--\u8c03\u6574\u540e\u987a\u5e8f\u4e3a--->" + orderCurrent));
        dsnRulesConfig.where().addEq(DsnRulesConfig.CONFIG_ID, (Object)configId);
        this.dao.update((AbsModel)dsnRulesConfig);
        dsnRulesResult.setDisplayOrder(Integer.valueOf(orderCurrent));
        dsnRulesResult.where().addEq(DsnRulesConfig.CONFIG_ID, (Object)dsnRulesResult.getConfigId());
        this.dao.update((AbsModel)dsnRulesResult);
        msg.setSuccessMsg(new Message("2010006", "\u8c03\u6574\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryTreeByGroupType(String groupType, String ruleId) {
        Return msg = new Return();
        ArrayList<Map> dsnRulesConfigList = new ArrayList<Map>();
        DsnRulesGroup dsnRulesGroup = new DsnRulesGroup();
        dsnRulesGroup.select(new Field[]{DsnRulesGroup.CONFIG_ID}).where().addEq(DsnRulesGroup.GROUP_TYPE, (Object)groupType).addEq(DsnRulesGroup.DATA_FLAG, (Object)"1");
        List dsnRulesGroups = this.dao.findAll((AbsModel)dsnRulesGroup);
        for (DsnRulesGroup group : dsnRulesGroups) {
            String configId = group.getConfigId();
            ReturnMsg returnMsg = this.queryTreeByConfigId(configId);
            if (!returnMsg.isSuccessflag()) continue;
            Map dataTable = returnMsg.getDataTable();
            dsnRulesConfigList.add(dataTable);
        }
        if (!StrUtils.isNull((Object)ruleId)) {
            HashMap<String, Object> dataTable = new HashMap<String, Object>();
            DsnRulesTemplate dsnRules = (DsnRulesTemplate)this.dao.findOne(DsnRulesTemplate.n().where().addEq(DsnRulesTemplate.RULE_ID, (Object)ruleId).model());
            if (!ObjectUtil.isEmpty((Object)dsnRules)) {
                dataTable.put("config_code", dsnRules.getRuleId());
                dataTable.put("config_name", dsnRules.getRuleName());
                List dsnRulesParams = this.dao.findAll(DsnRulesTemplateParam.n().where().addEq(DsnRulesTemplateParam.RULE_ID, (Object)ruleId).model());
                if (!ObjectUtil.isEmpty((Object)dsnRulesParams)) {
                    ArrayList list = new ArrayList();
                    dsnRulesParams.stream().forEach(o -> {
                        ConfigTreeVo configTreeVo = new ConfigTreeVo();
                        configTreeVo.setConfigCode("###" + o.getParamCode() + "###");
                        configTreeVo.setConfigName(o.getParamName());
                        list.add(configTreeVo);
                    });
                    dataTable.put("children", list);
                }
                dsnRulesConfigList.add(dataTable);
            }
        }
        msg.setDataList(dsnRulesConfigList);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    public ReturnMsg queryTreeByConfigId(String configId) {
        Return msg = new Return();
        DsnRulesConfig dsnRulesConfig = new DsnRulesConfig();
        dsnRulesConfig.where().addEq(DsnRulesConfig.CONFIG_ID, (Object)configId);
        DsnRulesConfig dsnRulesConfigDb = (DsnRulesConfig)this.dao.findOne((AbsModel)dsnRulesConfig);
        if (null != dsnRulesConfigDb) {
            List<DsnRulesConfig> childs = this.getConfigTreeVo(configId, "Y");
            if (!StrUtils.isNull((Object)dsnRulesConfigDb.getConfigExtends())) {
                List<DsnRulesConfig> configTreeVo = this.getConfigTreeVo(dsnRulesConfigDb.getConfigExtends(), "Y");
                configTreeVo.forEach(o -> o.setIsExtends("1"));
                childs.addAll(configTreeVo);
            }
            if (null != childs && childs.size() > 0) {
                dsnRulesConfigDb.setChildren(childs);
            }
            this.getConfigParams(configId, dsnRulesConfigDb);
        }
        msg.setDataTable(new Object[]{dsnRulesConfigDb});
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryTreeByConfigId(DsnRulesConfig dsnRulesConfig) {
        List dsnRulesConfigMappings;
        Return msg = new Return();
        String configId = dsnRulesConfig.getConfigId();
        List<DsnRulesConfig> childs = this.getConfigTreeVo(configId, "Y");
        if (!StrUtils.isNull((Object)dsnRulesConfig.getConfigExtends())) {
            List<DsnRulesConfig> configTreeVo = this.getConfigTreeVo(dsnRulesConfig.getConfigExtends(), "Y");
            configTreeVo.forEach(o -> o.setIsExtends("1"));
            childs.addAll(configTreeVo);
        }
        if (null != childs && childs.size() > 0) {
            dsnRulesConfig.setChildren(childs);
        }
        if (ConfigTypeEnum.MAPPING.getCode().equals(dsnRulesConfig.getConfigType()) && CollectionUtils.isNotEmpty((Collection)(dsnRulesConfigMappings = dsnRulesConfig.getDsnRulesConfigMappings()))) {
            DsnRulesConfigMapping dsnRulesConfigMapping = (DsnRulesConfigMapping)dsnRulesConfigMappings.get(0);
            String mappingType = dsnRulesConfigMapping.getMappingType();
            if (MappingTypeEnum.tableMapping.getCode().equals(mappingType)) {
                this.getTableMapping(dsnRulesConfig, dsnRulesConfigMapping, "Y");
            }
        }
        msg.setDataTable(new Object[]{dsnRulesConfig});
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public void exportRulesConfig(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        List configIds = map.getList("config_ids", String.class);
        ArrayList<DsnRulesConfig> configs = new ArrayList<DsnRulesConfig>();
        for (String configId : configIds) {
            DsnRulesConfig config = DsnRulesConfig.n();
            config.where().addEq(DsnRulesConfig.CONFIG_ID, (Object)configId);
            config = (DsnRulesConfig)this.dao.findOne((AbsModel)config);
            DsnRulesConfigMapping configMapping = DsnRulesConfigMapping.n();
            configMapping.where().addEq(DsnRulesConfigMapping.CONFIG_ID, (Object)configId);
            List configMappings = this.dao.findAll((AbsModel)configMapping);
            config.setDsnRulesConfigMappings(configMappings);
            DsnRulesConfigParam configParam = DsnRulesConfigParam.n();
            configParam.where().addEq(DsnRulesConfigParam.CONFIG_ID, (Object)configId);
            List configParams = this.dao.findAll((AbsModel)configParam);
            config.setDsnRulesConfigParams(configParams);
            configs.add(config);
        }
        String json = JsonUtils.toJson(configs);
        String currentTimeMillis = String.valueOf(System.currentTimeMillis());
        String basePath = this.uploadFormCollectPath + "/export/rulesConfig/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/456";
        String baseAddress = basePath + "/";
        String uuid = UUID.shortUUID();
        FilesUtil.createFile(baseAddress + uuid + ".json");
        FilesUtil.writeToFile(baseAddress + uuid + ".json", json, false);
        String zipFile = basePath + ".zip";
        Ulog.info((String)("baseAddress----" + baseAddress));
        Ulog.info((String)("zipFile----" + zipFile));
        String zip = FileUtils.zip((String)baseAddress, (String)zipFile, (String[])new String[]{".json"});
        Ulog.info((String)("zip----" + zip));
        try {
            File file = new File(zipFile);
            FileInputStream inputStream = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            inputStream.read(data);
            inputStream.close();
            response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
            response.setContentType("application/octet-stream;charset=ISO8859-1");
            response.addHeader("Content-Length", "" + file.length());
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(currentTimeMillis + ".zip", "UTF-8"));
            ServletOutputStream stream = response.getOutputStream();
            stream.write(data);
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileUtil.del((String)baseAddress);
        FileUtil.del((String)zipFile);
    }

    @Override
    public ReturnMsg importRulesConfig(MultipartFile file) {
        Return aReturn = new Return();
        String basePath = this.uploadFormCollectPath + "/import/rulesConfig/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        try {
            FileUtils.unzip((InputStream)file.getInputStream(), (String)basePath);
        }
        catch (IOException e) {
            e.printStackTrace();
            aReturn.setFailMsg(e.getMessage());
            return aReturn.msg();
        }
        File importDir = new File(basePath);
        ArrayList<File> files = new ArrayList<File>();
        FilesUtil.getAllFiles(importDir, files);
        for (File fileTemp : files) {
            StringBuffer buffer = new StringBuffer();
            try (FileInputStream inputStream = new FileInputStream(fileTemp);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String result = "";
            result = new String(buffer.toString().getBytes(), StandardCharsets.UTF_8);
            List configs = JsonUtils.json2List((String)result, DsnRulesConfig.class);
            ArrayList mappingList = new ArrayList();
            ArrayList paramList = new ArrayList();
            for (DsnRulesConfig config : configs) {
                config.where().addEq(DsnRulesConfig.CONFIG_ID, (Object)config.getConfigId());
                this.dao.delete((AbsModel)config);
                if (CollectionUtils.isNotEmpty((Collection)config.getDsnRulesConfigMappings())) {
                    DsnRulesConfigMapping mapping = DsnRulesConfigMapping.n();
                    mapping.where().addEq(DsnRulesConfigMapping.CONFIG_ID, (Object)config.getConfigId());
                    this.dao.delete((AbsModel)mapping);
                    mappingList.addAll(config.getDsnRulesConfigMappings());
                }
                if (!CollectionUtils.isNotEmpty((Collection)config.getDsnRulesConfigParams())) continue;
                DsnRulesConfigParam param = DsnRulesConfigParam.n();
                param.where().addEq(DsnRulesConfigParam.CONFIG_ID, (Object)config.getConfigId());
                this.dao.delete((AbsModel)param);
                paramList.addAll(config.getDsnRulesConfigParams());
            }
            this.dao.save(configs);
            this.dao.save(mappingList);
            this.dao.save(paramList);
        }
        FileUtil.del((String)basePath);
        return aReturn.msg();
    }

    private void getTableMapping(DsnRulesConfig dsnRulesConfig, DsnRulesConfigMapping dsnRulesConfigMapping, String isNeedChilds) {
        String mappingOrder;
        String mappingTab = dsnRulesConfigMapping.getMappingTab();
        String mappingId = dsnRulesConfigMapping.getMappingId();
        String mappingValue = dsnRulesConfigMapping.getMappingValue();
        String mappingParent = dsnRulesConfigMapping.getMappingParent();
        String mappingName = dsnRulesConfigMapping.getMappingName();
        ArrayList<String> whereValue = new ArrayList<String>();
        whereValue.add(mappingValue);
        String sql = "select t.*,t." + mappingId + " as config_id , t." + mappingId + " as config_code , t." + mappingName + " as config_name , t." + mappingParent + " as up_config  from " + mappingTab + " t where t." + mappingParent + " = ? ";
        String mappingRule = dsnRulesConfigMapping.getMappingRule();
        if (!StrUtils.isNull((Object)mappingRule)) {
            String[] rule = mappingRule.split("##");
            for (int i = 0; i < rule.length; ++i) {
                String[] subRule = rule[i].split("|");
                sql = sql + " AND " + subRule[0] + " ? ";
                whereValue.add(subRule[1]);
            }
        }
        if (!StrUtils.isNull((Object)(mappingOrder = dsnRulesConfigMapping.getMappingOrder()))) {
            sql = sql + " ORDER BY " + mappingOrder;
        }
        try {
            List allTableList = this.dao.findAll(sql + " \uff03NOTCHECK", Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(whereValue)});
            List children = dsnRulesConfig.getChildren();
            for (Map mapTable : allTableList) {
                DsnRulesConfig dsnTable = new DsnRulesConfig();
                dsnTable.setConfigId(mapTable.get("config_id").toString());
                dsnTable.setConfigCode(mapTable.get("config_code").toString());
                dsnTable.setConfigName(mapTable.get("config_name").toString());
                dsnTable.setUpConfig(mapTable.get("up_config").toString());
                dsnTable.setConfigType(ConfigTypeEnum.MAPPING.getCode());
                DsnRulesConfigMapping mapping = new DsnRulesConfigMapping();
                BeanUtils.copyProperties((Object)dsnRulesConfigMapping, (Object)mapping);
                mapping.setMappingValue(mapTable.get("config_id").toString());
                ArrayList<DsnRulesConfigMapping> mappings = new ArrayList<DsnRulesConfigMapping>();
                mappings.add(mapping);
                dsnTable.setDsnRulesConfigMappings(mappings);
                if ("Y".equals(isNeedChilds)) {
                    this.getTableMapping(dsnTable, (DsnRulesConfigMapping)dsnTable.getDsnRulesConfigMappings().get(0), "N");
                }
                children.add(dsnTable);
            }
            dsnRulesConfig.setChildren(children);
        }
        catch (Exception e) {
            e.printStackTrace();
            Ulog.info((String)("\u83b7\u53d6\u6620\u5c04\u4fe1\u606f\u5931\u8d25-->" + e.getMessage()));
        }
    }

    private List<ConfigTreeVo> findConfigIds(String configIds) {
        List<ConfigTreeVo> configTreeVos = new ArrayList<ConfigTreeVo>();
        ArrayList<String> paraApp = new ArrayList<String>();
        paraApp.add("1");
        paraApp.add(configIds);
        String sql = " SELECT config_id id, up_config parent_id,config_name name,config_code code,config_extends extends,display_order orders\n FROM dsn_rules_config where data_flag = ? start with config_id = ? connect by prior config_id = up_config ";
        List configs = this.dao.findAll(sql, new AbsModelRepository.Args[]{this.dao.args(paraApp)});
        if (CollectionUtils.isNotEmpty((Collection)configs)) {
            configTreeVos = configs.stream().map(o -> {
                ConfigTreeVo c = new ConfigTreeVo();
                c.setConfigCode(o.get("code").toString());
                c.setConfigId(o.get("id").toString());
                c.setConfigName(o.get("name").toString());
                c.setUpConfig(o.get("parent_id").toString());
                c.setConfigExtends(o.get("extends").toString());
                c.setDisplayOrder(Integer.parseInt(o.get("orders").toString()));
                return c;
            }).collect(Collectors.toList());
        }
        return configTreeVos;
    }
}

