/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.base.model.DsnRulesTemplate;
import com.newtouch.base.model.DsnRulesTemplateConst;
import com.newtouch.base.model.DsnRulesTemplateParam;
import com.newtouch.base.utils.export.EqualsUtil;
import com.newtouch.base.utils.export.ExportQueryUtil;
import com.newtouch.base.utils.export.UpdateUtil;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.StrUtils;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class RulesInfo
extends DsnRulesTemplate {
    private String rule_id;
    private List<DsnRulesTemplate> rule;
    private List<DsnRulesTemplateParam> params;
    private List<DsnRulesTemplateConst> consts;
    @JsonProperty(value="step")
    private String step;

    public RulesInfo load(String ruleId, String operateFlag) {
        ExportQueryUtil query = (ExportQueryUtil)SpringContext.getBean(ExportQueryUtil.class);
        this.rule_id = ruleId;
        this.rule = query.queryRulesTemplate(ruleId);
        if (CollectionUtils.isEmpty(this.rule)) {
            return this;
        }
        DsnRulesTemplateParam dsnRulesTemplateParam = new DsnRulesTemplateParam();
        dsnRulesTemplateParam.where().addEq(DsnRulesTemplate.RULE_ID, (Object)ruleId);
        this.params = query.queryRulesTemplateParams(ruleId);
        this.consts = query.queryRulesTemplateConst(ruleId);
        return this;
    }

    public void merge(RulesInfo rulesInfo) {
        this.rule = EqualsUtil.merge(this.rule, rulesInfo.getRule());
        this.params = EqualsUtil.merge(this.params, rulesInfo.getParams());
        this.consts = EqualsUtil.merge(this.consts, rulesInfo.getConsts());
    }

    public void save(String ruleId) {
        UpdateUtil update = (UpdateUtil)SpringContext.getBean(UpdateUtil.class);
        update.delByRuleId(ruleId);
        if (this.rule != null) {
            this.rule.forEach(m -> {
                UpdateUtil.UpdateFlag updateFlag = (UpdateUtil.UpdateFlag)((Object)((Object)m.getOtherProperty("update_flag", UpdateUtil.UpdateFlag.class)));
                if (StrUtils.isNull((Object)((Object)updateFlag)) || updateFlag == UpdateUtil.UpdateFlag.U || updateFlag == UpdateUtil.UpdateFlag.I) {
                    update.save((AbsModel)m);
                }
            });
        }
        if (this.params != null) {
            this.params.forEach(m -> {
                UpdateUtil.UpdateFlag updateFlag = (UpdateUtil.UpdateFlag)((Object)((Object)m.getOtherProperty("update_flag", UpdateUtil.UpdateFlag.class)));
                if (StrUtils.isNull((Object)((Object)updateFlag)) || updateFlag == UpdateUtil.UpdateFlag.U || updateFlag == UpdateUtil.UpdateFlag.I) {
                    update.save((AbsModel)m);
                }
            });
        }
        if (this.consts != null) {
            this.consts.forEach(m -> {
                UpdateUtil.UpdateFlag updateFlag = (UpdateUtil.UpdateFlag)((Object)((Object)m.getOtherProperty("update_flag", UpdateUtil.UpdateFlag.class)));
                if (StrUtils.isNull((Object)((Object)updateFlag)) || updateFlag == UpdateUtil.UpdateFlag.U || updateFlag == UpdateUtil.UpdateFlag.I) {
                    update.save((AbsModel)m);
                }
            });
        }
    }

    public String getRule_id() {
        return this.rule_id;
    }

    public List<DsnRulesTemplate> getRule() {
        return this.rule;
    }

    public List<DsnRulesTemplateParam> getParams() {
        return this.params;
    }

    public List<DsnRulesTemplateConst> getConsts() {
        return this.consts;
    }

    public String getStep() {
        return this.step;
    }

    public void setRule_id(String rule_id) {
        this.rule_id = rule_id;
    }

    public void setRule(List<DsnRulesTemplate> rule) {
        this.rule = rule;
    }

    public void setParams(List<DsnRulesTemplateParam> params) {
        this.params = params;
    }

    public void setConsts(List<DsnRulesTemplateConst> consts) {
        this.consts = consts;
    }

    @JsonProperty(value="step")
    public void setStep(String step) {
        this.step = step;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RulesInfo)) {
            return false;
        }
        RulesInfo other = (RulesInfo)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$rule_id = this.getRule_id();
        String other$rule_id = other.getRule_id();
        if (this$rule_id == null ? other$rule_id != null : !this$rule_id.equals(other$rule_id)) {
            return false;
        }
        List<DsnRulesTemplate> this$rule = this.getRule();
        List<DsnRulesTemplate> other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !((Object)this$rule).equals(other$rule)) {
            return false;
        }
        List<DsnRulesTemplateParam> this$params = this.getParams();
        List<DsnRulesTemplateParam> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        List<DsnRulesTemplateConst> this$consts = this.getConsts();
        List<DsnRulesTemplateConst> other$consts = other.getConsts();
        if (this$consts == null ? other$consts != null : !((Object)this$consts).equals(other$consts)) {
            return false;
        }
        String this$step = this.getStep();
        String other$step = other.getStep();
        return !(this$step == null ? other$step != null : !this$step.equals(other$step));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RulesInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rule_id = this.getRule_id();
        result = result * 59 + ($rule_id == null ? 43 : $rule_id.hashCode());
        List<DsnRulesTemplate> $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : ((Object)$rule).hashCode());
        List<DsnRulesTemplateParam> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        List<DsnRulesTemplateConst> $consts = this.getConsts();
        result = result * 59 + ($consts == null ? 43 : ((Object)$consts).hashCode());
        String $step = this.getStep();
        result = result * 59 + ($step == null ? 43 : $step.hashCode());
        return result;
    }

    public String toString() {
        return "RulesInfo(rule_id=" + this.getRule_id() + ", rule=" + this.getRule() + ", params=" + this.getParams() + ", consts=" + this.getConsts() + ", step=" + this.getStep() + ")";
    }
}

