/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.service.impl;

import com.newtouch.base.model.DsnRulesGroup;
import com.newtouch.base.param.GroupReqParam;
import com.newtouch.base.param.GroupSortReqParam;
import com.newtouch.base.service.GroupSettingService;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupSettingServiceImpl
implements GroupSettingService {
    @Autowired
    AbsModelRepository dao;

    @Override
    public ReturnMsg queryGroupList(GroupReqParam groupReqParam) {
        Return msg = new Return();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select g.config_id config_Id , g.group_name group_name ,g.group_type group_type,g.serno,g.crt_date,g.crt_user,g.group_desc group_desc,g.display_order,c.config_name config_name from dsn_rules_group g left join dsn_rules_config c on g.config_id = c.config_id where g.data_flag  = ? ");
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add("1");
        if (StringUtils.isNotBlank((CharSequence)groupReqParam.getGroupName())) {
            stringBuilder.append("and g.group_name like ? ");
            sqlList.add("%" + groupReqParam.getGroupName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)groupReqParam.getCrtDateEnd()) && StringUtils.isNotBlank((CharSequence)groupReqParam.getCrtDateStart())) {
            stringBuilder.append("and g.crt_date >= ? and  g.crt_date<= ? ");
            sqlList.add(groupReqParam.getCrtDateStart());
            sqlList.add(groupReqParam.getCrtDateEnd());
        }
        stringBuilder.append("order by g.group_type,g.display_order");
        List groupRes = this.dao.findAll(stringBuilder.toString(), new AbsModelRepository.Args[]{this.dao.args(sqlList)});
        msg.setDataList(groupRes);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg addOrUpdateGroup(DsnRulesGroup dsnRulesGroup) {
        Return msg = new Return();
        String serno = dsnRulesGroup.getSerno();
        if (!StrUtils.isNull((Object)serno)) {
            List dsnRulesGroups = this.dao.findAll(DsnRulesGroup.n().where().addEq(DsnRulesGroup.CONFIG_ID, (Object)dsnRulesGroup.getConfigId()).addEq(DsnRulesGroup.GROUP_TYPE, (Object)dsnRulesGroup.getGroupType()).addEq(DsnRulesGroup.DATA_FLAG, (Object)"1").addNotEq(DsnRulesGroup.SERNO, (Object)serno).model());
            if (CollectionUtils.isNotEmpty((Collection)dsnRulesGroups)) {
                msg.setFailMsg(new Message("4010001", "\u5f53\u524d\u89c4\u5219\u4e0b\u5df2\u6709\u6b64\u5206\u7ec4\u3002"));
                return msg.msg();
            }
            dsnRulesGroup.where().addEq(DsnRulesGroup.SERNO, (Object)serno).addEq(DsnRulesGroup.DATA_FLAG, (Object)"1");
            this.dao.update((AbsModel)dsnRulesGroup);
            msg.setDataTable(new Object[]{dsnRulesGroup});
            msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        } else {
            List dsnRulesGroups = this.dao.findAll(DsnRulesGroup.n().where().addEq(DsnRulesGroup.CONFIG_ID, (Object)dsnRulesGroup.getConfigId()).addEq(DsnRulesGroup.GROUP_TYPE, (Object)dsnRulesGroup.getGroupType()).addEq(DsnRulesGroup.DATA_FLAG, (Object)"1").model());
            if (CollectionUtils.isNotEmpty((Collection)dsnRulesGroups)) {
                msg.setFailMsg(new Message("4010001", "\u5f53\u524d\u89c4\u5219\u4e0b\u5df2\u6709\u6b64\u5206\u7ec4\u3002"));
                return msg.msg();
            }
            DsnRulesGroup group = new DsnRulesGroup();
            group.where().addEq(DsnRulesGroup.DATA_FLAG, (Object)"1").addEq(DsnRulesGroup.GROUP_TYPE, (Object)dsnRulesGroup.getGroupType());
            group.groupBy().max(DsnRulesGroup.DISPLAY_ORDER);
            DsnRulesGroup c = (DsnRulesGroup)this.dao.findOne((AbsModel)group);
            int order = StringUtils.isNotBlank((CharSequence)c.getOtherProperty("max_display_order").toString()) ? Integer.parseInt(c.getOtherProperty("max_display_order").toString()) + 1 : 0;
            dsnRulesGroup.setDisplayOrder(Integer.valueOf(order));
            this.dao.save((AbsModel)dsnRulesGroup);
            msg.setDataTable(new Object[]{dsnRulesGroup});
            msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteGroup(String serno) {
        Return msg = new Return();
        DsnRulesGroup dsnRulesGroup = new DsnRulesGroup();
        dsnRulesGroup.where().addEq(DsnRulesGroup.SERNO, (Object)serno);
        this.dao.delete((AbsModel)dsnRulesGroup);
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg sortGroup(GroupSortReqParam req) {
        Return msg = new Return();
        if (!req.getCurrentType().equals(req.getResultType())) {
            msg.setFailMsg(new Message("4010002", "\u4e0d\u540c\u5206\u7ec4\u7c7b\u578b\uff0c\u4e0d\u80fd\u8c03\u6574\u987a\u5e8f\u3002"));
            return msg.msg();
        }
        DsnRulesGroup dsnRulesGroup = new DsnRulesGroup();
        dsnRulesGroup.setDisplayOrder(Integer.valueOf(req.getResultOrder()));
        dsnRulesGroup.where().addEq(DsnRulesGroup.SERNO, (Object)req.getCurrentId());
        this.dao.update((AbsModel)dsnRulesGroup);
        dsnRulesGroup.setDisplayOrder(Integer.valueOf(req.getCurrentOrder()));
        dsnRulesGroup.where().addEq(DsnRulesGroup.SERNO, (Object)req.getResultId());
        this.dao.update((AbsModel)dsnRulesGroup);
        msg.setSuccessMsg(new Message("2010006", "\u8c03\u6574\u6210\u529f"));
        return msg.msg();
    }
}

