/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.utils.export;

import com.newtouch.base.model.DsnRulesTemplate;
import com.newtouch.base.model.DsnRulesTemplateConst;
import com.newtouch.base.model.DsnRulesTemplateParam;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateUtil {
    @Autowired
    AbsModelRepository dao;

    public void update(AbsModel model) {
        if (model == null) {
            return;
        }
        String name = model.getClass().getName();
        UpdateFlag updateFlag = (UpdateFlag)((Object)model.getOtherProperty("update_flag", UpdateFlag.class));
        if (updateFlag == null) {
            return;
        }
        switch (updateFlag) {
            case I: {
                DsnRulesTemplate rules;
                int delete = 0;
                if (!(model instanceof DsnRulesTemplate || model instanceof DsnRulesTemplateParam || model instanceof DsnRulesTemplateConst)) {
                    delete = this.dao.delete(model.getSerno(), model.getClass());
                }
                if (model instanceof DsnRulesTemplate) {
                    rules = (DsnRulesTemplate)model;
                    rules.where().addEq(DsnRulesTemplate.RULE_ID, (Object)rules.getRuleId());
                    this.dao.delete((AbsModel)rules);
                }
                if (model instanceof DsnRulesTemplateParam) {
                    rules = (DsnRulesTemplateParam)model;
                    rules.where().addEq(DsnRulesTemplateParam.RULE_ID, (Object)rules.getRuleId());
                    this.dao.delete((AbsModel)rules);
                }
                if (model instanceof DsnRulesTemplateConst) {
                    rules = (DsnRulesTemplateConst)model;
                    rules.where().addEq(DsnRulesTemplateConst.RULE_ID, (Object)rules.getRuleId());
                    this.dao.delete((AbsModel)rules);
                }
                this.dao.save(model);
                break;
            }
            case U: {
                this.dao.update(model.getSerno(), model);
                break;
            }
            case D: {
                DsnRulesTemplate rules;
                if (!(model instanceof DsnRulesTemplate || model instanceof DsnRulesTemplateParam || model instanceof DsnRulesTemplateConst)) {
                    this.dao.delete(model.getSerno(), model.getClass());
                }
                if (model instanceof DsnRulesTemplate) {
                    rules = (DsnRulesTemplate)model;
                    rules.where().addEq(DsnRulesTemplate.RULE_ID, (Object)rules.getRuleId());
                    this.dao.delete((AbsModel)rules);
                }
                if (model instanceof DsnRulesTemplateParam) {
                    rules = (DsnRulesTemplateParam)model;
                    rules.where().addEq(DsnRulesTemplateParam.RULE_ID, (Object)rules.getRuleId());
                    this.dao.delete((AbsModel)rules);
                }
                if (!(model instanceof DsnRulesTemplateConst)) break;
                rules = (DsnRulesTemplateConst)model;
                rules.where().addEq(DsnRulesTemplateConst.RULE_ID, (Object)rules.getRuleId());
                this.dao.delete((AbsModel)rules);
                break;
            }
        }
    }

    public void del(AbsModel model) {
        DsnRulesTemplateConst dsnRulesTemplateConst;
        DsnRulesTemplateParam dsnRulesTemplateParam;
        DsnRulesTemplate dsnRulesTemplate;
        if (model == null) {
            return;
        }
        if (model instanceof DsnRulesTemplate && !StrUtils.isNull((Object)(dsnRulesTemplate = (DsnRulesTemplate)model).getRuleId())) {
            dsnRulesTemplate.where().addEq(DsnRulesTemplate.RULE_ID, (Object)dsnRulesTemplate.getRuleId());
            this.dao.delete((AbsModel)dsnRulesTemplate);
        }
        if (model instanceof DsnRulesTemplateParam && !StrUtils.isNull((Object)(dsnRulesTemplateParam = (DsnRulesTemplateParam)model).getRuleId())) {
            dsnRulesTemplateParam.where().addEq(DsnRulesTemplateParam.RULE_ID, (Object)dsnRulesTemplateParam.getRuleId());
            this.dao.delete((AbsModel)dsnRulesTemplateParam);
        }
        if (model instanceof DsnRulesTemplateConst && !StrUtils.isNull((Object)(dsnRulesTemplateConst = (DsnRulesTemplateConst)model).getRuleId())) {
            dsnRulesTemplateConst.where().addEq(DsnRulesTemplateConst.RULE_ID, (Object)dsnRulesTemplateConst.getRuleId());
            this.dao.delete((AbsModel)dsnRulesTemplateConst);
        }
    }

    public void save(AbsModel model) {
        UpdateFlag updateFlag = (UpdateFlag)((Object)model.getOtherProperty("update_flag", UpdateFlag.class));
        if (updateFlag == null) {
            this.dao.save(model);
            return;
        }
        switch (updateFlag) {
            case I: {
                this.dao.save(model);
                break;
            }
            case U: {
                this.dao.save(model);
                break;
            }
        }
    }

    public void delByRuleId(String ruleId) {
        DsnRulesTemplate dsnRulesTemplate = new DsnRulesTemplate();
        dsnRulesTemplate.where().addEq(DsnRulesTemplate.RULE_ID, (Object)ruleId);
        this.dao.delete((AbsModel)dsnRulesTemplate);
        DsnRulesTemplateParam dsnRulesTemplateParam = new DsnRulesTemplateParam();
        dsnRulesTemplateParam.where().addEq(DsnRulesTemplateParam.RULE_ID, (Object)ruleId);
        this.dao.delete((AbsModel)dsnRulesTemplateParam);
        DsnRulesTemplateConst dsnRulesTemplateConst = new DsnRulesTemplateConst();
        dsnRulesTemplateConst.where().addEq(DsnRulesTemplateConst.RULE_ID, (Object)ruleId);
        this.dao.delete((AbsModel)dsnRulesTemplateConst);
    }

    public static enum UpdateFlag {
        I,
        U,
        D;

    }
}

