/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.web.controller;

import com.newtouch.base.model.DsnRules;
import com.newtouch.base.param.FkRulesReqParam;
import com.newtouch.base.param.SaveRuleUsedParam;
import com.newtouch.base.service.RuleUsedService;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ruleUsedController"})
public class RuleUsedController {
    @Autowired
    private RuleUsedService ruleUsedService;

    @RequestMapping(value={"/saveRuleUsed.do"})
    public String saveRuleUsed(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        SaveRuleUsedParam saveRuleUsedParam = (SaveRuleUsedParam)((Object)JsonUtils.map2Class((Map)param, SaveRuleUsedParam.class));
        ReturnMsg returnMsg = this.ruleUsedService.saveRuleUsed(saveRuleUsedParam);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/getProperty.do"})
    public String getProperty(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String params = map.get("params");
        ReturnMsg returnMsg = this.ruleUsedService.getProperty(params);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/queryFkRules.do"})
    public String queryFkRules(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        FkRulesReqParam fkRulesReqParam = (FkRulesReqParam)JsonUtils.map2Class((Map)param, FkRulesReqParam.class);
        ReturnMsg returnMsg = this.ruleUsedService.queryFkRules(fkRulesReqParam);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/deleteByRelateFks.do"})
    public String deleteByRelateFks(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String relateFks = map.get("relate_fks");
        String relateTab = map.get("relate_tab");
        ReturnMsg returnMsg = this.ruleUsedService.deleteByRelateFks(relateFks, relateTab);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/queryAttrRuleInfo.do"})
    public String queryAttrRuleInfo(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        DsnRules dsnRules = (DsnRules)JsonUtils.map2Class((Map)param, DsnRules.class);
        if (StrUtils.isNull((Object)dsnRules.getRelateFk())) {
            throw new BusinessException("\u5165\u53c2attr_id\u4e3a\u7a7a");
        }
        ReturnMsg returnMsg = this.ruleUsedService.queryAttrRuleInfo(dsnRules);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/queryRuleInfoByRuleId.do"})
    public String queryRuleInfoByRuleId(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String ruleId = map.get("rule_id");
        if (StrUtils.isNull((Object)ruleId)) {
            throw new BusinessException("\u5165\u53c2rule_id\u4e3a\u7a7a");
        }
        ReturnMsg returnMsg = this.ruleUsedService.queryRuleInfoByRuleId(ruleId);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/deleteRuleInfoByRuleId.do"})
    public String deleteRuleInfoByRuleId(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String ruleId = map.get("rule_id");
        if (StrUtils.isNull((Object)ruleId)) {
            throw new BusinessException("\u5165\u53c2rule_id\u4e3a\u7a7a");
        }
        ReturnMsg returnMsg = this.ruleUsedService.deleteRuleInfoByRuleId(ruleId);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }
}

