/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.service.impl;

import com.newtouch.base.config.TemplateConfig;
import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.DsnRulesConst;
import com.newtouch.base.model.DsnRulesParam;
import com.newtouch.base.model.DsnRulesTemplate;
import com.newtouch.base.model.DsnRulesTemplateConst;
import com.newtouch.base.model.DsnRulesTemplateParam;
import com.newtouch.base.param.SaveParams;
import com.newtouch.base.service.RuleService;
import com.newtouch.base.utils.FilesUtil;
import com.newtouch.base.vo.RulesInfo;
import com.newtouch.base.vo.RulesInfoVo;
import com.newtouch.nms.sip.model.SipProductSyncTask;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.FileUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.StringJoiner;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RuleServiceImpl
implements RuleService {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    private TemplateConfig templateConfig;
    private static final String FILE_SUFFIX = "GIF,JPG,JPEG,PNG,MP4,PDF,gif,jpg,jpeg,png,mp4,pdf";

    @Override
    public ReturnMsg queryRules(String ruleName) {
        Return msg = new Return();
        DsnRulesTemplate dsnRules = new DsnRulesTemplate();
        dsnRules.where().setCheckWhere(false);
        if (!StrUtils.isNull((Object)ruleName)) {
            dsnRules.where().addLike(DsnRulesTemplate.RULE_NAME, (Object)ruleName);
        }
        dsnRules.setOrderBy(new Sort.Order[]{DsnRulesTemplate.CRT_DATE.desc()});
        List dsnRulesList = this.dao.findAll((AbsModel)dsnRules, Boolean.valueOf(true));
        msg.setDataList(dsnRulesList, DsnRulesTemplate.class);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRulesInfoAndParams(String ruleId) {
        Return msg = new Return();
        DsnRulesTemplate dsnRulesTemplate = (DsnRulesTemplate)this.dao.findOne(DsnRulesTemplate.n().where().addEq(DsnRulesTemplate.RULE_ID, (Object)ruleId).model());
        RulesInfoVo vo = new RulesInfoVo();
        BeanUtils.copyProperties((Object)dsnRulesTemplate, (Object)((Object)vo));
        DsnRulesTemplateParam dsnRulesTemplateParam = new DsnRulesTemplateParam();
        dsnRulesTemplateParam.where().addEq(DsnRulesTemplateParam.RULE_ID, (Object)ruleId);
        dsnRulesTemplateParam.where().addEq(DsnRulesTemplateParam.DATA_FLAG, (Object)"1");
        dsnRulesTemplateParam.setOrderBy(new Sort.Order[]{DsnRulesTemplateParam.DISPLAY_ORDER.asc()});
        List dsnRulesParams = this.dao.findAll((AbsModel)dsnRulesTemplateParam);
        vo.setParams(dsnRulesParams);
        DsnRulesTemplateConst dsnRulesTemplateConst = new DsnRulesTemplateConst();
        dsnRulesTemplateConst.where().addEq(DsnRulesTemplateConst.RULE_ID, (Object)ruleId);
        dsnRulesTemplateConst.where().addEq(DsnRulesTemplateConst.DATA_FLAG, (Object)"1");
        List dsnRulesConsts = this.dao.findAll((AbsModel)dsnRulesTemplateConst);
        vo.setConsts(dsnRulesConsts);
        msg.setDataTable(new Object[]{vo});
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg saveRules(RulesInfoVo rulesInfoVo) {
        Return msg = new Return();
        DsnRulesTemplate dsnRulesTemplate = new DsnRulesTemplate();
        BeanUtils.copyProperties((Object)((Object)rulesInfoVo), (Object)dsnRulesTemplate);
        this.checkTemplate(dsnRulesTemplate);
        String ruleId = rulesInfoVo.getRuleId();
        if (StrUtils.isNull((Object)ruleId)) {
            String uuid = UUID.uuid();
            rulesInfoVo.setRuleId(uuid);
            dsnRulesTemplate.setRuleId(uuid);
            this.dao.save((AbsModel)dsnRulesTemplate);
            msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        } else {
            dsnRulesTemplate.where().addEq(DsnRulesTemplate.RULE_ID, (Object)ruleId);
            this.dao.update((AbsModel)dsnRulesTemplate);
            msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        }
        if (!StrUtils.isNull((Object)rulesInfoVo.getStep()) && "3".equals(rulesInfoVo.getStep())) {
            this.saveConstList(rulesInfoVo);
        }
        msg.setDataTable(new Object[]{rulesInfoVo});
        return msg.msg();
    }

    @Override
    public ReturnMsg delRules(List<String> ruleIds) {
        Return msg = new Return();
        DsnRules dsnRules = new DsnRules();
        dsnRules.where().addIn(DsnRules.RULE_TEMPLATE_ID, ruleIds);
        List resUsed = this.dao.findAll((AbsModel)dsnRules);
        if (!CollectionUtils.isEmpty((Collection)resUsed)) {
            msg.setFailMsg(new Message("5010009", "\u5df2\u7ecf\u4f7f\u7528\u7684\u5e38\u7528\u89c4\u5219\u4e0d\u5141\u8bb8\u5220\u9664\uff01"));
            return msg.msg();
        }
        DsnRulesTemplate dsnRulesTemplate = new DsnRulesTemplate();
        dsnRulesTemplate.where().addIn(DsnRulesTemplate.RULE_ID, ruleIds);
        this.dao.delete((AbsModel)dsnRulesTemplate);
        DsnRulesTemplateParam dsnRulesTemplateParam = new DsnRulesTemplateParam();
        dsnRulesTemplateParam.where().addIn(DsnRulesTemplateParam.RULE_ID, ruleIds);
        this.dao.delete((AbsModel)dsnRulesTemplateParam);
        DsnRulesTemplateConst dsnRulesTemplateConst = new DsnRulesTemplateConst();
        dsnRulesTemplateConst.where().addIn(DsnRulesTemplateConst.RULE_ID, ruleIds);
        this.dao.delete((AbsModel)dsnRulesTemplateConst);
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg getRuleInfo(String ruleId) {
        Return msg = new Return();
        DsnRulesTemplate dsnRulesTemplate = (DsnRulesTemplate)this.dao.findOne(DsnRulesTemplate.n().where().addEq(DsnRulesTemplate.RULE_ID, (Object)ruleId).model());
        msg.setDataTable(new Object[]{dsnRulesTemplate});
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg saveParamList(SaveParams saveParams) {
        Return msg = new Return();
        List dsnRulesParams = this.dao.findAll(DsnRulesTemplateParam.n().where().addEq(DsnRulesTemplateParam.RULE_ID, (Object)saveParams.getRuleId()).model());
        if (CollectionUtils.isNotEmpty((Collection)dsnRulesParams)) {
            DsnRulesTemplateParam dsnRulesParam = new DsnRulesTemplateParam();
            dsnRulesParam.where().addEq(DsnRulesTemplateParam.RULE_ID, (Object)saveParams.getRuleId());
            this.dao.delete((AbsModel)dsnRulesParam);
        }
        if (CollectionUtils.isNotEmpty(saveParams.getParams())) {
            List<DsnRulesTemplateParam> params = saveParams.getParams();
            params.forEach(o -> o.setParamId(UUID.uuid()));
            this.dao.save(params);
        }
        msg.setSuccessMsg(new Message("2010005", "\u4fdd\u5b58\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg saveConstList(RulesInfoVo rulesInfoVo) {
        Return msg = new Return();
        List<DsnRulesTemplateConst> consts = rulesInfoVo.getConsts();
        String ruleId = rulesInfoVo.getRuleId();
        DsnRulesTemplateConst dsnRulesTemplateConst = new DsnRulesTemplateConst();
        dsnRulesTemplateConst.where().addEq(DsnRulesTemplateConst.RULE_ID, (Object)ruleId);
        this.dao.delete((AbsModel)dsnRulesTemplateConst);
        if (CollectionUtils.isNotEmpty(consts)) {
            consts.forEach(o -> o.setRuleId(ruleId));
            this.dao.save(consts);
        }
        msg.setSuccessMsg(new Message("2010005", "\u4fdd\u5b58\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public void updateUseNumber(String ruleId) {
        DsnRulesTemplate dsnRulesTemplate = (DsnRulesTemplate)this.dao.findOne(DsnRulesTemplate.n().where().addEq(DsnRulesTemplate.RULE_ID, (Object)ruleId).model());
        if (dsnRulesTemplate != null) {
            dsnRulesTemplate.setUseNumber(Integer.valueOf(StrUtils.isNull((Object)dsnRulesTemplate.getUseNumber()) ? 1 : dsnRulesTemplate.getUseNumber() + 1));
            dsnRulesTemplate.where().addEq(DsnRulesTemplate.RULE_ID, (Object)ruleId);
            this.dao.update((AbsModel)dsnRulesTemplate);
        }
    }

    @Override
    public ReturnMsg queryAllRule() {
        Return msg = new Return();
        List list = this.dao.findAll(DsnRulesTemplate.n().where().addEq(DsnRulesTemplate.DATA_FLAG, (Object)"1").model());
        msg.setDataList(list, DsnRulesTemplate.class);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg updateUsedRule(DsnRulesTemplate dsnRulesTemplate) {
        Return msg = new Return();
        String templateRuleId = dsnRulesTemplate.getRuleId();
        if (StrUtils.isNull((Object)templateRuleId)) {
            msg.setFailMsg(new Message("9999999", "\u5931\u8d25"));
            return msg.msg();
        }
        DsnRules dsnRulesDb = new DsnRules();
        dsnRulesDb.where().addEq(DsnRules.RULE_TEMPLATE_ID, (Object)templateRuleId);
        dsnRulesDb.where().addEq(DsnRules.RULE_TYPE, (Object)"C");
        List allRules = this.dao.findAll((AbsModel)dsnRulesDb);
        if (CollectionUtils.isEmpty((Collection)allRules)) {
            Ulog.info((String)"\u8be5\u89c4\u5219\u6ca1\u6709\u88ab\u4f7f\u7528");
            msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
            return msg.msg();
        }
        DsnRules dsnRules = new DsnRules();
        dsnRules.where().addEq(DsnRules.RULE_TEMPLATE_ID, (Object)templateRuleId);
        dsnRules.where().addEq(DsnRules.RULE_TYPE, (Object)"C");
        dsnRules.setRuleInfo(dsnRulesTemplate.getRuleInfo());
        dsnRules.setRuleName(dsnRulesTemplate.getRuleName());
        this.dao.update((AbsModel)dsnRules);
        DsnRulesTemplateConst dsnRulesTemplateConst = new DsnRulesTemplateConst();
        dsnRulesTemplateConst.where().addEq(DsnRulesTemplateConst.RULE_ID, (Object)templateRuleId);
        List templateConsts = this.dao.findAll((AbsModel)dsnRulesTemplateConst);
        DsnRulesTemplateParam dsnRulesTemplateParam = new DsnRulesTemplateParam();
        dsnRulesTemplateParam.where().addEq(DsnRulesTemplateParam.RULE_ID, (Object)templateRuleId);
        List templateParams = this.dao.findAll((AbsModel)dsnRulesTemplateParam);
        ArrayList<Object> saveConstList = new ArrayList<Object>();
        ArrayList<DsnRulesParam> saveParamList = new ArrayList<DsnRulesParam>();
        ArrayList<String> deleteRuleId = new ArrayList<String>();
        for (DsnRules rule : allRules) {
            String ruleId = rule.getRuleId();
            deleteRuleId.add(ruleId);
            for (DsnRulesTemplateConst templateConst : templateConsts) {
                DsnRulesConst dsnRulesConst = new DsnRulesConst();
                BeanUtils.copyProperties((Object)templateConst, (Object)dsnRulesConst);
                dsnRulesConst.setSerno(null);
                dsnRulesConst.setRuleId(ruleId);
                saveConstList.add(dsnRulesConst);
            }
            DsnRulesConst dsnRulesConst = new DsnRulesConst();
            dsnRulesConst.where().addEq(DsnRulesConst.RULE_ID, (Object)ruleId);
            List consts = this.dao.findAll((AbsModel)dsnRulesConst);
            for (DsnRulesConst rulesConst : consts) {
                boolean flag = true;
                for (DsnRulesTemplateConst templateConst : templateConsts) {
                    if (!rulesConst.getConstId().equals(templateConst.getConstId())) continue;
                    flag = false;
                }
                if (!flag) continue;
                saveConstList.add(rulesConst);
            }
            DsnRulesParam dsnRulesParam = new DsnRulesParam();
            dsnRulesParam.where().addEq(DsnRulesParam.RULE_ID, (Object)ruleId);
            List params = this.dao.findAll((AbsModel)dsnRulesParam);
            for (DsnRulesTemplateParam templateParam : templateParams) {
                boolean flag = true;
                for (DsnRulesParam rulesParam : params) {
                    if (!rulesParam.getParamCode().equals(templateParam.getParamCode())) continue;
                    flag = false;
                    DsnRulesParam rulesParamUpdate = new DsnRulesParam();
                    BeanUtils.copyProperties((Object)templateParam, (Object)rulesParamUpdate);
                    rulesParamUpdate.setSerno(null);
                    rulesParamUpdate.setRuleId(ruleId);
                    rulesParamUpdate.setParamFact(rulesParam.getParamFact());
                    rulesParamUpdate.setParamValue(rulesParam.getParamValue());
                    saveParamList.add(rulesParam);
                }
                if (!flag) continue;
                DsnRulesParam rulesParam = new DsnRulesParam();
                BeanUtils.copyProperties((Object)templateParam, (Object)rulesParam);
                rulesParam.setSerno(null);
                rulesParam.setRuleId(ruleId);
                saveParamList.add(rulesParam);
            }
        }
        this.dao.delete(DsnRulesParam.n().where().addIn(DsnRulesParam.RULE_ID, deleteRuleId).model());
        this.dao.delete(DsnRulesConst.n().where().addIn(DsnRulesConst.RULE_ID, deleteRuleId).model());
        this.dao.save(saveConstList);
        this.dao.save(saveParamList);
        msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msg.msg();
    }

    private ReturnMsg checkTemplate(DsnRulesTemplate dsnRulesTemplate) {
        List all;
        Return msg = new Return();
        String ruleName = dsnRulesTemplate.getRuleName();
        if (StrUtils.isNull((Object)ruleName)) {
            msg.setFailMsg(new Message("3010001", "\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        if (ruleName.length() < 2) {
            msg.setFailMsg(new Message("3010002", "\u6700\u5c11\u5f55\u51652\u4e2a\u5b57\u7b26"));
            return msg.msg();
        }
        if (ruleName.length() > 128) {
            msg.setFailMsg(new Message("3010003", "\u6700\u591a\u53ef\u5f55\u5165128\u4e2a\u5b57\u7b26"));
            return msg.msg();
        }
        DsnRulesTemplate check = new DsnRulesTemplate();
        check.where().addEq(DsnRulesTemplate.RULE_NAME, (Object)ruleName);
        check.where().addEq(DsnRulesTemplate.DATA_FLAG, (Object)"1");
        if (!StrUtils.isNull((Object)dsnRulesTemplate.getRuleId())) {
            check.where().addNotEq(DsnRulesTemplate.RULE_ID, (Object)dsnRulesTemplate.getRuleId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(all = this.dao.findAll((AbsModel)check)))) {
            msg.setFailMsg(new Message("3010004", "\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u91cd\u590d"));
            return msg.msg();
        }
        return null;
    }

    @Override
    public ReturnMsg exportRules(String ruleIds, HttpServletResponse response) {
        Return r = new Return();
        SipProductSyncTask task = new SipProductSyncTask();
        task.setFuncModule("RULETEMPLATE");
        task.setIsZipDel("1");
        task.setTaskType("EXP");
        task.setCrtDate(new Date());
        StringJoiner joiner = new StringJoiner(",");
        String zipFile = "";
        try {
            String currentTimeMillis = String.valueOf(System.currentTimeMillis());
            String baseAddress = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + "/";
            if (StrUtils.isNull((Object)ruleIds)) {
                r.setFailMsg("\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u4ea7\u54c1");
                return r.msg();
            }
            String[] ruleIdList = ruleIds.split(",");
            ArrayList<RulesInfo> rulesInfoList = new ArrayList<RulesInfo>();
            for (String ruleId : ruleIdList) {
                RulesInfo rulesInfo = new RulesInfo();
                rulesInfo.load(ruleId, "export");
                joiner.add(rulesInfo.getRule().get(0).getRuleName());
                rulesInfoList.add(rulesInfo);
            }
            for (RulesInfo data : rulesInfoList) {
                String ruleId = data.getRule_id();
                String path = baseAddress + "/" + ruleId + "/";
                FilesUtil.createFile(path + ruleId + ".json");
                FilesUtil.writeToFile(path + ruleId + ".json", JsonUtils.toJson((Object)((Object)data)), false);
            }
            zipFile = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + ".zip";
            Ulog.info((String)("\u5e38\u7528\u89c4\u5219\u5bfc\u51fabaseAddress----" + baseAddress));
            Ulog.info((String)("\u5e38\u7528\u89c4\u5219\u5bfc\u51fazipFile----" + zipFile));
            String zip = FileUtils.zip((String)baseAddress, (String)zipFile, (String[])new String[]{".txt", ".json", ".xlsx", ".png", ".jpg", "jpeg", "gif", "mp4", "pdf"});
            Ulog.info((String)("\u5e38\u7528\u89c4\u5219\u5bfc\u51fazip----" + zip));
            File file = new File(zipFile);
            FileInputStream inputStream = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            inputStream.read(data);
            inputStream.close();
            response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
            response.setContentType("application/octet-stream;charset=ISO8859-1");
            response.addHeader("Content-Length", "" + file.length());
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(currentTimeMillis + ".zip", "UTF-8"));
            ServletOutputStream stream = response.getOutputStream();
            stream.write(data);
            stream.flush();
            stream.close();
            FilesUtil.delFile(baseAddress);
            String taskName = joiner.toString();
            task.setTaskName(taskName);
            task.setTaskState("FINISH");
            task.setFinishDate(new Date());
            task.setZipPath(zipFile);
            this.dao.save((AbsModel)task);
            r.setSuccessMsg("\u5bfc\u51fa\u6210\u529f");
            return r.msg();
        }
        catch (Exception e) {
            e.printStackTrace();
            Ulog.info((String)("\u5e38\u7528\u89c4\u5219\u5bfc\u51fa\u5931\u8d25--->" + e.getMessage()));
            String taskName = joiner.toString();
            task.setTaskName(taskName);
            task.setTaskState("FAIL");
            task.setErrorInfo(e.getMessage());
            task.setFinishDate(new Date());
            this.dao.save((AbsModel)task);
            r.setFailMsg("\u5bfc\u51fa\u5931\u8d25");
            return r.msg();
        }
    }

    @Override
    public ReturnMsg uploadRules(MultipartFile zipFile) {
        SipProductSyncTask task = new SipProductSyncTask();
        task.setCrtDate(new Date());
        String pathName = this.templateConfig.getUploadFormCollectPath() + "/upload/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        Return msg = FilesUtil.unzipFile(zipFile, pathName);
        if (!msg.isSuccessflag()) {
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"));
            return msg.msg();
        }
        File importDir = new File(pathName);
        ArrayList<File> jsonList = new ArrayList<File>();
        ArrayList<File> fileList = new ArrayList<File>();
        RuleServiceImpl.getAllFiles(importDir, jsonList, fileList);
        Ulog.info((String)("\u5e38\u7528\u89c4\u5219\u5bfc\u5165\u83b7\u53d6\u9700\u8981\u8bfb\u53d6\u7684\u6587\u4ef6" + JsonUtils.toJson(jsonList)));
        StringJoiner joiner = new StringJoiner(",");
        for (File jsonFile : jsonList) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
                Throwable throwable = null;
                try {
                    int ch = 0;
                    StringBuilder sb = new StringBuilder();
                    while ((ch = ((Reader)reader).read()) != -1) {
                        sb.append((char)ch);
                    }
                    String jsonStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u5e38\u7528\u89c4\u5219\u6570\u636e\u4e3a" + jsonStr));
                    RulesInfo rulesInfo = (RulesInfo)((Object)JsonUtils.json2Class((String)jsonStr, RulesInfo.class));
                    RulesInfo dbRulesInfo = new RulesInfo();
                    String ruleId = jsonFile.getName().substring(0, jsonFile.getName().lastIndexOf("."));
                    dbRulesInfo.load(ruleId, "upload");
                    String dbRuleStr = JsonUtils.toJson((Object)((Object)dbRulesInfo));
                    Ulog.info((String)("\u67e5\u51fa\u6765\u539f\u6765\u7684\u5e38\u7528\u89c4\u5219\u6570\u636e\u4e3a------->" + dbRuleStr));
                    dbRulesInfo.merge(rulesInfo);
                    dbRuleStr = JsonUtils.toJson((Object)((Object)dbRulesInfo));
                    Ulog.info((String)("merge\u540e\u7684\u5e38\u7528\u89c4\u5219\u6570\u636e\u4e3a------->" + dbRuleStr));
                    dbRulesInfo.save(ruleId);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Ulog.error((Throwable)e);
                Ulog.info((String)("\u5e38\u7528\u89c4\u5219\u5bfc\u5165\u5931\u8d25-->" + e.getMessage()));
                e.printStackTrace();
                msg.setFailMsg("\u5bfc\u5165\u5931\u8d25");
                return msg.msg();
            }
        }
        FilesUtil.delFile(pathName);
        String taskName = joiner.toString();
        task.setFuncModule("RULETEMPLATE");
        task.setTaskType("IMP");
        task.setTaskName(taskName);
        task.setTaskState("FINISH");
        task.setFinishDate(new Date());
        this.dao.save((AbsModel)task);
        msg.setSuccessMsg("\u5bfc\u5165\u6210\u529f");
        return msg.msg();
    }

    public static void getAllFiles(File dir, List<File> jsonList, List<File> fileList) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                RuleServiceImpl.getAllFiles(files[i], jsonList, fileList);
                continue;
            }
            String name = files[i].getName();
            if (name.endsWith(".json")) {
                File file1 = files[i];
                jsonList.add(file1);
            }
            String suffix = name.substring(name.lastIndexOf(".") + 1);
            List<String> fileSuffixList = Arrays.asList(FILE_SUFFIX.split(","));
            if (fileSuffixList.contains(suffix)) {
                File file1 = files[i];
                fileList.add(file1);
            }
            Ulog.info((Object)files[i]);
        }
    }
}

