/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.policy.service.impl;

import com.newtouch.base.enums.SmsEnum;
import com.newtouch.base.policy.service.CheckService;
import com.newtouch.base.policy.service.ETongReqService;
import com.newtouch.base.policy.service.ProposalFormService;
import com.newtouch.base.policy.service.impl.OrderServiceImpl;
import com.newtouch.base.policy.service.impl.PolicyServiceImpl;
import com.newtouch.base.utils.SystemEAbutmentUtil;
import com.newtouch.base.utils.sys.SysTradeLog;
import com.newtouch.policy.model.PolPolicyOrder;
import com.newtouch.policy.model.PolPolicyRisk;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProposalFormServiceImpl
implements ProposalFormService {
    private static Map<String, String> mapmm;
    @Value(value="${ETong.saveInsureList}")
    private String eTongSaveInsureUrl;
    @Value(value="${apiPlatform.apikey}")
    private String apiPlatformApikey;
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private ETongReqService eTongReqService;
    @Autowired
    private SystemEAbutmentUtil systemEAbutmentUtil;
    @Autowired
    private OrderServiceImpl orderServiceImpl;
    @Autowired
    private PolicyServiceImpl policyServiceImpl;
    @Autowired
    private CheckService checkService;

    @Override
    public ReturnMsg getPolicyList(Map<String, Object> requestMap, String isNq) {
        Return msgtu = new Return();
        String agent_code = (String)requestMap.get("agent_code");
        String policy_state = (String)requestMap.get("policy_state");
        String projectNo = (String)requestMap.get("project_no");
        if (StrUtils.isNull((Object)agent_code)) {
            msgtu.setFailMsg("\u4e1a\u52a1\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msgtu.msg();
        }
        if (StrUtils.isNull((Object)policy_state)) {
            msgtu.setFailMsg("\u4fdd\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return msgtu.msg();
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Object> list = new ArrayList<Object>();
        stringBuilder.append("select ppo.order_uuid,to_char(ppo.apply_date, 'YYYY-MM-DD') apply_date,ppo.image_upload,ppo.agent_level,ppo.cooperativity_model,ppo.is_agent_relative_dr,ppo.is_bancassurance,ppo.is_connected_project_code,ppo.is_pension_exclusive,ppo.is_pension_policy,ppo.is_rural,ppo.is_show_licence_code,ppo.is_union_type,ppo.notify_type,ppo.outeragent_code,ppo.policy_input_type,ppo.recommend_repair_code,ppo.shop_name_4s,ppo.sky_sign_state,ppo.bespoketype, ppo.bespokedate, ");
        stringBuilder.append(" pp.policy_state,pp.approval_date,pp.agent_id,pp.apply_code,to_char(pp.apply_date, 'YYYY-MM-DD') apply_datepp,pp.crt_date,pp.crt_user,pp.data_flag,pp.delivery_mode,pp.organ_id,");
        stringBuilder.append(" pp.extra_premium_disable,pp.is_record,pp.effective_date,pp.extra_premium,pp.followup_mode,pp.initial_premium, ");
        stringBuilder.append(" pp.insure_type,pp.is_2nd_dev,pp.is_underwrite,pp.extra_premium_job,pp.manual_cause,pp.manual_state,pp.mdf_date,pp.mdf_user,pp.patch_memo,pp.policy_code,pp.policy_type,pp.received_date,pp.received_mode,pp.reduce_amount, ");
        stringBuilder.append(" pp.serno,pp.sign_state,pp.insured_amount,pp.terminate_date,pp.topup_premium,pp.total_amount,pp.uw_cause,pp.uw_finish_date,pp.uw_memo,pp.extra_premium_weak, ");
        stringBuilder.append(" ppp.acct_holder,ppp.bank_branch,ppp.dpst_bank,ppp.fail_count,ppp.id_no,ppp.id_type,ppp.is_ocr_result,ppp.pay_acct,ppp.pay_amount,ppp.pay_fail_msg,ppp.pay_mode,ppp.pay_plat,ppp.pay_state,ppp.pay_type,ppp.premium_source,ppp.reserve_phone,ppp.result_code,ppp.result_msg,ppp.verify_time,");
        stringBuilder.append(" ppop.party_uuid,ppop.full_name ");
        stringBuilder.append(" from pol_policy_order ppo ");
        stringBuilder.append(" left join pol_policy pp on ppo.order_uuid = pp.order_uuid ");
        stringBuilder.append(" left join pol_policy_pay ppp on ppo.order_uuid = ppp.order_uuid ");
        stringBuilder.append(" left join pol_policy_order_party ppop on ppo.order_uuid = ppop.order_uuid ");
        stringBuilder.append(" and ppop.party_type =  ? ");
        if (!StrUtils.isNull((Object)projectNo)) {
            stringBuilder.append(" left join pol_policy_corporate_project ppcp on ppo.order_uuid = ppcp.order_uuid ");
        }
        stringBuilder.append("where 1 = 1 ");
        list.add("TBR");
        if (!StrUtils.isNull((Object)isNq) && isNq.startsWith("N")) {
            stringBuilder.append("and ppo.is_internal_policy =  ? ");
            list.add("Y");
        }
        stringBuilder.append("and ppo.agent_id =  ? ");
        list.add(agent_code);
        String stateList = policy_state;
        String[] policyStateList = stateList.split(",");
        List<String> stateIdList = Arrays.asList(policyStateList);
        stringBuilder.append(" and pp.policy_state  in ( ");
        for (int i = 0; i < stateIdList.size(); ++i) {
            if (i == stateIdList.size() - 1) {
                stringBuilder.append(" ?  ");
            } else {
                stringBuilder.append(" ?,  ");
            }
            list.add(stateIdList.get(i));
        }
        stringBuilder.append(")");
        if (!StrUtils.isNull((Object)projectNo)) {
            String proList = projectNo;
            String[] projectList = proList.split(",");
            List<String> projectNoList = Arrays.asList(projectList);
            stringBuilder.append(" and ppcp.project_no in ( ");
            for (int i = 0; i < projectNoList.size(); ++i) {
                if (i == projectNoList.size() - 1) {
                    stringBuilder.append(" ?  ");
                } else {
                    stringBuilder.append(" ?,  ");
                }
                list.add(projectNoList.get(i));
            }
            stringBuilder.append(")");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!StrUtils.isNull((Object)requestMap.get("start_date"))) {
            stringBuilder.append("and ppo.apply_date >= ? ");
            list.add(requestMap.get("start_date"));
        }
        if (!StrUtils.isNull((Object)requestMap.get("end_date"))) {
            stringBuilder.append("and ppo.apply_date <= ?  ");
            list.add(requestMap.get("end_date"));
        }
        stringBuilder.append("order by ppo.mdf_date desc");
        List pdMaterialList = this.dao.findAll(stringBuilder.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(list)});
        ArrayList<HashMap<String, Object>> data = new ArrayList<HashMap<String, Object>>();
        for (Map policy : pdMaterialList) {
            StringBuilder stringBuilderRisk = new StringBuilder();
            ArrayList<String> listRisk = new ArrayList<String>();
            stringBuilderRisk.append("select pr.* from pol_policy_risk pr ");
            stringBuilderRisk.append(" left join pol_policy_order_party ppop on ");
            stringBuilderRisk.append(" pr.party_uuid = ppop.party_uuid ");
            stringBuilderRisk.append(" and pr.order_uuid = ppop.order_uuid ");
            stringBuilderRisk.append("where 1 = 1 ");
            if (!StrUtils.isNull((Object)requestMap.get("name"))) {
                stringBuilderRisk.append("and (ppop.full_name   like  ? or pr.risk_name like  ? ) ");
                listRisk.add("%" + requestMap.get("name") + "%");
                listRisk.add("%" + requestMap.get("name") + "%");
            }
            stringBuilderRisk.append(" and pr.order_uuid =  ?  ");
            stringBuilderRisk.append(" and pr.risk_type !=  ?  ");
            listRisk.add((String)policy.get("order_uuid"));
            listRisk.add("P");
            List riskList = this.dao.findAll(stringBuilderRisk.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(listRisk)});
            List prdList = riskList.stream().filter(p -> "M".equals(p.get("risk_type")) || "A".equals(p.get("risk_type")) || "W".equals(p.get("risk_type"))).collect(Collectors.toList());
            List patryUuid = prdList.stream().filter(p -> !p.get("party_uuid").equals("")).collect(Collectors.toList());
            String fieldName = "initial_premium";
            Double totalPaymentPeriod = prdList.stream().filter(p -> p.containsKey(fieldName) && p.get(fieldName) != null && !p.get(fieldName).equals("")).mapToDouble(p -> Double.parseDouble(p.get(fieldName).toString())).sum();
            List insureTypes = prdList.stream().map(map -> (String)map.get("insure_type")).collect(Collectors.toList());
            List polPolicyRisks = JsonUtils.json2List((String)JsonUtils.toJson((Object)riskList), PolPolicyRisk.class);
            String insureType = this.policyServiceImpl.getInsureType(polPolicyRisks);
            List policyIds = prdList.stream().distinct().map(map -> (String)map.get("policy_id")).collect(Collectors.toList());
            HashMap<String, Integer> mapmerge = new HashMap<String, Integer>();
            for (String policyId : policyIds) {
                List mergeflag = prdList.stream().filter(p -> !StrUtils.isNull(p.get("initial_premium")) && p.get("merge_calc_flag").equals("Y") && policyId.equals(p.get("policy_id"))).collect(Collectors.toList());
                Integer len = mergeflag.size();
                mapmerge.put(policyId, len);
            }
            if (!CollectionUtils.isEmpty(patryUuid)) {
                riskList = riskList.stream().collect(Collectors.collectingAndThen(Collectors.toMap(map -> map.get("policy_id"), Function.identity(), (existing, replacement) -> existing), map -> new ArrayList(map.values())));
            }
            if (!StrUtils.isNull((Object)requestMap.get("name")) && CollectionUtils.isEmpty((Collection)riskList)) {
                pdMaterialList.remove(policy);
                continue;
            }
            policy.put("sipRisk", riskList);
            HashMap<String, Object> datapolicy = new HashMap<String, Object>();
            ArrayList<Map<String, Object>> polPolicyList = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> signList = new ArrayList<Map<String, Object>>();
            if (!CollectionUtils.isEmpty((Collection)riskList)) {
                for (Map risk1 : riskList) {
                    HashMap<String, Object> polPolicy = new HashMap<String, Object>();
                    String mergeCalcFlag = (String)risk1.get("merge_calc_flag");
                    Integer len = (Integer)mapmerge.get(risk1.get("policy_id"));
                    if (!StrUtils.isNull((Object)mergeCalcFlag) && mergeCalcFlag.equals("Y") && len == 2) {
                        Double initialPremium = null;
                        if (!Objects.isNull(risk1.get("initial_premium")) && !risk1.get("initial_premium").equals("")) {
                            initialPremium = Double.parseDouble((String)risk1.get("initial_premium"));
                            totalPaymentPeriod = totalPaymentPeriod - initialPremium;
                        }
                    }
                    PolPolicyRisk risk2 = (PolPolicyRisk)JsonUtils.map2Class((Map)risk1, PolPolicyRisk.class);
                    this.setPolPolicy(polPolicy, risk2);
                    polPolicyList.add(polPolicy);
                }
            }
            this.extracted(policy, datapolicy, polPolicyList, signList, totalPaymentPeriod, insureType);
            data.add(datapolicy);
        }
        msgtu.setDataList(data);
        msgtu.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msgtu.msg();
    }

    public String insureTypes(List<String> insureTypes) {
        String insureType = "";
        insureType = insureTypes.size() == 0 ? "" : (insureTypes.size() == 1 ? insureTypes.get(0) : (insureTypes.contains("FZSJ") ? "FZSJ" : (insureTypes.contains("PZJG") ? "PZJG" : "CQ")));
        return insureType;
    }

    @Override
    public ReturnMsg updateOrderWj(Map<String, Object> requestMap) {
        Return msg = new Return();
        String order_uuid = (String)requestMap.get("order_uuid");
        this.checkService.checkAuth(order_uuid);
        String policyFlowType = (String)requestMap.get("policy_flow_type");
        if (!StrUtils.isNull((Object)policyFlowType) && (policyFlowType.equals("double") || policyFlowType.equals("family"))) {
            ArrayList polPolicyList = new ArrayList();
            order_uuid = (String)requestMap.get("order_uuid");
            PolPolicyOrder policyOrder = new PolPolicyOrder();
            policyOrder.where().addEq(PolPolicyOrder.ORDER_UUID, (Object)order_uuid);
            PolPolicyOrder policyOrderdou = (PolPolicyOrder)this.dao.findOne((AbsModel)policyOrder);
            PolPolicyRisk policyRisk = new PolPolicyRisk();
            policyRisk.where().addEq(PolPolicyRisk.ORDER_UUID, (Object)order_uuid);
            policyRisk.where().addEq(PolPolicyRisk.IS_MAIN_RISK, (Object)"M");
            List policyRiskList = this.dao.findAll((AbsModel)policyRisk);
            for (PolPolicyRisk risk1 : policyRiskList) {
                HashMap<String, String> polPolicy = new HashMap<String, String>();
                polPolicy.put("risk_code", risk1.getRiskCode());
                polPolicy.put("risk_name", risk1.getRiskName());
                polPolicy.put("benefit_duration", risk1.getBenefitDuration());
                polPolicy.put("benefit_duration_mode", risk1.getBenefitDurationMode());
                polPolicy.put("benefit_duration_mode_name", risk1.getBenefitDurationMode());
                polPolicy.put("charge_type", risk1.getChargeType());
                polPolicy.put("cvr_amount", risk1.getCvrAmount());
                polPolicy.put("initial_premium", risk1.getInitialPremium());
                polPolicy.put("payment_duration", risk1.getPaymentDuration());
                polPolicy.put("payment_duration_mode", risk1.getPaymentDurationMode());
                polPolicy.put("payment_duration_mode_name", risk1.getPaymentDurationMode());
                polPolicy.put("gross_premium", "");
                polPolicy.put("topup_premium", risk1.getTopupPremium());
                polPolicyList.add(polPolicy);
            }
            requestMap.put("order_uuid", order_uuid);
            requestMap.put("funcID", "saveInsureList.controller");
            requestMap.put("rqstType", "MOBILE");
            requestMap.put("organ_id", policyOrderdou.getOrganId());
            requestMap.put("risk_info", polPolicyList);
        }
        requestMap.remove("order_uuid");
        String organ_id = (String)requestMap.get("organ_id");
        requestMap.remove("organ_id");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("organ_id", organ_id);
        SysTradeLog sysTradeLog = new SysTradeLog();
        String transno = UUID.shortUUID();
        sysTradeLog.setInterfaceNo(SmsEnum.abutmentInterface.abutmentEFXJG.getType());
        sysTradeLog.setSystemNo(SmsEnum.callSystem.SystemeTong.getType());
        sysTradeLog.setParamData(JsonUtils.toJson(requestMap));
        sysTradeLog.setTransNo(transno);
        sysTradeLog.setParamType(SmsEnum.paramType.paramTypeReq.getType());
        sysTradeLog.setOrderUuid(order_uuid);
        this.systemEAbutmentUtil.insertSysTradeLog(sysTradeLog);
        String resultStr = "";
        headerMap.put("order_uuid", order_uuid);
        resultStr = this.eTongReqService.jsonPostETong(this.eTongSaveInsureUrl + "?apikey=" + this.apiPlatformApikey, JsonUtils.toJson(requestMap), headerMap);
        sysTradeLog.setParamData(resultStr);
        sysTradeLog.setParamType(SmsEnum.paramType.paramTypeRes.getType());
        this.systemEAbutmentUtil.insertSysTradeLog(sysTradeLog);
        Map result = JsonUtils.json2Map((String)resultStr);
        String success = (String)result.get("flag");
        if (success.equals("fail")) {
            List messages = (List)result.get("msg");
            ArrayList<Message> fail = new ArrayList<Message>();
            for (Map o : messages) {
                Message m = new Message();
                System.out.println(o);
                m.setMsgRemark((String)o.get(""));
                fail.add(m);
            }
            msg.setFailMsg(fail);
            return msg.msg();
        }
        PolPolicyOrder policyOrder = new PolPolicyOrder();
        policyOrder.setWjId((String)requestMap.get("wj_id"));
        policyOrder.where().addEq(PolPolicyOrder.ORDER_UUID, (Object)order_uuid);
        this.dao.update((AbsModel)policyOrder);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryPolicyInsuredType(Map<String, Object> requestMap) {
        this.checkService.checkAuth((String)requestMap.get("order_uuid"));
        Return msg = new Return();
        String order_uuid = (String)requestMap.get("order_uuid");
        Map dataInfo = new HashMap();
        dataInfo = (Map)requestMap.get("dataInfo");
        String insured_type_1 = (String)dataInfo.get("insured_type_1");
        String insured_type_2 = (String)dataInfo.get("insured_type_2");
        PolPolicyOrder policyOrder = new PolPolicyOrder();
        policyOrder.setInsuredType1(insured_type_1);
        policyOrder.setInsuredType2(insured_type_2);
        policyOrder.where().addEq(PolPolicyOrder.ORDER_UUID, (Object)order_uuid);
        this.dao.update((AbsModel)policyOrder);
        return msg.msg();
    }

    @Override
    public ReturnMsg insertSysTradeLog(SysTradeLog entry) {
        Return msg = new Return();
        this.dao.save((AbsModel)entry);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryPolicycount(Map<String, Object> requestMap) {
        Return msgtu = new Return();
        String agent_code = (String)requestMap.get("agent_code");
        String policy_state = (String)requestMap.get("policy_state");
        String projectNo = (String)requestMap.get("project_no");
        if (StrUtils.isNull((Object)agent_code)) {
            msgtu.setFailMsg("\u4e1a\u52a1\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msgtu.msg();
        }
        this.checkService.checkAuthAnent(agent_code);
        if (StrUtils.isNull((Object)policy_state)) {
            msgtu.setFailMsg("\u4fdd\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return msgtu.msg();
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Object> list = new ArrayList<Object>();
        stringBuilder.append(" select ppo.order_uuid ");
        stringBuilder.append(" from pol_policy_order ppo ");
        stringBuilder.append(" left join pol_policy pp on ppo.order_uuid = pp.order_uuid ");
        stringBuilder.append(" left join pol_policy_pay ppp on ppo.order_uuid = ppp.order_uuid ");
        stringBuilder.append(" left join pol_policy_order_party ppop on ppo.order_uuid = ppop.order_uuid ");
        stringBuilder.append(" and ppop.party_type =  ? ");
        if (!StrUtils.isNull((Object)projectNo)) {
            stringBuilder.append(" left join pol_policy_corporate_project ppcp on ppo.order_uuid = ppcp.order_uuid ");
        }
        stringBuilder.append("where 1 = 1 ");
        stringBuilder.append("and ppo.agent_id =  ? ");
        list.add("TBR");
        list.add(agent_code);
        String stateList = policy_state;
        String[] policyStateList = stateList.split(",");
        List<String> stateIdList = Arrays.asList(policyStateList);
        stringBuilder.append(" and pp.policy_state  in ( ");
        for (int i = 0; i < stateIdList.size(); ++i) {
            if (i == stateIdList.size() - 1) {
                stringBuilder.append(" ?  ");
            } else {
                stringBuilder.append(" ?,  ");
            }
            list.add(stateIdList.get(i));
        }
        stringBuilder.append(")");
        if (!StrUtils.isNull((Object)projectNo)) {
            String proList = projectNo;
            String[] projectList = proList.split(",");
            List<String> projectNoList = Arrays.asList(projectList);
            stringBuilder.append(" and ppcp.project_no in ( ");
            for (int i = 0; i < projectNoList.size(); ++i) {
                if (i == projectNoList.size() - 1) {
                    stringBuilder.append(" ?  ");
                } else {
                    stringBuilder.append(" ?,  ");
                }
                list.add(projectNoList.get(i));
            }
            stringBuilder.append(")");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!StrUtils.isNull((Object)requestMap.get("start_date"))) {
            stringBuilder.append("and ppo.apply_date >= ? ");
            list.add(requestMap.get("start_date"));
        }
        if (!StrUtils.isNull((Object)requestMap.get("end_date"))) {
            stringBuilder.append("and ppo.apply_date <= ?  ");
            list.add(requestMap.get("end_date"));
        }
        List pdMaterialList = this.dao.findAll(stringBuilder.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(list)});
        HashMap<String, Integer> defmap = new HashMap<String, Integer>();
        Integer count = pdMaterialList.size();
        defmap.put("NotSubmittedCount", count);
        msgtu.setDataTable(defmap);
        msgtu.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msgtu.msg();
    }

    @Override
    public ReturnMsg delPolicyList(Map<String, Object> requestMap) {
        Return msgtu = new Return();
        String agent_code = (String)requestMap.get("agent_code");
        String policy_state = (String)requestMap.get("policy_state");
        if (StrUtils.isNull((Object)policy_state)) {
            msgtu.setFailMsg("\u4fdd\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            return msgtu.msg();
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Object> list = new ArrayList<Object>();
        stringBuilder.append("select ppo.order_uuid,to_char(ppo.apply_date, 'YYYY-MM-DD') apply_date,ppo.image_upload,ppo.agent_level,ppo.cooperativity_model,ppo.is_agent_relative_dr,ppo.is_bancassurance,ppo.is_connected_project_code,ppo.is_pension_exclusive,ppo.is_pension_policy,ppo.is_rural,ppo.is_show_licence_code,ppo.is_union_type,ppo.notify_type,ppo.outeragent_code,ppo.policy_input_type,ppo.recommend_repair_code,ppo.shop_name_4s,ppo.sky_sign_state, ");
        stringBuilder.append(" pp.policy_state,pp.approval_date,pp.agent_id,pp.apply_code,to_char(pp.apply_date, 'YYYY-MM-DD') apply_datepp,pp.crt_date,pp.crt_user,pp.data_flag,pp.delivery_mode,pp.organ_id,");
        stringBuilder.append(" pp.extra_premium_disable,pp.is_record,pp.effective_date,pp.extra_premium,pp.followup_mode,pp.initial_premium, ");
        stringBuilder.append(" pp.insure_type,pp.is_2nd_dev,pp.is_underwrite,pp.extra_premium_job,pp.manual_cause,pp.manual_state,pp.mdf_date,pp.mdf_user,pp.patch_memo,pp.policy_code,pp.policy_type,pp.received_date,pp.received_mode,pp.reduce_amount, ");
        stringBuilder.append(" pp.serno,pp.sign_state,pp.insured_amount,pp.terminate_date,pp.topup_premium,pp.total_amount,pp.uw_cause,pp.uw_finish_date,pp.uw_memo,pp.extra_premium_weak, ");
        stringBuilder.append(" ppp.acct_holder,ppp.bank_branch,ppp.dpst_bank,ppp.fail_count,ppp.id_no,ppp.id_type,ppp.is_ocr_result,ppp.pay_acct,ppp.pay_amount,ppp.pay_fail_msg,ppp.pay_mode,ppp.pay_plat,ppp.pay_state,ppp.pay_type,ppp.premium_source,ppp.reserve_phone,ppp.result_code,ppp.result_msg,ppp.verify_time,");
        stringBuilder.append(" ppop.party_uuid,ppop.full_name ");
        stringBuilder.append(" from pol_policy_order ppo ");
        stringBuilder.append(" left join pol_policy pp on ppo.order_uuid = pp.order_uuid ");
        stringBuilder.append(" left join pol_policy_pay ppp on ppo.order_uuid = ppp.order_uuid ");
        stringBuilder.append(" left join pol_policy_order_party ppop on ppo.order_uuid = ppop.order_uuid ");
        stringBuilder.append(" and ppop.party_type =  ? ");
        stringBuilder.append("where 1 = 1 ");
        if (!StrUtils.isNull((Object)agent_code)) {
            stringBuilder.append("and ppo.agent_id =  ? ");
        }
        list.add("TBR");
        if (!StrUtils.isNull((Object)agent_code)) {
            list.add(agent_code);
        }
        String stateList = policy_state;
        String[] policyStateList = stateList.split(",");
        List<String> stateIdList = Arrays.asList(policyStateList);
        stringBuilder.append(" and pp.policy_state  in ( ");
        for (int i = 0; i < stateIdList.size(); ++i) {
            if (i == stateIdList.size() - 1) {
                stringBuilder.append(" ?  ");
            } else {
                stringBuilder.append(" ?,  ");
            }
            list.add(stateIdList.get(i));
        }
        stringBuilder.append(")");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!StrUtils.isNull((Object)requestMap.get("start_date"))) {
            stringBuilder.append("and ppo.apply_date >= ? ");
            list.add(requestMap.get("start_date"));
        }
        if (!StrUtils.isNull((Object)requestMap.get("end_date"))) {
            stringBuilder.append("and ppo.apply_date <= ?  ");
            list.add(requestMap.get("end_date"));
        }
        stringBuilder.append("order by ppo.mdf_date desc");
        List pdMaterialList = this.dao.findAll(stringBuilder.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(list)});
        ArrayList data = new ArrayList();
        for (Map policy : pdMaterialList) {
            HashMap<String, Object> datapolicy = new HashMap<String, Object>();
            datapolicy.put("policy_uuid", policy.get("order_uuid"));
            datapolicy.put("delete_type", "W");
            this.orderServiceImpl.deletePolicy(datapolicy);
        }
        msgtu.setDataList(data);
        msgtu.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msgtu.msg();
    }

    private void extracted(Map<String, Object> policy, Map<String, Object> datapolicy, List<Map<String, Object>> polPolicyList, List<Map<String, Object>> signList, Double totalPaymentPeriod, String insureType) {
        datapolicy.put("accept_date", policy.get("approval_date"));
        datapolicy.put("acct_holder", policy.get("acct_holder"));
        datapolicy.put("acct_pub_pri", "7");
        datapolicy.put("acct_purp", "7");
        datapolicy.put("acct_type", "");
        datapolicy.put("agency_code", "");
        datapolicy.put("agency_hand", "");
        datapolicy.put("agent_code", policy.get("agent_id"));
        datapolicy.put("agent_level", policy.get("agent_level"));
        datapolicy.put("apply_code", policy.get("apply_code"));
        datapolicy.put("apply_date", policy.get("apply_date"));
        datapolicy.put("apply_mode", "");
        datapolicy.put("ask_number", "");
        datapolicy.put("auto_renewal", "");
        datapolicy.put("bank_branch", policy.get("bank_branch"));
        datapolicy.put("bespokedate", policy.get("bespokedate"));
        datapolicy.put("bespoketype", policy.get("bespoketype"));
        datapolicy.put("branchagency_code", "");
        datapolicy.put("business_type", "");
        datapolicy.put("case_uuid", policy.get("case_uuid"));
        datapolicy.put("continue_apply", "");
        datapolicy.put("cooperativity_model", policy.get("cooperativity_model"));
        datapolicy.put("corp_act", "");
        datapolicy.put("corp_bank", "");
        datapolicy.put("crt_date", policy.get("crt_date"));
        datapolicy.put("crt_user", policy.get("crt_user"));
        datapolicy.put("data_flag", policy.get("data_flag"));
        datapolicy.put("delivery_mode", policy.get("delivery_mode"));
        datapolicy.put("dept_id", policy.get("organ_id"));
        datapolicy.put("disable_add_prem", policy.get("extra_premium_disable"));
        datapolicy.put("div_receipt_method", "");
        datapolicy.put("double_code", "");
        datapolicy.put("double_record", policy.get("is_record"));
        datapolicy.put("dpst_bank", policy.get("dpst_bank"));
        datapolicy.put("eff_date", policy.get("effective_date"));
        datapolicy.put("email", "");
        datapolicy.put("emp_code", "");
        datapolicy.put("employee_name", "");
        datapolicy.put("expire_transform_tbr_source", "");
        datapolicy.put("extra_premium", policy.get("extra_premium"));
        datapolicy.put("faceunits", "");
        datapolicy.put("fail_count", policy.get("fail_count"));
        datapolicy.put("fail_reason", "");
        datapolicy.put("followup_mode", policy.get("followup_mode"));
        datapolicy.put("former_policy_code", "");
        datapolicy.put("gross_premium", "");
        datapolicy.put("harmony_health_flag", "");
        datapolicy.put("id_no", policy.get("id_no"));
        datapolicy.put("id_type", policy.get("id_type"));
        datapolicy.put("image_up_state", policy.get("image_upload"));
        datapolicy.put("initial_premium", policy.get("initial_premium"));
        datapolicy.put("insure_type", insureType);
        datapolicy.put("insured_num", "");
        datapolicy.put("invest_acc", "");
        datapolicy.put("isInteractIssue", "");
        datapolicy.put("is_2nd_dev", policy.get("is_2nd_dev"));
        datapolicy.put("is_agent_relative_dr", policy.get("is_agent_relative_dr"));
        datapolicy.put("is_allowedsign", "");
        datapolicy.put("is_bancassurance", policy.get("is_bancassurance"));
        datapolicy.put("is_collaborator", "");
        datapolicy.put("is_connected_project_code", policy.get("is_connected_project_code"));
        datapolicy.put("is_defer_double_record", "");
        datapolicy.put("is_holder_in_insured_company", "");
        datapolicy.put("is_iwp", "");
        datapolicy.put("is_multi_main_risk", "");
        datapolicy.put("is_notice", "");
        datapolicy.put("is_ocr_result", policy.get("is_ocr_result"));
        datapolicy.put("is_pay_cancel", "");
        datapolicy.put("is_pension_exclusive", policy.get("is_pension_exclusive"));
        datapolicy.put("is_pension_policy", policy.get("is_pension_policy"));
        datapolicy.put("is_print_paper_voucher", policy.get(""));
        datapolicy.put("is_proposer_spouse", policy.get(""));
        datapolicy.put("is_rural", policy.get("is_rural"));
        datapolicy.put("is_secrecy", "");
        datapolicy.put("is_show_licence_code", policy.get("is_show_licence_code"));
        datapolicy.put("is_underwrite", policy.get("is_underwrite"));
        datapolicy.put("is_union_type", policy.get("is_union_type"));
        datapolicy.put("is_upload_authorization", "");
        datapolicy.put("is_upload_data", "");
        datapolicy.put("is_verification", "");
        datapolicy.put("job_add_prem", policy.get("extra_premium_job"));
        datapolicy.put("join_service_code", "");
        datapolicy.put("join_service_name", "");
        datapolicy.put("kpi_ratio", "");
        datapolicy.put("manual_cause", policy.get("manual_cause"));
        datapolicy.put("manual_cause_name", "");
        datapolicy.put("manual_state", policy.get("manual_state"));
        datapolicy.put("manual_state_name", "");
        datapolicy.put("mdf_date", policy.get("mdf_date"));
        datapolicy.put("mdf_user", policy.get("mdf_user"));
        datapolicy.put("mobile_review_code", "");
        datapolicy.put("mobile_review_desc", "");
        datapolicy.put("need_audio_video", "");
        datapolicy.put("no_account_type", "");
        datapolicy.put("nonage_sign_state", "");
        datapolicy.put("notify_state", "");
        datapolicy.put("notify_state_number", "");
        datapolicy.put("notify_type", policy.get("notify_type"));
        datapolicy.put("origin_policy_uuid", "");
        datapolicy.put("out_trade_no", "");
        datapolicy.put("outeragent_code", policy.get("outeragent_code"));
        datapolicy.put("outeragent_name", "");
        datapolicy.put("overdue_type", "");
        datapolicy.put("patch_memo", policy.get("patch_memo"));
        datapolicy.put("pay_acct", policy.get("pay_acct"));
        datapolicy.put("pay_amount", policy.get("pay_amount"));
        datapolicy.put("pay_end_date", "");
        datapolicy.put("pay_fail_msg", policy.get("pay_fail_msg"));
        datapolicy.put("pay_mode", policy.get("pay_mode"));
        datapolicy.put("pay_mode_name", "");
        datapolicy.put("pay_plat", policy.get("pay_plat"));
        datapolicy.put("pay_start_date", "");
        datapolicy.put("pay_state", policy.get("pay_state"));
        datapolicy.put("pay_type", policy.get("pay_type"));
        datapolicy.put("payauth_check_code", "");
        datapolicy.put("payauth_check_msg", "");
        datapolicy.put("phone_number", "");
        datapolicy.put("phone_visit", "");
        datapolicy.put("pol_policy", polPolicyList);
        datapolicy.put("pol_policy_corporate_customer", "");
        datapolicy.put("policy_code", policy.get("policy_code"));
        datapolicy.put("policy_create_time", policy.get(""));
        datapolicy.put("policy_holder", policy.get("full_name"));
        datapolicy.put("policy_input_type", policy.get("policy_input_type"));
        datapolicy.put("policy_insured_type", "");
        datapolicy.put("policy_state", policy.get("policy_state"));
        datapolicy.put("policy_state_name", "");
        datapolicy.put("policy_type", policy.get("policy_type"));
        datapolicy.put("policy_uuid", policy.get("order_uuid"));
        datapolicy.put("pre_verification_result", "");
        datapolicy.put("premium_divide", "");
        datapolicy.put("premium_source", policy.get("premium_source"));
        datapolicy.put("product_info", "");
        datapolicy.put("propose_no", policy.get(""));
        datapolicy.put("query_state_number", "");
        datapolicy.put("received_date", policy.get("received_date"));
        datapolicy.put("received_way", policy.get("received_mode"));
        datapolicy.put("recommend_repair_code", policy.get("recommend_repair_code"));
        datapolicy.put("reduced_mount", policy.get("reduce_amount"));
        datapolicy.put("reject_proposer_reason", policy.get(""));
        datapolicy.put("report_receipt_method", "");
        datapolicy.put("request_source", policy.get(""));
        datapolicy.put("resason_manual", "");
        datapolicy.put("reserve_phone", policy.get("reserve_phone"));
        datapolicy.put("result_code", policy.get("result_code"));
        datapolicy.put("result_msg", policy.get("result_msg"));
        datapolicy.put("revoke_policy_code", "");
        datapolicy.put("revoke_transfer_state", "");
        datapolicy.put("risk_name", "");
        datapolicy.put("rn", policy.get("rn"));
        datapolicy.put("serno", policy.get("serno"));
        datapolicy.put("shop_name_4s", policy.get("shop_name_4s"));
        datapolicy.put("signInfoList", signList);
        datapolicy.put("sign_state", policy.get("sign_state"));
        datapolicy.put("sign_type", "");
        datapolicy.put("sky_sign_state", policy.get("sky_sign_state"));
        datapolicy.put("standard_amount", policy.get("insured_amount"));
        datapolicy.put("sub_pay_mode", "");
        datapolicy.put("switch_apply", "");
        datapolicy.put("switch_apply_type", "");
        datapolicy.put("tbr_sex", "");
        datapolicy.put("term_date", policy.get("terminate_date"));
        datapolicy.put("topup_prem", policy.get("topup_premium"));
        datapolicy.put("total_insured", policy.get("total_amount"));
        String totalPaymentPeriodS = String.format("%.2f", totalPaymentPeriod);
        datapolicy.put("total_payment_period", totalPaymentPeriodS);
        datapolicy.put("trans_date", "");
        datapolicy.put("trans_type", "");
        datapolicy.put("transaction_id", "");
        datapolicy.put("unsuccess_type", "");
        datapolicy.put("uw_cause", policy.get("uw_cause"));
        datapolicy.put("uw_cause_name", "");
        datapolicy.put("uw_finish_date", policy.get("uw_finish_date"));
        datapolicy.put("uw_memo", policy.get("uw_memo"));
        datapolicy.put("uw_state", policy.get(""));
        datapolicy.put("verify_time", policy.get("verify_time"));
        datapolicy.put("villageid", "");
        datapolicy.put("visit_date", "");
        datapolicy.put("weak_add_prem", policy.get("extra_premium_weak"));
        datapolicy.put("party_uuid", policy.get("party_uuid"));
    }

    private void setPolPolicy(Map<String, Object> polPolicy, PolPolicyRisk risk1) {
        polPolicy.put("addup_amount", risk1.getAddupAmount());
        polPolicy.put("addup_period", risk1.getAddupPeriod());
        polPolicy.put("addup_status", risk1.getAddupStatus());
        polPolicy.put("addup_type", risk1.getAddupType());
        polPolicy.put("apply_share", risk1.getApplyShare());
        polPolicy.put("assign_rate", risk1.getAssignRate());
        polPolicy.put("associated_policy_code", risk1.getAssociatedPolicyCode());
        polPolicy.put("auto_renewal", risk1.getIsAutoRenewal());
        polPolicy.put("benefit_duration", risk1.getBenefitDuration());
        polPolicy.put("benefit_duration_mode", risk1.getBenefitDurationMode());
        polPolicy.put("benefit_duration_mode_name", "");
        polPolicy.put("benefit_level", risk1.getBenefitLevel());
        polPolicy.put("benefit_mode", risk1.getBenefitMode());
        polPolicy.put("benefit_year", risk1.getBenefitYear());
        polPolicy.put("bespoke_renew_limit", "");
        polPolicy.put("carrying_passenger_num", risk1.getSeatingCapacity());
        polPolicy.put("charge_type", risk1.getChargeType());
        polPolicy.put("charge_type_name", "");
        polPolicy.put("continue_apply", "");
        polPolicy.put("conversion_standard_lock_mode", "");
        polPolicy.put("count_way", risk1.getCountWay());
        polPolicy.put("crt_date", risk1.getCrtDate());
        polPolicy.put("crt_user", risk1.getCrtUser());
        polPolicy.put("cvr_amount", risk1.getCvrAmount());
        polPolicy.put("data_flag", risk1.getDataFlag());
        polPolicy.put("disability_insuance_payout_duration", risk1.getDisabilityInsuancePayoutDuration());
        polPolicy.put("disability_insuance_payout_duration_mode", risk1.getDisabilityInsuancePayoutDurationMode());
        polPolicy.put("disability_insuance_payout_type", risk1.getDisabilityInsuancePayoutType());
        polPolicy.put("disable_add_prem", risk1.getExtraPremiumDisable());
        polPolicy.put("div_receipt_method", risk1.getDivReceiptMethod());
        polPolicy.put("div_type", "");
        polPolicy.put("draw_annuity_amount", risk1.getDrawAnnuityAmount());
        polPolicy.put("elimination_period", risk1.getWaitingPeriod());
        polPolicy.put("except_value", risk1.getExceptValue());
        polPolicy.put("extra_premium", risk1.getExtraPremium());
        polPolicy.put("faceunits", risk1.getFaceunits());
        polPolicy.put("first_payment_period", risk1.getFirstPaymentPeriod());
        polPolicy.put("gross_premium", "");
        polPolicy.put("double_record", risk1.getDoubleRecord());
        polPolicy.put("inform_way", risk1.getInformWay());
        polPolicy.put("initial_premium", risk1.getInitialPremium());
        polPolicy.put("initial_ratio", risk1.getInitialRatio());
        polPolicy.put("insurance_category", "");
        polPolicy.put("is_endowment", "");
        polPolicy.put("is_main_risk", mapmm.get(risk1.getRiskType()));
        polPolicy.put("is_proposer_spouse", risk1.getIsProposerSpouse());
        polPolicy.put("is_required", risk1.getIsRequired());
        polPolicy.put("is_together_pzj", "");
        polPolicy.put("is_waiver", risk1.getIsWaiver());
        polPolicy.put("job_add_prem", risk1.getExtraPremiumJob());
        polPolicy.put("long_term_care_max_pay_period", "");
        polPolicy.put("mdf_date", risk1.getMdfDate());
        polPolicy.put("mdf_user", risk1.getMdfUser());
        polPolicy.put("overdue_type", "");
        polPolicy.put("parent_serno", risk1.getParentSerno());
        polPolicy.put("party_uuid", risk1.getPartyUuid());
        polPolicy.put("patch_memo", risk1.getPatchMemo());
        polPolicy.put("pay_ensure", risk1.getPayEnsure());
        polPolicy.put("pay_method", risk1.getPayMethod());
        polPolicy.put("pay_period", risk1.getPayPeriod());
        polPolicy.put("pay_rate", "");
        polPolicy.put("pay_year", "");
        polPolicy.put("payment_duration", risk1.getPaymentDuration());
        polPolicy.put("payment_duration_mode", risk1.getPaymentDurationMode());
        polPolicy.put("payment_duration_name", "");
        polPolicy.put("payout_duration", risk1.getPayoutDuration());
        polPolicy.put("payout_duration_mode", risk1.getPayoutDurationMode());
        polPolicy.put("payout_end_age", risk1.getAnnuityEndAge());
        polPolicy.put("payout_start_age", risk1.getAnnuityStartAge());
        polPolicy.put("payout_type", risk1.getPayoutType());
        polPolicy.put("pension_draw_annuity_amount", "");
        polPolicy.put("pension_payout_type", "");
        polPolicy.put("pension_ratio", "");
        polPolicy.put("policy_uuid", risk1.getOrderUuid());
        polPolicy.put("pre_tax_revenue", "");
        polPolicy.put("premium_rate_level", "");
        polPolicy.put("product_no", "");
        polPolicy.put("reduced_mount", risk1.getReduceAmount());
        polPolicy.put("reject_proposer_reason", risk1.getRejectProposerReason());
        polPolicy.put("renew_decision", risk1.getRenewDecision());
        polPolicy.put("report_receipt_method", risk1.getReportReceiptMethod());
        polPolicy.put("reserve_premium", "");
        polPolicy.put("risk_no", risk1.getRiskNo());
        polPolicy.put("policy_id", risk1.getPolicyId());
        if (!StrUtils.isNull((Object)risk1.getRiskCode())) {
            polPolicy.put("product_no", risk1.getRiskCode());
        } else {
            polPolicy.put("product_no", risk1.getRiskNo());
        }
        polPolicy.put("is_present_policy ", risk1.getIsPresentPolicy());
        polPolicy.put("risk_name", risk1.getRiskName());
        polPolicy.put("risk_order", risk1.getDisplayOrder());
        polPolicy.put("rn", "");
        polPolicy.put("scheme", risk1.getScheme());
        polPolicy.put("serno", risk1.getSerno());
        polPolicy.put("standard_amount", "");
        polPolicy.put("start_pay_date", risk1.getStartPayDate());
        polPolicy.put("three_one_ratio", "");
        polPolicy.put("topup_prem", risk1.getTopupPremium());
        polPolicy.put("total_payment_period", risk1.getTotalPaymentPeriod());
        polPolicy.put("transfer_adj_acct", risk1.getTransferAdjAcct());
        polPolicy.put("transfered_pol_number", risk1.getTransferedPolNumber());
        polPolicy.put("transfered_pol_type", "");
        polPolicy.put("transfered_risk_no", risk1.getTransferRisk());
        polPolicy.put("travel_type", "");
        polPolicy.put("uw_cause", "");
        polPolicy.put("uw_cause_name", "");
        polPolicy.put("uw_memo", "");
        polPolicy.put("uw_state", "");
        polPolicy.put("uw_state_name", "");
        polPolicy.put("vehicle_engine_num", risk1.getVehicleEngineId());
        polPolicy.put("vehicle_fram_num", risk1.getVehicleFrameId());
        polPolicy.put("vehicle_license_num", risk1.getVehicleLicenseId());
        polPolicy.put("vehicle_type", risk1.getVehicleType());
        polPolicy.put("waiver_code", risk1.getWaiverRisk());
        polPolicy.put("weak_add_prem", risk1.getExtraPremiumWeak());
    }

    static {
        if (mapmm == null) {
            mapmm = new HashMap<String, String>();
            mapmm.put("M", "1");
            mapmm.put("A", "2");
        }
    }
}

