/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.policy.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.shade.com.alibaba.fastjson.JSONObject;
import com.newtouch.base.enums.SmsEnum;
import com.newtouch.base.policy.param.AgainPolicyParam;
import com.newtouch.base.policy.param.DownPolicyParam;
import com.newtouch.base.policy.service.CheckService;
import com.newtouch.base.policy.service.ETongReqService;
import com.newtouch.base.policy.service.PolicyService;
import com.newtouch.base.policy.vo.CorporateProjectVo;
import com.newtouch.base.policy.vo.CrsResult;
import com.newtouch.base.policy.vo.PolCrsResultVo;
import com.newtouch.base.policy.vo.PolPolicyOrderPartyMd5Vo;
import com.newtouch.base.policy.vo.PolPolicyOrderPartyVo;
import com.newtouch.base.policy.vo.PolPolicyVo;
import com.newtouch.base.policy.vo.PolTaxVo;
import com.newtouch.base.policy.vo.PolicyAddressVo;
import com.newtouch.base.policy.vo.PolicyContract;
import com.newtouch.base.policy.vo.PolicyImageVo;
import com.newtouch.base.policy.vo.PolicyInfoVo;
import com.newtouch.base.policy.vo.PolicyPartyCalcVo;
import com.newtouch.base.policy.vo.PolicyPartyVo;
import com.newtouch.base.policy.vo.PolicyPayVo;
import com.newtouch.base.policy.vo.PolicyRiskVo;
import com.newtouch.base.policy.vo.PolicyTaxVo;
import com.newtouch.base.policy.vo.QuestionVo;
import com.newtouch.base.policy.vo.eTong.ETongAddressVo;
import com.newtouch.base.policy.vo.eTong.ETongBpolPolicyPartyVo;
import com.newtouch.base.policy.vo.eTong.ETongContactVo;
import com.newtouch.base.policy.vo.eTong.ETongImageVo;
import com.newtouch.base.policy.vo.eTong.ETongPolPolicyCorporateCompanyVo;
import com.newtouch.base.policy.vo.eTong.ETongPolPolicyCorporateConfirmationVo;
import com.newtouch.base.policy.vo.eTong.ETongPolPolicyCorporateCustomerVo;
import com.newtouch.base.policy.vo.eTong.ETongPolPolicyCorporateProjectVo;
import com.newtouch.base.policy.vo.eTong.ETongPolPolicyCorporateResourceVo;
import com.newtouch.base.policy.vo.eTong.ETongPolPolicyCorporateTeamVo;
import com.newtouch.base.policy.vo.eTong.ETongPolPolicyCorporateUserVo;
import com.newtouch.base.policy.vo.eTong.ETongPolPolicyCorporateVxgroupVo;
import com.newtouch.base.policy.vo.eTong.ETongPolPolicyPartyVo;
import com.newtouch.base.policy.vo.eTong.ETongPolPolicyPayVo;
import com.newtouch.base.policy.vo.eTong.ETongPolPolicyRiskVo;
import com.newtouch.base.policy.vo.eTong.ETongPolPolicyTaxVo;
import com.newtouch.base.policy.vo.eTong.ETongPolPolicyVo;
import com.newtouch.base.policy.vo.eTong.ETongSavePolicyInfoReqVo;
import com.newtouch.base.policy.vo.eTong.ETongSpolPolicyPartyVo;
import com.newtouch.base.policy.vo.eTong.ETongTpolPolicyPartyVo;
import com.newtouch.base.utils.SystemEAbutmentUtil;
import com.newtouch.base.utils.sys.SysTradeLog;
import com.newtouch.policy.model.PolCrsResult;
import com.newtouch.policy.model.PolPolicy;
import com.newtouch.policy.model.PolPolicyCorporateCompany;
import com.newtouch.policy.model.PolPolicyCorporateConfirmation;
import com.newtouch.policy.model.PolPolicyCorporateCustomer;
import com.newtouch.policy.model.PolPolicyCorporateProject;
import com.newtouch.policy.model.PolPolicyCorporateResource;
import com.newtouch.policy.model.PolPolicyCorporateTeam;
import com.newtouch.policy.model.PolPolicyCorporateUser;
import com.newtouch.policy.model.PolPolicyCorporateVxgroup;
import com.newtouch.policy.model.PolPolicyOrder;
import com.newtouch.policy.model.PolPolicyOrderParty;
import com.newtouch.policy.model.PolPolicyParty;
import com.newtouch.policy.model.PolPolicyPartyAddress;
import com.newtouch.policy.model.PolPolicyPartyContact;
import com.newtouch.policy.model.PolPolicyPartyImage;
import com.newtouch.policy.model.PolPolicyPartyRelation;
import com.newtouch.policy.model.PolPolicyPay;
import com.newtouch.policy.model.PolPolicyRisk;
import com.uniapis.logger.Env;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.HttpUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PolicyServiceImpl
implements PolicyService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private ETongReqService eTongReqService;
    @Value(value="${ETong.downPolicy}")
    private String downPolicyPath;
    @Value(value="${ETong.calcProductPremiumNewUrl}")
    private String calcProductPremiumNewUrl;
    @Value(value="${ETong.queryRiskInfo}")
    private String queryRiskInfo;
    @Value(value="${ETong.savePolicyInfoUrl}")
    private String savePolicyInfoUrl;
    @Value(value="${ETong.queryProductListByNo}")
    private String queryProductListByNo;
    @Value(value="${ETong.sendPolicyInfoUrl}")
    private String sendPolicyInfoUrl;
    @Value(value="${apiPlatform.url}")
    private String apiPlatformUrl;
    @Value(value="${apiPlatform.apikey}")
    private String apiPlatformApikey;
    @Autowired
    private SystemEAbutmentUtil systemEAbutmentUtil;
    @Autowired
    private CheckService checkService;
    private final String[] excludeRows = new String[]{"serno", "crt_user", "mdf_user", "crt_date", "mdf_date", "data_flag"};

    public static void copyNonNullProperties(Object source, Object target) {
        BeanUtils.copyProperties((Object)source, (Object)target, (String[])PolicyServiceImpl.getNullPropertyNames(source));
    }

    private static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    @Override
    public ReturnMsg OrderInfo(DownPolicyParam param) {
        List polPolicyOrderPartys;
        List bol_policy_partys;
        this.checkService.checkAuth(param.getPolicy_uuid());
        String policyUuid = param.getPolicy_uuid();
        Return msg = new Return();
        PolPolicy polPolicy = (PolPolicy)this.dao.findOne(PolPolicy.n().where().addEq(PolPolicy.ORDER_UUID, (Object)policyUuid).model());
        PolPolicyOrder polPolicyOrder = (PolPolicyOrder)this.dao.findOne(PolPolicyOrder.n().where().addEq(PolPolicyOrder.ORDER_UUID, (Object)policyUuid).model());
        PolPolicyVo polPolicyVo = new PolPolicyVo();
        polPolicyVo = (PolPolicyVo)JsonUtils.json2Class((String)JsonUtils.toJson((Object)polPolicyOrder), PolPolicyVo.class);
        PolicyServiceImpl.copyNonNullProperties(JsonUtils.json2Class((String)JsonUtils.toJson((Object)polPolicy), PolPolicyVo.class), polPolicyVo);
        PolPolicyPay polPolicyPay = (PolPolicyPay)this.dao.findOne(PolPolicyPay.n().where().addEq(PolPolicyPay.ORDER_UUID, (Object)policyUuid).model());
        PolicyPayVo policyPayVo = new PolicyPayVo();
        if (!StrUtils.isNull((Object)polPolicyPay)) {
            policyPayVo = (PolicyPayVo)((Object)JsonUtils.json2Class((String)JsonUtils.toJson((Object)polPolicyPay), PolicyPayVo.class));
        }
        if (CollectionUtils.isEmpty((Collection)(bol_policy_partys = JsonUtils.json2List((String)JsonUtils.toJson((Object)(polPolicyOrderPartys = this.dao.findAll(PolPolicyOrderParty.n().where().addEq(PolPolicyOrderParty.ORDER_UUID, (Object)policyUuid).model()))), PolicyPartyVo.class)))) {
            PolicyInfoVo policyInfoVo = new PolicyInfoVo();
            polPolicyVo.setPol_policy_corporate_project(this.getCorporate(policyUuid));
            List polPolicyRisks1 = this.dao.findAll(PolPolicyRisk.n().where().addIn(PolPolicyRisk.ORDER_UUID, new String[]{policyUuid}).model());
            policyInfoVo.setPol_policy_risk(polPolicyRisks1);
            policyInfoVo.setPol_policy_pay(policyPayVo);
            policyInfoVo.setPol_policy(polPolicyVo);
            msg.setDataTable(new Object[]{policyInfoVo});
            return msg.msg();
        }
        List polPolicyPartyRelations = this.dao.findAll(PolPolicyPartyRelation.n().where().addIn(PolPolicyPartyRelation.MASTER_RELATION, (String[])polPolicyOrderPartys.stream().map(PolPolicyOrderParty::getPartyUuid).toArray(String[]::new)).model());
        List tAddresses = this.dao.findAll(PolPolicyPartyAddress.n().where().addIn(PolPolicyPartyAddress.PARTY_UUID, (String[])polPolicyOrderPartys.stream().map(PolPolicyOrderParty::getPartyUuid).toArray(String[]::new)).model());
        List address = JsonUtils.json2List((String)JsonUtils.toJson((Object)tAddresses), PolicyAddressVo.class);
        List contracts = this.dao.findAll(PolPolicyPartyContact.n().where().addIn(PolPolicyPartyContact.PARTY_UUID, (String[])polPolicyOrderPartys.stream().map(PolPolicyOrderParty::getPartyUuid).toArray(String[]::new)).model());
        List contact = JsonUtils.json2List((String)JsonUtils.toJson((Object)contracts), PolicyContract.class);
        List polPolicyPartyImages = this.dao.findAll(PolPolicyPartyImage.n().where().addEq(PolPolicyPartyImage.ORDER_UUID, (Object)policyUuid).addIn(PolPolicyPartyImage.PARTY_UUID, (String[])polPolicyOrderPartys.stream().map(PolPolicyOrderParty::getPartyUuid).toArray(String[]::new)).model());
        List imageVos = JsonUtils.json2List((String)JsonUtils.toJson((Object)polPolicyPartyImages), PolicyImageVo.class);
        List polCrsResults = this.dao.findAll(PolCrsResult.n().where().addIn(PolCrsResult.PARTY_UUID, (String[])polPolicyOrderPartys.stream().map(PolPolicyOrderParty::getPartyUuid).toArray(String[]::new)).model());
        bol_policy_partys.stream().forEach(r -> {
            address.stream().forEach(a -> {
                if (r.getParty_uuid().equals(a.getParty_uuid())) {
                    if (StrUtils.isNull(r.getAddress())) {
                        ArrayList<PolicyAddressVo> add = new ArrayList<PolicyAddressVo>();
                        add.add((PolicyAddressVo)((Object)((Object)a)));
                        r.setAddress(add);
                    } else {
                        r.getAddress().add((PolicyAddressVo)((Object)((Object)a)));
                    }
                }
            });
            contact.stream().forEach(a -> {
                if (r.getParty_uuid().equals(a.getParty_uuid())) {
                    if (StrUtils.isNull(r.getContact())) {
                        ArrayList<PolicyContract> add = new ArrayList<PolicyContract>();
                        add.add((PolicyContract)((Object)((Object)a)));
                        r.setContact(add);
                    } else {
                        r.getContact().add((PolicyContract)((Object)((Object)a)));
                    }
                }
            });
            imageVos.stream().forEach(a -> {
                if (r.getParty_uuid().equals(a.getParty_uuid())) {
                    if (StrUtils.isNull(r.getPol_policy_image())) {
                        ArrayList<PolicyImageVo> add = new ArrayList<PolicyImageVo>();
                        add.add((PolicyImageVo)((Object)((Object)a)));
                        r.setPol_policy_image(add);
                    } else {
                        r.getPol_policy_image().add((PolicyImageVo)((Object)((Object)a)));
                    }
                }
            });
            CrsResult crsResult = new CrsResult();
            ArrayList pol_policy_tax = new ArrayList();
            polCrsResults.stream().forEach(a -> {
                if (r.getParty_uuid().equals(a.getPartyUuid())) {
                    crsResult.setFamily_name(a.getFamilyName());
                    crsResult.setFirst_name(a.getFirstName());
                    crsResult.setReason(a.getReason());
                    crsResult.setReasondescribe(a.getReasondescribe());
                    PolTaxVo polTaxVo = new PolTaxVo();
                    if (!StrUtils.isNull((Object)a.getTaxResidentCountry1())) {
                        PolTaxVo polTaxVo1 = new PolTaxVo();
                        polTaxVo1.setTax_resident_country(a.getTaxResidentCountry1());
                        polTaxVo1.setTaxpayer_identification_code(a.getTaxpayerIdentificationCode1());
                        pol_policy_tax.add(polTaxVo1);
                    }
                    if (!StrUtils.isNull((Object)a.getTaxResidentCountry2())) {
                        PolTaxVo polTaxVo2 = new PolTaxVo();
                        polTaxVo2.setTax_resident_country(a.getTaxResidentCountry2());
                        polTaxVo2.setTaxpayer_identification_code(a.getTaxpayerIdentificationCode2());
                        pol_policy_tax.add(polTaxVo2);
                    }
                    if (!StrUtils.isNull((Object)a.getTaxResidentCountry3())) {
                        PolTaxVo polTaxVo3 = new PolTaxVo();
                        polTaxVo3.setTax_resident_country(a.getTaxResidentCountry3());
                        polTaxVo3.setTaxpayer_identification_code(a.getTaxpayerIdentificationCode3());
                        pol_policy_tax.add(polTaxVo3);
                    }
                    if (!StrUtils.isNull((Object)a.getTaxResidentCountry4())) {
                        PolTaxVo polTaxVo4 = new PolTaxVo();
                        polTaxVo4.setTax_resident_country(a.getTaxResidentCountry4());
                        polTaxVo4.setTaxpayer_identification_code(a.getTaxpayerIdentificationCode4());
                        pol_policy_tax.add(polTaxVo4);
                    }
                    crsResult.setPol_policy_tax(pol_policy_tax);
                    r.setCrsResult(crsResult);
                }
            });
            polPolicyPartyRelations.stream().forEach(a -> {
                if (r.getParty_uuid().equals(a.getAffiliatedRelation())) {
                    r.setBenefit_order(a.getBenefitOrder());
                    r.setBenefit_ratio(a.getBenefitRatio());
                    r.setAffiliated_type(a.getAffiliatedType());
                    r.setAffiliated_applicant(a.getAffiliatedApplicant());
                }
            });
        });
        String[] TPolicyId = (String[])bol_policy_partys.stream().filter(a -> a.getParty_type().equals("TBR")).collect(Collectors.toList()).stream().map(PolicyPartyVo::getParty_uuid).toArray(String[]::new);
        String[] BPolicyId = (String[])bol_policy_partys.stream().filter(a -> a.getParty_type().equals("BBR")).collect(Collectors.toList()).stream().map(PolicyPartyVo::getParty_uuid).toArray(String[]::new);
        if (CollectionUtils.isEmpty(Arrays.asList(BPolicyId))) {
            PolicyInfoVo policyInfoVo = new PolicyInfoVo();
            polPolicyVo.setPol_policy_corporate_project(this.getCorporate(policyUuid));
            policyInfoVo.setPol_policy_pay(policyPayVo);
            policyInfoVo.setPol_policy(polPolicyVo);
            policyInfoVo.setTpol_policy_party((PolicyPartyVo)((Object)bol_policy_partys.stream().filter(a -> a.getParty_type().equals("TBR")).collect(Collectors.toList()).get(0)));
            msg.setDataTable(new Object[]{policyInfoVo});
            return msg.msg();
        }
        List polPolicyRisks = this.dao.findAll(PolPolicyRisk.n().where().addIn(PolPolicyRisk.PARTY_UUID, BPolicyId).model());
        bol_policy_partys.stream().filter(a -> a.getParty_type().equals("BBR")).forEach(o -> {
            String[] SPolicyId = (String[])polPolicyPartyRelations.stream().filter(a -> a.getMasterRelation().equals(o.getParty_uuid())).collect(Collectors.toList()).stream().map(PolPolicyPartyRelation::getAffiliatedRelation).toArray(String[]::new);
            o.setSpol_policy_party(bol_policy_partys.stream().filter(a -> Arrays.asList(SPolicyId).contains(a.getParty_uuid())).sorted(Comparator.comparing(PolicyPartyVo::getBenefit_order)).collect(Collectors.toList()));
            ArrayList<PolPolicyRisk> polPolicyRisks1 = new ArrayList<PolPolicyRisk>();
            polPolicyRisks.forEach(p -> {
                if (p.getPartyUuid().equals(o.getParty_uuid())) {
                    polPolicyRisks1.add((PolPolicyRisk)p);
                }
            });
            o.setPol_policy_risk(polPolicyRisks1);
        });
        bol_policy_partys.stream().filter(a -> a.getParty_type().equals("TBR")).forEach(o -> {
            if (StrUtils.isNull((Object)o.getDelivery_mode())) {
                o.setDelivery_mode(polPolicyOrder.getDeliveryMode());
            }
            o.setBpol_policy_party(bol_policy_partys.stream().filter(a -> Arrays.asList(BPolicyId).contains(a.getParty_uuid())).collect(Collectors.toList()));
        });
        PolicyInfoVo policyInfoVo = new PolicyInfoVo();
        polPolicyVo.setPol_policy_corporate_project(this.getCorporate(policyUuid));
        policyInfoVo.setPol_policy_pay(policyPayVo);
        policyInfoVo.setPol_policy(polPolicyVo);
        policyInfoVo.setTpol_policy_party((PolicyPartyVo)((Object)bol_policy_partys.stream().filter(a -> a.getParty_type().equals("TBR")).collect(Collectors.toList()).get(0)));
        msg.setDataTable(new Object[]{policyInfoVo});
        return msg.msg();
    }

    private CorporateProjectVo getCorporate(String orderUuid) {
        CorporateProjectVo corporateProjectVo = new CorporateProjectVo();
        PolPolicyCorporateProject polPolicyCorporateProject = (PolPolicyCorporateProject)this.dao.findOne(PolPolicyCorporateProject.n().where().addEq(PolPolicyCorporateProject.ORDER_UUID, (Object)orderUuid).model());
        if (StrUtils.isNull((Object)polPolicyCorporateProject)) {
            return new CorporateProjectVo();
        }
        corporateProjectVo.setCommitDate(polPolicyCorporateProject.getCommitDate());
        corporateProjectVo.setCreateDate(polPolicyCorporateProject.getCreateDate());
        corporateProjectVo.setProjectNo(polPolicyCorporateProject.getProjectNo());
        corporateProjectVo.setGroupCode(polPolicyCorporateProject.getGroupCode());
        corporateProjectVo.setGroupName(polPolicyCorporateProject.getGroupName());
        PolPolicyCorporateResource polPolicyCorporateResource = (PolPolicyCorporateResource)this.dao.findOne(PolPolicyCorporateResource.n().where().addEq(PolPolicyCorporateResource.ORDER_UUID, (Object)orderUuid).model());
        PolPolicyCorporateTeam polPolicyCorporateTeam = (PolPolicyCorporateTeam)this.dao.findOne(PolPolicyCorporateTeam.n().where().addEq(PolPolicyCorporateTeam.ORDER_UUID, (Object)orderUuid).model());
        List polPolicyCorporateConfirmation = this.dao.findAll(PolPolicyCorporateConfirmation.n().where().addEq(PolPolicyCorporateConfirmation.ORDER_UUID, (Object)orderUuid).model());
        PolPolicyCorporateCustomer polPolicyCorporateCustomer = (PolPolicyCorporateCustomer)this.dao.findOne(PolPolicyCorporateCustomer.n().where().addEq(PolPolicyCorporateCustomer.ORDER_UUID, (Object)orderUuid).model());
        PolPolicyCorporateCompany polPolicyCorporateCompany = (PolPolicyCorporateCompany)this.dao.findOne(PolPolicyCorporateCompany.n().where().addEq(PolPolicyCorporateCompany.ORDER_UUID, (Object)orderUuid).model());
        List polPolicyCorporateUser = this.dao.findAll(PolPolicyCorporateUser.n().where().addEq(PolPolicyCorporateUser.ORDER_UUID, (Object)orderUuid).model());
        corporateProjectVo.setPol_policy_corporate_company(polPolicyCorporateCompany);
        corporateProjectVo.setPol_policy_corporate_confirmation(polPolicyCorporateConfirmation);
        corporateProjectVo.setPol_policy_corporate_customer(polPolicyCorporateCustomer);
        corporateProjectVo.setPol_policy_corporate_resource(polPolicyCorporateResource);
        corporateProjectVo.setPol_policy_corporate_team(polPolicyCorporateTeam);
        corporateProjectVo.setPol_policy_corporate_user(polPolicyCorporateUser);
        return corporateProjectVo;
    }

    @Override
    public ReturnMsg getInfoFromHistory(DownPolicyParam param) {
        Return msg = new Return();
        String policyUuid = param.getPolicy_uuid();
        String policy_uuid = UUID.uuid();
        String order_uuid = policyUuid;
        if (param.getIs_proposal().equals("Y")) {
            order_uuid = UUID.uuid();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String isProposal = param.getIs_proposal();
        if (isProposal.equals("Y")) {
            PolPolicy polPolicy = (PolPolicy)JSONObject.parseObject((String)JsonUtils.toJson((Object)param.getCurrent_policy()), PolPolicy.class);
            PolPolicyOrder polPolicyOrder = (PolPolicyOrder)JSONObject.parseObject((String)JsonUtils.toJson((Object)param.getCurrent_policy()), PolPolicyOrder.class);
            polPolicy.setPolicyUuid(policy_uuid);
            polPolicy.setOrderUuid(order_uuid);
            polPolicyOrder.setOrderUuid(order_uuid);
            this.dao.save((AbsModel)polPolicy);
            this.dao.save((AbsModel)polPolicyOrder);
            if (!CollectionUtils.isEmpty(param.getCurrent_policy().getParties())) {
                List polPolicyParties = JSONObject.parseArray((String)JsonUtils.toJson(param.getCurrent_policy().getParties()), PolPolicyParty.class);
                List polPolicyOrderParties = JSONObject.parseArray((String)JsonUtils.toJson(param.getCurrent_policy().getParties()), PolPolicyOrderParty.class);
                ArrayList polPolicyRisks = new ArrayList();
                ArrayList polPolicyPartyAddresses = new ArrayList();
                ArrayList polPolicyPartyContacts = new ArrayList();
                param.getCurrent_policy().getParties().forEach(o -> {
                    List polPolicyRisk = JSONObject.parseArray((String)JsonUtils.toJson(o.getPolicyRisks()), PolPolicyRisk.class);
                    List policyAddressVos = JSONObject.parseArray((String)JsonUtils.toJson(o.getPartyAddresses()), PolPolicyPartyAddress.class);
                    List policyContracts = JSONObject.parseArray((String)JsonUtils.toJson(o.getPartyContracts()), PolPolicyPartyContact.class);
                    if (!CollectionUtils.isEmpty((Collection)polPolicyRisk)) {
                        polPolicyRisks.addAll(polPolicyRisk);
                    }
                    if (!CollectionUtils.isEmpty((Collection)policyAddressVos)) {
                        polPolicyPartyAddresses.addAll(policyAddressVos);
                    }
                    if (!CollectionUtils.isEmpty((Collection)policyContracts)) {
                        polPolicyPartyContacts.addAll(policyContracts);
                    }
                });
                String finalPolicy_uuid1 = policy_uuid;
                polPolicyParties.forEach(o -> o.setPolicyUuid(finalPolicy_uuid1));
                if (!CollectionUtils.isEmpty(polPolicyPartyAddresses)) {
                    polPolicyPartyAddresses.forEach(o -> o.setAddressUuid(UUID.uuid()));
                }
                if (!CollectionUtils.isEmpty((Collection)polPolicyOrderParties)) {
                    String finalOrder_uuid2 = order_uuid;
                    polPolicyOrderParties.forEach(o -> o.setOrderUuid(finalOrder_uuid2));
                }
                String finalOrder_uuid1 = order_uuid;
                int displayOrder = 0;
                if (!CollectionUtils.isEmpty(polPolicyRisks)) {
                    PolPolicyRisk polPolicyRisk = new PolPolicyRisk();
                    polPolicyRisk.setOrderUuid(order_uuid);
                    polPolicyRisk.setPolicyUuid(policy_uuid);
                    polPolicyRisk.setRiskUuid(UUID.uuid());
                    polPolicyRisk.setRiskType("P");
                    polPolicyRisk.setPartyUuid(((PolPolicyRisk)polPolicyRisks.get(0)).getPartyUuid());
                    polPolicyRisk.setParentSerno(((PolPolicyRisk)polPolicyRisks.get(0)).getParentSerno());
                    polPolicyRisk.setProductCode("PK" + ((PolPolicyRisk)polPolicyRisks.get(0)).getRiskCode());
                    polPolicyRisk.setProductName(((PolPolicyRisk)polPolicyRisks.get(0)).getRiskName());
                    polPolicyRisk.setRiskCode("PK" + ((PolPolicyRisk)polPolicyRisks.get(0)).getRiskCode());
                    polPolicyRisk.setTotalPremium(((PolPolicyRisk)polPolicyRisks.get(0)).getInitialPremium());
                    polPolicyRisk.setTotalAmount(((PolPolicyRisk)polPolicyRisks.get(0)).getInitialPremium());
                    polPolicyRisk.setIsChecked("y");
                    polPolicyRisk.setDisplayOrder(Integer.valueOf(displayOrder));
                }
                for (PolPolicyRisk p2 : polPolicyRisks) {
                    p2.setPolicyUuid(finalPolicy_uuid1);
                    p2.setOrderUuid(finalOrder_uuid1);
                    p2.setDisplayOrder(Integer.valueOf(++displayOrder));
                }
                this.dao.save(polPolicyOrderParties);
                this.dao.save(polPolicyParties);
                this.dao.save(polPolicyRisks);
                this.dao.save(polPolicyPartyAddresses);
                this.dao.save(polPolicyPartyContacts);
            }
            map.put("policy_uuid", order_uuid);
            msg.setDataTable(map);
            return msg.msg();
        }
        String pk_uuid = param.getPk_uuid();
        String token = param.getToken();
        String user_code = param.getUser_code();
        String deployed_env = param.getDeployed_env();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("x-auth-token", token);
        headerMap.put("usercode", user_code);
        headerMap.put("deployed_env", deployed_env);
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("policy_uuid", policyUuid);
        bodyMap.put("pk_uuid", pk_uuid);
        bodyMap.put("funcID", "/downloadPolicy.do");
        SysTradeLog sysTradeLog = new SysTradeLog();
        String transno = UUID.shortUUID();
        sysTradeLog.setInterfaceNo(SmsEnum.abutmentInterface.abutmentEBCBD.getType());
        sysTradeLog.setSystemNo(SmsEnum.callSystem.SystemeTong.getType());
        sysTradeLog.setParamData(JsonUtils.toJson(bodyMap));
        sysTradeLog.setTransNo(transno);
        sysTradeLog.setParamType(SmsEnum.paramType.paramTypeReq.getType());
        sysTradeLog.setOrderUuid(order_uuid);
        this.systemEAbutmentUtil.insertSysTradeLog(sysTradeLog);
        headerMap.put("order_uuid", order_uuid);
        String json = this.eTongReqService.jsonPostETong(this.downPolicyPath + "?apikey=" + this.apiPlatformApikey, JsonUtils.toJson(bodyMap), headerMap);
        Map returnMap = JsonUtils.json2Map((String)json);
        String flag = (String)returnMap.get("flag");
        if (!flag.equals("success")) {
            sysTradeLog.setParamData(JsonUtils.toJson((Object)returnMap));
            sysTradeLog.setParamType(SmsEnum.paramType.paramTypeRes.getType());
            this.systemEAbutmentUtil.insertSysTradeLog(sysTradeLog);
            msg.setFailMsg("\u8c03\u7528E\u901a\u63a5\u53e3\u5931\u8d25");
            return msg.msg();
        }
        sysTradeLog.setParamData(JsonUtils.toJson((Object)returnMap));
        sysTradeLog.setParamType(SmsEnum.paramType.paramTypeRes.getType());
        this.systemEAbutmentUtil.insertSysTradeLog(sysTradeLog);
        Map defmap = (Map)returnMap.get("defmap");
        long startTime = System.currentTimeMillis();
        PolicyInfoVo policyInfoVo = (PolicyInfoVo)JSONObject.parseObject((String)JsonUtils.toJson((Object)defmap), PolicyInfoVo.class);
        PolPolicy polPolicy = (PolPolicy)JSONObject.parseObject((String)JsonUtils.toJson((Object)policyInfoVo.getPol_policy()), PolPolicy.class);
        PolPolicyOrder polPolicyOrder = (PolPolicyOrder)JSONObject.parseObject((String)JsonUtils.toJson((Object)policyInfoVo.getPol_policy()), PolPolicyOrder.class);
        PolPolicy polPolicyDB = new PolPolicy();
        polPolicyDB.where().addEq(PolPolicy.ORDER_UUID, (Object)polPolicy.getPolicyUuid());
        polPolicyDB = (PolPolicy)this.dao.findOne((AbsModel)polPolicyDB);
        if (!StrUtils.isNull((Object)polPolicyDB)) {
            policy_uuid = polPolicyDB.getPolicyUuid();
            order_uuid = polPolicyDB.getOrderUuid();
        }
        PolPolicy polPolicyDel = new PolPolicy();
        polPolicyDel.where().addEq(PolPolicy.ORDER_UUID, (Object)order_uuid);
        this.dao.delete((AbsModel)polPolicyDel);
        PolPolicyOrder polPolicyOrderDB = new PolPolicyOrder();
        polPolicyOrderDB.where().addEq(PolPolicyOrder.ORDER_UUID, (Object)polPolicy.getPolicyUuid());
        polPolicyOrderDB = (PolPolicyOrder)this.dao.findOne((AbsModel)polPolicyOrderDB);
        if (!StrUtils.isNull((Object)polPolicyOrderDB)) {
            policy_uuid = polPolicyDB.getPolicyUuid();
            order_uuid = polPolicyDB.getOrderUuid();
        }
        PolPolicyOrder polPolicyOrderDel = new PolPolicyOrder();
        polPolicyOrderDel.where().addEq(PolPolicy.ORDER_UUID, (Object)order_uuid);
        this.dao.delete((AbsModel)polPolicyOrderDel);
        polPolicy.setOrderUuid(order_uuid);
        polPolicy.setPolicyUuid(policy_uuid);
        this.dao.save((AbsModel)polPolicy);
        polPolicyOrder.setOrderUuid(order_uuid);
        polPolicyOrder.setBranchId(polPolicyOrder.getOrganId());
        this.dao.save((AbsModel)polPolicyOrder);
        PolPolicyPay polPolicyPay = (PolPolicyPay)JsonUtils.json2Class((String)JsonUtils.toJson((Object)((Object)policyInfoVo.getPol_policy_pay())), PolPolicyPay.class);
        PolPolicyPay polPolicyPayDB = new PolPolicyPay();
        polPolicyPayDB.where().addEq(PolPolicyPay.ORDER_UUID, (Object)polPolicyPay.getPolicyUuid());
        polPolicyPayDB = (PolPolicyPay)this.dao.findOne((AbsModel)polPolicyPayDB);
        if (!StrUtils.isNull((Object)polPolicyPayDB)) {
            polPolicyPay.setAcctUuid(polPolicyPayDB.getAcctUuid());
            polPolicyPay.setPayType(polPolicyPayDB.getPayType());
        }
        PolPolicyPay polPolicyPayDel = new PolPolicyPay();
        polPolicyPayDel.where().addEq(PolPolicyPay.ORDER_UUID, (Object)polPolicyPay.getPolicyUuid());
        this.dao.delete((AbsModel)polPolicyPayDel);
        if (StrUtils.isNull((Object)polPolicyPay.getAcctUuid())) {
            polPolicyPay.setAcctUuid(UUID.uuid());
        }
        polPolicyPay.setOrderUuid(order_uuid);
        polPolicyPay.setPolicyUuid(policy_uuid);
        polPolicyPay.setPartyUuid(policyInfoVo.getTpol_policy_party().getParty_uuid());
        this.dao.save((AbsModel)polPolicyPay);
        ArrayList<PolicyPartyVo> pol_policy_party = new ArrayList<PolicyPartyVo>();
        ArrayList<PolicyAddressVo> address = new ArrayList<PolicyAddressVo>();
        ArrayList<PolicyContract> contract = new ArrayList<PolicyContract>();
        ArrayList<PolicyTaxVo> pol_policy_tax = new ArrayList<PolicyTaxVo>();
        ArrayList<PolicyImageVo> pol_policy_image = new ArrayList<PolicyImageVo>();
        ArrayList pol_policy_risk = new ArrayList();
        PolicyPartyVo policyPartyVo = new PolicyPartyVo();
        BeanUtils.copyProperties((Object)((Object)policyInfoVo.getTpol_policy_party()), (Object)((Object)policyPartyVo));
        pol_policy_party.add(policyPartyVo);
        address.addAll(policyInfoVo.getTpol_policy_party().getAddress());
        contract.addAll(policyInfoVo.getTpol_policy_party().getContact());
        pol_policy_tax.addAll(policyInfoVo.getTpol_policy_party().getPol_policy_tax());
        pol_policy_image.addAll(policyInfoVo.getTpol_policy_party().getPol_policy_image());
        if (!CollectionUtils.isEmpty(policyInfoVo.getTpol_policy_party().getBpol_policy_party())) {
            policyInfoVo.getTpol_policy_party().getBpol_policy_party().forEach(o -> {
                PolicyPartyVo policyPartyVo1 = new PolicyPartyVo();
                BeanUtils.copyProperties((Object)o, (Object)((Object)policyPartyVo1));
                pol_policy_party.add(policyPartyVo1);
                address.addAll(o.getAddress());
                contract.addAll(o.getContact());
                pol_policy_tax.addAll(o.getPol_policy_tax());
                pol_policy_image.addAll(o.getPol_policy_image());
                pol_policy_risk.addAll(JsonUtils.json2List((String)JsonUtils.toJson(o.getPol_policy_risk()), PolPolicyRisk.class));
                if (!CollectionUtils.isEmpty(o.getSpol_policy_party())) {
                    o.getSpol_policy_party().forEach(s -> {
                        PolicyPartyVo policyPartyVo2 = new PolicyPartyVo();
                        BeanUtils.copyProperties((Object)s, (Object)((Object)policyPartyVo2));
                        pol_policy_party.add(policyPartyVo2);
                        address.addAll(s.getAddress());
                        contract.addAll(s.getContact());
                        pol_policy_image.addAll(s.getPol_policy_image());
                    });
                }
            });
        }
        List policyOrderParties = JsonUtils.json2List((String)JsonUtils.toJson(pol_policy_party), PolPolicyOrderParty.class);
        List polPolicyPartyAddresses = JsonUtils.json2List((String)JsonUtils.toJson(address), PolPolicyPartyAddress.class);
        List polPolicyPartyContracts = JsonUtils.json2List((String)JsonUtils.toJson(contract), PolPolicyPartyContact.class);
        List polCrsResults = JsonUtils.json2List((String)JsonUtils.toJson(pol_policy_tax), PolCrsResult.class);
        List polPolicyPartyImages = JsonUtils.json2List((String)JsonUtils.toJson(pol_policy_image), PolPolicyPartyImage.class);
        List polPolicyRisks = JsonUtils.json2List((String)JsonUtils.toJson(pol_policy_risk), PolPolicyRisk.class);
        String finalOrder_uuid = order_uuid;
        String finalPolicy_uuid = policy_uuid;
        polPolicyPartyImages.forEach(p -> {
            p.setPolicyUuid(finalPolicy_uuid);
            p.setOrderUuid(finalOrder_uuid);
        });
        policyOrderParties.forEach(p -> p.setOrderUuid(finalOrder_uuid));
        int contactOrder = 1;
        for (PolPolicyPartyContact p3 : polPolicyPartyContracts) {
            p3.setContactType((String)p3.getOtherProperty().get("contract_type"));
            p3.setContactUuid((String)p3.getOtherProperty().get("contract_no"));
            p3.setContactLabel((String)p3.getOtherProperty().get("contract_label"));
            p3.setContactValue((String)p3.getOtherProperty().get("contract_value"));
            p3.setContactOrder(Integer.valueOf(contactOrder));
            ++contactOrder;
        }
        String[] s = (String[])policyOrderParties.stream().map(PolPolicyOrderParty::getPartyUuid).toArray(String[]::new);
        this.dao.delete(PolPolicyOrderParty.n().where().addIn(PolPolicyOrderParty.PARTY_UUID, s).model());
        this.dao.delete(PolPolicyPartyAddress.n().where().addIn(PolPolicyPartyAddress.PARTY_UUID, s).model());
        this.dao.delete(PolPolicyPartyContact.n().where().addIn(PolPolicyPartyContact.PARTY_UUID, s).model());
        this.dao.delete(PolCrsResult.n().where().addIn(PolCrsResult.PARTY_UUID, s).model());
        this.dao.delete(PolPolicyPartyImage.n().where().addIn(PolPolicyPartyImage.PARTY_UUID, s).model());
        this.dao.save(policyOrderParties);
        this.dao.save(polPolicyPartyAddresses);
        this.dao.save(polPolicyPartyContracts);
        this.dao.save(polCrsResults);
        this.dao.save(polPolicyPartyImages);
        map.put("policy_uuid", order_uuid);
        msg.setDataTable(map);
        long endTime = System.currentTimeMillis();
        Ulog.info((Object)(endTime - startTime));
        return msg.msg();
    }

    @Override
    public ReturnMsg proposalToPolicy(DownPolicyParam param) {
        this.checkService.checkAuthAnent(param.getCurrent_policy().getAgent_code());
        Return msg = new Return();
        String policyUuid = param.getPolicy_uuid();
        String policy_uuid = UUID.uuid();
        String order_uuid = UUID.shortUUID();
        HashMap<String, String> map = new HashMap<String, String>();
        PolPolicy polPolicy = (PolPolicy)JSONObject.parseObject((String)JsonUtils.toJson((Object)param.getCurrent_policy()), PolPolicy.class);
        PolPolicyOrder polPolicyOrder = (PolPolicyOrder)JSONObject.parseObject((String)JsonUtils.toJson((Object)param.getCurrent_policy()), PolPolicyOrder.class);
        polPolicy.setPolicyUuid(policy_uuid);
        polPolicy.setOrderUuid(order_uuid);
        polPolicyOrder.setOrderUuid(order_uuid);
        this.dao.save((AbsModel)polPolicy);
        this.dao.save((AbsModel)polPolicyOrder);
        if (!CollectionUtils.isEmpty(param.getCurrent_policy().getParties())) {
            List polPolicyParties = JSONObject.parseArray((String)JsonUtils.toJson(param.getCurrent_policy().getParties()), PolPolicyParty.class);
            List polPolicyOrderParties = JSONObject.parseArray((String)JsonUtils.toJson(param.getCurrent_policy().getParties()), PolPolicyOrderParty.class);
            ArrayList<PolPolicyRisk> polPolicyRisks = new ArrayList<PolPolicyRisk>();
            ArrayList polPolicyPartyAddresses = new ArrayList();
            ArrayList polPolicyPartyContacts = new ArrayList();
            List polPolicyPartyRelations = new ArrayList();
            if (!CollectionUtils.isEmpty(param.getCurrent_policy().getPartyRelations())) {
                polPolicyPartyRelations = JSONObject.parseArray((String)JsonUtils.toJson(param.getCurrent_policy().getPartyRelations()), PolPolicyPartyRelation.class);
                polPolicyPartyRelations.forEach(o -> param.getCurrent_policy().getParties().forEach(l -> {
                    if (l.getParty_uuid().equals(o.getMasterRelation())) {
                        o.setMasterPartyType(l.getParty_type());
                    }
                    if (l.getParty_uuid().equals(o.getAffiliatedRelation())) {
                        o.setAffiliatedPartyType(l.getParty_type());
                    }
                }));
            }
            param.getCurrent_policy().getParties().forEach(o -> {
                List polPolicyRisk = JSONObject.parseArray((String)JsonUtils.toJson(o.getPolicyRisks()), PolPolicyRisk.class);
                List policyAddressVos = JSONObject.parseArray((String)JsonUtils.toJson(o.getPartyAddresses()), PolPolicyPartyAddress.class);
                List policyContracts = JSONObject.parseArray((String)JsonUtils.toJson(o.getPartyContracts()), PolPolicyPartyContact.class);
                if (!CollectionUtils.isEmpty((Collection)polPolicyRisk)) {
                    List<PolPolicyRisk> collect = polPolicyRisk.stream().filter(p -> "1".equals(p.getIsMainRisk()) || "true".equals(p.getIsChecked())).collect(Collectors.toList());
                    collect.forEach(p -> {
                        if ("3".equals(p.getIsMainRisk())) {
                            p.setWaiverPartyUuid(p.getPartyUuid());
                            p.setPartyUuid(o.getParty_uuid());
                        }
                    });
                    polPolicyRisks.addAll(collect);
                }
                if (!CollectionUtils.isEmpty((Collection)policyAddressVos)) {
                    polPolicyPartyAddresses.addAll(policyAddressVos);
                }
                if (!CollectionUtils.isEmpty((Collection)policyContracts)) {
                    polPolicyPartyContacts.addAll(policyContracts);
                }
            });
            if (!CollectionUtils.isEmpty(polPolicyRisks)) {
                ArrayList polPolicyRiskPs = new ArrayList();
                ArrayList<Map<String, Object>> riskMap = new ArrayList<Map<String, Object>>();
                polPolicyRisks.forEach(m -> {
                    if ("1".equals(m.getIsMainRisk())) {
                        HashMap<String, String> body = new HashMap<String, String>();
                        body.put("riskNos", m.getRiskNo());
                        String json = HttpUtils.jsonPost((String)this.queryProductListByNo, (String)JsonUtils.toJson(body));
                        Map mapData = JsonUtils.json2Map((String)json);
                        List list1 = (List)mapData.get("data");
                        Map map1 = (Map)list1.get(0);
                        Map product = (Map)map1.get("productData");
                        PolPolicyRisk polPolicyRiskP = new PolPolicyRisk();
                        String newParentSerno = UUID.shortUUID();
                        m.setParentSerno(newParentSerno);
                        polPolicyRiskP.setOrderUuid(order_uuid);
                        polPolicyRiskP.setPolicyUuid(policy_uuid);
                        polPolicyRiskP.setRiskUuid(UUID.uuid());
                        polPolicyRiskP.setRiskType("P");
                        polPolicyRiskP.setPartyUuid(m.getPartyUuid());
                        polPolicyRiskP.setParentSerno(newParentSerno);
                        polPolicyRiskP.setSerno(newParentSerno);
                        polPolicyRiskP.setProductCode("PK" + m.getRiskNo());
                        polPolicyRiskP.setProductName(m.getRiskName());
                        polPolicyRiskP.setRiskCode("PK" + m.getRiskNo());
                        polPolicyRiskP.setTotalPremium(m.getInitialPremium());
                        polPolicyRiskP.setTotalAmount(m.getInitialPremium());
                        polPolicyRiskP.setIsChecked("y");
                        polPolicyRiskP.setNodeSeq((String)product.get("product_no"));
                        polPolicyRiskP.setParentNodeSeq((String)product.get("product_no"));
                        polPolicyRiskP.setInsureType((String)product.get("insure_type"));
                        polPolicyRiskP.setIsChecked("Y");
                        PolicyServiceImpl.copyNonNullProperties(product, polPolicyRiskP);
                        polPolicyRiskPs.add(polPolicyRiskP);
                        m.setRiskType("M");
                        List list2 = (List)map1.get("risk");
                        Map risk = (Map)list2.get(0);
                        List<Map<String, Object>> risks = this.toList(risk);
                        riskMap.addAll(risks);
                    }
                });
                this.mergeRisk(riskMap, polPolicyRisks);
                polPolicyRisks.addAll(0, polPolicyRiskPs);
                polPolicyRisks.forEach(p -> {
                    if (!"P".equals(p.getRiskType())) {
                        PolPolicyRisk parentRisk = polPolicyRisks.stream().filter(q -> p.getParentSerno().equals(q.getSerno())).findFirst().get();
                        p.setParentNodeSeq(parentRisk.getNodeSeq());
                        p.setNodeSeq(parentRisk.getNodeSeq() + "," + p.getPolicyId());
                    }
                });
            }
            String finalPolicy_uuid1 = policy_uuid;
            polPolicyParties.forEach(o -> o.setPolicyUuid(finalPolicy_uuid1));
            if (!CollectionUtils.isEmpty(polPolicyPartyAddresses)) {
                polPolicyPartyAddresses.forEach(o -> o.setAddressUuid(UUID.uuid()));
            }
            if (!CollectionUtils.isEmpty((Collection)polPolicyOrderParties)) {
                String finalOrder_uuid2 = order_uuid;
                polPolicyOrderParties.forEach(o -> o.setOrderUuid(finalOrder_uuid2));
            }
            String finalOrder_uuid1 = order_uuid;
            int displayOrder = 0;
            String[] s = (String[])polPolicyOrderParties.stream().map(PolPolicyOrderParty::getPartyUuid).toArray(String[]::new);
            for (PolPolicyRisk p2 : polPolicyRisks) {
                p2.setPolicyUuid(finalPolicy_uuid1);
                p2.setOrderUuid(finalOrder_uuid1);
                p2.setDisplayOrder(Integer.valueOf(++displayOrder));
            }
            ArrayList partys = new ArrayList();
            for (String a2 : s) {
                HashMap<String, String> pmap = new HashMap<String, String>();
                pmap.put("old_id", a2);
                pmap.put("new_id", UUID.shortUUID());
                partys.add(pmap);
            }
            for (Map map2 : partys) {
                polPolicyOrderParties.stream().filter(a -> a.getPartyUuid().equals(m2.get("old_id"))).forEach(b -> b.setPartyUuid((String)m2.get("new_id")));
                polPolicyPartyAddresses.stream().filter(a -> a.getPartyUuid().equals(m2.get("old_id"))).forEach(b -> b.setPartyUuid((String)m2.get("new_id")));
                polPolicyPartyContacts.stream().filter(a -> a.getPartyUuid().equals(m2.get("old_id"))).forEach(b -> b.setPartyUuid((String)m2.get("new_id")));
                polPolicyPartyRelations.stream().filter(a -> a.getMasterRelation().equals(m2.get("old_id"))).forEach(b -> b.setMasterRelation((String)m2.get("new_id")));
                polPolicyPartyRelations.stream().filter(a -> a.getAffiliatedRelation().equals(m2.get("old_id"))).forEach(b -> b.setAffiliatedRelation((String)m2.get("new_id")));
                polPolicyRisks.stream().filter(a -> a.getPartyUuid().equals(m2.get("old_id"))).sorted(Comparator.comparing(PolPolicyRisk::getDisplayOrder)).forEach(r -> {
                    r.setOrderUuid(order_uuid);
                    r.setPolicyUuid(policy_uuid);
                    r.setPartyUuid((String)m2.get("new_id"));
                    r.setRiskUuid(UUID.uuid());
                    r.setSerno("");
                    if ("W".equals(r.getRiskType())) {
                        String newId = (String)partys.stream().filter(a -> r.getWaiverPartyUuid().equals(a.get("old_id"))).findFirst().get().get("new_id");
                        r.setWaiverPartyUuid(newId);
                    }
                });
            }
            this.dao.save(polPolicyOrderParties);
            this.dao.save(polPolicyParties);
            this.dao.save(polPolicyRisks);
            this.dao.save(polPolicyPartyAddresses);
            this.dao.save(polPolicyPartyContacts);
            this.dao.save(polPolicyPartyRelations);
        }
        map.put("policy_uuid", order_uuid);
        msg.setDataTable(map);
        return msg.msg();
    }

    public List<Map<String, Object>> toList(Map<String, Object> risk) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Stack<Map> stack = new Stack<Map>();
        risk.put("risk_type", "M");
        stack.push(risk);
        while (!stack.empty()) {
            Map node = (Map)stack.pop();
            result.add(node);
            if (node.get("accy_risk") != null) {
                for (Map child : (List)node.get("accy_risk")) {
                    child.put("risk_type", "A");
                    stack.push(child);
                }
            }
            if (node.get("exempt_risk") == null) continue;
            for (Map child : (List)node.get("exempt_risk")) {
                child.put("risk_type", "W");
                stack.push(child);
            }
        }
        return result;
    }

    public void mergeRisk(List<Map<String, Object>> riskMap, List<PolPolicyRisk> risks) {
        risks.stream().forEach(r -> riskMap.stream().forEach(m -> {
            if (r.getRiskNo().equals(m.get("policy_code"))) {
                PolicyServiceImpl.copyNonNullProperties(m, r);
                r.setRiskType((String)m.get("risk_type"));
                r.setInsureType((String)m.get("insure_type"));
                r.setRiskCode(r.getRiskNo());
                r.setRiskNo((String)m.get("policy_code"));
                r.setIsMainRisk((String)m.get("is_main_risk"));
                r.setContainDeath((String)m.get("contain_death"));
                r.setPolicyId((String)m.get("policy_id"));
                r.setTermType((String)m.get("term_type"));
                r.setDutyType((String)m.get("duty_type"));
                r.setIsChecked("Y");
                r.setRiskClassify((String)m.get("risk_classify"));
            }
        }));
    }

    @Override
    public ReturnMsg continuePolicy(AgainPolicyParam downPolicyParam) {
        this.checkService.checkAuth(downPolicyParam.getPolicy_uuid());
        Return msg = new Return();
        String policy_uuid = "";
        String order_uuid = "";
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, Object> eTong = this.downloadPolicy(downPolicyParam);
        PolicyInfoVo policyInfoVo = (PolicyInfoVo)JSONObject.parseObject((String)JsonUtils.toJson(eTong), PolicyInfoVo.class);
        PolPolicy polPolicy = (PolPolicy)JSONObject.parseObject((String)JsonUtils.toJson((Object)policyInfoVo.getPol_policy()), PolPolicy.class);
        PolPolicyOrder polPolicyOrder = (PolPolicyOrder)JSONObject.parseObject((String)JsonUtils.toJson((Object)policyInfoVo.getPol_policy()), PolPolicyOrder.class);
        PolPolicy polPolicyDB = new PolPolicy();
        polPolicyDB.where().addEq(PolPolicy.ORDER_UUID, (Object)downPolicyParam.getPolicy_uuid());
        polPolicyDB = (PolPolicy)this.dao.findOne((AbsModel)polPolicyDB);
        if (!StrUtils.isNull((Object)polPolicyDB)) {
            policy_uuid = polPolicyDB.getPolicyUuid();
            order_uuid = polPolicyDB.getOrderUuid();
        } else {
            order_uuid = downPolicyParam.getPolicy_uuid();
            policy_uuid = UUID.uuid();
        }
        PolPolicy polPolicyDel = new PolPolicy();
        polPolicyDel.where().addEq(PolPolicy.ORDER_UUID, (Object)order_uuid);
        this.dao.delete((AbsModel)polPolicyDel);
        PolPolicyOrder polPolicyOrderDb = (PolPolicyOrder)this.dao.findOne(PolPolicyOrder.n().where().addEq(PolPolicy.ORDER_UUID, (Object)order_uuid).model());
        if (!StrUtils.isNull((Object)polPolicyOrderDb)) {
            PolPolicyOrder polPolicyOrderDel = new PolPolicyOrder();
            polPolicyOrderDel.where().addEq(PolPolicy.ORDER_UUID, (Object)order_uuid);
            polPolicyOrder.setIsEmployeeProveImage(polPolicyOrderDb.getIsEmployeeProveImage());
            polPolicyOrder.setBabyUuid(polPolicyOrderDb.getBabyUuid());
            this.dao.delete((AbsModel)polPolicyOrderDel);
        }
        polPolicy.setOrderUuid(order_uuid);
        polPolicy.setPolicyUuid(policy_uuid);
        if (!StrUtils.isNull((Object)polPolicyOrder.getOuteragentCode()) && !polPolicyOrder.getOuteragentCode().startsWith("3")) {
            String a = polPolicyOrder.getOuteragentCode();
            String b2 = polPolicyOrder.getAgentId();
            polPolicyOrder.setOuteragentCode(b2);
            polPolicyOrder.setAgentId(a);
            polPolicy.setAgentId(a);
        }
        this.dao.save((AbsModel)polPolicy);
        polPolicyOrder.setOrderUuid(order_uuid);
        polPolicyOrder.setBranchId(polPolicyOrder.getOrganId());
        this.dao.save((AbsModel)polPolicyOrder);
        ArrayList<PolicyPartyVo> pol_policy_party = new ArrayList<PolicyPartyVo>();
        ArrayList<PolicyAddressVo> address = new ArrayList<PolicyAddressVo>();
        ArrayList<PolicyContract> contract = new ArrayList<PolicyContract>();
        ArrayList<PolicyTaxVo> pol_policy_tax = new ArrayList<PolicyTaxVo>();
        ArrayList<PolicyImageVo> pol_policy_image = new ArrayList<PolicyImageVo>();
        ArrayList<PolPolicyRisk> riskETong = new ArrayList<PolPolicyRisk>();
        ArrayList polPolicyPartyRelations = new ArrayList();
        PolicyPartyVo policyPartyVo = new PolicyPartyVo();
        BeanUtils.copyProperties((Object)((Object)policyInfoVo.getTpol_policy_party()), (Object)((Object)policyPartyVo));
        policyPartyVo.setLcls(policyPartyVo.getL_cls());
        policyPartyVo.setMcls(policyPartyVo.getM_cls());
        policyPartyVo.setEcls(policyPartyVo.getE_cls());
        policyPartyVo.setHcls(policyPartyVo.getH_cls());
        policyInfoVo.getTpol_policy_party().getBpol_policy_party().forEach(b -> {
            if ("Y".equals(b.getIsMentallyDisabledParty())) {
                policyPartyVo.setMentallyDisabledName(b.getFull_name());
            }
            if (!CollectionUtils.isEmpty(b.getSpol_policy_party())) {
                b.getSpol_policy_party().forEach(s -> {
                    if ("Y".equals(s.getIsMentallyDisabledParty())) {
                        policyPartyVo.setMentallyDisabledName(s.getFull_name());
                    }
                });
            }
        });
        pol_policy_party.add(policyPartyVo);
        if ("ZYJY".equals(policyInfoVo.getPol_policy().getPolicy_from_source())) {
            PolPolicyOrder orderUpdate = new PolPolicyOrder();
            orderUpdate.setFromScene("career_field");
            orderUpdate.setPolicyFromSource("ZYJY");
            orderUpdate.setMocrmCustomerId(policyInfoVo.getTpol_policy_party().getMocrm_customer_id());
            orderUpdate.where().addEq(PolPolicyOrder.ORDER_UUID, (Object)order_uuid);
            this.dao.update((AbsModel)orderUpdate);
        }
        address.addAll(policyInfoVo.getTpol_policy_party().getAddress());
        contract.addAll(policyInfoVo.getTpol_policy_party().getContact());
        pol_policy_image.addAll(policyInfoVo.getTpol_policy_party().getPol_policy_image());
        if (!CollectionUtils.isEmpty(policyInfoVo.getTpol_policy_party().getPol_policy_tax())) {
            PolicyTaxVo tpolicyTaxVo = new PolicyTaxVo();
            tpolicyTaxVo = this.getTax(policyInfoVo.getTpol_policy_party().getPol_policy_tax());
            tpolicyTaxVo.setParty_uuid(policyInfoVo.getTpol_policy_party().getParty_uuid());
            String[] tname = policyInfoVo.getTpol_policy_party().getTaxpayer_name().split("&");
            tpolicyTaxVo.setFirstName(tname[0]);
            tpolicyTaxVo.setFamilyName(tname[1]);
            BeanUtils.copyProperties((Object)((Object)tpolicyTaxVo), policyInfoVo.getTpol_policy_party().getPol_policy_tax());
            tpolicyTaxVo.setReason(policyInfoVo.getTpol_policy_party().getNo_registeration_reson());
            tpolicyTaxVo.setReasondescribe(policyInfoVo.getTpol_policy_party().getNo_registeration_reson_info());
            pol_policy_tax.add(tpolicyTaxVo);
        }
        if (!CollectionUtils.isEmpty(policyInfoVo.getTpol_policy_party().getBpol_policy_party())) {
            policyInfoVo.getTpol_policy_party().getBpol_policy_party().forEach(o -> {
                PolicyPartyVo policyPartyVo1 = new PolicyPartyVo();
                policyPartyVo1.setLcls(o.getLcls());
                policyPartyVo1.setMcls(o.getMcls());
                policyPartyVo1.setEcls(o.getEcls());
                policyPartyVo1.setHcls(o.getHcls());
                BeanUtils.copyProperties((Object)o, (Object)((Object)policyPartyVo1));
                if (o.getAddress().equals(policyInfoVo.getTpol_policy_party().getAddress())) {
                    policyPartyVo1.setAddress_same_with_applicant("Y");
                } else {
                    policyPartyVo1.setAddress_same_with_applicant("N");
                }
                if (o.getId_no().equals(policyInfoVo.getTpol_policy_party().getId_no())) {
                    policyPartyVo.setLcls(o.getLcls());
                    policyPartyVo.setMcls(o.getMcls());
                    policyPartyVo.setEcls(o.getEcls());
                    policyPartyVo.setHcls(o.getHcls());
                }
                pol_policy_party.add(policyPartyVo1);
                address.addAll(o.getAddress());
                contract.addAll(o.getContact());
                o.getPol_policy_tax().forEach(t -> {
                    t.setReason(o.getNo_registeration_reson());
                    t.setReasondescribe(o.getNo_registeration_reson_info());
                });
                if (!CollectionUtils.isEmpty(o.getPol_policy_tax())) {
                    PolicyTaxVo policyTaxVo = new PolicyTaxVo();
                    policyTaxVo = this.getTax(o.getPol_policy_tax());
                    String[] name = o.getTaxpayer_name().split("&");
                    policyTaxVo.setFirstName(name[0]);
                    policyTaxVo.setFamilyName(name[1]);
                    policyTaxVo.setParty_uuid(o.getParty_uuid());
                    policyTaxVo.setReason(o.getNo_registeration_reson());
                    policyTaxVo.setReasondescribe(o.getNo_registeration_reson_info());
                    pol_policy_tax.add(policyTaxVo);
                }
                pol_policy_image.addAll(o.getPol_policy_image());
                List<PolPolicyRisk> AMRisk = o.getPol_policy_risk();
                List<PolPolicyRisk> WRisk = o.getPol_waiver_risk();
                AMRisk.forEach(r -> {
                    r.setIsMainRisk("A");
                    r.setDisplayOrder(Integer.valueOf(Integer.parseInt(r.getRiskOrder())));
                });
                WRisk.forEach(r -> r.setIsMainRisk("W"));
                riskETong.addAll(JsonUtils.json2List((String)JsonUtils.toJson(AMRisk), PolPolicyRisk.class));
                riskETong.addAll(JsonUtils.json2List((String)JsonUtils.toJson(WRisk), PolPolicyRisk.class));
                PolPolicyPartyRelation polPolicyPartyRelation = new PolPolicyPartyRelation();
                polPolicyPartyRelation.setMasterRelation(policyInfoVo.getTpol_policy_party().getParty_uuid());
                polPolicyPartyRelation.setMasterPartyType("TBR");
                polPolicyPartyRelation.setAffiliatedRelation(o.getParty_uuid());
                polPolicyPartyRelation.setAffiliatedPartyType("BBR");
                polPolicyPartyRelation.setAffiliatedType(o.getAffiliated_type());
                polPolicyPartyRelations.add(polPolicyPartyRelation);
                if (!CollectionUtils.isEmpty(o.getSpol_policy_party())) {
                    o.getSpol_policy_party().forEach(s -> {
                        PolicyPartyVo policyPartyVo2 = new PolicyPartyVo();
                        BeanUtils.copyProperties((Object)s, (Object)((Object)policyPartyVo2));
                        policyPartyVo2.setLcls(policyPartyVo2.getLcls());
                        policyPartyVo2.setMcls(policyPartyVo2.getMcls());
                        policyPartyVo2.setEcls(policyPartyVo2.getEcls());
                        policyPartyVo2.setHcls(policyPartyVo2.getHcls());
                        pol_policy_party.add(policyPartyVo2);
                        address.addAll(s.getAddress());
                        contract.addAll(s.getContact());
                        pol_policy_image.addAll(s.getPol_policy_image());
                        PolPolicyPartyRelation polPolicyPartyRelation1 = new PolPolicyPartyRelation();
                        polPolicyPartyRelation1.setMasterRelation(o.getParty_uuid());
                        polPolicyPartyRelation1.setMasterPartyType("BBR");
                        polPolicyPartyRelation1.setAffiliatedRelation(s.getParty_uuid());
                        polPolicyPartyRelation1.setAffiliatedPartyType("SYR");
                        polPolicyPartyRelation1.setAffiliatedType(s.getAffiliated_type());
                        polPolicyPartyRelation1.setAffiliatedApplicant("N");
                        if (s.getId_no().equals(policyInfoVo.getTpol_policy_party().getId_no())) {
                            polPolicyPartyRelation1.setAffiliatedApplicant("5");
                        } else {
                            polPolicyPartyRelation1.setAffiliatedApplicant("N");
                        }
                        polPolicyPartyRelation1.setBenefitOrder(s.getBenefit_order());
                        polPolicyPartyRelation1.setBenefitRatio(s.getBenefit_ratio());
                        polPolicyPartyRelations.add(polPolicyPartyRelation1);
                    });
                }
            });
        }
        List polCrsResults = JsonUtils.json2List((String)JsonUtils.toJson(pol_policy_tax), PolCrsResult.class);
        if (riskETong.size() != 1 || StrUtils.isNull((Object)((PolPolicyRisk)riskETong.get(0)).getIsPresentPolicy()) || !((PolPolicyRisk)riskETong.get(0)).getIsPresentPolicy().equals("Y")) {
            PolPolicyPay polPolicyPay = (PolPolicyPay)JsonUtils.json2Class((String)JsonUtils.toJson((Object)((Object)policyInfoVo.getPol_policy_pay())), PolPolicyPay.class);
            PolPolicyPay polPolicyPayDB = new PolPolicyPay();
            polPolicyPayDB.where().addEq(PolPolicyPay.ORDER_UUID, (Object)polPolicyPay.getPolicyUuid());
            polPolicyPayDB = (PolPolicyPay)this.dao.findOne((AbsModel)polPolicyPayDB);
            if (!StrUtils.isNull((Object)polPolicyPayDB)) {
                polPolicyPay.setAcctUuid(polPolicyPayDB.getAcctUuid());
                polPolicyPay.setPayType(polPolicyPayDB.getPayType());
            }
            PolPolicyPay polPolicyPayDel = new PolPolicyPay();
            polPolicyPayDel.where().addEq(PolPolicyPay.ORDER_UUID, (Object)polPolicyPay.getPolicyUuid());
            this.dao.delete((AbsModel)polPolicyPayDel);
            if (StrUtils.isNull((Object)polPolicyPay.getAcctUuid())) {
                polPolicyPay.setAcctUuid(UUID.uuid());
            }
            polPolicyPay.setOrderUuid(order_uuid);
            polPolicyPay.setPolicyUuid(policy_uuid);
            polPolicyPay.setPartyUuid(policyInfoVo.getTpol_policy_party().getParty_uuid());
            this.dao.save((AbsModel)polPolicyPay);
        }
        this.getRiskSerno(riskETong);
        pol_policy_party.stream().forEach(o -> {
            polCrsResults.forEach(f -> {
                if (f.getPartyUuid().equals(o.getParty_uuid()) && !StrUtils.isNull((Object)o.getTaxpayer_name())) {
                    String[] s = o.getTaxpayer_name().split("&");
                    f.setFamilyName(s[0]);
                    f.setFirstName(s[1]);
                }
            });
            o.getId().stream().forEach(i -> {
                if (i.getId_order().equals("1")) {
                    o.setId_no(i.getId_no());
                    o.setId_type(i.getId_type());
                    o.setId_start_date(i.getId_start_date());
                    o.setId_end_date(i.getId_end_date());
                }
                if (i.getId_order().equals("2")) {
                    o.setId_no2(i.getId_no());
                    o.setId_type2(i.getId_type());
                    o.setId_start_date2(i.getId_start_date());
                    o.setId_end_date2(i.getId_end_date());
                }
                if (i.getId_order().equals("3")) {
                    o.setId_no3(i.getId_no());
                    o.setId_type3(i.getId_type());
                    o.setId_start_date3(i.getId_start_date());
                    o.setId_end_date3(i.getId_end_date());
                }
            });
        });
        List policyOrderParties = JsonUtils.json2List((String)JsonUtils.toJson(pol_policy_party), PolPolicyOrderParty.class);
        List polPolicyPartyAddresses = JsonUtils.json2List((String)JsonUtils.toJson(address), PolPolicyPartyAddress.class);
        List polPolicyPartyContracts = JsonUtils.json2List((String)JsonUtils.toJson(contract), PolPolicyPartyContact.class);
        List polPolicyPartyImages = JsonUtils.json2List((String)JsonUtils.toJson(pol_policy_image), PolPolicyPartyImage.class);
        List polPolicyRisks = JsonUtils.json2List((String)JsonUtils.toJson(riskETong), PolPolicyRisk.class);
        ArrayList imageSave = new ArrayList();
        String finalOrder_uuid = order_uuid;
        String finalPolicy_uuid = policy_uuid;
        polPolicyPartyImages.forEach(p -> {
            p.setPolicyUuid(finalPolicy_uuid);
            p.setOrderUuid(finalOrder_uuid);
            if (p.getImageType().equals("01") || p.getImageType().equals("11") || p.getImageType().equals("RRAK") || p.getImageType().equals("279") || "280".equals(p.getImageType())) {
                imageSave.add(p);
            }
        });
        policyOrderParties.forEach(p -> {
            p.setOrderUuid(finalOrder_uuid);
            p.setFinishFlag("Y");
            p.setFinishSpolFlag("Y");
        });
        int contactOrder = 1;
        for (PolPolicyPartyContact p2 : polPolicyPartyContracts) {
            if (p2.getOtherProperty().get("contract_type").equals("04") && StrUtils.isNull(p2.getOtherProperty().get("contract_value"))) continue;
            p2.setContactType((String)p2.getOtherProperty().get("contract_type"));
            p2.setContactUuid((String)p2.getOtherProperty().get("contract_no"));
            p2.setContactLabel((String)p2.getOtherProperty().get("contract_label"));
            p2.setContactValue((String)p2.getOtherProperty().get("contract_value"));
            p2.setContactOrder(Integer.valueOf(contactOrder));
            ++contactOrder;
        }
        polPolicyRisks.forEach(r -> {
            r.setOrderUuid(finalOrder_uuid);
            r.setRiskUuid(r.getRiskNo());
            if (r.getIsMainRisk().equals("M")) {
                String risks = r.getRiskNo();
                HashMap<String, String> bodyJson = new HashMap<String, String>();
                bodyJson.put("riskNos", risks);
                String respJson = HttpUtils.jsonPost((String)this.queryProductListByNo, (String)JsonUtils.toJson(bodyJson));
                Map dataMap = JsonUtils.json2Map((String)respJson);
                List data = (List)dataMap.get("data");
                Map product = (Map)((Map)data.get(0)).get("productData");
                r.setInsureType((String)product.get("insure_type"));
            }
        });
        String[] s = (String[])policyOrderParties.stream().map(PolPolicyOrderParty::getPartyUuid).toArray(String[]::new);
        this.dao.delete(PolPolicyOrderParty.n().where().addIn(PolPolicyOrderParty.ORDER_UUID, new String[]{order_uuid}).model());
        this.dao.delete(PolPolicyPartyRelation.n().where().addIn(PolPolicyPartyRelation.MASTER_RELATION, s).model());
        this.dao.delete(PolPolicyPartyAddress.n().where().addIn(PolPolicyPartyAddress.PARTY_UUID, s).model());
        this.dao.delete(PolPolicyPartyContact.n().where().addIn(PolPolicyPartyContact.PARTY_UUID, s).model());
        this.dao.delete(PolCrsResult.n().where().addIn(PolCrsResult.PARTY_UUID, s).model());
        this.dao.delete(PolPolicyPartyImage.n().where().addIn(PolPolicyPartyImage.PARTY_UUID, s).model());
        this.dao.delete(PolPolicyRisk.n().where().addEq(PolPolicyRisk.ORDER_UUID, (Object)order_uuid).model());
        this.dao.save(polPolicyPartyRelations);
        this.dao.save(policyOrderParties);
        this.dao.save(polPolicyPartyAddresses);
        this.dao.save(polPolicyPartyContracts);
        polPolicyRisks.forEach(r -> {
            if (StrUtils.isNull((Object)r.getParentSerno())) {
                r.setParentSerno(r.getSerno());
            }
            r.setPolicyUuid(finalPolicy_uuid);
            r.setRiskUuid(UUID.shortUUID());
            r.setIsChecked("Y");
            r.setRiskCode(r.getRiskNo());
            if (!StrUtils.isNull((Object)r.getChargeType()) && (r.getChargeType().equals("1") || r.getChargeType().equals("5"))) {
                r.setRateCoefficient("1");
            }
            if (!StrUtils.isNull((Object)r.getRiskCode()) && (r.getRiskCode().equals("72418") || r.getRiskCode().equals("65605") || r.getRiskCode().equals("72925"))) {
                r.setJobTypeCls("2");
            }
            if (!StrUtils.isNull((Object)r.getRiskCode()) && (r.getRiskCode().equals("80211") || r.getRiskCode().equals("80147") || r.getRiskCode().equals("80252"))) {
                r.setInsureType("PZJG");
            }
        });
        this.dao.save(polPolicyRisks);
        this.dao.save(polCrsResults);
        this.dao.save(imageSave);
        map.put("policy_uuid", order_uuid);
        msg.setDataTable(map);
        return msg.msg();
    }

    private Map<String, Object> getCls(String jobCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String json = new String(Files.readAllBytes(Paths.get(Env.env().baseDir() + "professionNewLs.json", new String[0])), StandardCharsets.UTF_8);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(json);
            JsonNode data = root.path("data");
            if (data.isArray()) {
                for (JsonNode item : data) {
                    if (!item.isArray() || item.size() != 2 || !String.valueOf(item).contains(jobCode)) continue;
                    String lCls = item.get(1).get("lCls").asText();
                    String hCls = item.get(1).get("hCls").asText();
                    String mCls = item.get(1).get("mCls").asText();
                    String eCls = item.get(1).get("eCls").asText();
                    map.put("lCls", lCls);
                    map.put("hCls", hCls);
                    map.put("mCls", mCls);
                    map.put("eCls", eCls);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    private List<PolPolicyRisk> getRiskSerno(List<PolPolicyRisk> riskETong) {
        ArrayList riskNos = new ArrayList();
        riskETong.forEach(r -> {
            if (r.getSerno().equals(r.getParentSerno())) {
                r.setIsMainRisk("M");
            }
            riskNos.add(r.getRiskNo());
        });
        String risks = riskNos.stream().collect(Collectors.joining(","));
        HashMap<String, String> bodyJson = new HashMap<String, String>();
        bodyJson.put("riskNos", risks);
        String respJson = HttpUtils.jsonPost((String)this.queryRiskInfo, (String)JsonUtils.toJson(bodyJson));
        Map dataMap = JsonUtils.json2Map((String)respJson);
        List mRisk = (List)dataMap.get("data");
        ArrayList<PolPolicyRisk> products = new ArrayList<PolPolicyRisk>();
        List<PolPolicyRisk> riskETong1 = this.getSerno(riskETong);
        BeanUtils.copyProperties(riskETong, riskETong1);
        ArrayList list = new ArrayList();
        ArrayList mrisks = new ArrayList();
        for (PolPolicyRisk polPolicyRisk : riskETong1) {
            for (Map r2 : mRisk) {
                if (!r2.get("risk_no").equals(polPolicyRisk.getRiskNo())) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("serno", polPolicyRisk.getSerno());
                map.put("policy_id", (String)r2.get("policy_id"));
                map.put(polPolicyRisk.getSerno(), (String)r2.get("policy_id"));
                list.add(map);
                polPolicyRisk.setPolicyId((String)r2.get("policy_id"));
                polPolicyRisk.setContainDeath((String)r2.get("contain_death"));
                polPolicyRisk.setMergeCalcFlag((String)r2.get("merge_calc_flag"));
                polPolicyRisk.setTermType((String)r2.get("term_type"));
                polPolicyRisk.setDutyType((String)r2.get("duty_type"));
                polPolicyRisk.setWaiverRisk((String)r2.get("waiver_risk"));
                polPolicyRisk.setWaiverType((String)r2.get("waiver_type"));
                polPolicyRisk.setIfNoCareSeries((String)r2.get("if_no_careSeries"));
                polPolicyRisk.setRiskType(polPolicyRisk.getIsMainRisk());
            }
            if (StrUtils.isNull((Object)polPolicyRisk.getParentSerno())) {
                polPolicyRisk.setParentSerno(polPolicyRisk.getSerno());
                PolPolicyRisk product = new PolPolicyRisk();
                product.setOrderUuid(polPolicyRisk.getOrderUuid());
                product.setPolicyUuid(polPolicyRisk.getPolicyUuid());
                product.setRiskUuid(UUID.shortUUID());
                product.setPartyUuid(polPolicyRisk.getPartyUuid());
                product.setParentSerno(polPolicyRisk.getParentSerno());
                product.setRiskType("P");
                product.setProductName(polPolicyRisk.getRiskName());
                product.setInsureType(polPolicyRisk.getInsureType());
                product.setNodeSeq(polPolicyRisk.getParentNodeSeq());
                product.setParentNodeSeq(polPolicyRisk.getParentNodeSeq());
                products.add(product);
                HashMap<String, String> mrisk = new HashMap<String, String>();
                mrisk.put("policy_id", polPolicyRisk.getPolicyId());
                mrisk.put("risk_no", polPolicyRisk.getRiskNo());
                mrisks.add(mrisk);
            }
            if (!polPolicyRisk.getIsMainRisk().equals("W")) continue;
            List r3 = riskETong1.stream().filter(o -> o.getSerno().equals(risk.getParentSerno())).collect(Collectors.toList());
            polPolicyRisk.setPartyUuid(((PolPolicyRisk)r3.get(0)).getPartyUuid());
        }
        riskETong1.addAll(products);
        for (Map map : list) {
            riskETong1.forEach(r -> {
                if (StrUtils.isNull((Object)r.getParentSerno())) {
                    r.setParentSerno(r.getSerno());
                }
                String node_seq = r.getNodeSeq().replaceAll((String)m.get("serno"), (String)m.get("policy_id"));
                String parent_node_seq = r.getParentNodeSeq().replaceAll((String)m.get("serno"), (String)m.get("policy_id"));
                r.setNodeSeq(node_seq);
                r.setParentNodeSeq(parent_node_seq);
            });
        }
        for (Map map : mrisks) {
            riskETong1.forEach(r -> {
                if (StrUtils.isNull((Object)r.getParentSerno())) {
                    r.setParentSerno(r.getSerno());
                }
                String node_seq = r.getNodeSeq().replaceAll("PK" + (String)m.get("policy_id"), "PK" + (String)m.get("risk_no"));
                String parent_node_seq = r.getParentNodeSeq().replaceAll("PK" + (String)m.get("policy_id"), "PK" + (String)m.get("risk_no"));
                r.setNodeSeq(node_seq);
                r.setParentNodeSeq(parent_node_seq);
            });
        }
        return riskETong1;
    }

    private List<PolPolicyRisk> getSerno(List<PolPolicyRisk> riskETong) {
        HashMap nodeMap = new HashMap();
        ArrayList riskNos = new ArrayList();
        riskETong.forEach(r -> {
            if (r.getSerno().equals(r.getParentSerno())) {
                r.setParentSerno("");
                riskNos.add(r.getRiskNo());
            }
            nodeMap.put(r.getSerno(), r);
        });
        for (PolPolicyRisk risk : riskETong) {
            PolPolicyRisk parentMap;
            String serno = risk.getSerno();
            String parentSerno = risk.getParentSerno();
            String sernoPath = "";
            while (!StrUtils.isNull((Object)parentSerno) && (parentMap = (PolPolicyRisk)nodeMap.get(parentSerno)) != null) {
                sernoPath = parentMap.getSerno() + "," + sernoPath;
                parentSerno = parentMap.getParentSerno();
            }
            String[] s = sernoPath.split(",");
            String pk = s[0];
            if (StrUtils.isNull((Object)pk)) {
                pk = risk.getSerno();
            }
            risk.setNodeSeq("PK" + pk + "," + sernoPath + serno);
            String p = "PK" + pk + "," + sernoPath;
            risk.setParentNodeSeq(p.substring(0, p.length() - 1));
            if (!risk.getIsMainRisk().equals("W")) continue;
            risk.setNodeSeq(risk.getNodeSeq() + "," + risk.getPartyUuid());
            risk.setWaiverPartyUuid(risk.getPartyUuid());
        }
        return riskETong;
    }

    @Override
    public ReturnMsg anotherOrder(AgainPolicyParam downPolicyParam) {
        Return msg = new Return();
        String policy_uuid = UUID.uuid();
        String order_uuid = UUID.shortUUID();
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, Object> eTong = this.downloadPolicy(downPolicyParam);
        PolicyInfoVo policyInfoVo = (PolicyInfoVo)JSONObject.parseObject((String)JsonUtils.toJson(eTong), PolicyInfoVo.class);
        PolPolicy polPolicy = (PolPolicy)JSONObject.parseObject((String)JsonUtils.toJson((Object)policyInfoVo.getPol_policy()), PolPolicy.class);
        PolPolicyOrder polPolicyOrder = (PolPolicyOrder)JSONObject.parseObject((String)JsonUtils.toJson((Object)policyInfoVo.getPol_policy()), PolPolicyOrder.class);
        if (polPolicyOrder.getPolicyInputType().equals("customer")) {
            polPolicyOrder.setImageUpload("");
            polPolicyOrder.setImageUpState("");
            polPolicy.setImageUpload("");
        }
        polPolicy.setPolicyState("1");
        polPolicy.setOrderUuid(order_uuid);
        polPolicy.setPolicyUuid(policy_uuid);
        polPolicy.setPolicyState("1");
        this.dao.save((AbsModel)polPolicy);
        polPolicyOrder.setOrderUuid(order_uuid);
        polPolicyOrder.setOrderUuid(order_uuid);
        polPolicyOrder.setBranchId(polPolicyOrder.getOrganId());
        polPolicyOrder.setCopyPolicyFlag("Y");
        polPolicyOrder.setIsInternalPolicy("");
        polPolicyOrder.setIsInternalPush("");
        polPolicyOrder.setInternalStaffAccountNo("");
        if (!StrUtils.isNull((Object)polPolicyOrder.getOuteragentCode()) && !polPolicyOrder.getOuteragentCode().startsWith("3")) {
            String a2 = polPolicyOrder.getOuteragentCode();
            String b2 = polPolicyOrder.getAgentId();
            polPolicyOrder.setOuteragentCode(b2);
            polPolicyOrder.setAgentId(a2);
        }
        this.dao.save((AbsModel)polPolicyOrder);
        PolPolicyPay polPolicyPay = (PolPolicyPay)JsonUtils.json2Class((String)JsonUtils.toJson((Object)((Object)policyInfoVo.getPol_policy_pay())), PolPolicyPay.class);
        PolPolicyPay polPolicyPayDB = new PolPolicyPay();
        polPolicyPayDB.where().addEq(PolPolicyPay.ORDER_UUID, (Object)polPolicyPay.getPolicyUuid());
        polPolicyPayDB = (PolPolicyPay)this.dao.findOne((AbsModel)polPolicyPayDB);
        if (!StrUtils.isNull((Object)polPolicyPayDB)) {
            polPolicyPay.setAcctUuid(polPolicyPayDB.getAcctUuid());
            polPolicyPay.setPayType(polPolicyPayDB.getPayType());
        }
        polPolicyPay.setOrderUuid(order_uuid);
        polPolicyPay.setPolicyUuid(policy_uuid);
        polPolicyPay.setAcctUuid(UUID.uuid());
        polPolicyPay.setPartyUuid(UUID.shortUUID());
        this.dao.save((AbsModel)polPolicyPay);
        CorporateProjectVo corporateProjectVo = policyInfoVo.getPol_policy().getPol_policy_corporate_project();
        if (!StrUtils.isNull((Object)corporateProjectVo)) {
            PolPolicyCorporateCompany polPolicyCorporateCompany;
            PolPolicyCorporateCustomer polPolicyCorporateCustomer;
            List<PolPolicyCorporateUser> polPolicyCorporateUsers;
            PolPolicyCorporateTeam polPolicyCorporateTeam;
            PolPolicyCorporateResource polPolicyCorporateResource;
            PolPolicyCorporateProject polPolicyCorporateProject = (PolPolicyCorporateProject)JsonUtils.json2Class((String)JsonUtils.toJson((Object)corporateProjectVo), PolPolicyCorporateProject.class);
            polPolicyCorporateProject.setOrderUuid(order_uuid);
            this.dao.save((AbsModel)polPolicyCorporateProject);
            List<PolPolicyCorporateConfirmation> polPolicyCorporateConfirmations = corporateProjectVo.getPol_policy_corporate_confirmation();
            if (!StrUtils.isNull(polPolicyCorporateConfirmations)) {
                polPolicyCorporateConfirmations.forEach(o -> o.setOrderUuid(order_uuid));
                this.dao.save(polPolicyCorporateConfirmations);
            }
            if (!StrUtils.isNull((Object)(polPolicyCorporateResource = corporateProjectVo.getPol_policy_corporate_resource()))) {
                polPolicyCorporateResource.setOrderUuid(order_uuid);
                this.dao.save((AbsModel)polPolicyCorporateResource);
            }
            if (!StrUtils.isNull((Object)(polPolicyCorporateTeam = corporateProjectVo.getPol_policy_corporate_team()))) {
                polPolicyCorporateTeam.setOrderUuid(order_uuid);
                this.dao.save((AbsModel)polPolicyCorporateTeam);
            }
            if (!StrUtils.isNull(polPolicyCorporateUsers = corporateProjectVo.getPol_policy_corporate_user())) {
                polPolicyCorporateUsers.forEach(o -> o.setOrderUuid(order_uuid));
                this.dao.save(polPolicyCorporateUsers);
            }
            if (!StrUtils.isNull((Object)(polPolicyCorporateCustomer = corporateProjectVo.getPol_policy_corporate_customer()))) {
                polPolicyCorporateCustomer.setOrderUuid(order_uuid);
                this.dao.save((AbsModel)polPolicyCorporateCustomer);
            }
            if (!StrUtils.isNull((Object)(polPolicyCorporateCompany = corporateProjectVo.getPol_policy_corporate_company()))) {
                polPolicyCorporateCompany.setOrderUuid(order_uuid);
                this.dao.save((AbsModel)polPolicyCorporateCompany);
            }
        }
        ArrayList<PolicyPartyVo> pol_policy_party = new ArrayList<PolicyPartyVo>();
        ArrayList<PolicyAddressVo> address = new ArrayList<PolicyAddressVo>();
        ArrayList<PolicyContract> contract = new ArrayList<PolicyContract>();
        ArrayList<PolicyTaxVo> pol_policy_tax = new ArrayList<PolicyTaxVo>();
        ArrayList<PolicyImageVo> pol_policy_image = new ArrayList<PolicyImageVo>();
        ArrayList<PolPolicyRisk> riskETong = new ArrayList<PolPolicyRisk>();
        ArrayList polPolicyPartyRelations = new ArrayList();
        PolicyPartyVo policyPartyVo = new PolicyPartyVo();
        BeanUtils.copyProperties((Object)((Object)policyInfoVo.getTpol_policy_party()), (Object)((Object)policyPartyVo));
        policyInfoVo.getTpol_policy_party().getBpol_policy_party().forEach(b -> {
            if ("Y".equals(b.getIsMentallyDisabledParty())) {
                policyPartyVo.setMentallyDisabledName(b.getFull_name());
            }
            if (!CollectionUtils.isEmpty(b.getSpol_policy_party())) {
                b.getSpol_policy_party().forEach(s -> {
                    if ("Y".equals(s.getIsMentallyDisabledParty())) {
                        policyPartyVo.setMentallyDisabledName(s.getFull_name());
                    }
                });
            }
        });
        policyPartyVo.setLcls(policyPartyVo.getL_cls());
        policyPartyVo.setMcls(policyPartyVo.getM_cls());
        policyPartyVo.setEcls(policyPartyVo.getE_cls());
        policyPartyVo.setHcls(policyPartyVo.getH_cls());
        if (!CollectionUtils.isEmpty(policyInfoVo.getTpol_policy_party().getPol_policy_tax())) {
            PolicyTaxVo tpolicyTaxVo = new PolicyTaxVo();
            tpolicyTaxVo = this.getTax(policyInfoVo.getTpol_policy_party().getPol_policy_tax());
            tpolicyTaxVo.setParty_uuid(policyInfoVo.getTpol_policy_party().getParty_uuid());
            String[] tname = policyInfoVo.getTpol_policy_party().getTaxpayer_name().split("&");
            tpolicyTaxVo.setFirstName(tname[0]);
            tpolicyTaxVo.setFamilyName(tname[1]);
            BeanUtils.copyProperties((Object)((Object)tpolicyTaxVo), policyInfoVo.getTpol_policy_party().getPol_policy_tax());
            tpolicyTaxVo.setReason(policyInfoVo.getTpol_policy_party().getNo_registeration_reson());
            tpolicyTaxVo.setReasondescribe(policyInfoVo.getTpol_policy_party().getNo_registeration_reson_info());
            pol_policy_tax.add(tpolicyTaxVo);
        }
        pol_policy_party.add(policyPartyVo);
        address.addAll(policyInfoVo.getTpol_policy_party().getAddress());
        contract.addAll(policyInfoVo.getTpol_policy_party().getContact());
        pol_policy_image.addAll(policyInfoVo.getTpol_policy_party().getPol_policy_image());
        if (!CollectionUtils.isEmpty(policyInfoVo.getTpol_policy_party().getBpol_policy_party())) {
            policyInfoVo.getTpol_policy_party().getBpol_policy_party().forEach(o -> {
                PolicyPartyVo policyPartyVo1 = new PolicyPartyVo();
                policyPartyVo1.setLcls(o.getLcls());
                policyPartyVo1.setMcls(o.getMcls());
                policyPartyVo1.setEcls(o.getEcls());
                policyPartyVo1.setHcls(o.getHcls());
                BeanUtils.copyProperties((Object)o, (Object)((Object)policyPartyVo1));
                if (o.getAddress().equals(policyInfoVo.getTpol_policy_party().getAddress())) {
                    policyPartyVo1.setAddress_same_with_applicant("Y");
                } else {
                    policyPartyVo1.setAddress_same_with_applicant("N");
                }
                if (o.getId_no().equals(policyInfoVo.getTpol_policy_party().getId_no())) {
                    policyPartyVo.setLcls(o.getLcls());
                    policyPartyVo.setMcls(o.getMcls());
                    policyPartyVo.setEcls(o.getEcls());
                    policyPartyVo.setHcls(o.getHcls());
                }
                pol_policy_party.add(policyPartyVo1);
                address.addAll(o.getAddress());
                contract.addAll(o.getContact());
                if (!CollectionUtils.isEmpty(o.getPol_policy_tax())) {
                    PolicyTaxVo policyTaxVo = new PolicyTaxVo();
                    policyTaxVo = this.getTax(o.getPol_policy_tax());
                    String[] name = o.getTaxpayer_name().split("&");
                    policyTaxVo.setFirstName(name[0]);
                    policyTaxVo.setFamilyName(name[1]);
                    policyTaxVo.setParty_uuid(o.getParty_uuid());
                    policyTaxVo.setReason(o.getNo_registeration_reson());
                    policyTaxVo.setReasondescribe(o.getNo_registeration_reson_info());
                    pol_policy_tax.add(policyTaxVo);
                }
                pol_policy_image.addAll(o.getPol_policy_image());
                List<PolPolicyRisk> AMRisk = o.getPol_policy_risk();
                List<PolPolicyRisk> WRisk = o.getPol_waiver_risk();
                AMRisk.forEach(r -> {
                    r.setIsMainRisk("A");
                    r.setDisplayOrder(Integer.valueOf(Integer.parseInt(r.getRiskOrder())));
                });
                WRisk.forEach(r -> r.setIsMainRisk("W"));
                riskETong.addAll(JsonUtils.json2List((String)JsonUtils.toJson(AMRisk), PolPolicyRisk.class));
                riskETong.addAll(JsonUtils.json2List((String)JsonUtils.toJson(WRisk), PolPolicyRisk.class));
                PolPolicyPartyRelation polPolicyPartyRelation = new PolPolicyPartyRelation();
                polPolicyPartyRelation.setMasterRelation(policyInfoVo.getTpol_policy_party().getParty_uuid());
                polPolicyPartyRelation.setMasterPartyType("TBR");
                polPolicyPartyRelation.setAffiliatedRelation(o.getParty_uuid());
                polPolicyPartyRelation.setAffiliatedPartyType("BBR");
                polPolicyPartyRelation.setAffiliatedType(o.getAffiliated_type());
                polPolicyPartyRelations.add(polPolicyPartyRelation);
                if (!CollectionUtils.isEmpty(o.getSpol_policy_party())) {
                    o.getSpol_policy_party().forEach(s -> {
                        PolicyPartyVo policyPartyVo2 = new PolicyPartyVo();
                        BeanUtils.copyProperties((Object)s, (Object)((Object)policyPartyVo2));
                        policyPartyVo2.setLcls(policyPartyVo2.getLcls());
                        policyPartyVo2.setMcls(policyPartyVo2.getMcls());
                        policyPartyVo2.setEcls(policyPartyVo2.getEcls());
                        policyPartyVo2.setHcls(policyPartyVo2.getHcls());
                        pol_policy_party.add(policyPartyVo2);
                        address.addAll(s.getAddress());
                        contract.addAll(s.getContact());
                        pol_policy_image.addAll(s.getPol_policy_image());
                        PolPolicyPartyRelation polPolicyPartyRelation1 = new PolPolicyPartyRelation();
                        polPolicyPartyRelation1.setMasterRelation(o.getParty_uuid());
                        polPolicyPartyRelation1.setMasterPartyType("BBR");
                        polPolicyPartyRelation1.setAffiliatedRelation(s.getParty_uuid());
                        polPolicyPartyRelation1.setAffiliatedPartyType("SYR");
                        polPolicyPartyRelation1.setAffiliatedType(s.getAffiliated_type());
                        polPolicyPartyRelation1.setAffiliatedApplicant("N");
                        if (s.getId_no().equals(policyInfoVo.getTpol_policy_party().getId_no())) {
                            polPolicyPartyRelation1.setAffiliatedApplicant("5");
                        } else {
                            polPolicyPartyRelation1.setAffiliatedApplicant("N");
                        }
                        polPolicyPartyRelation1.setBenefitOrder(s.getBenefit_order());
                        polPolicyPartyRelation1.setBenefitRatio(s.getBenefit_ratio());
                        polPolicyPartyRelations.add(polPolicyPartyRelation1);
                    });
                }
            });
        }
        this.getRiskSerno(riskETong);
        List polCrsResults = JsonUtils.json2List((String)JsonUtils.toJson(pol_policy_tax), PolCrsResult.class);
        pol_policy_party.stream().forEach(o -> {
            polCrsResults.forEach(f -> {
                if (f.getPartyUuid().equals(o.getParty_uuid()) && !StrUtils.isNull((Object)o.getTaxpayer_name())) {
                    String[] s = o.getTaxpayer_name().split("&");
                    f.setFamilyName(s[0]);
                    f.setFirstName(s[1]);
                }
            });
            o.getId().stream().forEach(i -> {
                if (i.getId_order().equals("1")) {
                    o.setId_no(i.getId_no());
                    o.setId_type(i.getId_type());
                    o.setId_start_date(i.getId_start_date());
                    o.setId_end_date(i.getId_end_date());
                }
                if (i.getId_order().equals("2")) {
                    o.setId_no2(i.getId_no());
                    o.setId_type2(i.getId_type());
                    o.setId_start_date2(i.getId_start_date());
                    o.setId_end_date2(i.getId_end_date());
                }
                if (i.getId_order().equals("3")) {
                    o.setId_no3(i.getId_no());
                    o.setId_type3(i.getId_type());
                    o.setId_start_date3(i.getId_start_date());
                    o.setId_end_date3(i.getId_end_date());
                }
            });
        });
        List policyOrderParties = JsonUtils.json2List((String)JsonUtils.toJson(pol_policy_party), PolPolicyOrderParty.class);
        List polPolicyPartyAddresses = JsonUtils.json2List((String)JsonUtils.toJson(address), PolPolicyPartyAddress.class);
        List polPolicyPartyContracts = JsonUtils.json2List((String)JsonUtils.toJson(contract), PolPolicyPartyContact.class);
        List polPolicyPartyImages = JsonUtils.json2List((String)JsonUtils.toJson(pol_policy_image), PolPolicyPartyImage.class);
        List polPolicyRisks = JsonUtils.json2List((String)JsonUtils.toJson(riskETong), PolPolicyRisk.class);
        String[] s = (String[])policyOrderParties.stream().map(PolPolicyOrderParty::getPartyUuid).toArray(String[]::new);
        ArrayList partys = new ArrayList();
        for (String a3 : s) {
            HashMap<String, String> pmap = new HashMap<String, String>();
            pmap.put("old_id", a3);
            pmap.put("new_id", UUID.shortUUID());
            partys.add(pmap);
        }
        polPolicyPartyContracts = polPolicyPartyContracts.stream().filter(a -> !StrUtils.isNull((Object)a.getContactValue())).collect(Collectors.toList());
        for (Map map2 : partys) {
            policyOrderParties.stream().filter(a -> a.getPartyUuid().equals(m.get("old_id"))).forEach(b -> b.setPartyUuid((String)m.get("new_id")));
            polPolicyPartyAddresses.stream().filter(a -> a.getPartyUuid().equals(m.get("old_id"))).forEach(b -> b.setPartyUuid((String)m.get("new_id")));
            polPolicyPartyContracts.stream().filter(a -> a.getPartyUuid().equals(m.get("old_id"))).forEach(b -> b.setPartyUuid((String)m.get("new_id")));
            polCrsResults.stream().filter(a -> a.getPartyUuid().equals(m.get("old_id"))).forEach(b -> b.setPartyUuid((String)m.get("new_id")));
            polPolicyPartyImages.stream().filter(a -> a.getPartyUuid().equals(m.get("old_id"))).forEach(b -> b.setPartyUuid((String)m.get("new_id")));
            polPolicyRisks.stream().filter(a -> a.getPartyUuid().equals(m.get("old_id"))).forEach(r -> {
                r.setOrderUuid(order_uuid);
                r.setPolicyUuid(policy_uuid);
                r.setPartyUuid((String)m.get("new_id"));
                r.setRiskUuid(UUID.uuid());
                r.setSerno("");
            });
            polPolicyRisks.stream().filter(a -> !StrUtils.isNull((Object)a.getWaiverPartyUuid()) && a.getWaiverPartyUuid().equals(m.get("old_id"))).forEach(r -> {
                r.setWaiverPartyUuid((String)m.get("new_id"));
                r.setNodeSeq(r.getNodeSeq().replace((CharSequence)m.get("old_id"), (CharSequence)m.get("new_id")));
            });
            polPolicyPartyRelations.stream().filter(a -> a.getMasterRelation().equals(m.get("old_id"))).forEach(b -> b.setMasterRelation((String)m.get("new_id")));
            polPolicyPartyRelations.stream().filter(a -> a.getAffiliatedRelation().equals(m.get("old_id"))).forEach(b -> b.setAffiliatedRelation((String)m.get("new_id")));
        }
        String finalOrder_uuid = order_uuid;
        String string = policy_uuid;
        ArrayList imageSave = new ArrayList();
        polPolicyPartyImages.forEach(p -> {
            p.setPolicyUuid(finalPolicy_uuid);
            p.setOrderUuid(finalOrder_uuid);
            if (p.getImageType().equals("01") || p.getImageType().equals("11") || p.getImageType().equals("279") || p.getImageType().equals("280")) {
                imageSave.add(p);
            }
        });
        policyOrderParties.forEach(p -> {
            p.setOrderUuid(finalOrder_uuid);
            Ulog.info((String)("\u518d\u6765\u4e00\u5355\u4eba\u5458" + p.getPartyUuid()));
            Ulog.info((String)("\u518d\u6765\u4e00\u5355jobcode" + p.getJobCode()));
            p.setFinishFlag("Y");
            p.setFinishSpolFlag("Y");
            Map<String, Object> job = this.getCls(p.getJobCode());
            Ulog.info((String)("\u518d\u6765\u4e00\u5355jobcode" + p.getJobCode() + "\u804c\u4e1a\u7b49\u7ea7" + JsonUtils.toJson(job)));
            p.setLcls((String)job.get("lCls"));
            p.setHcls((String)job.get("hCls"));
            p.setEcls((String)job.get("eCls"));
            p.setMcls((String)job.get("mCls"));
        });
        Ulog.info((String)("\u4eba\u5458\u603b" + JsonUtils.toJson((Object)policyOrderParties)));
        int contactOrder = 1;
        for (PolPolicyPartyContact p2 : polPolicyPartyContracts) {
            if (p2.getOtherProperty().get("contract_type").equals("04") && StrUtils.isNull(p2.getOtherProperty().get("contract_value"))) continue;
            p2.setContactType((String)p2.getOtherProperty().get("contract_type"));
            p2.setContactUuid((String)p2.getOtherProperty().get("contract_no"));
            p2.setContactLabel((String)p2.getOtherProperty().get("contract_label"));
            p2.setContactValue((String)p2.getOtherProperty().get("contract_value"));
            p2.setContactOrder(Integer.valueOf(contactOrder));
            ++contactOrder;
        }
        polPolicyRisks.forEach(r -> {
            if (r.getIsMainRisk().equals("M")) {
                String risks = r.getRiskNo();
                HashMap<String, String> bodyJson = new HashMap<String, String>();
                bodyJson.put("riskNos", risks);
                String respJson = HttpUtils.jsonPost((String)this.queryProductListByNo, (String)JsonUtils.toJson(bodyJson));
                Map dataMap = JsonUtils.json2Map((String)respJson);
                List data = (List)dataMap.get("data");
                Map product = (Map)((Map)data.get(0)).get("productData");
                r.setInsureType((String)product.get("insure_type"));
            }
            if (StrUtils.isNull((Object)r.getParentSerno())) {
                r.setParentSerno(r.getSerno());
            }
            r.setPolicyUuid(finalPolicy_uuid);
            r.setRiskUuid(UUID.shortUUID());
            r.setIsChecked("Y");
            r.setRiskCode(r.getRiskNo());
            if (!StrUtils.isNull((Object)r.getChargeType()) && (r.getChargeType().equals("1") || r.getChargeType().equals("5"))) {
                r.setRateCoefficient("1");
            }
            if (!StrUtils.isNull((Object)r.getRiskCode()) && (r.getRiskCode().equals("72418") || r.getRiskCode().equals("65605") || r.getRiskCode().equals("72925"))) {
                r.setJobTypeCls("2");
            }
            if (!StrUtils.isNull((Object)r.getRiskCode()) && (r.getRiskCode().equals("80211") || r.getRiskCode().equals("80147") || r.getRiskCode().equals("80252"))) {
                r.setInsureType("PZJG");
            }
        });
        this.dao.save(polPolicyPartyRelations);
        this.dao.save(policyOrderParties);
        polPolicyPartyAddresses.stream().forEach(a -> a.setAddressUuid(UUID.uuid()));
        this.dao.save(polPolicyPartyAddresses);
        polPolicyPartyContracts.stream().forEach(a -> a.setContactUuid(UUID.uuid()));
        this.dao.save(polPolicyPartyContracts);
        this.dao.save(polPolicyRisks);
        this.dao.save(polCrsResults);
        imageSave.stream().forEach(a -> a.setImageUuid(UUID.uuid()));
        if (!polPolicyOrder.getPolicyInputType().equals("customer")) {
            this.dao.save(imageSave);
        }
        map.put("policy_uuid", order_uuid);
        msg.setDataTable(map);
        return msg.msg();
    }

    private PolicyTaxVo getTax(List<PolicyTaxVo> policyTaxVos) {
        PolicyTaxVo policyTaxVo = new PolicyTaxVo();
        int i = 0;
        for (PolicyTaxVo t : policyTaxVos) {
            if (i == 0) {
                policyTaxVo.setTaxResidentCountry1(t.getCountry_code());
                policyTaxVo.setTaxpayerIdentificationCode1(t.getTaxpayer_num());
            }
            if (i == 1) {
                policyTaxVo.setTaxResidentCountry2(t.getCountry_code());
                policyTaxVo.setTaxpayerIdentificationCode2(t.getTaxpayer_num());
            }
            if (i == 2) {
                policyTaxVo.setTaxResidentCountry3(t.getCountry_code());
                policyTaxVo.setTaxpayerIdentificationCode3(t.getTaxpayer_num());
            }
            if (i == 3) {
                policyTaxVo.setTaxResidentCountry4(t.getCountry_code());
                policyTaxVo.setTaxpayerIdentificationCode4(t.getTaxpayer_num());
            }
            ++i;
        }
        return policyTaxVo;
    }

    private Map<String, Object> downloadPolicy(AgainPolicyParam param) {
        String pk_uuid = param.getPk_uuid();
        String token = param.getToken();
        String user_code = param.getUser_code();
        String deployed_env = param.getDeployed_env();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("x-auth-token", token);
        headerMap.put("usercode", user_code);
        headerMap.put("deployed_env", "rel");
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("policy_uuid", param.getPolicy_uuid());
        bodyMap.put("pk_uuid", pk_uuid);
        bodyMap.put("funcID", "/downloadPolicy.do");
        SysTradeLog sysTradeLog = new SysTradeLog();
        String transno = UUID.shortUUID();
        sysTradeLog.setInterfaceNo(SmsEnum.abutmentInterface.abutmentBDXZ.getType());
        sysTradeLog.setSystemNo(SmsEnum.callSystem.SystemeTong.getType());
        sysTradeLog.setParamData(JsonUtils.toJson(bodyMap));
        sysTradeLog.setTransNo(transno);
        sysTradeLog.setParamType(SmsEnum.paramType.paramTypeReq.getType());
        sysTradeLog.setOrderUuid(param.getPolicy_uuid());
        this.systemEAbutmentUtil.insertSysTradeLog(sysTradeLog);
        headerMap.put("order_uuid", param.getPolicy_uuid());
        String json = this.eTongReqService.jsonPostETong(this.downPolicyPath + "?apikey=" + this.apiPlatformApikey, JsonUtils.toJson(bodyMap), headerMap);
        Map returnMap = JsonUtils.json2Map((String)json);
        String flag = (String)returnMap.get("flag");
        if (!flag.equals("success")) {
            sysTradeLog.setParamData(JsonUtils.toJson((Object)returnMap));
            sysTradeLog.setParamType(SmsEnum.paramType.paramTypeRes.getType());
            this.systemEAbutmentUtil.insertSysTradeLog(sysTradeLog);
            throw new BusinessException("\u8c03\u7528E\u901a\u63a5\u53e3\u5931\u8d25");
        }
        sysTradeLog.setParamData(JsonUtils.toJson((Object)returnMap));
        sysTradeLog.setParamType(SmsEnum.paramType.paramTypeRes.getType());
        this.systemEAbutmentUtil.insertSysTradeLog(sysTradeLog);
        Map defmap = (Map)returnMap.get("defmap");
        return defmap;
    }

    @Override
    public ReturnMsg saveOrUpdateOrder(PolPolicyOrder orderReq, List<PolPolicyRisk> riskListReq, ETongPolPolicyCorporateProjectVo corporateProjectVo, String state) {
        this.checkService.checkAuth(orderReq.getOrderUuid());
        this.checkService.checkAuthAnent(orderReq.getAgentId());
        Return aReturn = new Return();
        String orderUuid = null;
        orderUuid = StrUtils.isNull((Object)orderReq.getOrderUuid()) ? UUID.uuid() : orderReq.getOrderUuid();
        orderReq.where().addEq(PolPolicyOrder.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)orderReq);
        orderReq.setOrderUuid(orderUuid);
        this.dao.save((AbsModel)orderReq);
        PolPolicy policy = PolPolicy.n();
        policy.where().addEq(PolPolicy.ORDER_UUID, (Object)orderUuid);
        PolPolicy policyDB = (PolPolicy)this.dao.findOne((AbsModel)policy);
        policy.where().addEq(PolPolicy.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)policy);
        BeanUtils.copyProperties((Object)orderReq, (Object)policy);
        String policyUuid = null;
        policyUuid = policyDB != null ? policyDB.getPolicyUuid() : UUID.uuid();
        policy.setPolicyUuid(policyUuid);
        if (StrUtils.isNull((Object)state)) {
            policy.setPolicyState("1");
        } else {
            policy.setPolicyState(state);
        }
        this.dao.save((AbsModel)policy);
        PolPolicyRisk risk = PolPolicyRisk.n();
        risk.where().addEq(PolPolicyRisk.ORDER_UUID, (Object)orderUuid);
        List risks = this.dao.findAll((AbsModel)risk);
        if (CollectionUtils.isEmpty((Collection)risks)) {
            this.savePolicyRisk(riskListReq, orderUuid, policyUuid);
        }
        PolPolicyCorporateProject projectDel = new PolPolicyCorporateProject();
        projectDel.where().addEq(PolPolicyCorporateProject.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)projectDel);
        PolPolicyCorporateResource resourceDel = new PolPolicyCorporateResource();
        resourceDel.where().addEq(PolPolicyCorporateResource.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)resourceDel);
        PolPolicyCorporateTeam teamDel = new PolPolicyCorporateTeam();
        teamDel.where().addEq(PolPolicyCorporateTeam.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)teamDel);
        PolPolicyCorporateConfirmation confirmationDel = new PolPolicyCorporateConfirmation();
        confirmationDel.where().addEq(PolPolicyCorporateConfirmation.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)confirmationDel);
        PolPolicyCorporateCustomer customerDel = new PolPolicyCorporateCustomer();
        customerDel.where().addEq(PolPolicyCorporateCustomer.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)customerDel);
        PolPolicyCorporateCompany companyDel = new PolPolicyCorporateCompany();
        companyDel.where().addEq(PolPolicyCorporateCompany.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)companyDel);
        PolPolicyCorporateUser userDel = new PolPolicyCorporateUser();
        userDel.where().addEq(PolPolicyCorporateProject.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)userDel);
        PolPolicyCorporateVxgroup vxgroupDel = new PolPolicyCorporateVxgroup();
        vxgroupDel.where().addEq(PolPolicyCorporateVxgroup.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)vxgroupDel);
        aReturn.getDataTable().put("order_uuid", orderUuid);
        aReturn.getDataTable().put("policy_uuid", policyUuid);
        if (ObjectUtils.isEmpty((Object)corporateProjectVo)) {
            return aReturn.msg();
        }
        PolPolicyCorporateProject project = new PolPolicyCorporateProject();
        BeanUtils.copyProperties((Object)corporateProjectVo, (Object)project);
        project.setOrderUuid(orderUuid);
        this.dao.save((AbsModel)project);
        if (!CollectionUtils.isEmpty(corporateProjectVo.getConfirmations())) {
            ArrayList<PolPolicyCorporateConfirmation> confirmations = new ArrayList<PolPolicyCorporateConfirmation>();
            for (ETongPolPolicyCorporateConfirmationVo confirmationVo : corporateProjectVo.getConfirmations()) {
                PolPolicyCorporateConfirmation confirmation = new PolPolicyCorporateConfirmation();
                BeanUtils.copyProperties((Object)((Object)confirmationVo), (Object)confirmation);
                confirmation.setOrderUuid(orderUuid);
                confirmations.add(confirmation);
            }
            this.dao.save(confirmations);
        }
        if (!ObjectUtils.isEmpty((Object)((Object)corporateProjectVo.getResource()))) {
            PolPolicyCorporateResource resource = new PolPolicyCorporateResource();
            BeanUtils.copyProperties((Object)((Object)corporateProjectVo.getResource()), (Object)resource);
            resource.setOrderUuid(orderUuid);
            this.dao.save((AbsModel)resource);
        }
        if (!ObjectUtils.isEmpty((Object)((Object)corporateProjectVo.getTeam()))) {
            PolPolicyCorporateTeam team = new PolPolicyCorporateTeam();
            BeanUtils.copyProperties((Object)((Object)corporateProjectVo.getTeam()), (Object)team);
            team.setOrderUuid(orderUuid);
            this.dao.save((AbsModel)team);
        }
        if (!CollectionUtils.isEmpty(corporateProjectVo.getUsers())) {
            ArrayList<PolPolicyCorporateUser> users = new ArrayList<PolPolicyCorporateUser>();
            for (ETongPolPolicyCorporateUserVo userVo : corporateProjectVo.getUsers()) {
                PolPolicyCorporateUser user = new PolPolicyCorporateUser();
                BeanUtils.copyProperties((Object)((Object)userVo), (Object)user);
                user.setOrderUuid(orderUuid);
                users.add(user);
            }
            this.dao.save(users);
        }
        if (!ObjectUtils.isEmpty((Object)((Object)corporateProjectVo.getCustomer()))) {
            PolPolicyCorporateCustomer customer = new PolPolicyCorporateCustomer();
            BeanUtils.copyProperties((Object)((Object)corporateProjectVo.getCustomer()), (Object)customer);
            customer.setOrderUuid(orderUuid);
            this.dao.save((AbsModel)customer);
        }
        if (!ObjectUtils.isEmpty((Object)((Object)corporateProjectVo.getCompany()))) {
            PolPolicyCorporateCompany company = new PolPolicyCorporateCompany();
            BeanUtils.copyProperties((Object)((Object)corporateProjectVo.getCompany()), (Object)company);
            company.setOrderUuid(orderUuid);
            this.dao.save((AbsModel)company);
        }
        if (!ObjectUtils.isEmpty((Object)corporateProjectVo.getVxGroupInfo())) {
            PolPolicyCorporateVxgroup vxgroup = corporateProjectVo.getVxGroupInfo();
            vxgroup.setOrderUuid(orderUuid);
            this.dao.save((AbsModel)vxgroup);
        }
        return aReturn.msg();
    }

    @Override
    public ReturnMsg saveOrUpdateParty(PolPolicyOrderPartyVo partyVo) {
        this.checkService.checkAuth(partyVo.getOrderUuid());
        Return aReturn = new Return();
        PolPolicyOrderPartyMd5Vo polPolicyOrderPartyMd5Vo = (PolPolicyOrderPartyMd5Vo)((Object)JsonUtils.json2Class((String)JsonUtils.toJson((Object)((Object)partyVo)), PolPolicyOrderPartyMd5Vo.class));
        JsonUtils.toJson((Object)((Object)partyVo));
        String partyVoJson = JsonUtils.toJson((Object)((Object)polPolicyOrderPartyMd5Vo));
        Ulog.info((String)("md5\u52a0\u5bc6json\u4e32:" + partyVoJson));
        String paramMd5 = DigestUtils.md5Hex((String)partyVoJson);
        Ulog.info((String)("saveOrUpdateParty\u63a5\u53e3\u5165\u53c2md5:" + paramMd5));
        PolPolicyOrderParty party = PolPolicyOrderParty.n();
        BeanUtils.copyProperties((Object)((Object)partyVo), (Object)party);
        String partyUuid = partyVo.getPartyUuid();
        if (StrUtils.isNull((Object)partyUuid)) {
            partyUuid = UUID.shortUUID();
        }
        PolPolicyOrderParty orderPartyDel = PolPolicyOrderParty.n();
        orderPartyDel.where().addEq(PolPolicyOrderParty.PARTY_UUID, (Object)partyUuid);
        PolPolicyOrderParty partyDB = (PolPolicyOrderParty)this.dao.findOne((AbsModel)orderPartyDel);
        orderPartyDel.where().addEq(PolPolicyOrderParty.PARTY_UUID, (Object)partyUuid);
        this.dao.delete((AbsModel)orderPartyDel);
        party.setPartyUuid(partyUuid);
        if (StrUtils.isNull((Object)party.getDisplayOrder())) {
            party.setDisplayOrder(Integer.valueOf(1));
        }
        party.setParamMd5(paramMd5);
        this.dao.save((AbsModel)party);
        PolPolicyParty partyDel = PolPolicyParty.n();
        partyDel.where().addEq(PolPolicyOrderParty.PARTY_UUID, (Object)partyUuid);
        this.dao.delete((AbsModel)partyDel);
        PolPolicyParty policyParty = new PolPolicyParty();
        BeanUtils.copyProperties((Object)((Object)partyVo), (Object)policyParty);
        PolPolicy policySr = PolPolicy.n();
        policySr.where().addEq(PolPolicy.ORDER_UUID, (Object)partyVo.getOrderUuid());
        List policyListDB = this.dao.findAll((AbsModel)policySr);
        for (PolPolicy policy : policyListDB) {
            policyParty.setPolicyUuid(policy.getPolicyUuid());
            this.dao.save((AbsModel)policyParty);
        }
        if (partyVo.getRelation() != null) {
            PolPolicyPartyRelation relationDel = PolPolicyPartyRelation.n();
            relationDel.setAffiliatedRelation(partyUuid);
            relationDel.where().addEq(PolPolicyPartyRelation.AFFILIATED_RELATION, (Object)partyUuid);
            this.dao.delete((AbsModel)relationDel);
            PolPolicyPartyRelation relation = partyVo.getRelation();
            relation.setAffiliatedRelation(partyUuid);
            this.dao.save((AbsModel)relation);
        }
        PolPolicyPartyAddress addressDel = PolPolicyPartyAddress.n();
        addressDel.setPartyUuid(partyUuid);
        addressDel.where().addEq(PolPolicyPartyAddress.PARTY_UUID, (Object)partyUuid);
        this.dao.delete((AbsModel)addressDel);
        List<PolPolicyPartyAddress> addressList = partyVo.getAddress();
        for (PolPolicyPartyAddress partyAddress : addressList) {
            partyAddress.setAddressUuid(UUID.uuid());
            partyAddress.setPartyUuid(partyUuid);
        }
        this.dao.save(addressList);
        PolPolicyPartyContact contactDel = PolPolicyPartyContact.n();
        contactDel.setPartyUuid(partyUuid);
        contactDel.where().addEq(PolPolicyPartyContact.PARTY_UUID, (Object)partyUuid);
        this.dao.delete((AbsModel)contactDel);
        List<PolPolicyPartyContact> contractList = partyVo.getContract();
        if (!CollectionUtils.isEmpty(contractList)) {
            int contractOrder = 1;
            for (PolPolicyPartyContact partyContact : contractList) {
                partyContact.setPartyUuid(partyUuid);
                partyContact.setContactUuid(UUID.uuid());
                partyContact.setContactOrder(Integer.valueOf(contractOrder));
                ++contractOrder;
            }
            this.dao.save(contractList);
        }
        PolCrsResult crsResultDel = PolCrsResult.n();
        crsResultDel.setPartyUuid(partyUuid);
        crsResultDel.where().addEq(PolCrsResult.PARTY_UUID, (Object)partyUuid);
        this.dao.delete((AbsModel)crsResultDel);
        PolCrsResultVo crsResultVo = partyVo.getCrsResult();
        if (("2".equals(partyVo.getTaxChina()) || "3".equals(partyVo.getTaxChina())) && !ObjectUtils.isEmpty((Object)((Object)crsResultVo))) {
            List<PolCrsResultVo.PolPolicyTax> polPolicyTaxList = crsResultVo.getPolPolicyTaxList();
            PolCrsResult crsResult = new PolCrsResult();
            BeanUtils.copyProperties((Object)((Object)crsResultVo), (Object)crsResult);
            crsResult.setPartyUuid(partyUuid);
            for (int i = 0; i < polPolicyTaxList.size(); ++i) {
                if (i == 0) {
                    crsResult.setTaxResidentCountry1(polPolicyTaxList.get(i).getTaxResidentCountry());
                    crsResult.setTaxpayerIdentificationCode1(polPolicyTaxList.get(i).getTaxpayerIdentificationCode());
                }
                if (i == 1) {
                    crsResult.setTaxResidentCountry2(polPolicyTaxList.get(i).getTaxResidentCountry());
                    crsResult.setTaxpayerIdentificationCode2(polPolicyTaxList.get(i).getTaxpayerIdentificationCode());
                }
                if (i != 2) continue;
                crsResult.setTaxResidentCountry3(polPolicyTaxList.get(i).getTaxResidentCountry());
                crsResult.setTaxpayerIdentificationCode3(polPolicyTaxList.get(i).getTaxpayerIdentificationCode());
            }
            this.dao.save((AbsModel)crsResult);
        }
        PolPolicyPartyImage image = PolPolicyPartyImage.n();
        image.where().addEq(PolPolicyPartyImage.PARTY_UUID, (Object)partyUuid).addIn(PolPolicyPartyImage.IMAGE_TYPE, new String[]{SmsEnum.ImageType.ZJ.getType(), SmsEnum.ImageType.RRAK.getType(), SmsEnum.ImageType.XZZA.getType()});
        this.dao.delete((AbsModel)image);
        List<PolPolicyPartyImage> imageList = partyVo.getImage();
        if (!CollectionUtils.isEmpty(imageList)) {
            for (PolPolicyPartyImage imageSave : imageList) {
                imageSave.setOrderUuid(partyVo.getOrderUuid());
                imageSave.setPolicyUuid(partyVo.getPolicyUuid());
                imageSave.setImageUuid(UUID.uuid());
                imageSave.setPartyUuid(partyUuid);
            }
            this.dao.save(imageList);
        }
        if ("TBR".equals(partyVo.getPartyType()) && partyDB != null && !paramMd5.equals(partyDB.getParamMd5())) {
            this.updateBBRFinishFlag(partyVo);
        }
        aReturn.getDataTable().put("party_uuid", partyUuid);
        return aReturn.msg();
    }

    private void updateBBRFinishFlag(PolPolicyOrderPartyVo partyVo) {
        PolPolicyPartyRelation bbrDB = (PolPolicyPartyRelation)this.dao.findOne(PolPolicyPartyRelation.n().where().addEq(PolPolicyPartyRelation.MASTER_RELATION, (Object)partyVo.getPartyUuid()).addEq(PolPolicyPartyRelation.MASTER_PARTY_TYPE, (Object)"TBR").addEq(PolPolicyPartyRelation.AFFILIATED_PARTY_TYPE, (Object)"BBR").addEq(PolPolicyPartyRelation.AFFILIATED_TYPE, (Object)"5").model());
        if (!ObjectUtils.isEmpty((Object)bbrDB)) {
            PolPolicyOrderParty bbrUpdate = PolPolicyOrderParty.n();
            bbrUpdate.where().addEq(PolPolicyOrderParty.PARTY_UUID, (Object)bbrDB.getAffiliatedRelation());
            bbrUpdate.setFinishFlag("N");
            bbrUpdate.setFinishSpolFlag("N");
            this.dao.update((AbsModel)bbrUpdate);
        }
    }

    @Override
    public ReturnMsg partyTongMethod(PolPolicyOrderPartyVo party) {
        ReturnMsg msg = null;
        List<PolPolicyPartyImage> imageList = party.getImage();
        if (null != imageList && !imageList.isEmpty()) {
            for (PolPolicyPartyImage image : imageList) {
                if (image.getImageType().equals("01")) continue;
                Return aReturn = new Return();
                aReturn.setFailMsg("\u5f71\u50cf\u7c7b\u578b\u9519\u8bef");
                return aReturn.msg();
            }
        }
        String partyType = party.getPartyType();
        msg = this.saveOrUpdateParty(party);
        if (partyType.equals("BBR")) {
            PolPolicyPartyRelation relation = party.getRelation();
            String affiliatedType = relation.getAffiliatedType();
            if (affiliatedType.equals("5")) {
                PolPolicyOrderParty tbr = new PolPolicyOrderParty();
                tbr.where().addEq(PolPolicyOrderParty.ORDER_UUID, (Object)party.getOrderUuid());
                tbr.where().addEq(PolPolicyOrderParty.PARTY_TYPE, (Object)"TBR");
                PolPolicyOrderParty tbryuan = (PolPolicyOrderParty)this.dao.findOne((AbsModel)tbr);
                party.setDeliveryMode(tbryuan.getDeliveryMode());
                party.setFamilyIncome(tbryuan.getFamilyIncome());
                party.setPartyType("TBR");
                party.setPartyUuid(tbryuan.getPartyUuid());
                party.setRelation(null);
                party.setDisplayOrder(1);
                msg = this.saveOrUpdateParty(party);
            }
        } else if (partyType.equals("TBR")) {
            PolPolicyPartyRelation bbrelation = new PolPolicyPartyRelation();
            bbrelation.where().addEq(PolPolicyPartyRelation.MASTER_RELATION, (Object)party.getPartyUuid()).addEq(PolPolicyPartyRelation.MASTER_PARTY_TYPE, (Object)"TBR").addEq(PolPolicyPartyRelation.AFFILIATED_PARTY_TYPE, (Object)"BBR").addEq(PolPolicyPartyRelation.AFFILIATED_TYPE, (Object)"5");
            PolPolicyPartyRelation bbryuan = (PolPolicyPartyRelation)this.dao.findOne((AbsModel)bbrelation);
            if (bbryuan != null) {
                PolPolicyPartyRelation bb = new PolPolicyPartyRelation();
                bb.setMasterRelation(party.getPartyUuid());
                bb.setAffiliatedPartyType("BBR");
                bb.setMasterPartyType("TBR");
                bb.setAffiliatedType("5");
                party.setRelation(bb);
                party.setDeliveryMode(null);
                party.setFamilyIncome(null);
                party.setPartyType("BBR");
                party.setPartyUuid(bbryuan.getAffiliatedRelation());
                PolPolicyOrderParty bbrPartyDb = (PolPolicyOrderParty)PolPolicyOrderParty.n().where().addEq(PolPolicyOrderParty.PARTY_UUID, (Object)bbryuan.getAffiliatedRelation()).model();
                bbrPartyDb = (PolPolicyOrderParty)this.dao.findOne((AbsModel)bbrPartyDb);
                party.setDisplayOrder(bbrPartyDb.getDisplayOrder());
                msg = this.saveOrUpdateParty(party);
            }
        }
        return msg;
    }

    @Override
    public ReturnMsg saveOrUpdateRisk(List<PolicyRiskVo> riskList, PolPolicyOrder policyOrder) {
        Return aReturn = new Return();
        if (CollectionUtils.isEmpty(riskList)) {
            return aReturn.msg();
        }
        PolPolicyRisk riskDel = PolPolicyRisk.n();
        String orderuuid = policyOrder.getOrderUuid();
        PolPolicyOrder policyOrderUpdate = new PolPolicyOrder();
        if (!StrUtils.isNull((Object)policyOrder.getOrderUuid())) {
            policyOrderUpdate.setBespokedate(policyOrder.getBespokedate());
            policyOrderUpdate.setBespoketype(policyOrder.getBespoketype());
            policyOrderUpdate.setIsMultiMainRisk(policyOrder.getIsMultiMainRisk());
            policyOrderUpdate.where().addEq(PolPolicyOrder.ORDER_UUID, (Object)orderuuid);
            this.dao.update((AbsModel)policyOrderUpdate);
        }
        riskDel.where().addEq(PolPolicyRisk.ORDER_UUID, (Object)riskList.get(0).getOrderUuid()).addIsNull(PolPolicyRisk.PARTY_UUID);
        this.dao.delete((AbsModel)riskDel);
        List wnRisk = riskList.stream().filter(item -> "WN".equals(item.getDutyType()) && !StrUtils.isNull((Object)item.getDisplayOrder())).collect(Collectors.toList());
        if (wnRisk.size() > 0) {
            int maxDisplayOrder = wnRisk.stream().mapToInt(item -> item.getDisplayOrder()).max().orElse(0);
            riskList.stream().filter(item -> "WN".equals(item.getDutyType())).forEach(item -> item.setDisplayOrder(maxDisplayOrder));
        }
        Map<String, List<PolicyRiskVo>> partyRisksMap = riskList.stream().collect(Collectors.groupingBy(PolPolicyRisk::getPartyUuid));
        for (Map.Entry<String, List<PolicyRiskVo>> entry : partyRisksMap.entrySet()) {
            String key = entry.getKey();
            List<PolicyRiskVo> value = entry.getValue();
            riskDel.where().addEq(PolPolicyRisk.ORDER_UUID, (Object)value.get(0).getOrderUuid()).addEq(PolPolicyRisk.PARTY_UUID, (Object)key);
            this.dao.delete((AbsModel)riskDel);
            ArrayList<PolPolicyRisk> riskListSave = new ArrayList<PolPolicyRisk>();
            List pRiskList = value.stream().filter(p -> "P".equals(p.getRiskType())).collect(Collectors.toList());
            for (PolicyRiskVo pRisk : pRiskList) {
                PolPolicyRisk riskSave = new PolPolicyRisk();
                BeanUtils.copyProperties((Object)((Object)pRisk), (Object)riskSave);
                riskSave.setSerno(UUID.shortUUID());
                riskSave.setRiskUuid(UUID.shortUUID());
                riskSave.setParentSerno(riskSave.getSerno());
                riskListSave.add(riskSave);
                this.recursionSaveRisk(value, riskListSave, pRisk.getNodeSeq(), riskSave.getSerno());
            }
            this.dao.save(riskListSave);
        }
        return aReturn.msg();
    }

    @Override
    public ReturnMsg saveOrUpdatePay(PolPolicyPay pay) {
        this.checkService.checkAuth(pay.getOrderUuid());
        Return aReturn = new Return();
        pay.where().addEq(PolPolicyPay.POLICY_UUID, (Object)pay.getPolicyUuid());
        this.dao.delete((AbsModel)pay);
        pay.setAcctUuid(UUID.uuid());
        pay.setPayAcct(pay.getPayAcct().replace(" ", ""));
        pay.setPayType(SmsEnum.PayType.FST.getType());
        this.dao.save((AbsModel)pay);
        return aReturn.msg();
    }

    @Override
    public ReturnMsg savePolicyInfo(Map<String, Object> param, String userCode, String token, String deployedEnv) {
        Return aReturn = new Return();
        String orderUuid = StrUtils.trimStr((Object)param.get("order_uuid"));
        String isSendPolicy = StrUtils.trimStr((Object)param.get("is_send_policy"));
        ETongSavePolicyInfoReqVo reqVo = this.transToETong(param);
        reqVo.setIs_share_account(StrUtils.trimStr((Object)param.get("is_share_account")));
        String bodyJson = "";
        if (!StrUtils.isNull((Object)param.get("is_share_account")) && param.get("is_share_account").equals("Y")) {
            HashMap<String, Object> polAccountMap = new HashMap<String, Object>();
            polAccountMap.put("send_sms_phone", StrUtils.trimStr((Object)param.get("send_sms_phone")));
            polAccountMap.put("link_id", StrUtils.trimStr((Object)param.get("link_id")));
            reqVo.setPolAccountStatusInfo(polAccountMap);
            bodyJson = JsonUtils.toJson((Object)reqVo);
        } else {
            reqVo.setIs_share_account("N");
            bodyJson = JsonUtils.toJson((Object)reqVo);
            JSONObject jsonObject = JSONObject.parseObject((String)bodyJson);
            jsonObject.remove((Object)"pol_account_status_info");
            bodyJson = jsonObject.toString();
        }
        String url = this.savePolicyInfoUrl + "?apikey=" + this.apiPlatformApikey;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("usercode", userCode);
        headers.put("x-auth-token", token);
        SysTradeLog sysTradeLog = new SysTradeLog();
        String transno = UUID.shortUUID();
        sysTradeLog.setInterfaceNo(SmsEnum.abutmentInterface.abutmentEBCBD.getType());
        sysTradeLog.setSystemNo(SmsEnum.callSystem.SystemeTong.getType());
        sysTradeLog.setParamData(bodyJson);
        sysTradeLog.setTransNo(transno);
        sysTradeLog.setParamType(SmsEnum.paramType.paramTypeReq.getType());
        sysTradeLog.setOrderUuid(orderUuid);
        this.systemEAbutmentUtil.insertSysTradeLog(sysTradeLog);
        headers.put("order_uuid", orderUuid);
        String respJson = this.eTongReqService.jsonPostETong(url, bodyJson, headers);
        sysTradeLog.setParamData(respJson);
        sysTradeLog.setParamType(SmsEnum.paramType.paramTypeRes.getType());
        this.systemEAbutmentUtil.insertSysTradeLog(sysTradeLog);
        Map map = JsonUtils.json2Map((String)respJson);
        if (StrUtils.isNull(map.get("flag"))) {
            aReturn.setFailMsg("e\u901asavePolicyInfo\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25");
            return aReturn.msg();
        }
        Return ret = Return.wrapperReturn((String)respJson);
        if (!"success".equals(StrUtils.trimStr(map.get("flag")))) {
            aReturn.setFailMsg(ret.getMsgList());
            return aReturn.msg();
        }
        PolPolicy policy = PolPolicy.n();
        policy.setPolicyState("2");
        policy.where().addEq(PolPolicy.ORDER_UUID, (Object)orderUuid);
        this.dao.update((AbsModel)policy);
        aReturn.getDataTable().put("policy_state", "2");
        String skipSendPolicyInfoFlag = StrUtils.trimStr((Object)param.get("skip_sendPolicyInfo_flag"));
        if ("Y".equals(skipSendPolicyInfoFlag)) {
            return aReturn.msg();
        }
        PolPolicyOrder policyOrder = (PolPolicyOrder)PolPolicyOrder.n().where().addEq(PolPolicyOrder.ORDER_UUID, (Object)orderUuid).model();
        PolPolicyOrder orderDB = (PolPolicyOrder)this.dao.findOne((AbsModel)policyOrder);
        if ((StrUtils.isNull((Object)isSendPolicy) || !isSendPolicy.equals("N")) && ("sale".equals(orderDB.getPolicyInputType()) || "customer".equals(orderDB.getPolicyInputType()) && "all".equals(orderDB.getImageUpload()))) {
            HashMap<String, String> sendPolicyInfoMap = new HashMap<String, String>();
            sendPolicyInfoMap.put("policy_uuid", orderUuid);
            String sendPolicyInfoJson = JsonUtils.toJson(sendPolicyInfoMap);
            String sendPolicyInfoApiUrl = this.sendPolicyInfoUrl + "?apikey=" + this.apiPlatformApikey;
            SysTradeLog tradeLog = new SysTradeLog();
            String transNo = UUID.shortUUID();
            tradeLog.setInterfaceNo(SmsEnum.abutmentInterface.abutmentEYHB.getType());
            tradeLog.setSystemNo(SmsEnum.callSystem.SystemeTong.getType());
            tradeLog.setParamData(sendPolicyInfoJson);
            tradeLog.setTransNo(transNo);
            tradeLog.setParamType(SmsEnum.paramType.paramTypeReq.getType());
            tradeLog.setOrderUuid(orderUuid);
            this.systemEAbutmentUtil.insertSysTradeLog(tradeLog);
            headers.put("order_uuid", orderUuid);
            String sendPolicyInfoResp = this.eTongReqService.jsonPostETong(sendPolicyInfoApiUrl, sendPolicyInfoJson, headers);
            tradeLog.setParamData(sendPolicyInfoResp);
            tradeLog.setParamType(SmsEnum.paramType.paramTypeRes.getType());
            this.systemEAbutmentUtil.insertSysTradeLog(tradeLog);
            Map sendPolicyInfoRespMap = JsonUtils.json2Map((String)sendPolicyInfoResp);
            if (StrUtils.isNull(sendPolicyInfoRespMap.get("flag"))) {
                aReturn.setFailMsg("e\u901asendPolicyInfo\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25");
                return aReturn.msg();
            }
            Return sendPolicyInfoRet = Return.wrapperReturn((String)sendPolicyInfoResp);
            if (sendPolicyInfoRet.isSuccessflag()) {
                PolPolicy policy2 = PolPolicy.n();
                policy2.setPolicyState("3");
                policy2.setApplyCode((String)sendPolicyInfoRet.getDataTable().get("apply_code"));
                policy2.where().addEq(PolPolicy.ORDER_UUID, (Object)orderUuid);
                this.dao.update((AbsModel)policy2);
                aReturn.setReturnMsg(sendPolicyInfoRet.msg());
                aReturn.setDataTable(sendPolicyInfoRet.getDataTable());
                aReturn.getDataTable().put("policy_state", "3");
            } else {
                aReturn.setFailMsg(sendPolicyInfoRet.getMsgList());
                return aReturn.msg();
            }
        }
        return aReturn.msg();
    }

    @Override
    public ReturnMsg sendPolicyInfo(Map<String, Object> param, String userCode, String token, String deployedEnv) {
        Return aReturn = new Return();
        String orderUuid = StrUtils.trimStr((Object)param.get("order_uuid"));
        this.checkService.checkAuth(orderUuid);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("usercode", userCode);
        headers.put("x-auth-token", token);
        HashMap<String, String> sendPolicyInfoMap = new HashMap<String, String>();
        sendPolicyInfoMap.put("policy_uuid", orderUuid);
        String sendPolicyInfoJson = JsonUtils.toJson(sendPolicyInfoMap);
        String sendPolicyInfoApiUrl = this.sendPolicyInfoUrl + "?apikey=" + this.apiPlatformApikey;
        SysTradeLog tradeLog = new SysTradeLog();
        String transNo = UUID.shortUUID();
        tradeLog.setInterfaceNo(SmsEnum.abutmentInterface.abutmentEYHB.getType());
        tradeLog.setSystemNo(SmsEnum.callSystem.SystemeTong.getType());
        tradeLog.setParamData(sendPolicyInfoJson);
        tradeLog.setTransNo(transNo);
        tradeLog.setParamType(SmsEnum.paramType.paramTypeReq.getType());
        tradeLog.setOrderUuid(orderUuid);
        this.systemEAbutmentUtil.insertSysTradeLog(tradeLog);
        headers.put("order_uuid", orderUuid);
        String sendPolicyInfoResp = this.eTongReqService.jsonPostETong(sendPolicyInfoApiUrl, sendPolicyInfoJson, headers);
        tradeLog.setParamData(sendPolicyInfoResp);
        tradeLog.setParamType(SmsEnum.paramType.paramTypeRes.getType());
        this.systemEAbutmentUtil.insertSysTradeLog(tradeLog);
        Map sendPolicyInfoRespMap = JsonUtils.json2Map((String)sendPolicyInfoResp);
        if (StrUtils.isNull(sendPolicyInfoRespMap.get("flag"))) {
            aReturn.setFailMsg("e\u901asendPolicyInfo\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25");
            return aReturn.msg();
        }
        Return sendPolicyInfoRet = Return.wrapperReturn((String)sendPolicyInfoResp);
        if (!sendPolicyInfoRet.isSuccessflag()) {
            aReturn.setFailMsg(sendPolicyInfoRet.getMsgList());
            return aReturn.msg();
        }
        PolPolicy policy = PolPolicy.n();
        policy.setPolicyState("3");
        policy.setApplyCode((String)sendPolicyInfoRet.getDataTable().get("apply_code"));
        policy.where().addEq(PolPolicy.ORDER_UUID, (Object)orderUuid);
        this.dao.update((AbsModel)policy);
        aReturn.setReturnMsg(sendPolicyInfoRet.msg());
        aReturn.setDataTable(sendPolicyInfoRet.getDataTable());
        aReturn.getDataTable().put("policy_state", "3");
        return aReturn.msg();
    }

    @Override
    public ReturnMsg updatePartyInfo(PolPolicyOrderParty party) {
        String order_uuid = ((PolPolicyOrderParty)this.dao.findOne(PolPolicyOrderParty.n().where().addEq(PolPolicyOrderParty.PARTY_UUID, (Object)party.getPartyUuid()).model())).getOrderUuid();
        this.checkService.checkAuth(order_uuid);
        Return aReturn = new Return();
        party.where().addEq(PolPolicyOrderParty.PARTY_UUID, (Object)party.getPartyUuid());
        this.dao.update((AbsModel)party);
        return aReturn.msg();
    }

    @Override
    public ReturnMsg updateOrderInfo(PolPolicyOrder order) {
        this.checkService.checkAuth(order.getOrderUuid());
        Return aReturn = new Return();
        order.where().addEq(PolPolicyOrder.ORDER_UUID, (Object)order.getOrderUuid());
        this.dao.update((AbsModel)order);
        return aReturn.msg();
    }

    @Override
    public ReturnMsg bindQuestion(QuestionVo party) {
        this.checkService.checkAuth(party.getOrderUuid());
        Return msg = new Return();
        if (StrUtils.isNull((Object)party.getOrderUuid())) {
            msg.setFailMsg("order_uuid\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)party.getWjId())) {
            msg.setFailMsg("\u95ee\u5377id\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)party.getWjType())) {
            msg.setFailMsg("\u95ee\u5377\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        PolPolicyOrder polPolicyOrder = new PolPolicyOrder();
        if (party.getWjType().equals("2")) {
            polPolicyOrder.setBabyUuid(party.getWjId());
        }
        if (party.getWjType().equals("3")) {
            polPolicyOrder.setWjId(party.getWjId());
        }
        polPolicyOrder.where().addEq(PolPolicyOrder.ORDER_UUID, (Object)party.getOrderUuid());
        this.dao.update((AbsModel)polPolicyOrder);
        msg.setSuccessMsg("\u4fdd\u5b58\u6210\u529f");
        return msg.msg();
    }

    public void recursionSaveRisk(List<PolicyRiskVo> riskList, List<PolPolicyRisk> riskListSave, String parentNodeSeq, String parentSerno) {
        List filterRiskVoList = riskList.stream().filter(p -> parentNodeSeq.equals(p.getParentNodeSeq()) && !p.getParentNodeSeq().equals(p.getNodeSeq())).collect(Collectors.toList());
        if (null == filterRiskVoList || filterRiskVoList.isEmpty()) {
            return;
        }
        for (PolicyRiskVo risk : filterRiskVoList) {
            PolPolicyRisk riskSave = new PolPolicyRisk();
            BeanUtils.copyProperties((Object)((Object)risk), (Object)riskSave);
            riskSave.setSerno(UUID.shortUUID());
            riskSave.setRiskUuid(UUID.shortUUID());
            riskSave.setParentSerno(parentSerno);
            riskListSave.add(riskSave);
            this.recursionSaveRisk(riskList, riskListSave, risk.getNodeSeq(), riskSave.getSerno());
        }
    }

    public void savePolicyRisk(List<PolPolicyRisk> riskListReq, String orderUuid, String policyUuid) {
        ArrayList<PolPolicyRisk> risks = new ArrayList<PolPolicyRisk>();
        for (PolPolicyRisk riskReq : riskListReq) {
            riskReq.setOrderUuid(orderUuid);
            riskReq.setPolicyUuid(policyUuid);
            riskReq.setRiskUuid(UUID.uuid());
            String serno = UUID.uuid();
            riskReq.setSerno(serno);
            riskReq.setParentSerno(serno);
            risks.add(riskReq);
        }
        this.dao.save(risks);
    }

    public ETongSavePolicyInfoReqVo transToETong(Map<String, Object> param) {
        ETongSavePolicyInfoReqVo eTongSavePolicyInfoReqVo = new ETongSavePolicyInfoReqVo();
        String orderUuid = StrUtils.trimStr((Object)param.get("order_uuid"));
        ETongTpolPolicyPartyVo tPolPolicyParty = this.packageTpolPolicyParty(orderUuid);
        eTongSavePolicyInfoReqVo.setTpolPolicyParty(tPolPolicyParty);
        if (!StrUtils.isNull((Object)tPolPolicyParty.getMentallyDisabledName())) {
            tPolPolicyParty.getBpolPolicyPartyList().forEach(b -> {
                if (b.getFullName().equals(tPolPolicyParty.getMentallyDisabledName())) {
                    b.setIsMentallyDisabledParty("Y");
                } else {
                    b.setIsMentallyDisabledParty("");
                }
                if (!CollectionUtils.isEmpty(b.getSpolPolicyParty())) {
                    b.getSpolPolicyParty().forEach(s -> {
                        if (s.getFullName().equals(tPolPolicyParty.getMentallyDisabledName())) {
                            s.setIsMentallyDisabledParty("Y");
                        } else {
                            s.setIsMentallyDisabledParty("");
                        }
                    });
                }
            });
        }
        PolPolicyPay paySr = new PolPolicyPay();
        paySr.where().addEq(PolPolicyPay.ORDER_UUID, (Object)orderUuid);
        PolPolicyPay payDB = (PolPolicyPay)this.dao.findOne((AbsModel)paySr);
        ETongPolPolicyPayVo polPolicyPay = new ETongPolPolicyPayVo();
        if (payDB != null) {
            BeanUtils.copyProperties((Object)payDB, (Object)polPolicyPay);
            polPolicyPay.setRpayAcct(payDB.getPayAcct());
        }
        eTongSavePolicyInfoReqVo.setPolPolicyPay(polPolicyPay);
        eTongSavePolicyInfoReqVo.setPolicyUuid(orderUuid);
        PolPolicyOrder order = new PolPolicyOrder();
        order.setOrderUuid(orderUuid);
        order.where().addEq(PolPolicyOrder.ORDER_UUID, (Object)orderUuid);
        PolPolicyOrder orderDB = (PolPolicyOrder)this.dao.findOne((AbsModel)order);
        eTongSavePolicyInfoReqVo.setChongqingUuid(orderDB.getWjId());
        ETongPolPolicyVo policyVo = this.packagePolPolicy(orderUuid);
        policyVo.setDeliveryMode(tPolPolicyParty.getDeliveryMode());
        policyVo.setIsUniversalInsurance(StrUtils.trimStr((Object)param.get("is_universal_insurance")));
        eTongSavePolicyInfoReqVo.setPolPolicy(policyVo);
        eTongSavePolicyInfoReqVo.setNotifyUuid("");
        eTongSavePolicyInfoReqVo.setBabyUuid(orderDB.getBabyUuid());
        return eTongSavePolicyInfoReqVo;
    }

    public ETongTpolPolicyPartyVo packageTpolPolicyParty(String orderUuid) {
        PolPolicyOrderParty partySr = new PolPolicyOrderParty();
        partySr.where().addEq(PolPolicyOrderParty.ORDER_UUID, (Object)orderUuid).addEq(PolPolicyOrderParty.PARTY_TYPE, (Object)SmsEnum.PartyType.TBR.getType());
        PolPolicyOrderParty polOrderPartyDB = (PolPolicyOrderParty)this.dao.findOne((AbsModel)partySr);
        ETongTpolPolicyPartyVo tpolPolicyParty = new ETongTpolPolicyPartyVo();
        this.packagePartyBasic(tpolPolicyParty, polOrderPartyDB);
        tpolPolicyParty.setE_cls(tpolPolicyParty.getEcls());
        tpolPolicyParty.setM_cls(tpolPolicyParty.getMcls());
        tpolPolicyParty.setH_cls(tpolPolicyParty.getHcls());
        tpolPolicyParty.setL_cls(tpolPolicyParty.getLcls());
        ArrayList<ETongBpolPolicyPartyVo> bpolPolicyPartyList = new ArrayList<ETongBpolPolicyPartyVo>();
        PolPolicyOrderParty bPolPartySr = new PolPolicyOrderParty();
        bPolPartySr.where().addEq(PolPolicyOrderParty.ORDER_UUID, (Object)orderUuid).addEq(PolPolicyOrderParty.PARTY_TYPE, (Object)SmsEnum.PartyType.BBR.getType());
        bPolPartySr.setOrderBy(new Sort.Order[]{PolPolicyOrderParty.DISPLAY_ORDER.asc()});
        List polPolicyPartyListDB = this.dao.findAll((AbsModel)bPolPartySr);
        Collections.sort(polPolicyPartyListDB, new Comparator<PolPolicyOrderParty>(){

            @Override
            public int compare(PolPolicyOrderParty o1, PolPolicyOrderParty o2) {
                if ("Y".equals(o1.getIsSpouse()) && !"Y".equals(o2.getIsSpouse())) {
                    return 1;
                }
                if ("Y".equals(o2.getIsSpouse()) && !"Y".equals(o1.getIsSpouse())) {
                    return -1;
                }
                return 0;
            }
        });
        int displayOrder = 0;
        for (PolPolicyOrderParty polPolciyPartyDB : polPolicyPartyListDB) {
            ETongBpolPolicyPartyVo bpolPolicyPartyVo = new ETongBpolPolicyPartyVo();
            this.packagePartyBasic(bpolPolicyPartyVo, polPolciyPartyDB);
            bpolPolicyPartyVo.setBbrOrder(StrUtils.trimStr((Object)(++displayOrder)));
            PolPolicyOrder order = (PolPolicyOrder)PolPolicyOrder.n().where().addEq(PolPolicyOrder.ORDER_UUID, (Object)orderUuid).model();
            PolPolicyOrder orderDB = (PolPolicyOrder)this.dao.findOne((AbsModel)order);
            bpolPolicyPartyVo.setRegion(this.getRegion(orderDB.getBranchId()));
            PolPolicyPartyRelation relation = PolPolicyPartyRelation.n();
            relation.where().addEq(PolPolicyPartyRelation.MASTER_PARTY_TYPE, (Object)SmsEnum.PartyType.TBR.getType()).addEq(PolPolicyPartyRelation.AFFILIATED_PARTY_TYPE, (Object)SmsEnum.PartyType.BBR.getType()).addEq(PolPolicyPartyRelation.MASTER_RELATION, (Object)tpolPolicyParty.getPartyUuid()).addEq(PolPolicyPartyRelation.AFFILIATED_RELATION, (Object)bpolPolicyPartyVo.getPartyUuid());
            PolPolicyPartyRelation relationDB = (PolPolicyPartyRelation)this.dao.findOne((AbsModel)relation);
            bpolPolicyPartyVo.setAffiliatedType(relationDB.getAffiliatedType());
            PolPolicyRisk riskSr = new PolPolicyRisk();
            riskSr.where().addEq(PolPolicyRisk.ORDER_UUID, (Object)orderUuid).addEq(PolPolicyRisk.PARTY_UUID, (Object)polPolciyPartyDB.getPartyUuid());
            List risksDB = this.dao.findAll((AbsModel)riskSr);
            ArrayList<ETongPolPolicyRiskVo> riskList = new ArrayList<ETongPolPolicyRiskVo>();
            List<PolPolicyRisk> filterRiskDB = risksDB.stream().filter(p -> !SmsEnum.RiskType.P.getType().equals(p.getRiskType()) && !SmsEnum.RiskType.W.getType().equals(p.getRiskType())).collect(Collectors.toList());
            filterRiskDB.forEach(p -> {
                ETongPolPolicyRiskVo riskVo = new ETongPolPolicyRiskVo();
                BeanUtils.copyProperties((Object)p, (Object)((Object)riskVo));
                riskVo.setCrtUser(null);
                riskVo.setMdfUser(null);
                riskVo.setCrtDate(null);
                riskVo.setMdfDate(null);
                riskVo.setPolicyUuid(riskVo.getOrderUuid());
                riskVo.setRiskNo(riskVo.getRiskCode());
                riskVo.setRiskOrder(riskVo.getDisplayOrder().toString());
                if (SmsEnum.RiskType.M.getType().equals(riskVo.getRiskType())) {
                    riskVo.setParentSerno(riskVo.getSerno());
                    riskVo.setProductNo(riskVo.getRiskCode());
                    riskVo.setIsMainRisk("1");
                } else if (SmsEnum.RiskType.A.getType().equals(riskVo.getRiskType())) {
                    riskVo.setIsMainRisk("2");
                    PolPolicyRisk parentRisk = risksDB.stream().filter(q -> q.getSerno().equals(riskVo.getParentSerno())).findFirst().get();
                    riskVo.setProductNo(parentRisk.getRiskCode());
                }
                PolPolicyRisk risk = PolPolicyRisk.n();
                risk.where().addEq(PolPolicyRisk.PARENT_SERNO, (Object)riskVo.getSerno()).addEq(PolPolicyRisk.RISK_TYPE, (Object)SmsEnum.RiskType.W.getType());
                List waiverRisk = this.dao.findAll((AbsModel)risk);
                if (!CollectionUtils.isEmpty((Collection)waiverRisk)) {
                    ArrayList<ETongPolPolicyRiskVo> waiverVoList = new ArrayList<ETongPolPolicyRiskVo>();
                    waiverRisk.forEach(q -> {
                        ETongPolPolicyRiskVo waiverVo = new ETongPolPolicyRiskVo();
                        BeanUtils.copyProperties((Object)q, (Object)((Object)waiverVo));
                        waiverVo.setCrtUser(null);
                        waiverVo.setMdfUser(null);
                        waiverVo.setCrtDate(null);
                        waiverVo.setMdfDate(null);
                        waiverVo.setPolicyUuid(waiverVo.getOrderUuid());
                        waiverVo.setPartyUuid(waiverVo.getWaiverPartyUuid());
                        waiverVo.setIsMainRisk("3");
                        PolPolicyRisk parentRisk = risksDB.stream().filter(r -> r.getSerno().equals(waiverVo.getParentSerno())).findFirst().get();
                        waiverVo.setProductNo(parentRisk.getRiskCode());
                        waiverVoList.add(waiverVo);
                    });
                    riskVo.setPolWaiverRisk(waiverVoList);
                }
                riskList.add(riskVo);
            });
            bpolPolicyPartyVo.setPolPolicyRisk(riskList);
            ArrayList<ETongSpolPolicyPartyVo> spolPolicyParty = new ArrayList<ETongSpolPolicyPartyVo>();
            List spolPartyRelationsDB = this.dao.findAll(PolPolicyPartyRelation.n().where().addEq(PolPolicyPartyRelation.MASTER_RELATION, (Object)polPolciyPartyDB.getPartyUuid()).addEq(PolPolicyPartyRelation.MASTER_PARTY_TYPE, (Object)SmsEnum.PartyType.BBR.getType()).addEq(PolPolicyPartyRelation.AFFILIATED_PARTY_TYPE, (Object)SmsEnum.PartyType.SYR.getType()).model());
            if (!CollectionUtils.isEmpty((Collection)spolPartyRelationsDB)) {
                for (PolPolicyPartyRelation spolPartyRelationDB : spolPartyRelationsDB) {
                    PolPolicyOrderParty spolPartyDB = (PolPolicyOrderParty)this.dao.findOne(PolPolicyOrderParty.n().where().addEq(PolPolicyOrderParty.PARTY_UUID, (Object)spolPartyRelationDB.getAffiliatedRelation()).model());
                    ETongSpolPolicyPartyVo spolPolicyPartyVo = new ETongSpolPolicyPartyVo();
                    this.packagePartyBasic(spolPolicyPartyVo, spolPartyDB);
                    spolPolicyPartyVo.setAffiliatedInsured(spolPartyRelationDB.getAffiliatedApplicant());
                    spolPolicyPartyVo.setMasterRelation(spolPartyRelationDB.getMasterRelation());
                    spolPolicyPartyVo.setAffiliatedType(spolPartyRelationDB.getAffiliatedType());
                    spolPolicyPartyVo.setAffiliatedRelation(spolPartyRelationDB.getAffiliatedRelation());
                    spolPolicyPartyVo.setBenefitRatio(spolPartyRelationDB.getBenefitRatio());
                    spolPolicyPartyVo.setBenefitOrder(spolPartyRelationDB.getBenefitOrder().toString());
                    spolPolicyPartyVo.setBbrOrder(polPolciyPartyDB.getDisplayOrder().toString());
                    spolPolicyPartyVo.setRelationType(SmsEnum.RelationType.BBR_SYR.getType());
                    spolPolicyPartyVo.setIsHolder("M".equals(spolPartyRelationDB.getAffiliatedApplicant()) ? "Y" : "N");
                    spolPolicyParty.add(spolPolicyPartyVo);
                }
            }
            spolPolicyParty.forEach(o -> {
                o.setE_cls(o.getEcls());
                o.setM_cls(o.getMcls());
                o.setH_cls(o.getHcls());
                o.setL_cls(o.getLcls());
            });
            bpolPolicyPartyVo.setSpolPolicyParty(spolPolicyParty);
            bpolPolicyPartyList.add(bpolPolicyPartyVo);
        }
        bpolPolicyPartyList.forEach(o -> {
            o.setE_cls(o.getEcls());
            o.setM_cls(o.getMcls());
            o.setH_cls(o.getHcls());
            o.setL_cls(o.getLcls());
        });
        tpolPolicyParty.setBpolPolicyPartyList(bpolPolicyPartyList);
        return tpolPolicyParty;
    }

    public void packagePartyBasic(ETongPolPolicyPartyVo polPolicyParty, PolPolicyOrderParty polOrderPartyDB) {
        BeanUtils.copyProperties((Object)polOrderPartyDB, (Object)((Object)polPolicyParty));
        polPolicyParty.setSerno(null);
        polPolicyParty.setCrtUser(null);
        polPolicyParty.setMdfUser(null);
        polPolicyParty.setCrtDate(null);
        polPolicyParty.setMdfDate(null);
        polPolicyParty.setOrderUuid(null);
        polPolicyParty.setUnifySocialNo(polOrderPartyDB.getSocialCreditId());
        polPolicyParty.setName(polOrderPartyDB.getFullName());
        polPolicyParty.setAvgIncome(polOrderPartyDB.getPersonalIncome());
        polPolicyParty.setPolicyUuid(polOrderPartyDB.getOrderUuid());
        polPolicyParty.setIsChinaTax(polOrderPartyDB.getTaxChina());
        polPolicyParty.setCustomerNo(polOrderPartyDB.getCustomerUuid());
        polPolicyParty.setAnswerPerson(polOrderPartyDB.getPartyUuid());
        ArrayList<ETongPolPolicyPartyVo.Id> idList = new ArrayList<ETongPolPolicyPartyVo.Id>();
        ETongPolPolicyPartyVo.Id id1 = new ETongPolPolicyPartyVo.Id();
        id1.setIdType(polOrderPartyDB.getIdType());
        id1.setIdStartDate(polOrderPartyDB.getIdStartDate());
        id1.setIdOrder("1");
        id1.setIdNo(polOrderPartyDB.getIdNo());
        id1.setIdEndDate(polOrderPartyDB.getIdEndDate());
        idList.add(id1);
        if (!StrUtils.isNull((Object)polOrderPartyDB.getIdNo2())) {
            ETongPolPolicyPartyVo.Id id2 = new ETongPolPolicyPartyVo.Id();
            id2.setIdType(polOrderPartyDB.getIdType2());
            id2.setIdStartDate(polOrderPartyDB.getIdStartDate2());
            id2.setIdOrder("2");
            id2.setIdNo(polOrderPartyDB.getIdNo2());
            id2.setIdEndDate(polOrderPartyDB.getIdEndDate2());
            idList.add(id2);
        }
        if (!StrUtils.isNull((Object)polOrderPartyDB.getIdNo3())) {
            ETongPolPolicyPartyVo.Id id3 = new ETongPolPolicyPartyVo.Id();
            id3.setIdType(polOrderPartyDB.getIdType3());
            id3.setIdStartDate(polOrderPartyDB.getIdStartDate3());
            id3.setIdOrder("3");
            id3.setIdNo(polOrderPartyDB.getIdNo3());
            id3.setIdEndDate(polOrderPartyDB.getIdEndDate3());
            idList.add(id3);
        }
        polPolicyParty.setId(idList);
        PolPolicyPartyAddress addressSr = new PolPolicyPartyAddress();
        addressSr.where().addEq(PolPolicyPartyAddress.PARTY_UUID, (Object)polOrderPartyDB.getPartyUuid());
        List addressDB = this.dao.findAll((AbsModel)addressSr);
        ArrayList<ETongAddressVo> addressVoList = new ArrayList<ETongAddressVo>();
        for (PolPolicyPartyAddress address : addressDB) {
            ETongAddressVo addressVo = new ETongAddressVo();
            BeanUtils.copyProperties((Object)address, (Object)addressVo);
            addressVo.setDetailedAddressCode(address.getAddressCode());
            addressVoList.add(addressVo);
        }
        polPolicyParty.setAddress(addressVoList);
        PolPolicyPartyContact contactSr = new PolPolicyPartyContact();
        contactSr.where().addEq(PolPolicyPartyContact.PARTY_UUID, (Object)polOrderPartyDB.getPartyUuid());
        List contactDB = this.dao.findAll((AbsModel)contactSr);
        ArrayList<ETongContactVo> contractList = new ArrayList<ETongContactVo>();
        for (PolPolicyPartyContact contact : contactDB) {
            ETongContactVo contactVo = new ETongContactVo();
            BeanUtils.copyProperties((Object)contact, (Object)contactVo);
            contactVo.setContractLabel(contact.getContactLabel());
            contactVo.setContractType(contact.getContactType());
            contactVo.setContractValue(contact.getContactValue());
            contractList.add(contactVo);
        }
        polPolicyParty.setContract(contractList);
        PolPolicyPartyImage imageSr = new PolPolicyPartyImage();
        imageSr.where().addEq(PolPolicyPartyImage.PARTY_UUID, (Object)polOrderPartyDB.getPartyUuid());
        List polPolicyImageDB = this.dao.findAll((AbsModel)imageSr);
        ArrayList<ETongImageVo> eTongImageVos = new ArrayList<ETongImageVo>();
        for (PolPolicyPartyImage polPolicyPartyImage : polPolicyImageDB) {
            ETongImageVo imageVo = new ETongImageVo();
            BeanUtils.copyProperties((Object)polPolicyPartyImage, (Object)imageVo);
            eTongImageVos.add(imageVo);
        }
        polPolicyParty.setPolPolicyImage(eTongImageVos);
        PolCrsResult crsResultSr = new PolCrsResult();
        crsResultSr.where().addEq(PolCrsResult.PARTY_UUID, (Object)polOrderPartyDB.getPartyUuid());
        PolCrsResult crsResultDB = (PolCrsResult)this.dao.findOne((AbsModel)crsResultSr);
        ArrayList<ETongPolPolicyTaxVo> polPolicyTax = new ArrayList<ETongPolPolicyTaxVo>();
        if (crsResultDB != null) {
            ETongPolPolicyTaxVo taxVo;
            if (crsResultDB.getTaxResidentCountry1() != null || crsResultDB.getTaxpayerIdentificationCode1() != null) {
                taxVo = new ETongPolPolicyTaxVo();
                taxVo.setCountryCode(crsResultDB.getTaxResidentCountry1());
                taxVo.setId("1");
                taxVo.setPartyUuid(polOrderPartyDB.getPartyUuid());
                taxVo.setTaxpayerNum(crsResultDB.getTaxpayerIdentificationCode1());
                polPolicyTax.add(taxVo);
            }
            if (crsResultDB.getTaxResidentCountry2() != null || crsResultDB.getTaxpayerIdentificationCode2() != null) {
                taxVo = new ETongPolPolicyTaxVo();
                taxVo.setCountryCode(crsResultDB.getTaxResidentCountry2());
                taxVo.setId("2");
                taxVo.setPartyUuid(polOrderPartyDB.getPartyUuid());
                taxVo.setTaxpayerNum(crsResultDB.getTaxpayerIdentificationCode2());
                polPolicyTax.add(taxVo);
            }
            if (crsResultDB.getTaxResidentCountry3() != null || crsResultDB.getTaxpayerIdentificationCode3() != null) {
                taxVo = new ETongPolPolicyTaxVo();
                taxVo.setCountryCode(crsResultDB.getTaxResidentCountry3());
                taxVo.setId("3");
                taxVo.setPartyUuid(polOrderPartyDB.getPartyUuid());
                taxVo.setTaxpayerNum(crsResultDB.getTaxpayerIdentificationCode3());
                polPolicyTax.add(taxVo);
            }
            polPolicyParty.setTaxpayerName(crsResultDB.getFirstName() + "&" + crsResultDB.getFamilyName());
            polPolicyParty.setTaxBirthdate(polOrderPartyDB.getBirthdate());
            polPolicyParty.setNoRegisterationReson(crsResultDB.getReason());
            polPolicyParty.setNoRegisterationResonInfo(crsResultDB.getReasondescribe());
        }
        polPolicyParty.setPolPolicyTax(polPolicyTax);
    }

    public ETongPolPolicyVo packagePolPolicy(String orderUuid) {
        PolPolicyOrder order = new PolPolicyOrder();
        order.setOrderUuid(orderUuid);
        order.where().addEq(PolPolicyOrder.ORDER_UUID, (Object)orderUuid);
        PolPolicyOrder orderDB = (PolPolicyOrder)this.dao.findOne((AbsModel)order);
        ETongPolPolicyVo policyVo = new ETongPolPolicyVo();
        BeanUtils.copyProperties((Object)orderDB, (Object)policyVo);
        policyVo.setKpiRatio(100);
        policyVo.setPremiumDivide("N");
        policyVo.setPolicyCreateTime(orderDB.getCrtDate());
        policyVo.setPolicyInputType(orderDB.getPolicyInputType());
        policyVo.setAgentCode(orderDB.getAgentId());
        policyVo.setIsMultiMainRisk(orderDB.getIsMultiMainRisk());
        if (!StrUtils.isNull((Object)orderDB.getCaseUuid())) {
            policyVo.setNotifyType("");
        } else {
            policyVo.setNotifyType("informConfig");
        }
        ETongPolPolicyCorporateProjectVo projectVo = this.packageCorporateProject(orderUuid);
        if (projectVo != null) {
            policyVo.setPolPolicyCorporateProject(projectVo);
        }
        policyVo.setPolPolicyAssist(new ArrayList());
        policyVo.setDataSource("PSCP");
        PolPolicyRisk risk = (PolPolicyRisk)PolPolicyRisk.n().where().addEq(PolPolicyRisk.ORDER_UUID, (Object)orderUuid).addEq(PolPolicyRisk.RISK_TYPE, (Object)"M").model();
        List riskList = this.dao.findAll((AbsModel)risk);
        String insureType = this.getInsureType(riskList);
        policyVo.setInsureType(insureType);
        List spouseRisk = riskList.stream().filter(p -> "Y".equals(p.getIsProposerSpouse())).collect(Collectors.toList());
        policyVo.setIsProposerSpouse(!CollectionUtils.isEmpty(spouseRisk) ? "Y" : "");
        List rejectRisk = spouseRisk.stream().filter(p -> !StrUtils.isNull((Object)p.getRejectProposerReason())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(rejectRisk) && spouseRisk.size() == rejectRisk.size()) {
            policyVo.setRejectProposerReason(((PolPolicyRisk)rejectRisk.get(0)).getRejectProposerReason());
        }
        return policyVo;
    }

    public String getInsureType(List<PolPolicyRisk> riskList) {
        List insureTypes = (riskList = riskList.stream().filter(p -> "M".equals(p.getRiskType())).collect(Collectors.toList())).stream().map(PolPolicyRisk::getInsureType).collect(Collectors.toList());
        if (insureTypes.size() == 1 && !insureTypes.contains("PZJG")) {
            return (String)insureTypes.get(0);
        }
        if (insureTypes.contains("TX")) {
            return "TX";
        }
        if (insureTypes.contains("FZSJ")) {
            return "FZSJ";
        }
        if (insureTypes.contains("PZJG")) {
            Map<String, List<PolPolicyRisk>> collectPZJG = riskList.stream().filter(p -> "PZJG".equals(p.getInsureType())).collect(Collectors.groupingBy(PolPolicyRisk::getRiskCode));
            for (Map.Entry<String, List<PolPolicyRisk>> entry : collectPZJG.entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                return "PZJG";
            }
        }
        return "CQ";
    }

    public ETongPolPolicyCorporateProjectVo packageCorporateProject(String orderUuid) {
        PolPolicyCorporateProject projectDB = new PolPolicyCorporateProject();
        projectDB.where().addEq(PolPolicyCorporateProject.ORDER_UUID, (Object)orderUuid);
        projectDB = (PolPolicyCorporateProject)this.dao.findOne((AbsModel)projectDB);
        if (null == projectDB) {
            return null;
        }
        ETongPolPolicyCorporateProjectVo projectVo = new ETongPolPolicyCorporateProjectVo();
        BeanUtils.copyProperties((Object)projectDB, (Object)projectVo);
        PolPolicyCorporateConfirmation confirmationSr = new PolPolicyCorporateConfirmation();
        confirmationSr.where().addEq(PolPolicyCorporateConfirmation.ORDER_UUID, (Object)orderUuid);
        List confirmationsDB = this.dao.findAll((AbsModel)confirmationSr);
        ArrayList<ETongPolPolicyCorporateConfirmationVo> confirmationVos = new ArrayList<ETongPolPolicyCorporateConfirmationVo>();
        for (PolPolicyCorporateConfirmation confirmationDB : confirmationsDB) {
            ETongPolPolicyCorporateConfirmationVo confirmationVo = new ETongPolPolicyCorporateConfirmationVo();
            BeanUtils.copyProperties((Object)confirmationDB, (Object)((Object)confirmationVo));
            confirmationVos.add(confirmationVo);
        }
        projectVo.setConfirmations(confirmationVos);
        PolPolicyCorporateResource resourceSr = new PolPolicyCorporateResource();
        resourceSr.where().addEq(PolPolicyCorporateResource.ORDER_UUID, (Object)orderUuid);
        PolPolicyCorporateResource resourceDB = (PolPolicyCorporateResource)this.dao.findOne((AbsModel)resourceSr);
        ETongPolPolicyCorporateResourceVo resourceVo = new ETongPolPolicyCorporateResourceVo();
        BeanUtils.copyProperties((Object)resourceDB, (Object)((Object)resourceVo));
        projectVo.setResource(resourceVo);
        PolPolicyCorporateTeam teamSr = new PolPolicyCorporateTeam();
        teamSr.where().addEq(PolPolicyCorporateTeam.ORDER_UUID, (Object)orderUuid);
        PolPolicyCorporateTeam teamDB = (PolPolicyCorporateTeam)this.dao.findOne((AbsModel)teamSr);
        ETongPolPolicyCorporateTeamVo teamVo = new ETongPolPolicyCorporateTeamVo();
        BeanUtils.copyProperties((Object)teamDB, (Object)((Object)teamVo));
        projectVo.setTeam(teamVo);
        PolPolicyCorporateUser userSr = new PolPolicyCorporateUser();
        userSr.where().addEq(PolPolicyCorporateUser.ORDER_UUID, (Object)orderUuid);
        List usersDB = this.dao.findAll((AbsModel)userSr);
        ArrayList<ETongPolPolicyCorporateUserVo> usersVo = new ArrayList<ETongPolPolicyCorporateUserVo>();
        for (PolPolicyCorporateUser userDB : usersDB) {
            ETongPolPolicyCorporateUserVo userVo = new ETongPolPolicyCorporateUserVo();
            BeanUtils.copyProperties((Object)userDB, (Object)((Object)userVo));
            usersVo.add(userVo);
        }
        projectVo.setUsers(usersVo);
        PolPolicyCorporateCustomer customerSr = new PolPolicyCorporateCustomer();
        customerSr.where().addEq(PolPolicyCorporateCustomer.ORDER_UUID, (Object)orderUuid);
        PolPolicyCorporateCustomer customerDB = (PolPolicyCorporateCustomer)this.dao.findOne((AbsModel)customerSr);
        ETongPolPolicyCorporateCustomerVo customerVo = new ETongPolPolicyCorporateCustomerVo();
        BeanUtils.copyProperties((Object)customerDB, (Object)((Object)customerVo));
        projectVo.setCustomer(customerVo);
        PolPolicyCorporateCompany companySr = new PolPolicyCorporateCompany();
        companySr.where().addEq(PolPolicyCorporateCompany.ORDER_UUID, (Object)orderUuid);
        PolPolicyCorporateCompany companyDB = (PolPolicyCorporateCompany)this.dao.findOne((AbsModel)companySr);
        ETongPolPolicyCorporateCompanyVo companyVo = new ETongPolPolicyCorporateCompanyVo();
        if (companyDB != null) {
            BeanUtils.copyProperties((Object)companyDB, (Object)((Object)companyVo));
        }
        projectVo.setCompany(companyVo);
        PolPolicyCorporateVxgroup vxgroup = new PolPolicyCorporateVxgroup();
        vxgroup.where().addEq(PolPolicyCorporateVxgroup.ORDER_UUID, (Object)orderUuid);
        PolPolicyCorporateVxgroup vxgroupDB = (PolPolicyCorporateVxgroup)this.dao.findOne((AbsModel)vxgroup);
        ETongPolPolicyCorporateVxgroupVo corporateVxgroupVo = new ETongPolPolicyCorporateVxgroupVo();
        if (vxgroupDB != null) {
            BeanUtils.copyProperties((Object)vxgroupDB, (Object)((Object)corporateVxgroupVo));
        }
        projectVo.setVxGroupInfo(corporateVxgroupVo);
        return projectVo;
    }

    public String getRegion(String organid) {
        String provinceCode = organid.substring(0, 2);
        String cityName = "";
        String specilRegion = "";
        switch (provinceCode) {
            case "11": {
                cityName = "\u5317\u4eac\u5e02";
                specilRegion = "110100";
                break;
            }
            case "12": {
                cityName = "\u5929\u6d25\u5e02";
                specilRegion = "120100";
                break;
            }
            case "31": {
                cityName = "\u4e0a\u6d77\u5e02";
                specilRegion = "310100";
                break;
            }
            case "50": {
                cityName = "\u91cd\u5e86\u5e02";
                specilRegion = "500100";
                break;
            }
            case "90": {
                provinceCode = "37";
                cityName = "\u9752\u5c9b\u5e02";
                specilRegion = "370200";
                break;
            }
            case "91": {
                provinceCode = "21";
                cityName = "\u5927\u8fde\u5e02";
                specilRegion = "210200";
                break;
            }
            case "92": {
                provinceCode = "33";
                cityName = "\u5b81\u6ce2\u5e02";
                specilRegion = "330200";
                break;
            }
            case "93": {
                provinceCode = "35";
                cityName = "\u53a6\u95e8\u5e02";
                break;
            }
            case "94": {
                provinceCode = "44";
                cityName = "\u6df1\u5733\u5e02";
                break;
            }
            case "87": {
                provinceCode = "11";
            }
        }
        String defaultRegion = provinceCode + organid.substring(3, 5) + "00";
        Ulog.info((String)defaultRegion);
        String region = !StrUtils.isNull((Object)specilRegion) ? specilRegion : defaultRegion;
        return region;
    }

    @Override
    public ReturnMsg calcProductPremium(DownPolicyParam param) {
        Return msg = new Return();
        String orderUuid = param.getPolicy_uuid();
        PolPolicyOrder orderDB = (PolPolicyOrder)this.dao.findOne(PolPolicyOrder.n().where().addEq(PolPolicyOrder.ORDER_UUID, (Object)orderUuid).model());
        List polPolicyOrderPartys = this.dao.findAll4Map(PolPolicyOrderParty.n().where().addEq(PolPolicyOrderParty.ORDER_UUID, (Object)orderUuid).model());
        Map tbrMap = (Map)polPolicyOrderPartys.stream().filter(a -> "TBR".equals(StrUtils.trimStr(a.get("party_type")))).collect(Collectors.toList()).get(0);
        List bbrList = polPolicyOrderPartys.stream().filter(a -> "BBR".equals(StrUtils.trimStr(a.get("party_type"))) && !"Y".equals(StrUtils.trimStr(a.get("is_spouse")))).collect(Collectors.toList());
        List spouseList = polPolicyOrderPartys.stream().filter(a -> "BBR".equals(StrUtils.trimStr(a.get("party_type"))) && "Y".equals(StrUtils.trimStr(a.get("is_spouse")))).collect(Collectors.toList());
        Map spouseBbr = new HashMap();
        if (!CollectionUtils.isEmpty(spouseList)) {
            spouseBbr = (Map)spouseList.get(0);
        }
        List allOrderRisks = this.dao.findAll4Map(PolPolicyRisk.n().where().addEq(PolPolicyRisk.ORDER_UUID, (Object)orderUuid).addNotEq(PolPolicyRisk.RISK_TYPE, (Object)"P").model());
        LinkedList allBbrMapList = new LinkedList();
        for (Map bbr : bbrList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tbr", tbrMap);
            LinkedList<Map> bbrMapList = new LinkedList<Map>();
            List<Map> polPolicyRisks = allOrderRisks.stream().filter(p -> StrUtils.trimStr(p.get("party_uuid")).equals(StrUtils.trimStr(bbr.get("party_uuid")))).collect(Collectors.toList());
            List notCalcRiskList = polPolicyRisks.stream().filter(p -> StrUtils.isNull(p.get("initial_premium"))).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(notCalcRiskList)) {
                msg.setFailMsg("\u88ab\u4fdd\u4eba\u3010" + (String)bbr.get("full_name") + "\u3011\u8ba1\u7b97\u4fdd\u8d39\u4fe1\u606f\u672a\u5f55\u5165\u5b8c\u6574\uff0c\u8bf7\u60a8\u586b\u5199\u3002");
                return msg.msg();
            }
            HashMap<String, List<Map>> valueMap = new HashMap<String, List<Map>>();
            polPolicyRisks.forEach(p -> {
                List mergeCalcRiskList = allOrderRisks.stream().filter(q -> ("Y".equals(StrUtils.trimStr(q.get("merge_calc_flag"))) || SmsEnum.PolicyFlowType.FAMILY.getType().equals(orderDB.getPolicyFlowType())) && ((String)p.get("risk_code")).equals((String)q.get("risk_code"))).collect(Collectors.toList());
                p.put("insured_num", mergeCalcRiskList.size() == 0 ? "1" : StrUtils.trimStr((Object)mergeCalcRiskList.size()));
            });
            valueMap.put("value", polPolicyRisks);
            bbr.put("lCls", (String)bbr.get("lcls"));
            bbr.put("hCls", (String)bbr.get("hcls"));
            bbr.put("mCls", (String)bbr.get("mcls"));
            bbr.put("eCls", (String)bbr.get("ecls"));
            bbr.put("riskMap", valueMap);
            bbrMapList.add(bbr);
            Map finalSpouseBbr = spouseBbr;
            Set waiverPartyUuids = polPolicyRisks.stream().filter(p -> "W".equals((String)p.get("risk_type")) && ((String)p.get("waiver_party_uuid")).equals(StrUtils.trimStr(finalSpouseBbr.get("party_uuid")))).map(p -> (String)p.get("waiver_party_uuid")).collect(Collectors.toSet());
            for (String waiverPartyUuid : waiverPartyUuids) {
                Map waiverParty = (Map)polPolicyOrderPartys.stream().filter(a -> waiverPartyUuid.equals(StrUtils.trimStr(a.get("party_uuid")))).collect(Collectors.toList()).get(0);
                bbrMapList.add(waiverParty);
            }
            map.put("bbr", bbrMapList);
            allBbrMapList.addAll(bbrMapList);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tbr", tbrMap);
        map.put("bbr", allBbrMapList);
        map.put("premium_flag", "2");
        ReturnMsg returnMsg = this.callCalcAndCompare(map);
        if (!returnMsg.isSuccessflag()) {
            return returnMsg;
        }
        msg.setSuccessMsg("\u88ab\u4fdd\u4eba\u8ba1\u7b97\u4fdd\u8d39\u901a\u8fc7");
        return msg.msg();
    }

    private ReturnMsg callCalcAndCompare(Map<String, Object> map) {
        Return msg = new Return();
        String res = HttpUtils.jsonPost((String)this.calcProductPremiumNewUrl, (String)JsonUtils.toJson(map));
        Map result = JsonUtils.json2Map((String)res);
        if (!"success".equals((String)result.get("flag"))) {
            Return ret = Return.wrapperReturn((String)res);
            msg.setFailMsg(ret.getMsgList());
            return msg.msg();
        }
        List resBbrMapList = (List)result.get("data");
        List reqBbrMapList = (List)map.get("bbr");
        for (Map reqBbrMap : reqBbrMapList) {
            Map resBbrMap = resBbrMapList.stream().filter(p -> StrUtils.trimStr(reqBbrMap.get("party_uuid")).equals(StrUtils.trimStr(p.get("party_uuid")))).findFirst().get();
            Map reqBbrRiskMap = (Map)reqBbrMap.get("riskMap");
            if (Objects.isNull(reqBbrRiskMap)) continue;
            List reqRiskList = (List)reqBbrRiskMap.get("value");
            Map resBbrRiskMap = (Map)resBbrMap.get("riskMap");
            List resRiskList = (List)resBbrRiskMap.get("value");
            for (Map reqRiskMap : reqRiskList) {
                Map resRiskMap = resRiskList.stream().filter(p -> StrUtils.trimStr(reqRiskMap.get("risk_uuid")).equals(StrUtils.trimStr(p.get("risk_uuid")))).findFirst().get();
                BigDecimal initialPremiumDB = new BigDecimal(StrUtils.trimStr(reqRiskMap.get("initial_premium"))).stripTrailingZeros();
                BigDecimal initialPremiumNew = new BigDecimal(StrUtils.trimStr(resRiskMap.get("initial_premium"))).stripTrailingZeros();
                BigDecimal cvrAmountDB = new BigDecimal("0").stripTrailingZeros();
                if (!StrUtils.isNull(reqRiskMap.get("cvr_amount"))) {
                    cvrAmountDB = new BigDecimal(StrUtils.trimStr(reqRiskMap.get("cvr_amount"))).stripTrailingZeros();
                }
                BigDecimal cvrAmountNew = new BigDecimal("0").stripTrailingZeros();
                if (!StrUtils.isNull(resRiskMap.get("cvr_amount"))) {
                    cvrAmountNew = new BigDecimal(StrUtils.trimStr(resRiskMap.get("cvr_amount"))).stripTrailingZeros();
                }
                if (initialPremiumDB.equals(initialPremiumNew) && cvrAmountDB.equals(cvrAmountNew)) continue;
                msg.setFailMsg("\u88ab\u4fdd\u9669\u4eba\u3010" + (String)reqBbrMap.get("full_name") + "\u3011\u4fe1\u606f\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u8fdb\u5165\u201c\u8ba1\u7b97\u4fdd\u8d39\u201d\u9875\u9762\u3001\u91cd\u65b0\u786e\u8ba4\u9669\u79cd\u76f8\u5173\u4fe1\u606f\u3002");
                return msg.msg();
            }
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg peopleInfo(DownPolicyParam param) {
        String policyUuid = param.getPolicy_uuid();
        Return msg = new Return();
        List polPolicyOrderPartys = this.dao.findAll(PolPolicyOrderParty.n().where().addEq(PolPolicyOrderParty.ORDER_UUID, (Object)policyUuid).model());
        List bol_policy_partys = JsonUtils.json2List((String)JsonUtils.toJson((Object)polPolicyOrderPartys), PolicyPartyCalcVo.class);
        List pol_policy_partys = JsonUtils.json2List((String)JsonUtils.toJson((Object)polPolicyOrderPartys), PolicyPartyCalcVo.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] TPolicyId = (String[])bol_policy_partys.stream().filter(a -> a.getParty_type().equals("TBR")).collect(Collectors.toList()).stream().map(PolicyPartyCalcVo::getParty_uuid).toArray(String[]::new);
        map.put("tbr", bol_policy_partys.stream().filter(a -> a.getParty_type().equals("TBR")).collect(Collectors.toList()).get(0));
        String[] BPolicyId = (String[])pol_policy_partys.stream().filter(a -> a.getParty_type().equals("BBR")).collect(Collectors.toList()).stream().map(PolicyPartyCalcVo::getParty_uuid).toArray(String[]::new);
        List polPolicyRisks = this.dao.findAll(PolPolicyRisk.n().where().addIn(PolPolicyRisk.PARTY_UUID, BPolicyId).model());
        bol_policy_partys.stream().filter(a -> a.getParty_type().equals("BBR")).forEach(o -> {
            ArrayList polPolicyRisks1 = new ArrayList();
            polPolicyRisks.forEach(p -> {
                if (p.getPartyUuid().equals(o.getParty_uuid())) {
                    polPolicyRisks1.add(p);
                }
            });
            HashMap<String, List<PolPolicyRisk>> valueMap = new HashMap<String, List<PolPolicyRisk>>();
            valueMap.put("value", polPolicyRisks1);
            o.setRiskMap(valueMap);
        });
        map.put("bbr", bol_policy_partys.stream().filter(a -> a.getParty_type().equals("BBR")).collect(Collectors.toList()));
        msg.setDataTable(map);
        return msg.msg();
    }

    @Override
    public ReturnMsg checkFinish(String orderUuid, String userCode, String token) {
        Return aReturn = new Return();
        String sqlStr = "select ppop.party_uuid, ppop.full_name, ppop.party_type, ppop.is_spouse, ppop.finish_flag, ppop.finish_spol_flag , order_uuid, pppr.*  \nfrom pol_policy_order_party ppop\nleft join pol_policy_party_relation pppr\non ppop.party_uuid = pppr.affiliated_relation \nwhere order_uuid = ?";
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(orderUuid);
        List partyList = this.dao.findAll(sqlStr, Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(argList)});
        Map TBRParty = partyList.stream().filter(p -> "TBR".equals(p.get("party_type"))).findFirst().get();
        for (Map partyDB : partyList) {
            if ("Y".equals(partyDB.get("finish_flag"))) continue;
            if ("BBR".equals(partyDB.get("party_type")) && "TBR".equals(partyDB.get("master_party_type")) && "BBR".equals(partyDB.get("affiliated_party_type")) && "5".equals(partyDB.get("affiliated_type"))) {
                aReturn.setFailMsg("\u88ab\u4fdd\u4eba\u3010" + StrUtils.trimStr((Object)(TBRParty.get("full_name") + "\u3011")) + "\u4fe1\u606f\u672a\u5f55\u5165\u5b8c\u6574\uff0c\u8bf7\u60a8\u586b\u5199\u3002");
                return aReturn.msg();
            }
            aReturn.setFailMsg((StrUtils.isNull(partyDB.get("full_name")) ? "\u88ab\u4fdd\u4eba" : "\u88ab\u4fdd\u4eba\u3010" + StrUtils.trimStr((Object)(partyDB.get("full_name") + "\u3011"))) + "\u4fe1\u606f\u672a\u5f55\u5165\u5b8c\u6574\uff0c\u8bf7\u60a8\u586b\u5199\u3002");
            return aReturn.msg();
        }
        DownPolicyParam downPolicyParam = new DownPolicyParam();
        downPolicyParam.setPolicy_uuid(orderUuid);
        ReturnMsg returnMsg = this.calcProductPremium(downPolicyParam);
        if (!returnMsg.isSuccessflag()) {
            return returnMsg;
        }
        for (Map partyDB : partyList) {
            if (!"BBR".equals(partyDB.get("party_type")) || "Y".equals(partyDB.get("is_spouse")) || "Y".equals(partyDB.get("finish_spol_flag"))) continue;
            aReturn.setFailMsg("\u88ab\u4fdd\u4eba\u3010" + partyDB.get("full_name") + "\u3011\u7684\u53d7\u76ca\u4eba\u4fe1\u606f\u672a\u5f55\u5165\u5b8c\u6574\uff0c\u8bf7\u60a8\u586b\u5199\u3002");
            return aReturn.msg();
        }
        PolPolicyOrder orderDB = (PolPolicyOrder)this.dao.findOne(PolPolicyOrder.n().where().addEq(PolPolicyOrder.ORDER_UUID, (Object)orderUuid).model());
        if (SmsEnum.PolicyFlowType.FAMILY.getType().equals(orderDB.getPolicyFlowType())) {
            this.checkJKGZ(orderUuid, userCode, token);
        }
        return aReturn.msg();
    }

    public ReturnMsg checkJKGZ(String orderUuid, String userCode, String xAuthToken) {
        Return msg = new Return();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("usercode", userCode);
        headerMap.put("x-auth-token", xAuthToken);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("policy_uuid", orderUuid);
        paramMap.put("paper_type", "JKGZ");
        SysTradeLog sysTradeLog = new SysTradeLog();
        String transno = UUID.shortUUID();
        sysTradeLog.setInterfaceNo(SmsEnum.abutmentInterface.abutmentInformResult.getType());
        sysTradeLog.setSystemNo(SmsEnum.callSystem.SystemeTong.getType());
        sysTradeLog.setParamData(JsonUtils.toJson(paramMap) + "---" + JsonUtils.toJson(headerMap));
        sysTradeLog.setTransNo(transno);
        sysTradeLog.setParamType(SmsEnum.paramType.paramTypeReq.getType());
        sysTradeLog.setOrderUuid(orderUuid);
        this.systemEAbutmentUtil.insertSysTradeLog(sysTradeLog);
        String resultStr = this.eTongReqService.jsonPostETong(this.apiPlatformUrl + "queryProductNotification?apikey=" + this.apiPlatformApikey, JsonUtils.toJson(paramMap), headerMap);
        sysTradeLog.setParamData(resultStr);
        sysTradeLog.setParamType(SmsEnum.paramType.paramTypeRes.getType());
        this.systemEAbutmentUtil.insertSysTradeLog(sysTradeLog);
        if (StrUtils.isNull((Object)resultStr)) {
            msg.setFailMsg("\u8c03\u7528e\u901a\u83b7\u53d6\u544a\u77e5\u7ed3\u679c\u4fe1\u606f\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a");
            return msg.msg();
        }
        Map resultAllMap = JsonUtils.json2Map((String)resultStr);
        String flag = (String)resultAllMap.get("flag");
        if (!"success".equals(flag)) {
            List msgList = (List)resultAllMap.get("msg");
            String message = ((Map)msgList.get(0)).values().toString();
            msg.setFailMsg("\u8c03\u7528e\u901a\u83b7\u53d6\u544a\u77e5\u7ed3\u679c\u4fe1\u606f\u5931\u8d25,\u8fd4\u56de\u4fe1\u606f\u4e3a\uff1a" + message);
            return msg.msg();
        }
        Return ret = Return.wrapperReturn((String)resultStr);
        Map dataTable = ret.getDataTable();
        List partyInfo = (List)dataTable.get("partyInfo");
        if (!CollectionUtils.isEmpty((Collection)partyInfo)) {
            List partyList = this.dao.findAll((AbsModel)((PolPolicyOrderParty)PolPolicyOrderParty.n().where().addEq(PolPolicyOrderParty.ORDER_UUID, (Object)orderUuid).addEq(PolPolicyOrderParty.PARTY_TYPE, (Object)"BBR").model()).setOrderBy(new Sort.Order[]{PolPolicyOrderParty.DISPLAY_ORDER.asc()}));
            Set completePartySet = partyInfo.stream().map(p -> (String)p.get("party_uuid")).collect(Collectors.toSet());
            for (PolPolicyOrderParty party : partyList) {
                if (completePartySet.contains(party.getPartyUuid())) continue;
                msg.setFailMsg("\u88ab\u4fdd\u4eba " + party.getFullName() + " \u9700\u586b\u5199\u544a\u77e5\u9879");
                return msg.msg();
            }
        } else {
            msg.setFailMsg("\u8bf7\u5148\u586b\u5199\u88ab\u4fdd\u4eba\u544a\u77e5");
            return msg.msg();
        }
        return msg.msg();
    }
}

