/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.policy.service.impl;

import com.newtouch.base.enums.SmsEnum;
import com.newtouch.base.policy.service.CheckService;
import com.newtouch.base.policy.service.OrderService;
import com.newtouch.base.utils.sys.SysTradeLog;
import com.newtouch.policy.model.PolCrsResult;
import com.newtouch.policy.model.PolPolicy;
import com.newtouch.policy.model.PolPolicyCorporateCompany;
import com.newtouch.policy.model.PolPolicyCorporateConfirmation;
import com.newtouch.policy.model.PolPolicyCorporateCustomer;
import com.newtouch.policy.model.PolPolicyCorporateProject;
import com.newtouch.policy.model.PolPolicyCorporateResource;
import com.newtouch.policy.model.PolPolicyCorporateTeam;
import com.newtouch.policy.model.PolPolicyCorporateUser;
import com.newtouch.policy.model.PolPolicyOrder;
import com.newtouch.policy.model.PolPolicyOrderParty;
import com.newtouch.policy.model.PolPolicyParty;
import com.newtouch.policy.model.PolPolicyPartyAddress;
import com.newtouch.policy.model.PolPolicyPartyContact;
import com.newtouch.policy.model.PolPolicyPartyImage;
import com.newtouch.policy.model.PolPolicyPartyRelation;
import com.newtouch.policy.model.PolPolicyPay;
import com.newtouch.policy.model.PolPolicyRisk;
import com.newtouch.policy.model.PolTempData;
import com.uniapis.cache.CacheManager;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
implements OrderService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private CheckService checkService;

    @Override
    public ReturnMsg deletePolicy(Map<String, Object> param) {
        String orderUuid = StrUtils.trimStr((Object)param.get("policy_uuid"));
        this.checkService.checkAuth(orderUuid);
        String delType = StrUtils.trimStr((Object)param.get("delete_type"));
        Return msg = new Return();
        if (StrUtils.isNull((Object)orderUuid)) {
            msg.setFailMsg("\u60a8\u5c1a\u672a\u9009\u62e9\u4fdd\u5355\uff01");
            return msg.msg();
        }
        PolPolicy polPolicyQuery = new PolPolicy();
        polPolicyQuery.where().addEq(PolPolicy.ORDER_UUID, (Object)orderUuid);
        PolPolicy queryRes = (PolPolicy)this.dao.findOne((AbsModel)polPolicyQuery);
        if (queryRes == null) {
            msg.setFailMsg("\u60a8\u63d0\u4f9b\u7684\u5355\u53f7\u4e0d\u6b63\u786e\uff01");
            return msg.msg();
        }
        String policyUuid = queryRes.getPolicyUuid();
        PolPolicyParty polPolicyPartyQuery = new PolPolicyParty();
        polPolicyPartyQuery.where().addEq(PolPolicyParty.POLICY_UUID, (Object)orderUuid);
        List resList = this.dao.findAll((AbsModel)polPolicyPartyQuery);
        if (delType.equals("W")) {
            PolPolicy polPolicyEdit = new PolPolicy();
            polPolicyEdit.setPolicyState(SmsEnum.PolicyStateType.POLICYSTATETYPEW.getType());
            polPolicyEdit.where().addEq(PolPolicy.ORDER_UUID, (Object)orderUuid);
            this.dao.update((AbsModel)polPolicyEdit);
            return msg.msg();
        }
        PolPolicy polPolicy = new PolPolicy();
        polPolicy.where().addEq(PolPolicy.POLICY_UUID, (Object)policyUuid);
        this.dao.delete((AbsModel)polPolicy);
        PolPolicyParty polPolicyParty = new PolPolicyParty();
        polPolicyParty.where().addEq(PolPolicyParty.POLICY_UUID, (Object)policyUuid);
        this.dao.delete((AbsModel)polPolicyParty);
        PolPolicyRisk polPolicyRisk = new PolPolicyRisk();
        polPolicyRisk.where().addEq(PolPolicyRisk.POLICY_UUID, (Object)policyUuid);
        this.dao.delete((AbsModel)polPolicyRisk);
        PolPolicyPay polPolicyPay = new PolPolicyPay();
        polPolicyPay.where().addEq(PolPolicyPay.POLICY_UUID, (Object)policyUuid);
        this.dao.delete((AbsModel)polPolicyPay);
        PolPolicyPartyImage polPolicyPartyImage = new PolPolicyPartyImage();
        polPolicyPartyImage.where().addEq(PolPolicyPartyImage.POLICY_UUID, (Object)policyUuid);
        this.dao.delete((AbsModel)polPolicyPartyImage);
        PolPolicyOrder polPolicyOrder = new PolPolicyOrder();
        polPolicyOrder.where().addEq(PolPolicyOrder.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)polPolicyOrder);
        PolPolicyCorporateUser polPolicyCorporateUser = new PolPolicyCorporateUser();
        polPolicyCorporateUser.where().addEq(PolPolicyCorporateUser.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)polPolicyCorporateUser);
        PolPolicyCorporateResource polPolicyCorporateResource = new PolPolicyCorporateResource();
        polPolicyCorporateResource.where().addEq(PolPolicyCorporateResource.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)polPolicyCorporateResource);
        PolPolicyCorporateProject polPolicyCorporateProject = new PolPolicyCorporateProject();
        polPolicyCorporateProject.where().addEq(PolPolicyCorporateProject.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)polPolicyCorporateProject);
        PolPolicyCorporateCustomer polPolicyCorporateCustomer = new PolPolicyCorporateCustomer();
        polPolicyCorporateCustomer.where().addEq(PolPolicyCorporateCustomer.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)polPolicyCorporateCustomer);
        PolPolicyCorporateConfirmation polPolicyCorporateConfirmation = new PolPolicyCorporateConfirmation();
        polPolicyCorporateConfirmation.where().addEq(PolPolicyCorporateConfirmation.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)polPolicyCorporateConfirmation);
        PolPolicyCorporateCompany polPolicyCorporateCompany = new PolPolicyCorporateCompany();
        polPolicyCorporateCompany.where().addEq(PolPolicyCorporateCompany.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)polPolicyCorporateCompany);
        PolPolicyCorporateTeam polPolicyCorporateTeam = new PolPolicyCorporateTeam();
        polPolicyCorporateTeam.where().addEq(PolPolicyCorporateTeam.ORDER_UUID, (Object)orderUuid);
        this.dao.delete((AbsModel)polPolicyCorporateTeam);
        if (!resList.isEmpty() && resList.size() != 0) {
            for (PolPolicyParty res : resList) {
                PolPolicyOrderParty polPolicyOrderParty = new PolPolicyOrderParty();
                polPolicyOrderParty.where().addEq(PolPolicyOrderParty.PARTY_UUID, (Object)res.getPartyUuid());
                this.dao.delete((AbsModel)polPolicyOrderParty);
                PolPolicyPartyContact polPolicyPartyContact = new PolPolicyPartyContact();
                polPolicyPartyContact.where().addEq(PolPolicyPartyContact.PARTY_UUID, (Object)res.getPartyUuid());
                this.dao.delete((AbsModel)polPolicyPartyContact);
                PolPolicyPartyAddress polPolicyPartyAddress = new PolPolicyPartyAddress();
                polPolicyPartyAddress.where().addEq(PolPolicyPartyAddress.PARTY_UUID, (Object)res.getPartyUuid());
                this.dao.delete((AbsModel)polPolicyPartyAddress);
                PolPolicyPartyRelation polPolicyPartyRelation = new PolPolicyPartyRelation();
                polPolicyPartyRelation.where().addEq(PolPolicyPartyRelation.MASTER_RELATION, (Object)res.getPartyUuid());
                this.dao.delete((AbsModel)polPolicyPartyRelation);
                PolCrsResult polCrsResult = new PolCrsResult();
                polCrsResult.where().addEq(PolCrsResult.PARTY_UUID, (Object)res.getPartyUuid());
                this.dao.delete((AbsModel)polCrsResult);
            }
        }
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg sysTradeLog(Map<String, Object> map) {
        Return msg = new Return();
        SysTradeLog log = new SysTradeLog();
        if (StrUtils.isNull(map)) {
            return msg.setFailMsg("\u67e5\u8be2\u5931\u8d25").msg();
        }
        if (StrUtils.isNull((Object)map.get("order_uuid"))) {
            return msg.setFailMsg("\u67e5\u8be2\u5931\u8d25").msg();
        }
        log.where().addEq(SysTradeLog.ORDER_UUID, map.get("order_uuid"));
        if (!StrUtils.isNull((Object)map.get("interface_no"))) {
            log.where().addEq(SysTradeLog.INTERFACE_NO, map.get("interface_no"));
        }
        List logs = this.dao.findAll((AbsModel)log);
        return msg.setDataList(logs, SysTradeLog.class).msg();
    }

    @Override
    public ReturnMsg saveOrUpdateTempData(PolTempData tempData) {
        Return msg = new Return();
        if (tempData.getOrderUuid().isEmpty()) {
            msg.setFailMsg("\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        tempData.where().addEq(PolTempData.ORDER_UUID, (Object)tempData.getOrderUuid());
        this.dao.delete((AbsModel)tempData);
        tempData.setOrderUuid(tempData.getOrderUuid());
        tempData.setTempData(tempData.getTempData());
        this.dao.save((AbsModel)tempData);
        ArrayList<PolTempData> tempList = new ArrayList<PolTempData>();
        tempList.add(tempData);
        CacheManager.remove((String)("temp_order_data:" + tempData.getOrderUuid()));
        CacheManager.put((String)("temp_order_data:" + tempData.getOrderUuid()), tempList, (int)172800);
        msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryTempData(PolTempData tempData) {
        Return msg = new Return();
        if (tempData.getOrderUuid().isEmpty()) {
            msg.setFailMsg("\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return msg.msg();
        }
        tempData.where().addEq(PolTempData.ORDER_UUID, (Object)tempData.getOrderUuid());
        List tempDataList = this.dao.findAll((AbsModel)tempData);
        msg.setDataList(tempDataList, PolTempData.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryTempDataCache(String orderUuid) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)orderUuid)) {
            throw new BusinessException("\u5165\u53c2orderUuid\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        List<PolTempData> redisData = this.getRedisData(orderUuid);
        if (null == redisData || redisData.isEmpty()) {
            msg = new Return();
            PolTempData tempData = new PolTempData();
            tempData.where().addEq(PolTempData.ORDER_UUID, (Object)orderUuid);
            List tempDataList = this.dao.findAll((AbsModel)tempData);
            msg.setDataList(tempDataList, PolTempData.class);
            Ulog.info((String)"\u67e5\u8be2\u4e86\u6570\u636e\u5e93\u3002\u3002\u3002\n");
            String key = orderUuid;
            CacheManager.put((String)("temp_order_data:" + key), (Object)tempDataList, (int)172800);
            return msg.msg();
        }
        Ulog.info((String)"\u67e5\u8be2\u4e86\u7f13\u5b58\u3002\u3002\u3002\n");
        msg.setDataList(redisData, PolTempData.class);
        return msg.msg();
    }

    private List<PolTempData> getRedisData(String orderUuid) {
        List redisKeySet = (List)CacheManager.get((String)("temp_order_data:" + orderUuid));
        if (null == redisKeySet || redisKeySet.isEmpty()) {
            Ulog.info((String)("\u5728redis\u4e2d\u672a\u67e5\u8be2\u5230key\u503c\u4e3aorder_uuid\u4e3a\u3010" + orderUuid + "\u3011\u7684\u8bb0\u5f55"));
            return null;
        }
        List redisValue = (List)CacheManager.get((String)("temp_order_data:" + orderUuid));
        return redisValue;
    }
}

