/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.policy.service.impl;

import com.newtouch.base.enums.SmsEnum;
import com.newtouch.base.policy.service.CheckService;
import com.newtouch.base.policy.service.ImageService;
import com.newtouch.policy.model.PolPolicyPartyImage;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ImageServiceImpl
implements ImageService {
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private CheckService checkService;

    @Override
    public ReturnMsg saveImageInfo(List<PolPolicyPartyImage> paramList) {
        Return msg = new Return();
        Set<String> order_uuids = paramList.stream().map(PolPolicyPartyImage::getOrderUuid).collect(Collectors.toSet());
        order_uuids.forEach(o -> this.checkService.checkAuth((String)o));
        if (CollectionUtils.isEmpty(paramList)) {
            return msg.msg();
        }
        List imageTypeCheckList = paramList.stream().filter(obj -> !"11".equals(obj.getImageType()) && !"279".equals(obj.getImageType())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(imageTypeCheckList)) {
            msg.setFailMsg("\u5176\u4ed6\u5f71\u50cf\u7684\u5f71\u50cf\u7c7b\u578b\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
            return msg.msg();
        }
        for (PolPolicyPartyImage param : paramList) {
            PolPolicyPartyImage queryDelete = new PolPolicyPartyImage();
            queryDelete.where().addEq(PolPolicyPartyImage.POLICY_UUID, (Object)param.getPolicyUuid());
            queryDelete.where().addEq(PolPolicyPartyImage.IMAGE_TYPE, (Object)param.getImageType());
            if (!SmsEnum.ImageType.QYYGSFZM.getType().equals(param.getImageType())) {
                queryDelete.where().addEq(PolPolicyPartyImage.PARTY_UUID, (Object)param.getPartyUuid());
                if (StrUtils.isNull((Object)param.getImageDetailType())) {
                    queryDelete.where().addIsNull(PolPolicyPartyImage.IMAGE_DETAIL_TYPE);
                } else {
                    queryDelete.where().addEq(PolPolicyPartyImage.IMAGE_DETAIL_TYPE, (Object)param.getImageDetailType());
                }
            }
            this.dao.delete((AbsModel)queryDelete);
        }
        paramList.forEach(o -> o.setImageUpload(SmsEnum.ImageUpload.IMAGEY.getType()));
        this.dao.save(paramList);
        msg.setSuccessMsg(new Message("2010005", "\u4fdd\u5b58\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryImageInfo(Map<String, Object> param) {
        Return msg = new Return();
        String orderID = StrUtils.trimStr((Object)param.get("policy_uuid"));
        this.checkService.checkAuth(orderID);
        if (StrUtils.isNull((Object)orderID)) {
            msg.setFailMsg("\u6295\u4fdd\u5355\u53f7\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        PolPolicyPartyImage queryImage = new PolPolicyPartyImage();
        queryImage.where().addEq(PolPolicyPartyImage.ORDER_UUID, (Object)orderID);
        List resImageData = this.dao.findAll((AbsModel)queryImage);
        msg.setDataList(resImageData, PolPolicyPartyImage.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg delImageInfo(PolPolicyPartyImage polImage) {
        Return msg = new Return();
        this.checkService.checkAuth(polImage.getOrderUuid());
        if (!StrUtils.isNull((Object)polImage.getOrderUuid())) {
            polImage.where().addEq(PolPolicyPartyImage.ORDER_UUID, (Object)polImage.getOrderUuid());
        }
        if (!StrUtils.isNull((Object)polImage.getImageType())) {
            polImage.where().addEq(PolPolicyPartyImage.IMAGE_TYPE, (Object)polImage.getImageType());
        }
        this.dao.delete((AbsModel)polImage);
        return msg.msg();
    }
}

