/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.policy.controller;

import com.newtouch.base.policy.param.AgainPolicyParam;
import com.newtouch.base.policy.param.DownPolicyParam;
import com.newtouch.base.policy.service.PolicyService;
import com.newtouch.base.policy.vo.PolPolicyOrderPartyVo;
import com.newtouch.base.policy.vo.PolicyRiskVo;
import com.newtouch.base.policy.vo.QuestionVo;
import com.newtouch.base.policy.vo.eTong.ETongPolPolicyCorporateProjectVo;
import com.newtouch.policy.model.PolPolicyOrder;
import com.newtouch.policy.model.PolPolicyOrderParty;
import com.newtouch.policy.model.PolPolicyPay;
import com.newtouch.policy.model.PolPolicyRisk;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.JsonUtils;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/policy"})
public class PolicyController {
    private static final String TOKEN = "x-auth-token";
    private static final String SOURCE = "rqstSource";
    private static final String USER_CODE = "usercode";
    private static final String DEPLOY_ENV = "deployed_env";
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private PolicyService policyService;

    @PostMapping(value={"/saveOrUpdateOrder.do", "/saveOrUpdateOrder.serv"})
    public String saveOrUpdateOrder(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        Map policyOrderMap = (Map)param.get("pol_policy_order");
        String state = (String)policyOrderMap.get("policy_state");
        PolPolicyOrder policyOrder = (PolPolicyOrder)JsonUtils.map2Class((Map)policyOrderMap, PolPolicyOrder.class);
        List riskMapList = (List)param.get("pol_policy_risk_list");
        List policyRiskList = JsonUtils.listMap2ListClass((List)riskMapList, PolPolicyRisk.class);
        Map corporateProjectMap = (Map)param.get("pol_policy_corporate_project");
        ETongPolPolicyCorporateProjectVo eTongPolPolicyCorporateProjectVo = null;
        if (!ObjectUtils.isEmpty((Object)corporateProjectMap)) {
            eTongPolPolicyCorporateProjectVo = (ETongPolPolicyCorporateProjectVo)JsonUtils.map2Class((Map)corporateProjectMap, ETongPolPolicyCorporateProjectVo.class);
        }
        ReturnMsg msg = this.policyService.saveOrUpdateOrder(policyOrder, policyRiskList, eTongPolPolicyCorporateProjectVo, state);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/saveOrUpdateParty.do", "/saveOrUpdateParty.serv"})
    public String saveOrUpdateParty(HttpServletRequest request, HttpServletResponse response) {
        RequestMap requestMap = RequestUtils.getRequest((HttpServletRequest)request);
        PolPolicyOrderPartyVo party = (PolPolicyOrderPartyVo)((Object)requestMap.get("pol_policy_order_party", PolPolicyOrderPartyVo.class));
        ReturnMsg msg = this.policyService.saveOrUpdateParty(party);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/saveOrUpdateRisk.do", "/saveOrUpdateRisk.serv"})
    public String saveOrUpdateRisk(HttpServletRequest request, HttpServletResponse response) {
        Map param = RequestUtils.getRequestMap((HttpServletRequest)request);
        List riskMapList = (List)param.get("pol_policy_risk");
        Map policy = (Map)param.get("pol_policy_order");
        PolPolicyOrder policyOrder = new PolPolicyOrder();
        if (!CollectionUtils.isEmpty((Map)policy)) {
            policyOrder = (PolPolicyOrder)JsonUtils.map2Class((Map)policy, PolPolicyOrder.class);
        }
        List policyRiskList = JsonUtils.listMap2ListClass((List)riskMapList, PolicyRiskVo.class);
        ReturnMsg msg = this.policyService.saveOrUpdateRisk(policyRiskList, policyOrder);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/saveOrUpdatePay.do", "/saveOrUpdatePay.serv"})
    public String saveOrUpdatePay(HttpServletRequest request, HttpServletResponse response) {
        RequestMap requestMap = RequestUtils.getRequest((HttpServletRequest)request);
        PolPolicyPay policyPay = (PolPolicyPay)requestMap.get("pol_policy_pay", PolPolicyPay.class);
        ReturnMsg msg = this.policyService.saveOrUpdatePay(policyPay);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/savePolicyInfo.do", "/savePolicyInfo.serv"})
    public String savePolicyInfo(HttpServletRequest request, HttpServletResponse response) {
        String userCode = request.getHeader(USER_CODE);
        String token = request.getHeader(TOKEN);
        String deployedEnv = request.getHeader(DEPLOY_ENV);
        RequestMap requestMap = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = requestMap.getParam();
        ReturnMsg msg = this.policyService.savePolicyInfo(param, userCode, token, deployedEnv);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/sendPolicyInfo.do", "/sendPolicyInfo.serv"})
    public String sendPolicyInfo(HttpServletRequest request, HttpServletResponse response) {
        String userCode = request.getHeader(USER_CODE);
        String token = request.getHeader(TOKEN);
        String deployedEnv = request.getHeader(DEPLOY_ENV);
        RequestMap requestMap = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = requestMap.getParam();
        ReturnMsg msg = this.policyService.sendPolicyInfo(param, userCode, token, deployedEnv);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/OrderInfo.do", "/OrderInfo.serv"})
    public String OrderInfo(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        DownPolicyParam downPolicyParam = (DownPolicyParam)RequestUtils.getRequestMap((Map)param.getParam(), DownPolicyParam.class);
        ReturnMsg msg = this.policyService.OrderInfo(downPolicyParam);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/getInfoFromHistory.do", "/getInfoFromHistory.serv"})
    public String getInfoFromHistory(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        DownPolicyParam downPolicyParam = (DownPolicyParam)RequestUtils.getRequestMap((Map)param.getParam(), DownPolicyParam.class);
        String userCode = request.getHeader(USER_CODE);
        String token = request.getHeader(TOKEN);
        String deployedEnv = request.getHeader(DEPLOY_ENV);
        downPolicyParam.setDeployed_env(deployedEnv);
        downPolicyParam.setToken(token);
        downPolicyParam.setUser_code(userCode);
        ReturnMsg msg = this.policyService.getInfoFromHistory(downPolicyParam);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/proposalToPolicy.do", "/proposalToPolicy.serv"})
    public String proposalToPolicy(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        DownPolicyParam downPolicyParam = (DownPolicyParam)RequestUtils.getRequestMap((Map)param.getParam(), DownPolicyParam.class);
        ReturnMsg msg = this.policyService.proposalToPolicy(downPolicyParam);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/continuePolicy.do", "/continuePolicy.serv"})
    public String continuePolicy(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        AgainPolicyParam downPolicyParam = (AgainPolicyParam)RequestUtils.getRequestMap((Map)param.getParam(), AgainPolicyParam.class);
        String userCode = request.getHeader(USER_CODE);
        String token = request.getHeader(TOKEN);
        String deployedEnv = request.getHeader(DEPLOY_ENV);
        downPolicyParam.setDeployed_env(deployedEnv);
        downPolicyParam.setToken(token);
        downPolicyParam.setUser_code(userCode);
        ReturnMsg msg = this.policyService.continuePolicy(downPolicyParam);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/anotherOrder.do", "/anotherOrder.serv"})
    public String anotherOrder(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        AgainPolicyParam downPolicyParam = (AgainPolicyParam)RequestUtils.getRequestMap((Map)param.getParam(), AgainPolicyParam.class);
        String userCode = request.getHeader(USER_CODE);
        String token = request.getHeader(TOKEN);
        String deployedEnv = request.getHeader(DEPLOY_ENV);
        downPolicyParam.setDeployed_env(deployedEnv);
        downPolicyParam.setToken(token);
        downPolicyParam.setUser_code(userCode);
        ReturnMsg msg = this.policyService.anotherOrder(downPolicyParam);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/updatePartyInfo.do", "/updatePartyInfo.serv"})
    public String updatePartyInfo(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        PolPolicyOrderParty party = (PolPolicyOrderParty)RequestUtils.getRequestMap((Map)param.getParam(), PolPolicyOrderParty.class);
        ReturnMsg msg = this.policyService.updatePartyInfo(party);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/updateOrderInfo.do", "/updateOrderInfo.serv"})
    public String updateOrderInfo(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        PolPolicyOrder order = (PolPolicyOrder)RequestUtils.getRequestMap((Map)param.getParam(), PolPolicyOrder.class);
        ReturnMsg msg = this.policyService.updateOrderInfo(order);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/calcProductPremium.serv"})
    public String calcProductPremium(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        DownPolicyParam downPolicyParam = (DownPolicyParam)RequestUtils.getRequestMap((Map)param.getParam(), DownPolicyParam.class);
        ReturnMsg msg = this.policyService.calcProductPremium(downPolicyParam);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/bindQuestion.do", "/bindQuestion.serv"})
    public String bindQuestion(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        QuestionVo party = (QuestionVo)RequestUtils.getRequestMap((Map)param.getParam(), QuestionVo.class);
        ReturnMsg msg = this.policyService.bindQuestion(party);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/peopleInfo.serv"})
    public String peopleInfo(HttpServletRequest request, HttpServletResponse response) {
        RequestMap param = RequestUtils.getRequest((HttpServletRequest)request);
        DownPolicyParam downPolicyParam = (DownPolicyParam)RequestUtils.getRequestMap((Map)param.getParam(), DownPolicyParam.class);
        ReturnMsg msg = this.policyService.peopleInfo(downPolicyParam);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/checkFinish.do", "/checkFinish.serv"})
    public String checkFinish(HttpServletRequest request, HttpServletResponse response) {
        String userCode = request.getHeader(USER_CODE);
        String token = request.getHeader(TOKEN);
        RequestMap requestMap = RequestUtils.getRequest((HttpServletRequest)request);
        String orderUuid = requestMap.get("order_uuid");
        ReturnMsg msg = this.policyService.checkFinish(orderUuid, userCode, token);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }
}

