/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.material.controller;

import com.newtouch.base.service.SysDataService;
import com.newtouch.material.param.AddMaterialsParam;
import com.newtouch.material.param.DeleteMaterialsParam;
import com.newtouch.material.param.DownloadMaterialParam;
import com.newtouch.material.param.QueryMaterialsParam;
import com.newtouch.material.param.SaveScpzTagsMaterialRelationparam;
import com.newtouch.material.param.SaveScpzTagsMaterialparam;
import com.newtouch.material.service.IMaterialManagerService;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.utils.JsonUtils;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/materialManager"})
public class MaterialManagerController {
    @Autowired
    private IMaterialManagerService iMaterialManagerService;
    @Autowired
    private SysDataService sysDataService;

    @RequestMapping(value={"/queryMaterial.do"})
    public String queryMaterial(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        QueryMaterialsParam queryMaterialsParam = (QueryMaterialsParam)JsonUtils.map2Class((Map)param, QueryMaterialsParam.class);
        ReturnMsg returnMsg = this.iMaterialManagerService.queryMaterial(queryMaterialsParam);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/addMaterial.do"})
    public String addMaterial(HttpServletRequest request) throws IOException {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        AddMaterialsParam addMaterialsParam = (AddMaterialsParam)((Object)JsonUtils.map2Class((Map)param, AddMaterialsParam.class));
        ReturnMsg returnMsg = this.iMaterialManagerService.addMaterial(addMaterialsParam);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/updateMaterialName.do"})
    public String updateMaterialName(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String materialId = map.get("material_id");
        String materialName = map.get("material_name");
        ReturnMsg returnMsg = this.iMaterialManagerService.updateMaterialName(materialId, materialName);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/deleteMaterials.do"})
    public String deleteMaterials(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        DeleteMaterialsParam deleteMaterialsParam = (DeleteMaterialsParam)JsonUtils.map2Class((Map)param, DeleteMaterialsParam.class);
        ReturnMsg returnMsg = this.iMaterialManagerService.deleteMaterials(deleteMaterialsParam);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @PostMapping(value={"/addScpzTags.do"})
    public String addScpzTags(HttpServletRequest request, HttpServletResponse response) {
        Map paramMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        String tagName = (String)paramMap.get("tagName");
        String tagCategories = (String)paramMap.get("tagCategories");
        ReturnMsg msg = this.iMaterialManagerService.insertScpzTags(tagName, tagCategories);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/queryScpzTags.do"})
    public String queryScpzTags(HttpServletRequest request, HttpServletResponse response) {
        Map paramMap = RequestUtils.getRequestMap((HttpServletRequest)request);
        String tagName = (String)paramMap.get("tagName");
        ReturnMsg msg = this.iMaterialManagerService.queryScpzTags(tagName);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/saveScpzTagsMaterialVo.do"})
    public String saveScpzTagsMaterialVo(HttpServletRequest request) {
        SaveScpzTagsMaterialparam saveScpzTagsMaterialparam = (SaveScpzTagsMaterialparam)RequestUtils.getRequestMap((HttpServletRequest)request, SaveScpzTagsMaterialparam.class);
        ReturnMsg msg = this.iMaterialManagerService.saveScpzTagsMaterialVo(saveScpzTagsMaterialparam);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @PostMapping(value={"/saveScpzMaterialTagsRelation.do"})
    public String saveScpzMaterialTagsRelation(HttpServletRequest request) {
        SaveScpzTagsMaterialRelationparam save = (SaveScpzTagsMaterialRelationparam)RequestUtils.getRequestMap((HttpServletRequest)request, SaveScpzTagsMaterialRelationparam.class);
        ReturnMsg msg = this.iMaterialManagerService.saveScpzMaterialTagsRelation(save);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/downloadMaterial.do"})
    public String downloadImageOrVideo(HttpServletRequest request, HttpServletResponse response, String filePath) throws IOException {
        ReturnMsg returnMsg = this.iMaterialManagerService.downloadMaterial(request, response, filePath);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/downloadMaterials.do"})
    public String downloadMaterial(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        DownloadMaterialParam downloadMaterialParam = (DownloadMaterialParam)JsonUtils.map2Class((Map)param, DownloadMaterialParam.class);
        ReturnMsg msg = this.sysDataService.downloadMaterial(downloadMaterialParam.getKeys(), response);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/downloadAuthorized.do"})
    public String downloadAuthorized(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        DownloadMaterialParam downloadMaterialParam = (DownloadMaterialParam)JsonUtils.map2Class((Map)param, DownloadMaterialParam.class);
        ReturnMsg msg = this.sysDataService.downloadAuthorized(downloadMaterialParam.getKeys(), response);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/export.do"})
    public String export(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        List materialUuidList = map.getList("materialIds", String.class);
        ReturnMsg returnMsg = this.iMaterialManagerService.exportNew(materialUuidList, response);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/upload.do"})
    public String upload(MultipartFile zipFile) {
        ReturnMsg returnMsg = this.iMaterialManagerService.uploadJson(zipFile);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }
}

