/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.utils.obs;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.newtouch.base.config.SyAccountConfig;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HCPClients {
    @Autowired
    private SyAccountConfig syAccountConfig;
    private AmazonS3 hs3ClientSY = null;
    private AmazonS3 hs3ClientRL = null;

    private HCPClients() {
    }

    public AmazonS3 getS3Client(String type) {
        if ("RL".equals(type)) {
            return this.getS3ClientRL();
        }
        if ("SY".equals(type)) {
            return this.getS3ClientSY();
        }
        return null;
    }

    public AmazonS3 getS3ClientRL() {
        if (this.hs3ClientRL == null) {
            String endpoint = this.syAccountConfig.getRlEndpoint();
            String accessKey = this.syAccountConfig.getRlAccessKey();
            String secretKey = this.syAccountConfig.getRlSecretKey();
            ClientConfiguration clientConfig = new ClientConfiguration();
            clientConfig.setProtocol(Protocol.HTTPS);
            clientConfig.setSignerOverride("S3SignerType");
            try {
                SSLContextBuilder builder = new SSLContextBuilder();
                builder.loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        return true;
                    }
                });
                SSLConnectionSocketFactory sslsf = null;
                sslsf = new SSLConnectionSocketFactory(builder.build(), new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.2"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                clientConfig.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)sslsf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.hs3ClientRL = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(clientConfig)).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, ""))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey)))).build();
        }
        return this.hs3ClientRL;
    }

    public AmazonS3 getS3ClientSY() {
        if (this.hs3ClientSY == null) {
            String endpoint = this.syAccountConfig.getEndpoint();
            String accessKey = this.syAccountConfig.getAccessKey();
            String secretKey = this.syAccountConfig.getSecretKey();
            ClientConfiguration clientConfig = new ClientConfiguration();
            clientConfig.setProtocol(Protocol.HTTP);
            clientConfig.setSignerOverride("S3SignerType");
            try {
                SSLContextBuilder builder = new SSLContextBuilder();
                builder.loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        return true;
                    }
                });
                SSLConnectionSocketFactory sslsf = null;
                sslsf = new SSLConnectionSocketFactory(builder.build(), new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.2"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                clientConfig.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)sslsf);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.hs3ClientSY = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(clientConfig)).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, ""))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey)))).build();
        }
        return this.hs3ClientSY;
    }
}

