/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.newtouch.base.config.TemplateConfig;
import com.newtouch.base.enums.BaseEnum;
import com.newtouch.base.enums.PageBaseEnum;
import com.newtouch.base.model.Component;
import com.newtouch.base.model.ComponentAttribute;
import com.newtouch.base.model.FmAttributesType;
import com.newtouch.base.service.ComponentService;
import com.newtouch.base.service.SyncService;
import com.newtouch.base.utils.FilesUtil;
import com.newtouch.base.vo.AttributeMultiVo;
import com.newtouch.base.vo.AttributeVo;
import com.newtouch.base.vo.ComponentAttributeTagsVo;
import com.newtouch.base.vo.ComponentAttributeVo;
import com.newtouch.base.vo.ComponentJsonVo;
import com.newtouch.base.vo.ComponentResVo;
import com.newtouch.base.vo.ComponentVo;
import com.newtouch.base.vo.ExportDataVo;
import com.newtouch.base.vo.TagsVo;
import com.newtouch.flow.model.FmEmbedded;
import com.newtouch.flow.param.QueryTagsRelationParam;
import com.newtouch.flow.param.QueryTagsRelationReturn;
import com.newtouch.issue.service.IWtIssueService;
import com.newtouch.nms.sip.model.SipProductSyncTask;
import com.newtouch.tags.service.ITagsService;
import com.uniapis.cache.CacheManager;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.FileUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ComponentServiceImpl
implements ComponentService {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    private IWtIssueService iWtIssueService;
    @Autowired
    private TemplateConfig templateConfig;
    @Autowired
    private ITagsService tagsService;
    @Autowired
    private SyncService syncService;

    @Override
    public ReturnMsg queryComponent(Component component) {
        int i;
        Return msg = new Return();
        String componentCategory = StrUtils.isNull((Object)component.getComponentCategory()) ? "" : component.getComponentCategory();
        QueryTagsRelationParam tag = new QueryTagsRelationParam();
        tag.setRelationTab("component");
        tag.setRelationField("component_id");
        tag.setTagBelongs(component.getTagBelongs());
        tag.setTagsId(component.getTagIds());
        ReturnMsg msgTag = this.iWtIssueService.queryTagsRelation(tag);
        List tagsList = msgTag.getDataList(QueryTagsRelationReturn.class);
        List idList = null;
        Map<Object, Object> listMaps = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)tagsList)) {
            idList = tagsList.stream().map(QueryTagsRelationReturn::getRelationFk).collect(Collectors.toList());
            listMaps = tagsList.stream().collect(Collectors.groupingBy(QueryTagsRelationReturn::getRelationFk));
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        stringBuilder.append("select ct.component_id ,ct.component_name ,ct.component_type ,ct.component_category ,ct.component_scene,ct.component_class ,ct.component_json ,ct.embedded_json,");
        stringBuilder.append(" ct.label_type ,ct.is_level ,ct.display_order ,ct.crt_date ,ct.mdf_date,ct.crt_user ,ct.mdf_user ,ct.data_flag ,");
        stringBuilder.append(" ct.patch_memo ,ct.component_icon ,ct.event_type ,ct.delivery_platform");
        stringBuilder.append(" from component ct where 1=1 ");
        stringBuilder.append("");
        if (StrUtils.isNull((Object)componentCategory)) {
            stringBuilder.append(" and ct.data_flag  = ?   and ct.component_class  = ?  and ct.component_category != ?  ");
            list.add(BaseEnum.DataFlag.USABLE.getType());
            list.add(component.getComponentClass());
            list.add(PageBaseEnum.ComponentCategory.CUSTOM.getType());
        } else {
            stringBuilder.append(" and ct.data_flag  = ?   and ct.component_class  = ?  and ct.component_category = ?  ");
            list.add(BaseEnum.DataFlag.USABLE.getType());
            list.add(component.getComponentClass());
            list.add(componentCategory);
        }
        if (!StrUtils.isNull((Object)component.getComponentName())) {
            stringBuilder.append(" and ct.component_name  like  ? ");
            list.add("%" + component.getComponentName() + "%");
        }
        if (!StrUtils.isNull((Object)component.getDeliveryPlatform())) {
            String deliveryPlatformList = component.getDeliveryPlatform();
            String[] platformList = deliveryPlatformList.split(",");
            List<String> platformIdList = Arrays.asList(platformList);
            stringBuilder.append(" and ( ");
            for (i = 0; i < platformIdList.size(); ++i) {
                if (i == platformIdList.size() - 1) {
                    stringBuilder.append(" ct.delivery_platform like ? ");
                    list.add("%" + platformIdList.get(i) + "%");
                    continue;
                }
                stringBuilder.append(" ct.delivery_platform like ? or ");
                list.add("%" + platformIdList.get(i) + "%");
            }
            stringBuilder.append(")");
        }
        if (!StrUtils.isNull((Object)component.getEventType())) {
            String eventTypeList = component.getEventType();
            String[] eventList = eventTypeList.split(",");
            List<String> eventIdList = Arrays.asList(eventList);
            stringBuilder.append(" and ( ");
            for (i = 0; i < eventIdList.size(); ++i) {
                if (i == eventIdList.size() - 1) {
                    stringBuilder.append(" ct.event_type like ? ");
                    list.add("%" + eventIdList.get(i) + "%");
                    continue;
                }
                stringBuilder.append(" ct.event_type like ? or  ");
                list.add("%" + eventIdList.get(i) + "%");
            }
            stringBuilder.append(")");
        }
        if (CollectionUtils.isNotEmpty(component.getTagIds())) {
            if (CollectionUtils.isEmpty(idList)) {
                ArrayList componentList = new ArrayList();
                msg.setDataList(componentList, Component.class);
                msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
                return msg.msg();
            }
            stringBuilder.append(" and ct.component_id  in ( ");
            for (int i2 = 0; i2 < idList.size(); ++i2) {
                if (i2 == idList.size() - 1) {
                    stringBuilder.append(" ?  ");
                } else {
                    stringBuilder.append(" ?,  ");
                }
                list.add((String)idList.get(i2));
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(" order by ct.display_order asc \uff03NOTCHECK");
        List tComponentList = this.dao.findAll(stringBuilder.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(list)});
        Map<Object, Object> finalListMaps = listMaps;
        tComponentList.stream().forEach(o -> {
            if (CollectionUtils.isNotEmpty((Collection)((Collection)finalListMaps.get(o.get("component_id"))))) {
                o.put("tags", finalListMaps.get(o.get("component_id")));
            }
            if (ObjectUtil.isNotEmpty(o.get("embedded_json"))) {
                o.put("embeddeds", JsonUtils.json2List((String)((String)o.get("embedded_json"))));
            }
        });
        msg.setDataList(tComponentList);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg addOrUpdateComponent(Component component) {
        List componentList;
        Return msg = new Return();
        String componentType = component.getComponentType();
        String componentClass = component.getComponentClass();
        String componentId = component.getComponentId();
        if (!ObjectUtil.isNull(component.getEmbeddeds())) {
            component.setEmbeddedJson(JsonUtils.toJson(component.getEmbeddeds()));
        }
        Component componentCheck = new Component();
        componentCheck.where().addEq(Component.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType()).addEq(Component.COMPONENT_TYPE, (Object)componentType).addEq(Component.COMPONENT_CLASS, (Object)componentClass);
        if (!StrUtils.isNull((Object)componentId)) {
            componentCheck.where().addNotEq(Component.COMPONENT_ID, (Object)componentId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(componentList = this.dao.findAll((AbsModel)componentCheck)))) {
            msg.setFailMsg("\u7ec4\u4ef6\u7c7b\u578b\u4e0d\u80fd\u91cd\u590d");
            return msg.msg();
        }
        if (!StrUtils.isNull((Object)componentId)) {
            component.setMdfDate(new Date());
            component.where().addEq(Component.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType()).addEq(Component.COMPONENT_ID, (Object)componentId);
            this.dao.update((AbsModel)component);
            msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        } else {
            component.setComponentId(UUID.shortUUID());
            component.setCrtDate(new Date());
            component.setMdfDate(new Date());
            this.dao.save((AbsModel)component);
            msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        }
        FmAttributesType fmAttributesTypeCheck = new FmAttributesType();
        fmAttributesTypeCheck.where().addEq(FmAttributesType.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType()).addEq(FmAttributesType.COMPONENT_TYPE, (Object)componentType);
        List fmAttributesTypeList = this.dao.findAll((AbsModel)fmAttributesTypeCheck);
        if (CollectionUtils.isEmpty((Collection)fmAttributesTypeList)) {
            FmAttributesType fmAttributesType = new FmAttributesType();
            fmAttributesType.setDatabaseType("VARCHAR");
            fmAttributesType.setComponentType(componentType);
            fmAttributesType.setTypeId(UUID.shortUUID());
            fmAttributesType.setDataFlag("1");
            fmAttributesType.setCrtDate(new Date());
            fmAttributesType.setMdfDate(new Date());
            this.dao.save((AbsModel)fmAttributesType);
        }
        this.cacheRemove(component.getComponentClass(), component.getComponentCategory());
        CacheManager.remove((String)"fm_attributes_type_db_type");
        msg.setDataTable(new Object[]{component});
        return msg.msg();
    }

    private void cacheRemove(String componentClass, String componentCategory) {
        String key = "all_component" + componentClass;
        Ulog.info((String)("\u6e05\u9664\u7f13\u5b58--->" + key + componentCategory + "--" + key));
        CacheManager.remove((String)(key + componentCategory));
        CacheManager.remove((String)key);
    }

    @Override
    public ReturnMsg deleteComponent(Component component) {
        Return msg = new Return();
        String componentId = component.getComponentId();
        if (StrUtils.isNull((Object)componentId)) {
            msg.setFailMsg(new Message("6010002", "\u7ec4\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        Component tComponent = new Component();
        tComponent.setDataFlag(BaseEnum.DataFlag.UNUSABLE.getType());
        tComponent.where().addEq(Component.COMPONENT_ID, (Object)componentId);
        Component componentDb = (Component)this.dao.findOne((AbsModel)tComponent);
        this.dao.update(tComponent.where().addEq(Component.COMPONENT_ID, (Object)componentId).model());
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        this.cacheRemove(componentDb.getComponentClass(), componentDb.getComponentCategory());
        return msg.msg();
    }

    @Override
    public ReturnMsg queryAttribute(String componentId) {
        ArrayList<ComponentAttributeVo> voList = new ArrayList<ComponentAttributeVo>();
        ComponentAttribute componentAttribute = new ComponentAttribute();
        componentAttribute.where().addEq(AbsModel.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
        componentAttribute.where().addEq(ComponentAttribute.COMPONENT_ID, (Object)componentId);
        componentAttribute.setOrderBy(ComponentAttribute.DISPLAY_ORDER.asc());
        List attributeList = this.dao.findAll((AbsModel)componentAttribute);
        if (CollectionUtils.isNotEmpty((Collection)attributeList)) {
            for (ComponentAttribute attribute : attributeList) {
                ComponentAttributeVo vo = new ComponentAttributeVo();
                BeanUtils.copyProperties((Object)((Object)attribute), (Object)((Object)vo));
                vo.setAttributeList(JSONObject.parseArray((String)attribute.getAttributeMulti(), ComponentAttributeVo.class));
                voList.add(vo);
            }
        }
        Return msg = new Return();
        msg.setDataList(voList, ComponentAttributeVo.class);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    public int getAttributeDisplayOrderbyId(ComponentAttribute componentAttribute) {
        ComponentAttribute attribute = new ComponentAttribute();
        attribute.where().addEq(ComponentAttribute.ATTRIBUTE_ID, (Object)componentAttribute.getAttributeId()).addEq(ComponentAttribute.COMPONENT_ID, (Object)componentAttribute.getComponentId());
        return ((ComponentAttribute)this.dao.findOne((AbsModel)attribute)).getDisplayOrder();
    }

    public int getMaxAttributeDisplayOrder(ComponentAttribute componentAttribute) {
        ComponentAttribute attribute = new ComponentAttribute();
        attribute.where().addIsNotNull(ComponentAttribute.DISPLAY_ORDER).addEq(ComponentAttribute.COMPONENT_ID, (Object)componentAttribute.getComponentId());
        attribute.groupBy().max(ComponentAttribute.DISPLAY_ORDER);
        ComponentAttribute maxDisplayOrderAttribute = (ComponentAttribute)this.dao.findOne((AbsModel)attribute);
        int maxDisplayOrder = StringUtils.isNotBlank((CharSequence)maxDisplayOrderAttribute.getOtherProperty("max_display_order").toString()) ? Integer.parseInt(maxDisplayOrderAttribute.getOtherProperty("max_display_order").toString()) + 1 : 0;
        return maxDisplayOrder;
    }

    public void updateDisplayOrderFromIToJ(ComponentAttribute componentAttribute, int i, int j) {
        ComponentAttribute attribute = new ComponentAttribute();
        attribute.setDisplayOrder(j);
        attribute.where().addEq(ComponentAttribute.DISPLAY_ORDER, (Object)i);
        attribute.where().addEq(ComponentAttribute.COMPONENT_ID, (Object)componentAttribute.getComponentId());
        attribute.where().addEq(ComponentAttribute.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
        this.dao.update((AbsModel)attribute);
    }

    public void updateDisplayOrderById(ComponentAttribute attribute, int displayOrder) {
        ComponentAttribute tempAttribute = new ComponentAttribute();
        tempAttribute.setDisplayOrder(displayOrder);
        tempAttribute.where().addEq(ComponentAttribute.ATTRIBUTE_ID, (Object)attribute.getAttributeId()).addEq(ComponentAttribute.COMPONENT_ID, (Object)attribute.getComponentId());
        this.dao.update((AbsModel)tempAttribute);
    }

    public void updateDisplayOrder(ComponentAttribute attribute) {
        int updateDisplayOrder = attribute.getDisplayOrder();
        int currentDisplayOrder = this.getAttributeDisplayOrderbyId(attribute);
        int maxDisplayOrder = this.getMaxAttributeDisplayOrder(attribute);
        if (updateDisplayOrder < 1) {
            updateDisplayOrder = 1;
        }
        if (updateDisplayOrder > maxDisplayOrder) {
            updateDisplayOrder = maxDisplayOrder;
        }
        if (updateDisplayOrder <= currentDisplayOrder) {
            for (int i = currentDisplayOrder - 1; i >= updateDisplayOrder; --i) {
                this.updateDisplayOrderFromIToJ(attribute, i, i + 1);
            }
        } else if (updateDisplayOrder > currentDisplayOrder) {
            for (int i = currentDisplayOrder + 1; i <= updateDisplayOrder; ++i) {
                this.updateDisplayOrderFromIToJ(attribute, i, i - 1);
            }
        }
        this.updateDisplayOrderById(attribute, updateDisplayOrder);
    }

    @Override
    public ReturnMsg addOrUpdateAttribute(ComponentAttribute componentAttribute) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)componentAttribute.getAttributeMulti()) || StrUtils.isNull((Object)componentAttribute.getComponentId()) || StrUtils.isNull((Object)componentAttribute.getDisplayOrder())) {
            msg.setFailMsg(new Message("6010001", "\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        if (componentAttribute.getAttributeDesc().getBytes(Charset.forName("UTF-8")).length >= 122) {
            msg.setFailMsg("\u5c5e\u6027\u63cf\u8ff0\u6700\u591a\u4e0d\u80fd\u8d85\u8fc740\u4e2a\u6c49\u5b57\uff01");
            return msg.msg();
        }
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{componentAttribute.getAttributeId(), componentAttribute.getComponentId()})) {
            Ulog.info((String)("\u7ec4\u4ef6\u5c5e\u6027\u4fee\u6539\u524d----" + JsonUtils.toJson((Object)((Object)componentAttribute))));
            this.updateDisplayOrder(componentAttribute);
            this.dao.update(componentAttribute.where().addEq(AbsModel.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType()).addEq(ComponentAttribute.ATTRIBUTE_ID, (Object)componentAttribute.getAttributeId()).addEq(ComponentAttribute.COMPONENT_ID, (Object)componentAttribute.getComponentId()).model());
            msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        } else {
            if (StringUtils.isBlank((CharSequence)componentAttribute.getAttributeId())) {
                componentAttribute.setAttributeId(UUID.shortUUID());
            }
            ComponentAttribute attribute = new ComponentAttribute();
            attribute.where().addEq(ComponentAttribute.COMPONENT_ID, (Object)componentAttribute.getComponentId()).addEq(ComponentAttribute.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
            attribute.groupBy().max(ComponentAttribute.DISPLAY_ORDER);
            ComponentAttribute c = (ComponentAttribute)this.dao.findOne((AbsModel)attribute);
            int order = StringUtils.isNotBlank((CharSequence)c.getOtherProperty("max_display_order").toString()) ? Integer.parseInt(c.getOtherProperty("max_display_order").toString()) + 1 : 0;
            int finalDisplayOrder = componentAttribute.getDisplayOrder();
            componentAttribute.setDisplayOrder(order);
            componentAttribute.setDisplayOrder(this.getMaxAttributeDisplayOrder(componentAttribute) + 1);
            Ulog.info((String)("\u7ec4\u4ef6\u5c5e\u6027\u65b0\u589e\u524d----" + JsonUtils.toJson((Object)((Object)componentAttribute))));
            this.dao.save((AbsModel)componentAttribute);
            componentAttribute.setDisplayOrder(finalDisplayOrder);
            this.updateDisplayOrder(componentAttribute);
            msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteAttribute(String attributeId) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)attributeId)) {
            msg.setFailMsg(new Message("6010003", "\u7ec4\u4ef6\u5c5e\u6027id\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        ComponentAttribute attribute = new ComponentAttribute();
        attribute.setDataFlag(BaseEnum.DataFlag.UNUSABLE.getType());
        attribute.setAttributeId(attributeId);
        attribute.where().addEq(ComponentAttribute.ATTRIBUTE_ID, (Object)attributeId);
        this.dao.update((AbsModel)attribute);
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg sortAttribute(ComponentAttributeVo componentAttributeVo) {
        Return msg = new Return();
        ComponentAttribute componentAttribute = new ComponentAttribute();
        componentAttribute.setDisplayOrder(componentAttributeVo.getResultOrder());
        componentAttribute.where().addEq(ComponentAttribute.ATTRIBUTE_ID, (Object)componentAttributeVo.getCurrentId());
        this.dao.update((AbsModel)componentAttribute);
        componentAttribute.setDisplayOrder(componentAttributeVo.getCurrentOrder());
        componentAttribute.where().addEq(ComponentAttribute.ATTRIBUTE_ID, (Object)componentAttributeVo.getResultId());
        this.dao.update((AbsModel)componentAttribute);
        msg.setSuccessMsg(new Message("2010006", "\u8c03\u6574\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryComponentAttribute(ComponentAttributeTagsVo componentAttributeTagsVo) {
        Return msg = new Return();
        String pkuuid = ThreadLocalContext.get().getUser().getPkUuid();
        String userAuthSql = "select t1.* from rms_resources_auth t1  where t1.relate_tab = ?  and t1.relate_field = ?  and t1.resource_type = ?  and t1.relate_fk = ?";
        List userAuthList = this.dao.findAll(userAuthSql + " \uff03NOTCHECK", Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(new Object[]{"rms_user", "pk_uuid", "PrivilegeLevel", pkuuid})});
        String componentClass = componentAttributeTagsVo.getComponentClass();
        ComponentResVo componentResVo = new ComponentResVo();
        ArrayList<ComponentVo> basic = new ArrayList<ComponentVo>();
        ArrayList<ComponentVo> enhance = new ArrayList<ComponentVo>();
        ArrayList<ComponentVo> layout = new ArrayList<ComponentVo>();
        ArrayList<ComponentVo> custom = new ArrayList<ComponentVo>();
        HashMap<String, List<AttributeVo>> optionsMap = new HashMap<String, List<AttributeVo>>();
        QueryTagsRelationParam tag = new QueryTagsRelationParam();
        tag.setRelationTab("component");
        tag.setRelationField("component_id");
        tag.setTagBelongs(componentAttributeTagsVo.getTagBelongs());
        tag.setTagsId(componentAttributeTagsVo.getTagIds());
        ReturnMsg msgTag = this.iWtIssueService.queryTagsRelation(tag);
        List tagsList = msgTag.getDataList(QueryTagsRelationReturn.class);
        List idList = null;
        Map<Object, Object> listMaps = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)tagsList)) {
            idList = tagsList.stream().map(QueryTagsRelationReturn::getRelationFk).collect(Collectors.toList());
            listMaps = tagsList.stream().collect(Collectors.groupingBy(QueryTagsRelationReturn::getRelationFk));
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        stringBuilder.append("select ct.component_id ,ct.component_name ,ct.component_type ,ct.component_category ,ct.component_scene,ct.component_class ,ct.component_json ,ct.embedded_json,");
        stringBuilder.append(" ct.label_type ,ct.is_level ,ct.display_order ,ct.crt_date ,ct.mdf_date,ct.crt_user ,ct.mdf_user ,ct.data_flag ,");
        stringBuilder.append(" ct.patch_memo ,ct.component_icon ,ct.event_type ,ct.delivery_platform");
        stringBuilder.append(" from component ct where 1=1 ");
        stringBuilder.append(" and ct.data_flag  = ?   and ct.component_class  = ?  and ct.component_category != ?  ");
        list.add(BaseEnum.DataFlag.USABLE.getType());
        list.add(componentClass);
        list.add(PageBaseEnum.ComponentCategory.CUSTOM.getType());
        if (!StrUtils.isNull((Object)componentAttributeTagsVo.getDeliveryPlatform())) {
            String deliveryPlatformList = componentAttributeTagsVo.getDeliveryPlatform();
            String[] platformList = deliveryPlatformList.split(",");
            List<String> platformIdList = Arrays.asList(platformList);
            stringBuilder.append(" and ( ");
            for (int i = 0; i < platformIdList.size(); ++i) {
                if (i == platformIdList.size() - 1) {
                    stringBuilder.append(" ct.delivery_platform like ? ");
                    list.add("%" + platformIdList.get(i) + "%");
                    continue;
                }
                stringBuilder.append(" ct.delivery_platform like ? or ");
                list.add("%" + platformIdList.get(i) + "%");
            }
            stringBuilder.append(")");
        }
        if (CollectionUtils.isNotEmpty(componentAttributeTagsVo.getTagIds())) {
            if (CollectionUtils.isEmpty(idList)) {
                ArrayList componentList = new ArrayList();
                msg.setDataList(componentList, Component.class);
                msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
                return msg.msg();
            }
            stringBuilder.append(" and ct.component_id  in ( ");
            for (int i = 0; i < idList.size(); ++i) {
                if (i == idList.size() - 1) {
                    stringBuilder.append(" ?  ");
                } else {
                    stringBuilder.append(" ?,  ");
                }
                list.add((String)idList.get(i));
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(" order by ct.display_order asc \uff03NOTCHECK");
        List tComponentList = this.dao.findAll(stringBuilder.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(list)});
        Map<Object, Object> finalListMaps = listMaps;
        tComponentList.stream().forEach(o -> {
            if (CollectionUtils.isNotEmpty((Collection)((Collection)finalListMaps.get(o.get("component_id"))))) {
                o.put("tags", finalListMaps.get(o.get("component_id")));
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)tComponentList)) {
            List componentIdList = tComponentList.stream().map(e -> e.get("component_id").toString()).collect(Collectors.toList());
            ComponentAttribute attribute = new ComponentAttribute();
            attribute.where().addEq(AbsModel.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
            attribute.where().addIn(ComponentAttribute.COMPONENT_ID, componentIdList);
            attribute.setOrderBy(ComponentAttribute.COMPONENT_ID.asc(), ComponentAttribute.DISPLAY_ORDER.asc());
            List attributeList = this.dao.findAll((AbsModel)attribute);
            Map<Object, Object> attributeMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)attributeList)) {
                attributeMap = attributeList.stream().collect(Collectors.groupingBy(ComponentAttribute::getComponentId));
            }
            for (Map t : tComponentList) {
                ComponentVo componentVo = new ComponentVo();
                ArrayList<AttributeVo> attributeVos = new ArrayList<AttributeVo>();
                if (CollectionUtils.isNotEmpty((Collection)((Collection)attributeMap.get(t.get("component_id"))))) {
                    for (ComponentAttribute c : (List)attributeMap.get(t.get("component_id"))) {
                        AttributeVo attributeVo = new AttributeVo();
                        attributeVo.setKey(c.getAttributeCode());
                        attributeVo.setLabel(c.getAttributeName());
                        attributeVo.setType(c.getAttributeType());
                        attributeVo.setAttribute_classify(c.getAttributeClassify());
                        attributeVo.setPrivilegeLevel(c.getPrivilegeLevel());
                        attributeVo.setAttributeDesc(c.getAttributeDesc());
                        attributeVo.setElements(JSONObject.parseArray((String)c.getAttributeMulti(), AttributeMultiVo.class));
                        attributeVos.add(attributeVo);
                    }
                }
                if (!StrUtils.isNull(t.get("embedded_json"))) {
                    componentVo.setEmbeddeds(JsonUtils.json2List((String)((String)t.get("embedded_json"))));
                }
                componentVo.setOptions(attributeVos);
                componentVo.setLabel(t.get("component_name").toString());
                componentVo.setType(t.get("component_type").toString());
                componentVo.setEventType(t.get("event_type").toString());
                componentVo.setComponentScene(t.get("component_scene").toString());
                componentVo.setComponentCategory(t.get("component_category").toString());
                componentVo.setIsLevel(t.get("is_level").toString());
                componentVo.setComponentIcon(t.get("component_icon").toString());
                componentVo.setTags((List)t.get("tags"));
                optionsMap.put(t.get("component_type").toString(), attributeVos);
                if (PageBaseEnum.ComponentCategory.BASIC.getType().equals(t.get("component_category").toString())) {
                    basic.add(componentVo);
                    componentResVo.setBasic(basic);
                    continue;
                }
                if (PageBaseEnum.ComponentCategory.ENHANCE.getType().equals(t.get("component_category").toString())) {
                    enhance.add(componentVo);
                    componentResVo.setEnhance(enhance);
                    continue;
                }
                if (PageBaseEnum.ComponentCategory.LAYOUT.getType().equals(t.get("component_category").toString())) {
                    layout.add(componentVo);
                    componentResVo.setLayout(layout);
                    continue;
                }
                if (!PageBaseEnum.ComponentCategory.CUSTOM.getType().equals(t.get("component_category").toString())) continue;
                custom.add(componentVo);
                componentResVo.setCustom(custom);
            }
        }
        componentResVo.setOptionsMap(optionsMap);
        msg.getDataTable().put("components", componentResVo);
        if (CollectionUtils.isNotEmpty((Collection)userAuthList)) {
            msg.getDataTable().put("pkuuidLevel", ((Map)userAuthList.get(0)).get("data_id"));
        } else {
            msg.getDataTable().put("pkuuidLevel", "0");
        }
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public void exportFindJson(String componentIds, String componentClass, HttpServletResponse response) {
        SipProductSyncTask task = new SipProductSyncTask();
        task.setFuncModule("TCOMPONENT");
        task.setTaskType("EXP");
        task.setCrtDate(new Date());
        StringJoiner joiner = new StringJoiner(",");
        String zipFile = "";
        try {
            List componentList;
            String currentTimeMillis = String.valueOf(System.currentTimeMillis());
            String basePath = this.templateConfig.getUploadFormCollectPath() + "/export/component/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis;
            String baseAddress = basePath + "/";
            Component component = new Component();
            component.where().addEq(Component.COMPONENT_CLASS, (Object)componentClass);
            component.where().addEq(Component.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
            if (!StrUtils.isNull((Object)componentIds)) {
                String[] split = componentIds.split(",");
                List<String> strings = Arrays.asList(split);
                if (CollectionUtils.isEmpty(strings)) {
                    Ulog.info((String)"\u4f20\u5165id\u4e3a\u7a7a");
                    throw new BusinessException("\u4f20\u5165id\u4e3a\u7a7a");
                }
                component.where().addIn(Component.COMPONENT_ID, strings);
            }
            if (CollectionUtils.isNotEmpty((Collection)(componentList = this.dao.findAll((AbsModel)component)))) {
                ExportDataVo exportDataVo = new ExportDataVo();
                ArrayList<ComponentJsonVo> componentJsonVoList = new ArrayList<ComponentJsonVo>();
                for (Component c : componentList) {
                    joiner.add(c.getComponentName());
                    ComponentJsonVo componentJson = new ComponentJsonVo();
                    BeanUtils.copyProperties((Object)((Object)c), (Object)((Object)componentJson));
                    String componentId = c.getComponentId();
                    ComponentAttribute componentAttribute = new ComponentAttribute();
                    componentAttribute.where().addEq(ComponentAttribute.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
                    componentAttribute.where().addEq(ComponentAttribute.COMPONENT_ID, (Object)componentId);
                    List attributeList = this.dao.findAll((AbsModel)componentAttribute);
                    componentJson.setAttributeList(attributeList);
                    FmAttributesType attributesType = new FmAttributesType();
                    attributesType.where().addEq(FmAttributesType.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
                    attributesType.where().addEq(FmAttributesType.COMPONENT_TYPE, (Object)c.getComponentType());
                    attributesType = (FmAttributesType)this.dao.findOne((AbsModel)attributesType);
                    componentJson.setAttributeType(attributesType);
                    componentJson.setScpzMaterialTagsRelationList(this.tagsService.findScpzMaterialTagsRelationList(componentId, "component_id", "component"));
                    ArrayList<FmEmbedded> embeddedList = new ArrayList<FmEmbedded>();
                    if (!StrUtils.isNull((Object)c.getEmbeddedJson())) {
                        List list = JsonUtils.json2List((String)c.getEmbeddedJson());
                        list.forEach(l -> {
                            FmEmbedded fmEmbeddedSelect = new FmEmbedded();
                            fmEmbeddedSelect.where().addEq(FmEmbedded.EMBEDDED_ELEMENT_CN, l.get("embedded_element_cn"));
                            fmEmbeddedSelect.where().addEq(FmEmbedded.EMBEDDED_ELEMENT_EN, l.get("embedded_element_en"));
                            fmEmbeddedSelect.where().addIn(FmEmbedded.DELIVERY_PLATFORM, Arrays.asList(l.get("delivery_platform").toString().split(",")));
                            List embeddeds = this.dao.findAll((AbsModel)fmEmbeddedSelect);
                            if (CollectionUtils.isNotEmpty((Collection)embeddeds)) {
                                embeddedList.addAll(embeddeds);
                            }
                        });
                    }
                    componentJson.setEmbeddedList(embeddedList);
                    componentJsonVoList.add(componentJson);
                }
                exportDataVo.setName("component_" + componentClass);
                exportDataVo.setJson(JsonUtils.toJson(componentJsonVoList));
                FilesUtil.createFile(baseAddress + exportDataVo.getName() + ".json");
                FilesUtil.writeToFile(baseAddress + exportDataVo.getName() + ".json", exportDataVo.getJson(), false);
                zipFile = basePath + ".zip";
                Ulog.info((String)("baseAddress----" + baseAddress));
                Ulog.info((String)("zipFile----" + zipFile));
                String zip = FileUtils.zip((String)baseAddress, (String)zipFile, (String[])new String[]{".json", ".xlsx"});
                Ulog.info((String)("zip----" + zip));
                File file = new File(zipFile);
                FileInputStream inputStream = new FileInputStream(file);
                byte[] data = new byte[(int)file.length()];
                inputStream.read(data);
                inputStream.close();
                response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
                response.setContentType("application/octet-stream;charset=ISO8859-1");
                response.addHeader("Content-Length", "" + file.length());
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(currentTimeMillis + ".zip", "UTF-8"));
                ServletOutputStream stream = response.getOutputStream();
                stream.write(data);
                stream.flush();
                stream.close();
                FilesUtil.delFile(baseAddress);
            }
            String taskName = joiner.toString();
            task.setIsZipDel("1");
            task.setTaskName(taskName);
            task.setTaskState("FINISH");
            task.setFinishDate(new Date());
            task.setZipPath(zipFile);
            this.dao.save((AbsModel)task);
        }
        catch (Exception e) {
            e.printStackTrace();
            String taskName = joiner.toString();
            task.setIsZipDel("0");
            task.setTaskName(taskName);
            task.setTaskState("FAIL");
            task.setErrorInfo(e.getMessage());
            task.setFinishDate(new Date());
            this.syncService.saveSyncTask(task, ThreadLocalContext.get().getUser());
            throw new BusinessException(e.getMessage());
        }
    }

    @Override
    public ReturnMsg uploadJson(MultipartFile zipFile) {
        SipProductSyncTask task = new SipProductSyncTask();
        task.setCrtDate(new Date());
        String pathName = this.templateConfig.getUploadFormCollectPath() + "/upload/component/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        Return msg = FilesUtil.unzipFile(zipFile, pathName);
        if (!msg.isSuccessflag()) {
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"));
            return msg.msg();
        }
        File importDir = new File(pathName);
        ArrayList<File> fileList = new ArrayList<File>();
        FilesUtil.getAllFiles(importDir, fileList);
        Ulog.info((String)("\u83b7\u53d6\u9700\u8981\u8bfb\u53d6\u7684\u6587\u4ef6" + JsonUtils.toJson(fileList)));
        StringJoiner joiner = new StringJoiner(",");
        for (File jsonFile : fileList) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
                Throwable throwable = null;
                try {
                    int ch = 0;
                    StringBuilder sb = new StringBuilder();
                    while ((ch = ((Reader)reader).read()) != -1) {
                        sb.append((char)ch);
                    }
                    String jsonStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u9875\u9762/\u4e1a\u52a1\u7ec4\u4ef6\u6570\u636e\u4e3a" + jsonStr));
                    List componentJsonVoList = JSONObject.parseArray((String)jsonStr, ComponentJsonVo.class);
                    for (ComponentJsonVo componentJsonVo : componentJsonVoList) {
                        String componentId = componentJsonVo.getComponentId();
                        String componentType = componentJsonVo.getComponentType();
                        joiner.add(componentJsonVo.getComponentName());
                        int cCount = this.dao.delete(Component.n().where().addEq(Component.COMPONENT_ID, (Object)componentId).model());
                        int caCount = this.dao.delete(ComponentAttribute.n().where().addEq(ComponentAttribute.COMPONENT_ID, (Object)componentId).model());
                        int atCount = this.dao.delete(FmAttributesType.n().where().addEq(FmAttributesType.COMPONENT_TYPE, (Object)componentType).model());
                        Component component = new Component();
                        BeanUtils.copyProperties((Object)((Object)componentJsonVo), (Object)((Object)component));
                        this.dao.save((AbsModel)component);
                        if (CollectionUtils.isNotEmpty(componentJsonVo.getAttributeList())) {
                            this.dao.save(componentJsonVo.getAttributeList());
                        }
                        if (!StrUtils.isNull((Object)((Object)componentJsonVo.getAttributeType()))) {
                            this.dao.save((AbsModel)componentJsonVo.getAttributeType());
                        }
                        if (CollectionUtils.isNotEmpty(componentJsonVo.getScpzMaterialTagsRelationList())) {
                            this.tagsService.saveScpzMaterialTagsRelationList(componentId, "component_id", "component", componentJsonVo.getScpzMaterialTagsRelationList());
                        }
                        if (!CollectionUtils.isNotEmpty(componentJsonVo.getEmbeddedList())) continue;
                        List<FmEmbedded> embeddedList = componentJsonVo.getEmbeddedList();
                        this.dao.delete(FmEmbedded.n().where().addIn(FmEmbedded.SERNO, embeddedList.stream().map(AbsModel::getSerno).collect(Collectors.toList())).model());
                        this.dao.save(embeddedList);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Ulog.error((Throwable)e);
                e.printStackTrace();
                msg.setFailMsg(new Message("6050005", "\u5bfc\u5165\u5931\u8d25"));
                return msg.msg();
            }
        }
        FilesUtil.delFile(pathName);
        String taskName = joiner.toString();
        task.setFuncModule("TCOMPONENT");
        task.setTaskType("IMP");
        task.setTaskName(taskName);
        task.setTaskState("FINISH");
        task.setFinishDate(new Date());
        this.dao.save((AbsModel)task);
        msg.setSuccessMsg(new Message("6050004", "\u5bfc\u5165\u6210\u529f"));
        return msg.msg();
    }

    private void setComponentList(List<Component> componentList, Map<String, Object> o) {
        Component components = new Component();
        components.setComponentId(o.get("component_id").toString());
        components.setComponentName(o.get("component_name").toString());
        components.setComponentType(o.get("component_type").toString());
        components.setComponentCategory(o.get("component_category").toString());
        components.setComponentScene(o.get("component_scene").toString());
        components.setComponentClass(o.get("component_class").toString());
        components.setComponentJson(o.get("component_json").toString());
        components.setIsLevel(o.get("is_level").toString());
        if (o.get("display_order") != null & !o.get("display_order").equals("")) {
            Integer order = (Integer)o.get("display_order");
            components.setDisplayOrder(order);
        }
        List maps = (List)o.get("tags");
        ArrayList<TagsVo> TagsVoList = new ArrayList<TagsVo>();
        if (!ObjectUtil.isEmpty((Object)maps)) {
            for (Map s : maps) {
                TagsVo tagsVo = new TagsVo();
                String tagId = (String)s.get("tag_id");
                String tagName = (String)s.get("tag_name");
                tagsVo.setTagId(tagId);
                tagsVo.setTagName(tagName);
                TagsVoList.add(tagsVo);
            }
        }
        components.setTagsVoList(TagsVoList);
        componentList.add(components);
    }

    private List<Map<String, Object>> getComponent(ComponentAttributeTagsVo componentAttributeTagsVo, String componentClass) {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> sqlParam = new ArrayList<String>();
        sql.append("select\n\tct.component_id ,\n\tct.component_name ,\n\tct.component_type ,\n\tct.component_category ,\n\tct.component_scene ,\n\tct.component_class ,\n\tct.component_json ,\n\tct.label_type ,\n\tct.is_level,\n\tct.display_order \nfrom\n\tcomponent ct\nleft join scpz_material_tags_relation sm on\n\tct.component_id  = sm.relation_fk\n\tand sm.relation_tab =  ? \n\tand sm.relation_field =  ? \nleft join scpz_tags st on\n\tsm.tag_id = st.tag_id\nwhere ct.data_flag = ? ");
        sqlParam.add("component");
        sqlParam.add("component_id");
        sqlParam.add(BaseEnum.DataFlag.USABLE.getType());
        sql.append(" AND ct.component_class = ? AND ct.component_category != ? ");
        sqlParam.add(componentClass);
        sqlParam.add(PageBaseEnum.ComponentCategory.CUSTOM.getType());
        List<String> tagIdsList = componentAttributeTagsVo.getTagIds();
        if (CollectionUtils.isNotEmpty(tagIdsList)) {
            sql.append(" and sm.tag_id  in ( ");
            for (int i = 0; i < tagIdsList.size(); ++i) {
                if (i == tagIdsList.size() - 1) {
                    sql.append(" ?  ");
                } else {
                    sql.append(" ?,  ");
                }
                sqlParam.add(tagIdsList.get(i));
            }
            sql.append(")");
        }
        sql.append(" group by ct.component_id ");
        sql.append(" order by ct.display_order ASC ");
        List componentList = this.dao.findAll(sql.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(sqlParam)});
        return componentList;
    }
}

