/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.inform.param;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.base.param.SaveRuleUsedParam;
import com.newtouch.base.utils.QueryUtils;
import com.newtouch.inform.model.QsnCoreQuestions;
import com.newtouch.inform.model.QsnQuestionBlanks;
import com.newtouch.inform.model.QsnQuestionOptions;
import com.newtouch.inform.model.QsnQuestions;
import com.newtouch.inform.param.QsnQuestionBlanksInfo;
import com.newtouch.inform.param.QsnQuestionOptionsInfo;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class QsnQuestionsInfo {
    @JsonProperty(value="qsnQuestions")
    private QsnQuestions qsnQuestions;
    @JsonProperty(value="qsnCoreQuestions")
    private QsnCoreQuestions qsnCoreQuestions;
    @JsonProperty(value="qsnQuestionBlanksInfos")
    private List<QsnQuestionBlanksInfo> qsnQuestionBlanksInfos;
    @JsonProperty(value="qsnQuestionOptionsInfos")
    private List<QsnQuestionOptionsInfo> qsnQuestionOptionsInfos;
    @JsonProperty(value="ruleInfos")
    private List<SaveRuleUsedParam> ruleInfos;

    public void load(String qsnUuid, String isCore) {
        QueryUtils query = (QueryUtils)SpringContext.getBean(QueryUtils.class);
        if (StrUtils.isNull((Object)((Object)this.qsnQuestions))) {
            this.qsnQuestions = query.queryQsnQuestions(qsnUuid);
        }
        if (StrUtils.isNull((Object)((Object)this.qsnQuestions))) {
            return;
        }
        if ("Y".equals(isCore)) {
            this.qsnCoreQuestions = query.queryQsnCoreQuestions(this.qsnQuestions.getCoreQuestionUuid());
        }
        List<QsnQuestionBlanks> qsnQuestionBlanksList = query.queryQsnQuestionBlanks(qsnUuid);
        this.qsnQuestionBlanksInfos = new ArrayList<QsnQuestionBlanksInfo>();
        if (CollectionUtils.isNotEmpty(qsnQuestionBlanksList)) {
            for (QsnQuestionBlanks qqb : qsnQuestionBlanksList) {
                QsnQuestionBlanksInfo qqbi = new QsnQuestionBlanksInfo();
                qqbi.setQsnQuestionBlank(qqb);
                qqbi.load(qqb.getBlankUuid());
                this.qsnQuestionBlanksInfos.add(qqbi);
            }
        }
        List<QsnQuestionOptions> qsnQuestionOptions = query.queryQsnQuestionOptions("qsn_uuid", "qsn_questions", qsnUuid);
        this.qsnQuestionOptionsInfos = new ArrayList<QsnQuestionOptionsInfo>();
        if (CollectionUtils.isNotEmpty(qsnQuestionOptions)) {
            for (QsnQuestionOptions qqo : qsnQuestionOptions) {
                QsnQuestionOptionsInfo qqoi = new QsnQuestionOptionsInfo();
                qqoi.load(qqo.getOptionUuid());
                qqoi.setQsnQuestionOption(qqo);
                this.qsnQuestionOptionsInfos.add(qqoi);
            }
        }
    }

    public QsnQuestions getQsnQuestions() {
        return this.qsnQuestions;
    }

    public QsnCoreQuestions getQsnCoreQuestions() {
        return this.qsnCoreQuestions;
    }

    public List<QsnQuestionBlanksInfo> getQsnQuestionBlanksInfos() {
        return this.qsnQuestionBlanksInfos;
    }

    public List<QsnQuestionOptionsInfo> getQsnQuestionOptionsInfos() {
        return this.qsnQuestionOptionsInfos;
    }

    public List<SaveRuleUsedParam> getRuleInfos() {
        return this.ruleInfos;
    }

    @JsonProperty(value="qsnQuestions")
    public void setQsnQuestions(QsnQuestions qsnQuestions) {
        this.qsnQuestions = qsnQuestions;
    }

    @JsonProperty(value="qsnCoreQuestions")
    public void setQsnCoreQuestions(QsnCoreQuestions qsnCoreQuestions) {
        this.qsnCoreQuestions = qsnCoreQuestions;
    }

    @JsonProperty(value="qsnQuestionBlanksInfos")
    public void setQsnQuestionBlanksInfos(List<QsnQuestionBlanksInfo> qsnQuestionBlanksInfos) {
        this.qsnQuestionBlanksInfos = qsnQuestionBlanksInfos;
    }

    @JsonProperty(value="qsnQuestionOptionsInfos")
    public void setQsnQuestionOptionsInfos(List<QsnQuestionOptionsInfo> qsnQuestionOptionsInfos) {
        this.qsnQuestionOptionsInfos = qsnQuestionOptionsInfos;
    }

    @JsonProperty(value="ruleInfos")
    public void setRuleInfos(List<SaveRuleUsedParam> ruleInfos) {
        this.ruleInfos = ruleInfos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QsnQuestionsInfo)) {
            return false;
        }
        QsnQuestionsInfo other = (QsnQuestionsInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QsnQuestions this$qsnQuestions = this.getQsnQuestions();
        QsnQuestions other$qsnQuestions = other.getQsnQuestions();
        if (this$qsnQuestions == null ? other$qsnQuestions != null : !((Object)((Object)this$qsnQuestions)).equals((Object)other$qsnQuestions)) {
            return false;
        }
        QsnCoreQuestions this$qsnCoreQuestions = this.getQsnCoreQuestions();
        QsnCoreQuestions other$qsnCoreQuestions = other.getQsnCoreQuestions();
        if (this$qsnCoreQuestions == null ? other$qsnCoreQuestions != null : !((Object)((Object)this$qsnCoreQuestions)).equals((Object)other$qsnCoreQuestions)) {
            return false;
        }
        List<QsnQuestionBlanksInfo> this$qsnQuestionBlanksInfos = this.getQsnQuestionBlanksInfos();
        List<QsnQuestionBlanksInfo> other$qsnQuestionBlanksInfos = other.getQsnQuestionBlanksInfos();
        if (this$qsnQuestionBlanksInfos == null ? other$qsnQuestionBlanksInfos != null : !((Object)this$qsnQuestionBlanksInfos).equals(other$qsnQuestionBlanksInfos)) {
            return false;
        }
        List<QsnQuestionOptionsInfo> this$qsnQuestionOptionsInfos = this.getQsnQuestionOptionsInfos();
        List<QsnQuestionOptionsInfo> other$qsnQuestionOptionsInfos = other.getQsnQuestionOptionsInfos();
        if (this$qsnQuestionOptionsInfos == null ? other$qsnQuestionOptionsInfos != null : !((Object)this$qsnQuestionOptionsInfos).equals(other$qsnQuestionOptionsInfos)) {
            return false;
        }
        List<SaveRuleUsedParam> this$ruleInfos = this.getRuleInfos();
        List<SaveRuleUsedParam> other$ruleInfos = other.getRuleInfos();
        return !(this$ruleInfos == null ? other$ruleInfos != null : !((Object)this$ruleInfos).equals(other$ruleInfos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QsnQuestionsInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QsnQuestions $qsnQuestions = this.getQsnQuestions();
        result = result * 59 + ($qsnQuestions == null ? 43 : ((Object)((Object)$qsnQuestions)).hashCode());
        QsnCoreQuestions $qsnCoreQuestions = this.getQsnCoreQuestions();
        result = result * 59 + ($qsnCoreQuestions == null ? 43 : ((Object)((Object)$qsnCoreQuestions)).hashCode());
        List<QsnQuestionBlanksInfo> $qsnQuestionBlanksInfos = this.getQsnQuestionBlanksInfos();
        result = result * 59 + ($qsnQuestionBlanksInfos == null ? 43 : ((Object)$qsnQuestionBlanksInfos).hashCode());
        List<QsnQuestionOptionsInfo> $qsnQuestionOptionsInfos = this.getQsnQuestionOptionsInfos();
        result = result * 59 + ($qsnQuestionOptionsInfos == null ? 43 : ((Object)$qsnQuestionOptionsInfos).hashCode());
        List<SaveRuleUsedParam> $ruleInfos = this.getRuleInfos();
        result = result * 59 + ($ruleInfos == null ? 43 : ((Object)$ruleInfos).hashCode());
        return result;
    }

    public String toString() {
        return "QsnQuestionsInfo(qsnQuestions=" + (Object)((Object)this.getQsnQuestions()) + ", qsnCoreQuestions=" + (Object)((Object)this.getQsnCoreQuestions()) + ", qsnQuestionBlanksInfos=" + this.getQsnQuestionBlanksInfos() + ", qsnQuestionOptionsInfos=" + this.getQsnQuestionOptionsInfos() + ", ruleInfos=" + this.getRuleInfos() + ")";
    }
}

