/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.web.controller;

import com.newtouch.base.model.QsnPaper;
import com.newtouch.base.service.PaperConfigService;
import com.newtouch.base.vo.PaperQueryVo;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.utils.JsonUtils;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/paper"})
public class PaperConfigController {
    @Autowired
    private PaperConfigService paperConfigService;

    @RequestMapping(value={"/queryPaper.do"})
    public String queryPaper(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        PaperQueryVo paperQueryVo = (PaperQueryVo)JsonUtils.map2Class((Map)param, PaperQueryVo.class);
        ReturnMsg returnMsg = this.paperConfigService.queryPaper(paperQueryVo);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/deletePaper.do"})
    public String deletePaper(HttpServletRequest request) {
        Map map = RequestUtils.getRequestMap((HttpServletRequest)request);
        ReturnMsg returnMsg = this.paperConfigService.deletePaper(map);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/export.do"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String paperUuids = map.get("paper_uuid");
        this.paperConfigService.exportJson(paperUuids, response);
    }

    @RequestMapping(value={"/upload.do"})
    public String upload(MultipartFile zipFile) {
        ReturnMsg returnMsg = this.paperConfigService.uploadPaper(zipFile);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/queryPaperCache.do"})
    public String queryPaperCache(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        QsnPaper qsnPaper = (QsnPaper)((Object)JsonUtils.map2Class((Map)param, QsnPaper.class));
        ReturnMsg returnMsg = this.paperConfigService.queryPaperCache(qsnPaper);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/cachePaperRemove.do"})
    public String cachePaperRemove(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String paperUuid = map.get("paper_uuid");
        String templateId = map.get("template_id");
        ReturnMsg returnMsg = this.paperConfigService.cachePaperRemove(paperUuid, templateId);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }

    @RequestMapping(value={"/queryPaperDetail.do"})
    public String queryPaperDetail(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String paperUuid = map.get("paper_uuid");
        String templateId = map.get("template_id");
        ReturnMsg returnMsg = this.paperConfigService.queryPaperDetail(paperUuid, templateId);
        return RequestUtils.return2Json((ReturnMsg)returnMsg);
    }
}

