/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.vo.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.base.enums.RelateEnum;
import com.newtouch.base.model.FmCollection;
import com.newtouch.base.model.QsnPaper;
import com.newtouch.base.model.QsnPaperTemplate;
import com.newtouch.base.utils.export.EqualsUtils;
import com.newtouch.base.utils.export.ExportQueryUtils;
import com.newtouch.base.utils.export.UpdateUtils;
import com.newtouch.base.vo.export.QsnPaperTemplateInfo;
import com.newtouch.base.vo.export.SmtrInfo;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class PaperAllInfo {
    @JsonProperty(value="qsnPaper")
    private QsnPaper qsnPaper;
    @JsonProperty(value="fmCollection")
    private FmCollection fmCollection;
    @JsonProperty(value="qsnPaperTemplateList")
    private List<QsnPaperTemplateInfo> qsnPaperTemplateList;
    @JsonProperty(value="smtrList")
    private List<SmtrInfo> smtrList;

    public PaperAllInfo load(String paperUuid) {
        ExportQueryUtils query = (ExportQueryUtils)SpringContext.getBean(ExportQueryUtils.class);
        this.qsnPaper = query.queryPaper(paperUuid);
        if (StrUtils.isNull((Object)((Object)this.qsnPaper))) {
            return this;
        }
        this.fmCollection = query.queryFmCollection(this.qsnPaper.getCollId());
        this.qsnPaperTemplateList = new ArrayList<QsnPaperTemplateInfo>();
        List<QsnPaperTemplate> qsnPaperTemplates = query.queryQsnPaperTemplateList(paperUuid);
        if (CollectionUtils.isNotEmpty(qsnPaperTemplates)) {
            for (QsnPaperTemplate qpt : qsnPaperTemplates) {
                QsnPaperTemplateInfo qpti = new QsnPaperTemplateInfo();
                qpti.setQsnPaperTemplate(qpt);
                qpti.load(qpt, this.qsnPaper.getPaperType());
                this.qsnPaperTemplateList.add(qpti);
            }
        }
        this.smtrList = new ArrayList<SmtrInfo>();
        List<ScpzMaterialTagsRelation> scpzMaterialTagsRelations = query.querySmtr(paperUuid, RelateEnum.paper.getRelateField(), RelateEnum.paper.getRelateTab());
        if (CollectionUtils.isNotEmpty(scpzMaterialTagsRelations)) {
            for (ScpzMaterialTagsRelation smtr : scpzMaterialTagsRelations) {
                SmtrInfo si = new SmtrInfo();
                si.setSmtr(smtr);
                si.load(smtr.getTagId());
                this.smtrList.add(si);
            }
        }
        return this;
    }

    public void merge(PaperAllInfo paperAllInfo) {
        this.qsnPaper = EqualsUtils.merge(this.qsnPaper, paperAllInfo.getQsnPaper());
        this.fmCollection = EqualsUtils.merge(this.fmCollection, paperAllInfo.getFmCollection());
        this.qsnPaperTemplateList = EqualsUtils.merge(this.qsnPaperTemplateList, paperAllInfo.getQsnPaperTemplateList(), QsnPaperTemplateInfo.class);
        this.smtrList = EqualsUtils.merge(this.smtrList, paperAllInfo.getSmtrList(), SmtrInfo.class);
    }

    public void save() {
        UpdateUtils update = (UpdateUtils)SpringContext.getBean(UpdateUtils.class);
        if (this.qsnPaper != null) {
            update.update(this.qsnPaper);
        }
        if (this.fmCollection != null) {
            update.update(this.fmCollection);
        }
        if (this.qsnPaperTemplateList != null) {
            this.qsnPaperTemplateList.forEach(m -> m.save());
        }
        if (this.smtrList != null) {
            this.smtrList.forEach(m -> m.save());
        }
    }

    public QsnPaper getQsnPaper() {
        return this.qsnPaper;
    }

    public FmCollection getFmCollection() {
        return this.fmCollection;
    }

    public List<QsnPaperTemplateInfo> getQsnPaperTemplateList() {
        return this.qsnPaperTemplateList;
    }

    public List<SmtrInfo> getSmtrList() {
        return this.smtrList;
    }

    @JsonProperty(value="qsnPaper")
    public void setQsnPaper(QsnPaper qsnPaper) {
        this.qsnPaper = qsnPaper;
    }

    @JsonProperty(value="fmCollection")
    public void setFmCollection(FmCollection fmCollection) {
        this.fmCollection = fmCollection;
    }

    @JsonProperty(value="qsnPaperTemplateList")
    public void setQsnPaperTemplateList(List<QsnPaperTemplateInfo> qsnPaperTemplateList) {
        this.qsnPaperTemplateList = qsnPaperTemplateList;
    }

    @JsonProperty(value="smtrList")
    public void setSmtrList(List<SmtrInfo> smtrList) {
        this.smtrList = smtrList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaperAllInfo)) {
            return false;
        }
        PaperAllInfo other = (PaperAllInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QsnPaper this$qsnPaper = this.getQsnPaper();
        QsnPaper other$qsnPaper = other.getQsnPaper();
        if (this$qsnPaper == null ? other$qsnPaper != null : !((Object)((Object)this$qsnPaper)).equals((Object)other$qsnPaper)) {
            return false;
        }
        FmCollection this$fmCollection = this.getFmCollection();
        FmCollection other$fmCollection = other.getFmCollection();
        if (this$fmCollection == null ? other$fmCollection != null : !((Object)((Object)this$fmCollection)).equals((Object)other$fmCollection)) {
            return false;
        }
        List<QsnPaperTemplateInfo> this$qsnPaperTemplateList = this.getQsnPaperTemplateList();
        List<QsnPaperTemplateInfo> other$qsnPaperTemplateList = other.getQsnPaperTemplateList();
        if (this$qsnPaperTemplateList == null ? other$qsnPaperTemplateList != null : !((Object)this$qsnPaperTemplateList).equals(other$qsnPaperTemplateList)) {
            return false;
        }
        List<SmtrInfo> this$smtrList = this.getSmtrList();
        List<SmtrInfo> other$smtrList = other.getSmtrList();
        return !(this$smtrList == null ? other$smtrList != null : !((Object)this$smtrList).equals(other$smtrList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaperAllInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QsnPaper $qsnPaper = this.getQsnPaper();
        result = result * 59 + ($qsnPaper == null ? 43 : ((Object)((Object)$qsnPaper)).hashCode());
        FmCollection $fmCollection = this.getFmCollection();
        result = result * 59 + ($fmCollection == null ? 43 : ((Object)((Object)$fmCollection)).hashCode());
        List<QsnPaperTemplateInfo> $qsnPaperTemplateList = this.getQsnPaperTemplateList();
        result = result * 59 + ($qsnPaperTemplateList == null ? 43 : ((Object)$qsnPaperTemplateList).hashCode());
        List<SmtrInfo> $smtrList = this.getSmtrList();
        result = result * 59 + ($smtrList == null ? 43 : ((Object)$smtrList).hashCode());
        return result;
    }

    public String toString() {
        return "PaperAllInfo(qsnPaper=" + (Object)((Object)this.getQsnPaper()) + ", fmCollection=" + (Object)((Object)this.getFmCollection()) + ", qsnPaperTemplateList=" + this.getQsnPaperTemplateList() + ", smtrList=" + this.getSmtrList() + ")";
    }
}

