/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.flow.service.impl;

import com.newtouch.base.model.FmCollection;
import com.newtouch.base.model.FmTemplate;
import com.newtouch.base.service.FormTemplateService;
import com.newtouch.base.vo.FmFlowTemplateParam;
import com.newtouch.base.vo.FmTemplateVo;
import com.newtouch.flow.model.FmFlow;
import com.newtouch.flow.model.FmFlowRelation;
import com.newtouch.flow.model.FmNode;
import com.newtouch.flow.model.FmNodeTemplate;
import com.newtouch.flow.model.FmProductFlow;
import com.newtouch.flow.model.FmRouter;
import com.newtouch.flow.param.FmNodeAndRouterParam;
import com.newtouch.flow.param.QueryFmNodeParam;
import com.newtouch.flow.param.QueryTagsRelationReturn;
import com.newtouch.flow.service.IFmNodeService;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FmNodeServiceImpl
implements IFmNodeService {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    FormTemplateService formTemplateService;

    @Override
    public ReturnMsg saveFmNodeAndRouter(FmNodeAndRouterParam saveFmNodeAndRouterParam) {
        Return msg = new Return();
        String flowUuid = saveFmNodeAndRouterParam.getFlowUuid();
        if (StrUtils.isNull((Object)flowUuid)) {
            msg.setFailMsg(new Message("6080001", "\u6d41\u7a0bid\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        List<FmNode> fmNodeList = saveFmNodeAndRouterParam.getNodes();
        long startCount = fmNodeList.stream().filter(node -> "start-node".equals(node.getNodeType())).count();
        if (startCount > 1L) {
            throw new BusinessException("\u6d41\u7a0b\u4e2d\u5f00\u59cb\u8282\u70b9\u53ea\u80fd\u6709\u4e00\u4e2a,\u8be5\u6d41\u7a0b\u5b58\u5728\u591a\u4e2a\u5f00\u59cb\u8282\u70b9\uff0c\u8bf7\u4fee\u6539\uff01");
        }
        long endCount = fmNodeList.stream().filter(node -> "end-node".equals(node.getNodeType())).count();
        if (endCount > 1L) {
            throw new BusinessException("\u6d41\u7a0b\u4e2d\u7ed3\u675f\u8282\u70b9\u53ea\u80fd\u6709\u4e00\u4e2a,\u8be5\u6d41\u7a0b\u5b58\u5728\u591a\u4e2a\u7ed3\u675f\u8282\u70b9\uff0c\u8bf7\u4fee\u6539\uff01");
        }
        Boolean result = fmNodeList.stream().filter(node -> !"if-node".equals(node.getNodeType())).filter(node -> StrUtils.isNull((Object)node.getRelateFk())).limit(1L).count() > 0L;
        if (result.booleanValue()) {
            throw new BusinessException("\u6d41\u7a0b\u4e2d\u5b58\u5728\u8282\u70b9\u672a\u5173\u8054\u9875\u9762\u7684\u60c5\u51b5,\u8bf7\u4fee\u6539\uff01");
        }
        FmProductFlow fmProductFlowSelect = new FmProductFlow();
        fmProductFlowSelect.where().addEq(FmProductFlow.FLOW_UUID, (Object)flowUuid);
        List fmProductFlowDbList = this.dao.findAll((AbsModel)fmProductFlowSelect);
        if (CollectionUtils.isNotEmpty((Collection)fmProductFlowDbList)) {
            for (FmProductFlow fpf : fmProductFlowDbList) {
                if (!"ON".equals(fpf.getState())) continue;
                msg.setFailMsg(new Message("6080002", "\u5df2\u7ecf\u5173\u8054\u4ea7\u54c1\u7684\u6d41\u7a0b,\u4e0d\u53ef\u8fdb\u884c\u4fee\u6539"));
                return msg.msg();
            }
        }
        String flowUrl = saveFmNodeAndRouterParam.getFlowUrl();
        FmFlow fmFlow = new FmFlow();
        fmFlow.setFlowUrl(flowUrl);
        fmFlow.where().addEq(FmFlow.FLOW_UUID, (Object)flowUuid);
        this.dao.update((AbsModel)fmFlow);
        FmNode fmNode = new FmNode();
        fmNode.where().addEq(FmNode.FLOW_UUID, (Object)flowUuid);
        this.dao.delete((AbsModel)fmNode);
        FmRouter fmRouter = new FmRouter();
        fmRouter.where().addEq(FmRouter.FLOW_UUID, (Object)flowUuid);
        this.dao.delete((AbsModel)fmRouter);
        FmFlowRelation flowRelation = new FmFlowRelation();
        flowRelation.where().addEq(FmFlowRelation.FLOW_UUID, (Object)flowUuid);
        this.dao.delete((AbsModel)flowRelation);
        List<FmRouter> fmRouterList = saveFmNodeAndRouterParam.getEdges();
        ArrayList fmFlowRelations = new ArrayList();
        if (CollectionUtils.isNotEmpty(fmNodeList)) {
            fmNodeList.forEach(n -> {
                n.setFlowUuid(flowUuid);
                if (n.getNodeType().equals("child_flow")) {
                    FmFlowRelation fmFlowRelation = new FmFlowRelation();
                    fmFlowRelation.setChildFlowUuid(n.getRelateFk());
                    fmFlowRelation.setFlowUuid(flowUuid);
                    fmFlowRelations.add(fmFlowRelation);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(fmRouterList)) {
            fmRouterList.forEach(r -> r.setFlowUuid(flowUuid));
        }
        if (CollectionUtils.isNotEmpty(fmFlowRelations)) {
            this.dao.save(fmFlowRelations);
        }
        this.dao.save(fmNodeList);
        this.dao.save(fmRouterList);
        msg.setSuccessMsg(new Message("2010005", "\u4fdd\u5b58\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryFmNodeAndRouter(QueryFmNodeParam queryFmNodeParam) {
        Return msg = new Return();
        String flowUuid = queryFmNodeParam.getFlowUuid();
        if (StrUtils.isNull((Object)flowUuid)) {
            msg.setFailMsg(new Message("6080001", "\u6d41\u7a0bid\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        FmFlow fmFlow = new FmFlow();
        fmFlow.where().addEq(FmFlow.FLOW_UUID, (Object)flowUuid);
        FmFlow fmFlowDb = (FmFlow)this.dao.findOne((AbsModel)fmFlow);
        FmNode fmNode = new FmNode();
        fmNode.where().addEq(FmNode.FLOW_UUID, (Object)flowUuid);
        List fmNodeList = this.dao.findAll((AbsModel)fmNode);
        FmRouter fmRouter = new FmRouter();
        fmRouter.where().addEq(FmRouter.FLOW_UUID, (Object)flowUuid);
        List fmRouterList = this.dao.findAll((AbsModel)fmRouter);
        ScpzMaterialTagsRelation scpzMaterialTagsRelation = new ScpzMaterialTagsRelation();
        scpzMaterialTagsRelation.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)"fm_flow");
        scpzMaterialTagsRelation.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)"flow_uuid");
        scpzMaterialTagsRelation.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)flowUuid);
        List scpzMaterialTagsRelations = this.dao.findAll((AbsModel)scpzMaterialTagsRelation);
        FmNodeAndRouterParam fmNodeAndRouterParam = new FmNodeAndRouterParam();
        fmNodeAndRouterParam.setFlowUuid(flowUuid);
        fmNodeAndRouterParam.setFmFlow(fmFlowDb);
        fmNodeAndRouterParam.setNodes(fmNodeList);
        fmNodeAndRouterParam.setEdges(fmRouterList);
        fmNodeAndRouterParam.setTags(scpzMaterialTagsRelations);
        msg.setDataTable(new Object[]{fmNodeAndRouterParam});
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg getFlowFormId(FmFlowTemplateParam fmFlowTemplateParam) {
        Return msg = new Return();
        String templateId = fmFlowTemplateParam.getRelateFk();
        ReturnMsg fmNodeTemplateMsg = this.findFmNodeTemplate(fmFlowTemplateParam);
        FmNodeTemplate fmNodeTemplate = new FmNodeTemplate();
        if (!fmNodeTemplateMsg.isSuccessflag()) {
            return fmNodeTemplateMsg;
        }
        fmNodeTemplate = (FmNodeTemplate)((Object)fmNodeTemplateMsg.getDataTable((Object)"fmNodeTemplate", FmNodeTemplate.class));
        if (fmNodeTemplate != null) {
            templateId = fmNodeTemplate.getTemplateId();
        }
        msg.getDataTable().put("template_id", templateId);
        msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg updateFlowForm(FmFlowTemplateParam fmFlowTemplateParam) {
        Return msg = new Return();
        String relateFk = fmFlowTemplateParam.getRelateFk();
        ReturnMsg fmNodeTemplateMsg = this.findFmNodeTemplate(fmFlowTemplateParam);
        FmNodeTemplate fmNodeTemplate = new FmNodeTemplate();
        if (!fmNodeTemplateMsg.isSuccessflag()) {
            return fmNodeTemplateMsg;
        }
        fmNodeTemplate = (FmNodeTemplate)((Object)fmNodeTemplateMsg.getDataTable((Object)"fmNodeTemplate", FmNodeTemplate.class));
        String templateId = "";
        if (fmNodeTemplate != null) {
            templateId = fmNodeTemplate.getTemplateId();
        } else {
            FmTemplateVo fmTemplateVo = new FmTemplateVo();
            fmTemplateVo.setTemplateId(relateFk);
            templateId = UUID.uuid();
            fmTemplateVo.setTemplateIdNew(templateId);
            this.formTemplateService.copyFormTemplate(fmTemplateVo);
            FmProductFlow fpfSelect = new FmProductFlow();
            fpfSelect.where().addEq(FmProductFlow.ADD_BATCH, (Object)fmFlowTemplateParam.getAddBatch());
            List fpfDbAll = this.dao.findAll((AbsModel)fpfSelect);
            for (FmProductFlow fpf : fpfDbAll) {
                fmNodeTemplate = new FmNodeTemplate();
                BeanUtils.copyProperties((Object)fmFlowTemplateParam, (Object)((Object)fmNodeTemplate));
                fmNodeTemplate.setProductFlowUuid(fpf.getProductFlowUuid());
                fmNodeTemplate.setOldTemplateId(relateFk);
                fmNodeTemplate.setTemplateId(templateId);
                fmNodeTemplate.setNodeTemplateUuid(UUID.uuid());
                this.dao.save((AbsModel)fmNodeTemplate);
            }
        }
        msg.getDataTable().put("template_id", templateId);
        msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryFlowRenderMethods(FmFlowTemplateParam fmFlowTemplateParam) {
        Return msg = new Return();
        String flowUuid = fmFlowTemplateParam.getFlowUuid();
        if (StrUtils.isNull((Object)flowUuid)) {
            return msg.msg();
        }
        FmFlow tempFlow = new FmFlow();
        tempFlow.where().addEq(FmFlow.FLOW_UUID, (Object)flowUuid);
        FmFlow flowOne = (FmFlow)this.dao.findOne((AbsModel)tempFlow);
        String renderMethod = "";
        if (flowOne != null && !StrUtils.isNull((Object)flowOne.getCollId())) {
            FmCollection fmCollectionTemp = new FmCollection();
            fmCollectionTemp.where().addEq(FmCollection.COLL_ID, (Object)flowOne.getCollId());
            FmCollection fmCollection = (FmCollection)this.dao.findOne((AbsModel)fmCollectionTemp);
            renderMethod = fmCollection.getRenderMethod();
        }
        msg.getDataTable().put("render_method", renderMethod);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryFlowFormList(FmFlowTemplateParam fmFlowTemplateParam) {
        Return msg = new Return();
        String flowUuid = fmFlowTemplateParam.getFlowUuid();
        String productFlowUuid = fmFlowTemplateParam.getProductFlowUuid();
        if (StrUtils.isNull((Object)flowUuid) || StrUtils.isNull((Object)productFlowUuid)) {
            msg.setFailMsg(new Message("6020006", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        String sql = "select fn.node_order,fn.relate_fk,fn.serno,fn.node_name,fn.relate_tab,fn.node_type,fn.flow_uuid,fn.node_no,fn.relate_field, fnt.template_id ,fnt.product_flow_uuid, ft.embedded_json, ft.template_code, ft.use_scene, ft.delivery_platform, ft.state, ft.is_edit, fc.coll_const, fc.coll_id, fc.coll_name, fc.render_method from fm_node fn left join fm_node_template fnt \non fn.relate_fk = fnt.old_template_id and fn.node_no  = fnt.node_no \nand  fnt.data_flag = ? and fnt.product_flow_uuid = ? left join fm_template ft on ft.template_id = fnt.old_template_id \nleft join fm_flow ff on ff.flow_uuid = fn.flow_uuid \nleft join fm_collection fc on fc.coll_id = ff.coll_id  \nwhere (fn.flow_uuid = ? or fn.flow_uuid in (select child_flow_uuid from fm_flow_relation start with flow_uuid = ? connect by prior child_flow_uuid  = flow_uuid)) \nand fn.data_flag = ? and node_type != ? order by fn.node_order";
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add(productFlowUuid);
        list.add(flowUuid);
        list.add(flowUuid);
        list.add("1");
        list.add("if-node");
        List fmNodeList = this.dao.findAll(sql, Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(list)});
        ArrayList<Map> returnList = new ArrayList<Map>();
        if (CollectionUtils.isNotEmpty((Collection)fmNodeList)) {
            int i = 1;
            for (Map fmNode : fmNodeList) {
                String templateId = fmNode.get("relate_fk").toString();
                if (fmNode.containsKey("template_id") && !StrUtils.isNull(fmNode.get("template_id"))) {
                    templateId = fmNode.get("template_id").toString();
                }
                FmTemplate fmTemplate = new FmTemplate();
                fmTemplate.where().addEq(FmTemplate.IS_EDIT, (Object)"Y");
                fmTemplate.where().addEq(FmTemplate.DATA_FLAG, (Object)"1");
                fmTemplate.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
                fmTemplate = (FmTemplate)this.dao.findOne((AbsModel)fmTemplate);
                ArrayList<QueryTagsRelationReturn> tagsList = new ArrayList<QueryTagsRelationReturn>();
                this.formTemplateService.setTagsList(templateId, tagsList);
                if (fmTemplate == null) continue;
                fmNode.put("template_name", fmTemplate.getTemplateName());
                fmNode.put("template_type", fmTemplate.getTemplateType());
                fmNode.put("template_code", fmTemplate.getTemplateCode());
                fmNode.put("embedded_json", fmTemplate.getEmbeddedJson());
                fmNode.put("use_scene", fmTemplate.getUseScene());
                fmNode.put("delivery_platform", fmTemplate.getDeliveryPlatform());
                fmNode.put("state", fmTemplate.getState());
                fmNode.put("is_edit", fmTemplate.getIsEdit());
                fmNode.put("rn", i);
                fmNode.put("tags", tagsList);
                ++i;
                returnList.add(fmNode);
            }
        }
        msg.getDataTable().put("flowFormList", returnList);
        FmFlow fmFlow = new FmFlow();
        fmFlow.where().addEq(FmFlow.FLOW_UUID, (Object)flowUuid);
        fmFlow = (FmFlow)this.dao.findOne((AbsModel)fmFlow);
        msg.getDataTable().put("flow_url", fmFlow.getFlowUrl());
        msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg delNodeTemplate(FmFlowTemplateParam fmFlowTemplateParam) {
        Return msg = new Return();
        String templateId = fmFlowTemplateParam.getTemplateId();
        if (StrUtils.isNull((Object)templateId)) {
            msg.setFailMsg(new Message("6020006", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        this.dao.delete(FmNodeTemplate.n().where().addEq(FmNodeTemplate.TEMPLATE_ID, (Object)templateId).addEq(FmNodeTemplate.DATA_FLAG, (Object)"1").model());
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    private ReturnMsg findFmNodeTemplate(FmFlowTemplateParam fmFlowTemplateParam) {
        Return msg = new Return();
        String relateFk = fmFlowTemplateParam.getRelateFk();
        String nodeNo = fmFlowTemplateParam.getNodeNo();
        String flowUuid = fmFlowTemplateParam.getFlowUuid();
        String productFlowUuid = fmFlowTemplateParam.getProductFlowUuid();
        if (StrUtils.isNull((Object)relateFk) || StrUtils.isNull((Object)nodeNo) || StrUtils.isNull((Object)flowUuid) || StrUtils.isNull((Object)productFlowUuid)) {
            msg.setFailMsg(new Message("6020006", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        FmNodeTemplate fmNodeTemplate = new FmNodeTemplate();
        fmNodeTemplate.where().addEq(FmNodeTemplate.NODE_NO, (Object)nodeNo);
        fmNodeTemplate.where().addEq(FmNodeTemplate.FLOW_UUID, (Object)flowUuid);
        fmNodeTemplate.where().addEq(FmNodeTemplate.PRODUCT_FLOW_UUID, (Object)productFlowUuid);
        fmNodeTemplate.where().addEq(FmNodeTemplate.OLD_TEMPLATE_ID, (Object)relateFk);
        fmNodeTemplate.where().addEq(FmNodeTemplate.DATA_FLAG, (Object)"1");
        fmNodeTemplate = (FmNodeTemplate)this.dao.findOne((AbsModel)fmNodeTemplate);
        msg.getDataTable().put("fmNodeTemplate", fmNodeTemplate);
        msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg copyFlowForm(FmFlowTemplateParam fmFlowTemplateParam) {
        Return msg = new Return();
        String relateFk = fmFlowTemplateParam.getRelateFk();
        String flowUuid = fmFlowTemplateParam.getFlowUuid();
        String addBatch = fmFlowTemplateParam.getAddBatch();
        String nodeNo = fmFlowTemplateParam.getNodeNo();
        String oldAddBatch = fmFlowTemplateParam.getOldAddBatch();
        if (StrUtils.isNull((Object)oldAddBatch) || StrUtils.isNull((Object)addBatch) || oldAddBatch.equals(addBatch)) {
            msg.setFailMsg(new Message("9999999", "\u9009\u4e2d\u6570\u636e\u4e0d\u652f\u6301\u4f7f\u7528"));
            return msg.msg();
        }
        String sql = "select fnt.template_id from fm_node_template fnt left join fm_product_flow fpf on fnt.product_flow_uuid =  fpf.product_flow_uuid\nwhere fnt.flow_uuid= ? \nand fnt.old_template_id= ? \nand fnt.node_no= ? \nand fpf.add_batch= ? ";
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(flowUuid);
        sqlList.add(relateFk);
        sqlList.add(nodeNo);
        sqlList.add(oldAddBatch);
        List fmNodeTemplateOldList = this.dao.findAll(sql, FmNodeTemplate.class, new AbsModelRepository.Args[]{this.dao.args(sqlList)});
        if (CollectionUtils.isEmpty((Collection)fmNodeTemplateOldList)) {
            msg.setFailMsg(new Message("9999999", "\u9009\u4e2d\u6570\u636e\u4e0d\u652f\u6301\u4f7f\u7528"));
            return msg.msg();
        }
        String templateId = ((FmNodeTemplate)((Object)fmNodeTemplateOldList.get(0))).getTemplateId();
        FmTemplateVo fmTemplateVo = new FmTemplateVo();
        fmTemplateVo.setTemplateId(templateId);
        String templateIdNew = UUID.uuid();
        fmTemplateVo.setTemplateIdNew(templateIdNew);
        this.formTemplateService.copyFormTemplate(fmTemplateVo);
        FmProductFlow fpfSelect = new FmProductFlow();
        fpfSelect.where().addEq(FmProductFlow.ADD_BATCH, (Object)addBatch);
        List fpfDbAll = this.dao.findAll((AbsModel)fpfSelect);
        for (FmProductFlow fpf : fpfDbAll) {
            FmNodeTemplate fmNodeTemplate = new FmNodeTemplate();
            BeanUtils.copyProperties((Object)fmFlowTemplateParam, (Object)((Object)fmNodeTemplate));
            fmNodeTemplate.setProductFlowUuid(fpf.getProductFlowUuid());
            fmNodeTemplate.setOldTemplateId(relateFk);
            fmNodeTemplate.setTemplateId(templateIdNew);
            fmNodeTemplate.setNodeTemplateUuid(UUID.uuid());
            this.dao.save((AbsModel)fmNodeTemplate);
        }
        msg.getDataTable().put("template_id", templateIdNew);
        msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryAllFlowFormList(Map<String, Object> param) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)param.get("add_batch"))) {
            msg.setFailMsg(new Message("6020006", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        String addBatch = param.get("add_batch").toString();
        FmProductFlow fmProductFlow = new FmProductFlow();
        fmProductFlow.where().addEq(FmProductFlow.ADD_BATCH, (Object)addBatch);
        List fmProductFlowList = this.dao.findAll((AbsModel)fmProductFlow);
        if (CollectionUtils.isEmpty((Collection)fmProductFlowList)) {
            msg.setFailMsg(new Message("6020006", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        String flowUuid = ((FmProductFlow)((Object)fmProductFlowList.get(0))).getFlowUuid();
        ArrayList<String> flowUuids = new ArrayList<String>();
        flowUuids.add(flowUuid);
        String flowUuidsSql = "select child_flow_uuid from fm_flow_relation start with flow_uuid = ? connect by prior child_flow_uuid  = flow_uuid \uff03NOTCHECK";
        List listMap = this.dao.findAll(flowUuidsSql, Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(new Object[]{flowUuid})});
        if (CollectionUtils.isNotEmpty((Collection)listMap)) {
            flowUuids.addAll(listMap.stream().map(o -> (String)o.get("child_flow_uuid")).collect(Collectors.toList()));
        }
        List<Map<String, Object>> fmNodeList = this.queryAllFlowNodeById(flowUuids);
        ArrayList<Map<String, Object>> returnList = new ArrayList<Map<String, Object>>();
        if (CollectionUtils.isNotEmpty(fmNodeList)) {
            int i = 1;
            for (Map<String, Object> fmNode : fmNodeList) {
                FmTemplate fmTemplate = this.getRealTemplate(fmNode, fmProductFlowList);
                if (fmTemplate == null) continue;
                fmNode.put("template_name", fmTemplate.getTemplateName());
                fmNode.put("template_id", fmTemplate.getTemplateId());
                ++i;
                returnList.add(fmNode);
            }
        }
        msg.getDataTable().put("flowFormList", returnList);
        msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msg.msg();
    }

    private List<Map<String, Object>> queryAllFlowNodeById(List<String> flowUuids) {
        String sql = "select ff.flow_uuid,ff.flow_name,ft.template_id,ft.template_name,fn.node_no from fm_flow ff \nleft join fm_node fn on ff.flow_uuid=fn.flow_uuid\nleft join fm_template ft on fn.relate_fk=ft.template_id\nwhere ";
        ArrayList<String> list = new ArrayList<String>();
        sql = sql + " ff.flow_uuid in ( ";
        for (int i = 0; i < flowUuids.size(); ++i) {
            sql = i == flowUuids.size() - 1 ? sql + " ?  " : sql + " ?,  ";
            list.add(flowUuids.get(i));
        }
        sql = sql + ") ";
        ArrayList<String> nodeTypes = new ArrayList<String>();
        nodeTypes.add("start-node");
        nodeTypes.add("end-node");
        nodeTypes.add("connect");
        sql = sql + "and fn.node_type in ( ";
        for (int i = 0; i < nodeTypes.size(); ++i) {
            sql = i == nodeTypes.size() - 1 ? sql + " ?  " : sql + " ?,  ";
            list.add((String)nodeTypes.get(i));
        }
        sql = sql + ") ";
        return this.dao.findAll(sql, Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(list)});
    }

    private FmTemplate getRealTemplate(Map<String, Object> fmNode, List<FmProductFlow> fmProductFlowList) {
        String templateId = fmNode.get("template_id").toString();
        String nodeNo = fmNode.get("node_no").toString();
        FmNodeTemplate fmNodeTemplate = new FmNodeTemplate();
        fmNodeTemplate.where().addEq(FmNodeTemplate.NODE_NO, (Object)nodeNo);
        fmNodeTemplate.where().addEq(FmNodeTemplate.OLD_TEMPLATE_ID, (Object)templateId);
        fmNodeTemplate.where().addIn(FmNodeTemplate.PRODUCT_FLOW_UUID, fmProductFlowList.stream().map(FmProductFlow::getProductFlowUuid).collect(Collectors.toList()));
        List fmNodeTemplateList = this.dao.findAll((AbsModel)fmNodeTemplate);
        if (CollectionUtils.isNotEmpty((Collection)fmNodeTemplateList)) {
            templateId = ((FmNodeTemplate)((Object)fmNodeTemplateList.get(0))).getTemplateId();
        }
        FmTemplate fmTemplate = new FmTemplate();
        fmTemplate.where().addEq(FmTemplate.DATA_FLAG, (Object)"1");
        fmTemplate.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
        return (FmTemplate)this.dao.findOne((AbsModel)fmTemplate);
    }
}

