/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.vo.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.base.enums.RelateEnum;
import com.newtouch.base.model.DsnRules;
import com.newtouch.base.utils.export.EqualsUtils;
import com.newtouch.base.utils.export.ExportQueryUtils;
import com.newtouch.base.utils.export.UpdateUtils;
import com.newtouch.base.vo.export.ExportRuleInfo;
import com.newtouch.flow.model.FmRouter;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class FmRouterInfo
implements Comparable {
    @JsonProperty(value="fmRouter")
    private FmRouter fmRouter;
    @JsonProperty(value="ruleInfos")
    private List<ExportRuleInfo> ruleInfos;

    public FmRouterInfo load(String routerUuid) {
        ExportQueryUtils query = (ExportQueryUtils)SpringContext.getBean(ExportQueryUtils.class);
        this.ruleInfos = new ArrayList<ExportRuleInfo>();
        List<DsnRules> dsnRulesList = query.queryDsnRulesList(routerUuid, RelateEnum.router.getRelateField(), RelateEnum.router.getRelateTab());
        if (CollectionUtils.isNotEmpty(dsnRulesList)) {
            for (DsnRules dr : dsnRulesList) {
                ExportRuleInfo eri = new ExportRuleInfo();
                eri.load(dr);
                this.ruleInfos.add(eri);
            }
        }
        return this;
    }

    public void merge(FmRouterInfo fmRouterInfo) {
        this.fmRouter = EqualsUtils.merge(this.fmRouter, fmRouterInfo.getFmRouter());
        this.ruleInfos = EqualsUtils.merge(this.ruleInfos, fmRouterInfo.getRuleInfos(), ExportRuleInfo.class);
    }

    public void save() {
        UpdateUtils update = (UpdateUtils)SpringContext.getBean(UpdateUtils.class);
        if (this.fmRouter != null) {
            update.update(this.fmRouter);
        }
        if (this.ruleInfos != null) {
            this.ruleInfos.forEach(m -> m.save("Y"));
        }
    }

    public int compareTo(@NotNull Object o) {
        UpdateUtils.UpdateFlag flag = (UpdateUtils.UpdateFlag)((Object)this.fmRouter.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class));
        if (flag == UpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == UpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == UpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }

    public FmRouter getFmRouter() {
        return this.fmRouter;
    }

    public List<ExportRuleInfo> getRuleInfos() {
        return this.ruleInfos;
    }

    @JsonProperty(value="fmRouter")
    public void setFmRouter(FmRouter fmRouter) {
        this.fmRouter = fmRouter;
    }

    @JsonProperty(value="ruleInfos")
    public void setRuleInfos(List<ExportRuleInfo> ruleInfos) {
        this.ruleInfos = ruleInfos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FmRouterInfo)) {
            return false;
        }
        FmRouterInfo other = (FmRouterInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FmRouter this$fmRouter = this.getFmRouter();
        FmRouter other$fmRouter = other.getFmRouter();
        if (this$fmRouter == null ? other$fmRouter != null : !((Object)((Object)this$fmRouter)).equals((Object)other$fmRouter)) {
            return false;
        }
        List<ExportRuleInfo> this$ruleInfos = this.getRuleInfos();
        List<ExportRuleInfo> other$ruleInfos = other.getRuleInfos();
        return !(this$ruleInfos == null ? other$ruleInfos != null : !((Object)this$ruleInfos).equals(other$ruleInfos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FmRouterInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FmRouter $fmRouter = this.getFmRouter();
        result = result * 59 + ($fmRouter == null ? 43 : ((Object)((Object)$fmRouter)).hashCode());
        List<ExportRuleInfo> $ruleInfos = this.getRuleInfos();
        result = result * 59 + ($ruleInfos == null ? 43 : ((Object)$ruleInfos).hashCode());
        return result;
    }

    public String toString() {
        return "FmRouterInfo(fmRouter=" + (Object)((Object)this.getFmRouter()) + ", ruleInfos=" + this.getRuleInfos() + ")";
    }
}

