/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.service.impl;

import com.newtouch.base.enums.BaseEnum;
import com.newtouch.base.model.QsnPaper;
import com.newtouch.base.model.QsnPaperTemplate;
import com.newtouch.base.service.FormTemplateService;
import com.newtouch.base.service.QuestionnaireService;
import com.newtouch.base.vo.FmJsonReqParam;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuestionnaireServiceImpl
implements QuestionnaireService {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    FormTemplateService formTemplateService;

    @Override
    public ReturnMsg queryQuestionnaire(String paperUuid) {
        Return msg = new Return();
        QsnPaper qsnPaper = new QsnPaper();
        qsnPaper.where().addEq(AbsModel.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType()).addEq(QsnPaper.PAPER_UUID, (Object)paperUuid);
        QsnPaper qsnPaperRes = (QsnPaper)this.dao.findOne((AbsModel)qsnPaper);
        msg.getDataTable().put("qsnPaper", qsnPaperRes);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryPaperByPaperName(String paperName, String paperType, String collId, String paperUuid) {
        Return msg = new Return();
        QsnPaper qsnPaper = new QsnPaper();
        qsnPaper.where().addEq(QsnPaper.PAPER_TYPE, (Object)paperType);
        qsnPaper.where().addEq(QsnPaper.COLL_ID, (Object)collId);
        qsnPaper.where().addNotEq(QsnPaper.PAPER_UUID, (Object)paperUuid);
        if (!StrUtils.isNull((Object)paperName)) {
            qsnPaper.where().addLike(QsnPaper.PAPER_NAME, (Object)paperName);
        }
        List paperList = this.dao.findAll((AbsModel)qsnPaper);
        msg.setDataList(paperList, QsnPaper.class);
        return msg.msg();
    }

    @Override
    public ReturnMsg queryQuestionnaireTitleByPaperUuid(String paperUuid, String useScene, String attrName) {
        Return msg = new Return();
        QsnPaperTemplate qsnPaperTemplate = new QsnPaperTemplate();
        qsnPaperTemplate.where().addEq(QsnPaperTemplate.PAPER_UUID, (Object)paperUuid);
        qsnPaperTemplate.where().addEq(QsnPaperTemplate.USE_SCENE, (Object)useScene);
        qsnPaperTemplate.setOrderBy(QsnPaper.CRT_DATE.desc());
        QsnPaperTemplate templateCheck = (QsnPaperTemplate)this.dao.findOne((AbsModel)qsnPaperTemplate);
        if (StrUtils.isNull((Object)((Object)templateCheck))) {
            msg.setSuccessMsg(new Message("2010007", "\u67e5\u8be2\u6210\u529f\uff08\u65e0\u6570\u636e\uff09"));
            return msg.msg();
        }
        String templateId = templateCheck.getTemplateId();
        FmJsonReqParam fmJsonReqParam = new FmJsonReqParam();
        fmJsonReqParam.setTemplateId(templateId);
        msg.setDataTable(this.formTemplateService.getFormJsonByTemplateId(fmJsonReqParam).getDataTable());
        return msg.msg();
    }

    @Override
    public ReturnMsg addOrUpdateQuestionnaire(QsnPaper qsnPaper) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)qsnPaper.getPaperNo()) || StrUtils.isNull((Object)qsnPaper.getPaperName())) {
            msg.setFailMsg(new Message("6040001", "\u95ee\u5377\u7f16\u53f7/\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        if (StrUtils.isNull((Object)qsnPaper.getDeliveryPlatform())) {
            msg.setFailMsg("\u9500\u552e\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)qsnPaper.getExpirationDate())) {
            qsnPaper.setExpirationDate(null);
        }
        if (StrUtils.isNull((Object)qsnPaper.getEffectiveDate())) {
            qsnPaper.setEffectiveDate(null);
        }
        if (!StrUtils.isNull((Object)qsnPaper.getPaperUuid())) {
            Ulog.info((String)("\u95ee\u5377\u9875\u9762\u4fee\u6539\u524d----" + JsonUtils.toJson((Object)((Object)qsnPaper))));
            String paperUuid = qsnPaper.getPaperUuid();
            this.dao.update(qsnPaper.where().addEq(AbsModel.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType()).addEq(QsnPaper.PAPER_UUID, (Object)paperUuid).model());
            msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        } else {
            qsnPaper.setPaperUuid(UUID.shortUUID());
            qsnPaper.setStatus("islnactive");
            Ulog.info((String)("\u95ee\u5377\u9875\u9762\u65b0\u589e\u524d----" + JsonUtils.toJson((Object)((Object)qsnPaper))));
            this.dao.save((AbsModel)qsnPaper);
            msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        }
        msg.setDataTable(new Object[]{qsnPaper});
        return msg.msg();
    }

    @Override
    public ReturnMsg setPaperStatus(String paperUuid, String status) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)paperUuid) || StrUtils.isNull((Object)status)) {
            msg.setFailMsg(new Message("6040001", "\u95ee\u5377\u7f16\u53f7/\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        QsnPaper qsnPaper = new QsnPaper();
        qsnPaper.setStatus(status);
        qsnPaper.where().addEq(QsnPaper.PAPER_UUID, (Object)paperUuid);
        this.dao.update((AbsModel)qsnPaper);
        msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        return msg.msg();
    }
}

