/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.inform.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.FmTemplateAttributes;
import com.newtouch.base.param.SaveRuleUsedParam;
import com.newtouch.base.service.RuleUsedService;
import com.newtouch.inform.model.QsnCoreQuestions;
import com.newtouch.inform.model.QsnQuestionBlanks;
import com.newtouch.inform.model.QsnQuestionOptions;
import com.newtouch.inform.model.QsnQuestions;
import com.newtouch.inform.model.QsnTitleRelation;
import com.newtouch.inform.param.QsnQuestionBlanksInfo;
import com.newtouch.inform.param.QsnQuestionOptionsInfo;
import com.newtouch.inform.param.QsnQuestionsInfo;
import com.newtouch.inform.param.QsnQuestionsInfo2;
import com.newtouch.inform.param.QsnQuestionsParam;
import com.newtouch.inform.param.QsnSortParam;
import com.newtouch.inform.service.QsnQuestionsService;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QsnQuestionsServiceImpl
implements QsnQuestionsService {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    private RuleUsedService ruleUsedService;

    @Override
    public ReturnMsg editQsn(QsnQuestionsInfo qsnQuestionsInfo) {
        QsnQuestions qsnQuestions = qsnQuestionsInfo.getQsnQuestions();
        QsnCoreQuestions qsnCoreQuestions = qsnQuestionsInfo.getQsnCoreQuestions();
        List<QsnQuestionBlanksInfo> qsnQuestionBlanksInfoList = qsnQuestionsInfo.getQsnQuestionBlanksInfos();
        List<QsnQuestionOptionsInfo> qsnQuestionOptionsList = qsnQuestionsInfo.getQsnQuestionOptionsInfos();
        List<SaveRuleUsedParam> ruleList = qsnQuestionsInfo.getRuleInfos();
        String coreQuestionUuid = "";
        coreQuestionUuid = StrUtils.isNull((Object)qsnCoreQuestions.getCoreQuestionUuid()) ? this.addCoreQsn(qsnCoreQuestions) : this.updateCoreQsn(qsnCoreQuestions);
        qsnQuestions.setCoreQuestionUuid(coreQuestionUuid);
        if (StrUtils.isNull((Object)qsnQuestions.getQsnUuid())) {
            return this.addQsn(qsnQuestions, qsnQuestionBlanksInfoList, qsnQuestionOptionsList, ruleList);
        }
        return this.updateQsn(qsnQuestions, qsnQuestionBlanksInfoList, qsnQuestionOptionsList, ruleList);
    }

    public String addCoreQsn(QsnCoreQuestions qsnCoreQuestions) {
        String coreQuestionUuid = UUID.shortUUID();
        qsnCoreQuestions.setCoreQuestionUuid(coreQuestionUuid);
        qsnCoreQuestions.setDisplayOrder(this.getQsnCoreQuestionsMaxDisplayorder() + 1);
        this.dao.save((AbsModel)qsnCoreQuestions);
        return coreQuestionUuid;
    }

    public String updateCoreQsn(QsnCoreQuestions qsnCoreQuestions) {
        String coreQuestionUuid = qsnCoreQuestions.getCoreQuestionUuid();
        qsnCoreQuestions.where().addEq(QsnCoreQuestions.CORE_QUESTION_UUID, (Object)coreQuestionUuid);
        this.dao.update((AbsModel)qsnCoreQuestions);
        return coreQuestionUuid;
    }

    public ReturnMsg addQsn(QsnQuestions qsnQuestions, List<QsnQuestionBlanksInfo> qsnQuestionBlanksInfoList, List<QsnQuestionOptionsInfo> qsnQuestionOptionsInfoList, List<SaveRuleUsedParam> ruleList) {
        Return msg = new Return();
        String qsnUuid = UUID.shortUUID();
        qsnQuestions.setQsnUuid(qsnUuid);
        if (qsnQuestions.getUpQuestionId().equals("0") || qsnQuestions.getUpQuestionId().isEmpty()) {
            qsnQuestions.setQuestionSeq(qsnUuid + ".");
        } else {
            QsnQuestions upNode = new QsnQuestions();
            upNode.where().addEq(QsnQuestions.QSN_UUID, (Object)qsnQuestions.getUpQuestionId());
            String upNodeSeq = ((QsnQuestions)this.dao.findOne((AbsModel)upNode)).getQuestionSeq();
            qsnQuestions.setQuestionSeq(upNodeSeq + qsnUuid + ".");
        }
        qsnQuestions.setDisplayOrder(this.getQsnQuestionsMaxDisplayorder() + 1);
        this.dao.save((AbsModel)qsnQuestions);
        this.saveQsnQuestionBlanks(qsnUuid, qsnQuestionBlanksInfoList, null, null, null);
        this.saveOptionsInfos(qsnQuestionOptionsInfoList, "qsn_questions", "qsn_uuid", qsnUuid);
        this.saveRuleInfos(ruleList, "qsn_questions", "qsn_uuid", qsnUuid);
        msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        return msg.msg();
    }

    public ReturnMsg updateQsn(QsnQuestions qsnQuestions, List<QsnQuestionBlanksInfo> qsnQuestionBlanksInfoList, List<QsnQuestionOptionsInfo> qsnQuestionOptionsInfoList, List<SaveRuleUsedParam> ruleList) {
        Return msg = new Return();
        String qsnUuid = qsnQuestions.getQsnUuid();
        qsnQuestions.where().addEq(QsnQuestions.QSN_UUID, (Object)qsnUuid);
        if (qsnQuestions.getUpQuestionId().equals("0") || qsnQuestions.getUpQuestionId().isEmpty()) {
            qsnQuestions.setQuestionSeq(qsnUuid + ".");
        } else {
            QsnQuestions upNode = new QsnQuestions();
            upNode.where().addEq(QsnQuestions.QSN_UUID, (Object)qsnQuestions.getUpQuestionId());
            String upNodeSeq = ((QsnQuestions)this.dao.findOne((AbsModel)upNode)).getQuestionSeq();
            qsnQuestions.setQuestionSeq(upNodeSeq + qsnUuid + ".");
            QsnQuestions selectQq = new QsnQuestions();
            selectQq.where().addEq(QsnQuestions.QSN_UUID, (Object)qsnUuid);
            QsnQuestions qqDb = (QsnQuestions)this.dao.findOne((AbsModel)selectQq);
            if ("0".equals(qqDb.getUpQuestionId())) {
                QsnTitleRelation delQtr = new QsnTitleRelation();
                delQtr.where().addEq(QsnTitleRelation.QSN_UUID, (Object)qsnUuid);
                this.dao.delete((AbsModel)delQtr);
            }
        }
        this.dao.update((AbsModel)qsnQuestions);
        this.delQsnBlanks(qsnUuid);
        this.delQsnOptions("qsn_uuid", "qsn_questions", qsnUuid);
        this.ruleUsedService.deleteByRelateFks(qsnUuid, "qsn_questions");
        this.saveQsnQuestionBlanks(qsnQuestions.getQsnUuid(), qsnQuestionBlanksInfoList, null, null, null);
        this.saveOptionsInfos(qsnQuestionOptionsInfoList, "qsn_questions", "qsn_uuid", qsnUuid);
        this.saveRuleInfos(ruleList, "qsn_questions", "qsn_uuid", qsnUuid);
        msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        return msg.msg();
    }

    public int getQsnQuestionsMaxDisplayorder() {
        QsnQuestions maxOrder = new QsnQuestions();
        maxOrder.where().addEq(QsnQuestions.DATA_FLAG, (Object)"1");
        maxOrder.groupBy().max(QsnQuestions.DISPLAY_ORDER);
        maxOrder = (QsnQuestions)this.dao.findOne((AbsModel)maxOrder);
        Object maxDisplayOrder = maxOrder.getOtherProperty("max_display_order", String.class);
        return Integer.parseInt(StrUtils.isNull((Object)maxDisplayOrder) ? "0" : maxDisplayOrder.toString());
    }

    public int getQsnCoreQuestionsMaxDisplayorder() {
        QsnCoreQuestions maxOrder = new QsnCoreQuestions();
        maxOrder.where().addEq(QsnCoreQuestions.DATA_FLAG, (Object)"1");
        maxOrder.groupBy().max(QsnCoreQuestions.DISPLAY_ORDER);
        maxOrder = (QsnCoreQuestions)this.dao.findOne((AbsModel)maxOrder);
        Object maxDisplayOrder = maxOrder.getOtherProperty("max_display_order", String.class);
        return Integer.parseInt(StrUtils.isNull((Object)maxDisplayOrder) ? "0" : maxDisplayOrder.toString());
    }

    public void saveQsnQuestionBlanks(String qsnUuid, List<QsnQuestionBlanksInfo> qsnQuestionBlanksInfoList, String relateTab, String relateField, String relateFk) {
        if (CollectionUtils.isNotEmpty(qsnQuestionBlanksInfoList)) {
            for (QsnQuestionBlanksInfo qsnQuestionBlanksInfo : qsnQuestionBlanksInfoList) {
                QsnQuestionBlanks qsnQuestionBlanks = qsnQuestionBlanksInfo.getQsnQuestionBlank();
                String blankUuid = qsnQuestionBlanks.getBlankUuid();
                if (StrUtils.isNull((Object)blankUuid)) {
                    blankUuid = UUID.shortUUID();
                }
                qsnQuestionBlanks.setQuestionUuid(qsnUuid);
                qsnQuestionBlanks.setBlankUuid(blankUuid);
                qsnQuestionBlanks.setRelateTab(relateTab);
                qsnQuestionBlanks.setRelateField(relateField);
                qsnQuestionBlanks.setRelateFk(relateFk);
                this.dao.save((AbsModel)qsnQuestionBlanks);
                this.saveOptionsInfos(qsnQuestionBlanksInfo.getQsnQuestionOptionsInfos(), "qsn_question_blanks", "blank_uuid", blankUuid);
                this.saveRuleInfos(qsnQuestionBlanksInfo.getRuleInfos(), "qsn_question_blanks", "blank_uuid", blankUuid);
            }
        }
    }

    public void saveOptionsInfos(List<QsnQuestionOptionsInfo> qsnQuestionOptionsInfos, String relateTab, String relateField, String relateFk) {
        if (CollectionUtils.isNotEmpty(qsnQuestionOptionsInfos)) {
            for (QsnQuestionOptionsInfo qsnQuestionOptionsInfo : qsnQuestionOptionsInfos) {
                if (StrUtils.isNull((Object)qsnQuestionOptionsInfo.getQsnQuestionOption().getOptionUuid())) {
                    String optionUuid = UUID.shortUUID();
                    qsnQuestionOptionsInfo.getQsnQuestionOption().setOptionUuid(optionUuid);
                }
                qsnQuestionOptionsInfo.getQsnQuestionOption().setRelateTab(relateTab);
                qsnQuestionOptionsInfo.getQsnQuestionOption().setRelateField(relateField);
                qsnQuestionOptionsInfo.getQsnQuestionOption().setRelateFk(relateFk);
                this.dao.save((AbsModel)qsnQuestionOptionsInfo.getQsnQuestionOption());
                this.saveQsnQuestionBlanks(null, qsnQuestionOptionsInfo.getQsnQuestionBlanksInfos(), "qsn_question_options", "option_uuid", qsnQuestionOptionsInfo.getQsnQuestionOption().getOptionUuid());
                this.saveRuleInfos(qsnQuestionOptionsInfo.getRuleInfos(), "qsn_question_options", "option_uuid", qsnQuestionOptionsInfo.getQsnQuestionOption().getOptionUuid());
            }
        }
    }

    public void saveRuleInfos(List<SaveRuleUsedParam> ruleInfos, String relateTab, String relateField, String relateFk) {
        if (CollectionUtils.isNotEmpty(ruleInfos)) {
            for (SaveRuleUsedParam rule : ruleInfos) {
                rule.setRelateTab(relateTab);
                rule.setRelateField(relateField);
                rule.setRelateFk(relateFk);
                this.ruleUsedService.saveRuleUsed(rule);
            }
        }
    }

    @Override
    public ReturnMsg delQsn(String questionIdList) {
        String[] questionIds;
        Return msg = new Return();
        if (StrUtils.isNull((Object)questionIdList)) {
            msg.setFailMsg("\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u9898\u76ee");
            return msg.msg();
        }
        for (String questionId : questionIds = questionIdList.split(",")) {
            QsnTitleRelation qsnTitleRelation = new QsnTitleRelation();
            qsnTitleRelation.where().addEq(QsnTitleRelation.QSN_UUID, (Object)questionId);
            QsnTitleRelation qsnTitleRelationCheck = (QsnTitleRelation)this.dao.findOne((AbsModel)qsnTitleRelation);
            if (qsnTitleRelationCheck != null) {
                QsnQuestions qsnQuestionCheck = new QsnQuestions();
                qsnQuestionCheck.where().addEq(QsnQuestions.QSN_UUID, (Object)questionId);
                String representationId = ((QsnQuestions)this.dao.findOne((AbsModel)qsnQuestionCheck)).getRepresentationId();
                QsnCoreQuestions qsnCoreQuestions = new QsnCoreQuestions();
                qsnCoreQuestions.where().addEq(QsnCoreQuestions.REPRESENTATION_ID, (Object)representationId);
                String title = ((QsnCoreQuestions)this.dao.findOne((AbsModel)qsnCoreQuestions)).getFullText();
                if (title.length() >= 12) {
                    throw new BusinessException("'" + title.substring(0, 11) + "...'\u5df2\u7ecf\u88ab\u4f7f\u7528\u7684\u9898\u76ee\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002");
                }
                throw new BusinessException("'" + title + "'\u5df2\u7ecf\u88ab\u4f7f\u7528\u7684\u9898\u76ee\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002");
            }
            QsnQuestions qsnQuestions = new QsnQuestions();
            qsnQuestions.where().addEq(QsnQuestions.QSN_UUID, (Object)questionId);
            String coreQuestionUuid = ((QsnQuestions)this.dao.findOne((AbsModel)qsnQuestions)).getCoreQuestionUuid();
            QsnCoreQuestions qsnCoreQuestionsDel = new QsnCoreQuestions();
            qsnCoreQuestionsDel.where().addEq(QsnCoreQuestions.CORE_QUESTION_UUID, (Object)coreQuestionUuid);
            this.dao.delete((AbsModel)qsnCoreQuestionsDel);
            QsnQuestions qsnDel = new QsnQuestions();
            qsnDel.where().addEq(QsnQuestions.QSN_UUID, (Object)questionId);
            this.dao.delete((AbsModel)qsnDel);
            this.delQsnBlanks(questionId);
            this.delQsnOptions("qsn_uuid", "qsn_questions", questionId);
        }
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    private void delQsnBlanks(String questionId) {
        QsnQuestionBlanks qsnQuestionBlanksQuery = new QsnQuestionBlanks();
        qsnQuestionBlanksQuery.where().addEq(QsnQuestionBlanks.QUESTION_UUID, (Object)questionId);
        List oldBlanks = this.dao.findAll((AbsModel)qsnQuestionBlanksQuery);
        if (CollectionUtils.isNotEmpty((Collection)oldBlanks)) {
            QsnQuestionBlanks qsnQuestionBlanksDel = new QsnQuestionBlanks();
            qsnQuestionBlanksDel.where().addEq(QsnQuestionBlanks.QUESTION_UUID, (Object)questionId);
            this.dao.delete((AbsModel)qsnQuestionBlanksDel);
            for (QsnQuestionBlanks b : oldBlanks) {
                String blankUuid = b.getBlankUuid();
                this.delQsnOptions("blank_uuid", "qsn_question_blanks", blankUuid);
                this.dao.delete(DsnRules.n().where().addEq(DsnRules.RELATE_TAB, (Object)"qsn_question_blanks").addEq(DsnRules.RELATE_FK, (Object)blankUuid).model());
            }
        }
    }

    public void delQsnOptions(String relateField, String relateTab, String relateFk) {
        QsnQuestionOptions qsnQuestionOptionsQuery = new QsnQuestionOptions();
        qsnQuestionOptionsQuery.where().addEq(QsnQuestionOptions.RELATE_TAB, (Object)relateTab);
        qsnQuestionOptionsQuery.where().addEq(QsnQuestionOptions.RELATE_FIELD, (Object)relateField);
        qsnQuestionOptionsQuery.where().addEq(QsnQuestionOptions.RELATE_FK, (Object)relateFk);
        List oldOptions = this.dao.findAll((AbsModel)qsnQuestionOptionsQuery);
        if (CollectionUtils.isNotEmpty((Collection)oldOptions)) {
            QsnQuestionOptions qsnQuestionOptionsDel = new QsnQuestionOptions();
            qsnQuestionOptionsDel.where().addEq(QsnQuestionOptions.RELATE_TAB, (Object)relateTab);
            qsnQuestionOptionsDel.where().addEq(QsnQuestionOptions.RELATE_FIELD, (Object)relateField);
            qsnQuestionOptionsDel.where().addEq(QsnQuestionOptions.RELATE_FK, (Object)relateFk);
            this.dao.delete((AbsModel)qsnQuestionOptionsDel);
            List<String> optionUuidList = oldOptions.stream().map(o -> o.getOptionUuid()).collect(Collectors.toList());
            this.delQsnBlanksByRelate("qsn_question_options", optionUuidList);
            this.dao.delete(DsnRules.n().where().addEq(DsnRules.RELATE_TAB, (Object)"qsn_question_options").addIn(DsnRules.RELATE_FK, optionUuidList).model());
        }
    }

    private void delQsnBlanksByRelate(String relateTab, List<String> relateFks) {
        QsnQuestionBlanks qsnQuestionBlanksQuery = new QsnQuestionBlanks();
        qsnQuestionBlanksQuery.where().addEq(QsnQuestionBlanks.RELATE_TAB, (Object)relateTab);
        qsnQuestionBlanksQuery.where().addIn(QsnQuestionBlanks.RELATE_FK, relateFks);
        List oldBlanks = this.dao.findAll((AbsModel)qsnQuestionBlanksQuery);
        if (CollectionUtils.isNotEmpty((Collection)oldBlanks)) {
            QsnQuestionBlanks qsnQuestionBlanksDel = new QsnQuestionBlanks();
            qsnQuestionBlanksDel.where().addEq(QsnQuestionBlanks.RELATE_TAB, (Object)relateTab);
            qsnQuestionBlanksDel.where().addIn(QsnQuestionBlanks.RELATE_FK, relateFks);
            this.dao.delete((AbsModel)qsnQuestionBlanksDel);
            for (QsnQuestionBlanks b : oldBlanks) {
                String blankUuid = b.getBlankUuid();
                this.delQsnOptions("blank_uuid", "qsn_question_blanks", blankUuid);
                this.dao.delete(DsnRules.n().where().addEq(DsnRules.RELATE_TAB, (Object)"qsn_question_blanks").addEq(DsnRules.RELATE_FK, (Object)blankUuid).model());
            }
        }
    }

    @Override
    public ReturnMsg queryQsnList(QsnQuestionsParam qsnQuestions) {
        Return msg = new Return();
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("SELECT DISTINCT qsn.qsn_uuid, qcq.core_question_uuid, qsn.representation_id, qsn.qsn_class, qsn.qsn_type, qcq.full_text, qcq.for_applicant, qcq.for_insurant, qcq.display_order,qcq.mdf_date, qsn.qsn_belong   FROM qsn_core_questions qcq, qsn_questions qsn   WHERE qsn.core_question_uuid  = qcq.core_question_uuid  ");
        if (!StrUtils.isNull((Object)qsnQuestions.getFullText())) {
            sql.append(" AND qcq.full_text LIKE ?");
            queryValue.add("%" + qsnQuestions.getFullText() + "%");
        }
        if (!StrUtils.isNull((Object)qsnQuestions.getRepresentationId())) {
            sql.append(" AND qsn.representation_id = ?");
            queryValue.add(qsnQuestions.getRepresentationId());
        }
        if (!StrUtils.isNull((Object)qsnQuestions.getQsnClass())) {
            sql.append(" AND qsn.qsn_class = ?");
            queryValue.add(qsnQuestions.getQsnClass());
        }
        if (!StrUtils.isNull((Object)qsnQuestions.getQsnType())) {
            sql.append(" AND qsn.qsn_type = ?");
            queryValue.add(qsnQuestions.getQsnType());
        }
        if (!StrUtils.isNull((Object)qsnQuestions.getSortNum())) {
            sql.append(" AND qcq.sort_num = ?");
            queryValue.add(qsnQuestions.getSortNum());
        }
        if (!StrUtils.isNull((Object)qsnQuestions.getQsnBelong())) {
            sql.append(" AND qsn.qsn_belong = ?");
            queryValue.add(qsnQuestions.getQsnBelong());
        }
        sql.append(" ORDER BY qcq.mdf_date desc");
        List result = this.dao.findAll(sql.toString(), Boolean.valueOf(true), new AbsModelRepository.Args[]{this.dao.args(queryValue)});
        msg.setDataList(result);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryQsn(String questionId) {
        Return msg = new Return();
        QsnQuestionsInfo qsnQuestionsInfo = new QsnQuestionsInfo();
        qsnQuestionsInfo.load(questionId, "Y");
        msg.setDataTable(new Object[]{qsnQuestionsInfo});
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryUpQuestionList(QsnQuestionsParam queryParam) {
        Return msg = new Return();
        QsnQuestions qsnQuestions = new QsnQuestions();
        if (!StrUtils.isNull((Object)queryParam.getRepresentationId())) {
            qsnQuestions.where().addEq(QsnQuestions.REPRESENTATION_ID, (Object)queryParam.getRepresentationId());
        }
        if (!StrUtils.isNull((Object)queryParam.getQsnTitle())) {
            qsnQuestions.where().addLike(QsnQuestions.QSN_TITLE, (Object)queryParam.getQsnTitle());
        }
        qsnQuestions.where().addEq(QsnQuestions.UP_QUESTION_ID, (Object)"0");
        qsnQuestions.where().addEq(QsnQuestions.QSN_CLASS, (Object)queryParam.getQsnClass());
        qsnQuestions.where().addEq(QsnQuestions.QSN_BELONG, (Object)queryParam.getQsnBelong());
        qsnQuestions.where().addEq(QsnQuestions.QSN_TYPE, (Object)"parentTitle");
        if (!StrUtils.isNull((Object)queryParam.getQsnUuid())) {
            qsnQuestions.where().addNotEq(QsnQuestions.QSN_UUID, (Object)queryParam.getQsnUuid());
        }
        List qsnQuestionsList = this.dao.findAll((AbsModel)qsnQuestions);
        msg.setDataList(qsnQuestionsList, QsnQuestions.class);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg sortQsn(QsnSortParam qsnSortParam) {
        Return msg = new Return();
        if (!qsnSortParam.getQsnClass().equals(qsnSortParam.getNewQsnClass())) {
            msg.setFailMsg(new Message("4010002", "\u4e0d\u540c\u5206\u7ec4\u7c7b\u578b\uff0c\u4e0d\u80fd\u8c03\u6574\u987a\u5e8f\u3002"));
            return msg.msg();
        }
        QsnQuestions qsnQuestions = new QsnQuestions();
        qsnQuestions.setDisplayOrder(qsnSortParam.getNewDisplayOrder());
        qsnQuestions.where().addEq(QsnTitleRelation.QSN_UUID, (Object)qsnSortParam.getQsnUuid());
        this.dao.update((AbsModel)qsnQuestions);
        qsnQuestions.setDisplayOrder(qsnSortParam.getDisplayOrder());
        qsnQuestions.where().addEq(QsnTitleRelation.QSN_UUID, (Object)qsnSortParam.getNewQsnUuid());
        this.dao.update((AbsModel)qsnQuestions);
        msg.setSuccessMsg(new Message("2010006", "\u8c03\u6574\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public void queryQsnQuestionsInfo(String paperUuid, List<QsnQuestionsInfo2> qsnQuestionsInfos, String qsnUuid) {
        QsnQuestionsInfo2 qsnQuestionsInfo = new QsnQuestionsInfo2();
        FmTemplateAttributes fmTemplateAttributes = this.getFmTemplateAttributes(paperUuid, qsnUuid);
        JSONObject attrJson = new JSONObject();
        if (fmTemplateAttributes != null) {
            attrJson = JSONObject.parseObject((String)fmTemplateAttributes.getAttrJson());
        }
        qsnQuestionsInfo.loadQsnInfo(attrJson, qsnUuid);
        qsnQuestionsInfos.add(qsnQuestionsInfo);
    }

    public FmTemplateAttributes getFmTemplateAttributes(String paperUuid, String qsnUuid) {
        String sql2 = "select * from fm_template_attributes b join fm_template ft on ft.template_id = b.template_id  join qsn_paper_template qpt on qpt.template_id  = ft.template_id  join  qsn_paper qp on qp.paper_uuid = qpt.paper_uuid  where qp.paper_uuid = ? and b.attr_json like ? order by b.display_order asc";
        ArrayList<String> sqlParam2 = new ArrayList<String>();
        sqlParam2.add(paperUuid);
        sqlParam2.add("%\"qsn_uuid\":\"" + qsnUuid + "\"%");
        List fmTemplateAttributesList = this.dao.findAll(sql2, FmTemplateAttributes.class, new AbsModelRepository.Args[]{this.dao.args(sqlParam2)});
        if (fmTemplateAttributesList == null || fmTemplateAttributesList.isEmpty()) {
            return null;
        }
        return (FmTemplateAttributes)((Object)fmTemplateAttributesList.get(0));
    }
}

