/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.vo.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.base.enums.RelateEnum;
import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.FmTemplateAttributes;
import com.newtouch.base.model.FmTemplateText;
import com.newtouch.base.utils.export.EqualsUtils;
import com.newtouch.base.utils.export.ExportQueryUtils;
import com.newtouch.base.utils.export.UpdateUtils;
import com.newtouch.base.vo.export.ExportRuleInfo;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class AttrInfo
implements Comparable {
    @JsonProperty(value="fmTemplateAttributes")
    private FmTemplateAttributes fmTemplateAttributes;
    @JsonProperty(value="fmTemplateText")
    private FmTemplateText fmTemplateText;
    @JsonProperty(value="ruleInfos")
    private List<ExportRuleInfo> ruleInfos;

    public AttrInfo load(FmTemplateAttributes fta) {
        ExportQueryUtils query = (ExportQueryUtils)SpringContext.getBean(ExportQueryUtils.class);
        String attrId = fta.getAttrId();
        if ("richText".equals(fta.getComponentType())) {
            this.fmTemplateText = query.queryFmTemplateText(attrId);
        }
        this.ruleInfos = new ArrayList<ExportRuleInfo>();
        List<DsnRules> dsnRulesList = query.queryDsnRulesList(attrId, RelateEnum.attr.getRelateField(), RelateEnum.attr.getRelateTab());
        if (CollectionUtils.isNotEmpty(dsnRulesList)) {
            for (DsnRules dr : dsnRulesList) {
                ExportRuleInfo eri = new ExportRuleInfo();
                eri.load(dr);
                this.ruleInfos.add(eri);
            }
        }
        return this;
    }

    public void merge(AttrInfo attrInfo) {
        this.fmTemplateAttributes = EqualsUtils.merge(this.fmTemplateAttributes, attrInfo.getFmTemplateAttributes());
        this.fmTemplateText = EqualsUtils.merge(this.fmTemplateText, attrInfo.getFmTemplateText());
        this.ruleInfos = EqualsUtils.merge(this.ruleInfos, attrInfo.getRuleInfos(), ExportRuleInfo.class);
    }

    public void save(String isDel) {
        UpdateUtils update = (UpdateUtils)SpringContext.getBean(UpdateUtils.class);
        UpdateUtils.UpdateFlag updateFlag = UpdateUtils.UpdateFlag.U;
        if (this.fmTemplateAttributes != null) {
            updateFlag = (UpdateUtils.UpdateFlag)((Object)this.fmTemplateAttributes.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class));
            if ("Y".equals(isDel)) {
                update.update(this.fmTemplateAttributes);
            } else if (updateFlag == UpdateUtils.UpdateFlag.U || updateFlag == UpdateUtils.UpdateFlag.I) {
                update.save(this.fmTemplateAttributes);
                String attrId = this.fmTemplateAttributes.getAttrId();
                FmTemplateText ftt = new FmTemplateText();
                ftt.setAttrId(attrId);
                update.del(ftt);
                DsnRules dsnRules = new DsnRules();
                dsnRules.setRelateFk(attrId);
                dsnRules.setRelateField(RelateEnum.attr.getRelateField());
                dsnRules.setRelateTab(RelateEnum.attr.getRelateTab());
                update.del((AbsModel)dsnRules);
            }
        }
        if (this.fmTemplateText != null) {
            if ("Y".equals(isDel)) {
                update.update(this.fmTemplateText);
            } else {
                updateFlag = (UpdateUtils.UpdateFlag)((Object)this.fmTemplateText.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class));
                if (updateFlag == UpdateUtils.UpdateFlag.U || updateFlag == UpdateUtils.UpdateFlag.I) {
                    update.save(this.fmTemplateText);
                }
            }
        }
        if (this.ruleInfos != null) {
            this.ruleInfos.forEach(m -> m.save(isDel));
        }
    }

    public int compareTo(@NotNull Object o) {
        UpdateUtils.UpdateFlag flag = (UpdateUtils.UpdateFlag)((Object)this.fmTemplateAttributes.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class));
        if (flag == UpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == UpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == UpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }

    public FmTemplateAttributes getFmTemplateAttributes() {
        return this.fmTemplateAttributes;
    }

    public FmTemplateText getFmTemplateText() {
        return this.fmTemplateText;
    }

    public List<ExportRuleInfo> getRuleInfos() {
        return this.ruleInfos;
    }

    @JsonProperty(value="fmTemplateAttributes")
    public void setFmTemplateAttributes(FmTemplateAttributes fmTemplateAttributes) {
        this.fmTemplateAttributes = fmTemplateAttributes;
    }

    @JsonProperty(value="fmTemplateText")
    public void setFmTemplateText(FmTemplateText fmTemplateText) {
        this.fmTemplateText = fmTemplateText;
    }

    @JsonProperty(value="ruleInfos")
    public void setRuleInfos(List<ExportRuleInfo> ruleInfos) {
        this.ruleInfos = ruleInfos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttrInfo)) {
            return false;
        }
        AttrInfo other = (AttrInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FmTemplateAttributes this$fmTemplateAttributes = this.getFmTemplateAttributes();
        FmTemplateAttributes other$fmTemplateAttributes = other.getFmTemplateAttributes();
        if (this$fmTemplateAttributes == null ? other$fmTemplateAttributes != null : !((Object)((Object)this$fmTemplateAttributes)).equals((Object)other$fmTemplateAttributes)) {
            return false;
        }
        FmTemplateText this$fmTemplateText = this.getFmTemplateText();
        FmTemplateText other$fmTemplateText = other.getFmTemplateText();
        if (this$fmTemplateText == null ? other$fmTemplateText != null : !((Object)((Object)this$fmTemplateText)).equals((Object)other$fmTemplateText)) {
            return false;
        }
        List<ExportRuleInfo> this$ruleInfos = this.getRuleInfos();
        List<ExportRuleInfo> other$ruleInfos = other.getRuleInfos();
        return !(this$ruleInfos == null ? other$ruleInfos != null : !((Object)this$ruleInfos).equals(other$ruleInfos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttrInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FmTemplateAttributes $fmTemplateAttributes = this.getFmTemplateAttributes();
        result = result * 59 + ($fmTemplateAttributes == null ? 43 : ((Object)((Object)$fmTemplateAttributes)).hashCode());
        FmTemplateText $fmTemplateText = this.getFmTemplateText();
        result = result * 59 + ($fmTemplateText == null ? 43 : ((Object)((Object)$fmTemplateText)).hashCode());
        List<ExportRuleInfo> $ruleInfos = this.getRuleInfos();
        result = result * 59 + ($ruleInfos == null ? 43 : ((Object)$ruleInfos).hashCode());
        return result;
    }

    public String toString() {
        return "AttrInfo(fmTemplateAttributes=" + (Object)((Object)this.getFmTemplateAttributes()) + ", fmTemplateText=" + (Object)((Object)this.getFmTemplateText()) + ", ruleInfos=" + this.getRuleInfos() + ")";
    }
}

