/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.flow.util;

import com.newtouch.base.enums.BaseEnum;
import com.newtouch.base.model.FmCollection;
import com.newtouch.base.model.FmTemplate;
import com.newtouch.base.param.FkRulesReqParam;
import com.newtouch.base.param.SaveRuleUsedParam;
import com.newtouch.base.service.RuleUsedService;
import com.newtouch.flow.model.FmEmbedded;
import com.newtouch.flow.model.FmFlow;
import com.newtouch.flow.model.FmFlowRelation;
import com.newtouch.flow.model.FmNode;
import com.newtouch.flow.model.FmRouter;
import com.newtouch.flow.vo.ScpzMaterialTagsRelationVo;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.newtouch.material.model.ScpzTags;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowQueryUtil {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    private RuleUsedService ruleUsedService;

    public FmFlow queryFlow(String flowUuid) {
        FmFlow flow = new FmFlow();
        flow.where().addEq(FmFlow.FLOW_UUID, (Object)flowUuid);
        FmFlow flowList = (FmFlow)this.dao.findOne((AbsModel)flow);
        ScpzMaterialTagsRelationVo scpzMaterialTagsRelationVo = new ScpzMaterialTagsRelationVo();
        flowList.setScpzMaterialTagsRelationList(scpzMaterialTagsRelationVo.load(flowList.getFlowUuid(), "flow_uuid", "fm_flow"));
        return flowList;
    }

    public FmCollection queryCollection(String flowUuid) {
        FmFlow flow = new FmFlow();
        flow.where().addEq(FmFlow.FLOW_UUID, (Object)flowUuid);
        FmFlow flowList = (FmFlow)this.dao.findOne((AbsModel)flow);
        FmCollection fmCollection = new FmCollection();
        fmCollection.where().addEq(FmCollection.COLL_ID, (Object)flowList.getCollId());
        fmCollection = (FmCollection)this.dao.findOne((AbsModel)fmCollection);
        return fmCollection;
    }

    public List<ScpzMaterialTagsRelation> queryTags(String relationFk, String relationField, String relationTab) {
        ScpzMaterialTagsRelation scpzMaterialTagsRelation1 = new ScpzMaterialTagsRelation();
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)relationFk);
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)relationField);
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)relationTab);
        List scpzMaterialTagsRelationList = this.dao.findAll((AbsModel)scpzMaterialTagsRelation1);
        for (ScpzMaterialTagsRelation s : scpzMaterialTagsRelationList) {
            ScpzTags scpzTags = (ScpzTags)this.dao.findOne(ScpzTags.n().where().addEq(ScpzTags.TAG_ID, (Object)s.getTagId()).model());
            s.setScpzTags(scpzTags);
        }
        return scpzMaterialTagsRelationList;
    }

    public List<FmRouter> queryRouters(String flowUuid) {
        ArrayList<String> flowUuids = new ArrayList<String>();
        String sql = "select * from fm_flow_relation start with flow_uuid = ? connect by prior child_flow_uuid  = flow_uuid \uff03NOTCHECK";
        List listMap = this.dao.findAll(sql, Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(new Object[]{flowUuid})});
        if (CollectionUtils.isNotEmpty((Collection)listMap)) {
            flowUuids.addAll(listMap.stream().map(o -> (String)o.get("child_flow_uuid")).collect(Collectors.toList()));
        }
        flowUuids.add(flowUuid);
        FmRouter fmRouter = new FmRouter();
        fmRouter.where().addIn(FmRouter.FLOW_UUID, flowUuids);
        List fmRouterList = this.dao.findAll((AbsModel)fmRouter);
        return fmRouterList;
    }

    public List<SaveRuleUsedParam> queryRules(String relateField, String relateTab, String relateFk) {
        FkRulesReqParam fkRulesReqParam = new FkRulesReqParam();
        fkRulesReqParam.setRelateField(relateField);
        fkRulesReqParam.setRelateTab(relateTab);
        fkRulesReqParam.setRelateFk(relateFk);
        List saveRuleUsedParams = this.ruleUsedService.queryRulesByFk(fkRulesReqParam);
        return saveRuleUsedParams;
    }

    public List<FmNode> queryNodes(String flowUuid) {
        ArrayList<String> flowUuids = new ArrayList<String>();
        String sql = "select * from fm_flow_relation start with flow_uuid = ? connect by prior child_flow_uuid  = flow_uuid \uff03NOTCHECK";
        List listMap = this.dao.findAll(sql, Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(new Object[]{flowUuid})});
        if (CollectionUtils.isNotEmpty((Collection)listMap)) {
            flowUuids.addAll(listMap.stream().map(o -> (String)o.get("child_flow_uuid")).collect(Collectors.toList()));
        }
        flowUuids.add(flowUuid);
        FmNode fmNode = new FmNode();
        fmNode.where().addIn(FmNode.FLOW_UUID, flowUuids);
        List fmNodeList = this.dao.findAll((AbsModel)fmNode);
        for (FmNode fmNode1 : fmNodeList) {
            FkRulesReqParam fkRulesReqParam = new FkRulesReqParam();
            fkRulesReqParam.setRelateField("node_no");
            fkRulesReqParam.setRelateTab("fm_node");
            fkRulesReqParam.setRelateFk(fmNode1.getNodeNo());
            List saveRuleUsedParams = this.ruleUsedService.queryRulesByFk(fkRulesReqParam);
            fmNode1.setRules(saveRuleUsedParams);
        }
        return fmNodeList;
    }

    public FmTemplate queryTemplate(String templateId) {
        FmTemplate fmTemplate = new FmTemplate();
        fmTemplate.where().addEq(FmTemplate.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
        fmTemplate.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
        fmTemplate = (FmTemplate)this.dao.findOne((AbsModel)fmTemplate);
        return fmTemplate;
    }

    public List<com.newtouch.base.model.Component> queryComponent(List<String> componentType, String componentClass) {
        com.newtouch.base.model.Component component = new com.newtouch.base.model.Component();
        component.where().addIn(com.newtouch.base.model.Component.COMPONENT_TYPE, componentType);
        component.where().addEq(com.newtouch.base.model.Component.COMPONENT_CLASS, (Object)componentClass);
        List components = this.dao.findAll((AbsModel)component);
        return components;
    }

    public List<FmEmbedded> queryEmbeddeds(String embeddedElementCn, String embeddedElementEn, String deliveryPlatform) {
        FmEmbedded fmEmbedded = new FmEmbedded();
        fmEmbedded.where().addEq(FmEmbedded.EMBEDDED_ELEMENT_CN, (Object)embeddedElementCn);
        fmEmbedded.where().addEq(FmEmbedded.EMBEDDED_ELEMENT_EN, (Object)embeddedElementEn);
        fmEmbedded.where().addIn(FmEmbedded.DELIVERY_PLATFORM, Arrays.asList(deliveryPlatform.split(",")));
        List fmEmbeddeds = this.dao.findAll((AbsModel)fmEmbedded);
        return fmEmbeddeds;
    }

    public List<FmFlowRelation> queryFlowRelation(String flowUuid) {
        ArrayList<String> flowUuids = new ArrayList<String>();
        String sql = "select * from fm_flow_relation start with flow_uuid = ? connect by prior child_flow_uuid  = flow_uuid \uff03NOTCHECK";
        List listMap = this.dao.findAll(sql, Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(new Object[]{flowUuid})});
        if (CollectionUtils.isNotEmpty((Collection)listMap)) {
            flowUuids.addAll(listMap.stream().map(o -> (String)o.get("child_flow_uuid")).collect(Collectors.toList()));
        }
        flowUuids.add(flowUuid);
        return this.dao.findAll(FmFlowRelation.n().where().addIn(FmFlowRelation.FLOW_UUID, flowUuids).model());
    }

    public List<FmFlow> queryChildFmFlows(String flowUuid) {
        ArrayList<String> flowUuids = new ArrayList<String>();
        String sql = "select * from fm_flow_relation start with flow_uuid = ? connect by prior child_flow_uuid  = flow_uuid \uff03NOTCHECK";
        List listMap = this.dao.findAll(sql, Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(new Object[]{flowUuid})});
        if (CollectionUtils.isNotEmpty((Collection)listMap)) {
            flowUuids.addAll(listMap.stream().map(o -> (String)o.get("child_flow_uuid")).collect(Collectors.toList()));
        }
        flowUuids.add(flowUuid);
        List fmFlowRelations = this.dao.findAll(FmFlowRelation.n().where().addIn(FmFlowRelation.FLOW_UUID, flowUuids).model());
        if (CollectionUtils.isEmpty((Collection)fmFlowRelations)) {
            return null;
        }
        List strings = fmFlowRelations.stream().map(FmFlowRelation::getChildFlowUuid).collect(Collectors.toList());
        List fmFlows = this.dao.findAll(FmFlow.n().where().addIn(FmFlow.FLOW_UUID, strings).model());
        return fmFlows;
    }
}

