/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.chain.service.impl;

import cn.hutool.core.lang.hash.MurmurHash;
import com.newtouch.chain.model.LjglChainManage;
import com.newtouch.chain.param.AddOrUpdateParam;
import com.newtouch.chain.service.LjglChainManageService;
import com.newtouch.chain.utils.ShortChainUtils;
import com.newtouch.operation.enums.OperationEnum;
import com.newtouch.operation.model.RmsOpRecord;
import com.newtouch.operation.service.OperationService;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Service
public class LjglChainManageServiceImpl
implements LjglChainManageService {
    @Autowired
    private Environment environment;
    @Autowired
    private AbsModelRepository dao;
    @Autowired
    private OperationService operationService;

    @Override
    public ReturnMsg queryChain(LjglChainManage chainManageParam, String opId) {
        Return msg = new Return();
        LjglChainManage chainManage = new LjglChainManage();
        if (!StrUtils.isNull((Object)chainManageParam.getChainName())) {
            chainManage.where().addLike(LjglChainManage.CHAIN_NAME, (Object)chainManageParam.getChainName());
        }
        if (!StrUtils.isNull((Object)chainManageParam.getOriginalChain())) {
            int index = StringUtils.ordinalIndexOf((CharSequence)chainManageParam.getOriginalChain(), (CharSequence)"/", (int)3);
            String originalChainIdentify = chainManageParam.getOriginalChain().substring(index + 1);
            chainManage.where().addLike(LjglChainManage.ORIGINAL_CHAIN, (Object)originalChainIdentify);
        }
        if (!StrUtils.isNull((Object)chainManageParam.getShortChain())) {
            chainManage.where().addLike(LjglChainManage.SHORT_CHAIN, (Object)chainManageParam.getShortChain());
        }
        if (!StrUtils.isNull((Object)chainManageParam.getDeliveryPlatform())) {
            chainManage.where().addLike(LjglChainManage.DELIVERY_PLATFORM, (Object)chainManageParam.getDeliveryPlatform());
        }
        if (!(StrUtils.isNull((Object)chainManageParam.getRelateTab()) || StrUtils.isNull((Object)chainManageParam.getRelateField()) || StrUtils.isNull((Object)chainManageParam.getRelateFk()))) {
            chainManage.where().addEq(LjglChainManage.RELATE_TAB, (Object)chainManageParam.getRelateTab()).addEq(LjglChainManage.RELATE_FIELD, (Object)chainManageParam.getRelateField()).addEq(LjglChainManage.RELATE_FK, (Object)chainManageParam.getRelateFk());
        }
        chainManage.where().addEq(LjglChainManage.DATA_FLAG, (Object)1);
        chainManage.setOrderBy(LjglChainManage.CRT_DATE.desc());
        List chainManages = this.dao.findAll((AbsModel)chainManage, Boolean.valueOf(true));
        msg.setDataList(chainManages, LjglChainManage.class);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        if (CollectionUtils.isNotEmpty((Collection)chainManages) && !StrUtils.isNull((Object)chainManageParam.getRelateFk())) {
            String opJson = OperationEnum.OpJsonEnum.delLink.getType();
            RmsOpRecord rmsOpRecord = new RmsOpRecord();
            rmsOpRecord.setOpId(opId);
            opJson = String.format(opJson, ((LjglChainManage)((Object)chainManages.get(0))).getChainUuid(), ((LjglChainManage)((Object)chainManages.get(0))).getChainName());
            rmsOpRecord.setOpJson(opJson);
            this.operationService.saveRmsOpRecord(rmsOpRecord, OperationEnum.OpResultEnum.upsuccess.getType());
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg addOrUpdate(AddOrUpdateParam param) {
        Return msg = new Return();
        LjglChainManage chainManage = param.getChainManage();
        String operation = param.getOperation();
        if (StrUtils.isNull((Object)chainManage.getChainName())) {
            msg.setFailMsg("\u94fe\u63a5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)chainManage.getOriginalChain())) {
            msg.setFailMsg("\u539f\u59cb\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)operation) || !operation.equals("add") && !operation.equals("update")) {
            msg.setFailMsg("\u64cd\u4f5c\u7c7b\u578b\u6709\u8bef\uff01");
            return msg.msg();
        }
        if (operation.equals("add")) {
            String[] deliveryPlatforms;
            int index = StringUtils.ordinalIndexOf((CharSequence)chainManage.getOriginalChain(), (CharSequence)"/", (int)3);
            String originalChainIdentify = chainManage.getOriginalChain().substring(index + 1);
            String deliveryPlatform = chainManage.getDeliveryPlatform();
            for (String platform : deliveryPlatforms = deliveryPlatform.split(",")) {
                String newOriginalChain = this.environment.getProperty("chainManage." + platform + ".originalUrlPrefix") + originalChainIdentify;
                LjglChainManage chain = new LjglChainManage();
                chain.where().addEq(LjglChainManage.ORIGINAL_CHAIN, (Object)newOriginalChain);
                List chains = this.dao.findAll((AbsModel)chain);
                if (!chains.isEmpty()) {
                    msg.setFailMsg(platform + "\u4e0b\u77ed\u94fe\u63a5\u5df2\u751f\u6210\u8fc7\uff01");
                    return msg.msg();
                }
                String newChainName = chainManage.getChainName() + "-" + platform;
                String newShortChain = this.getShortChain(this.environment.getProperty("chainManage." + platform + ".shortUrlPrefix"));
                LjglChainManage chainOfPlatform = new LjglChainManage();
                chainOfPlatform.setChainName(newChainName);
                chainOfPlatform.setOriginalChain(newOriginalChain);
                chainOfPlatform.setShortChain(newShortChain);
                chainOfPlatform.setChainUuid(UUID.shortUUID());
                chainOfPlatform.setDeliveryPlatform(platform);
                chainOfPlatform.setRelateTab(chainManage.getRelateTab());
                chainOfPlatform.setRelateField(chainManage.getRelateField());
                chainOfPlatform.setRelateFk(chainManage.getRelateFk());
                this.dao.save((AbsModel)chainOfPlatform);
            }
            msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        } else {
            LjglChainManage chain = new LjglChainManage();
            chain.where().addEq(LjglChainManage.CHAIN_UUID, (Object)chainManage.getChainUuid());
            List chains = this.dao.findAll((AbsModel)chain);
            if (chains.isEmpty()) {
                msg.setFailMsg("\u539f\u94fe\u63a5\u4e0d\u5b58\u5728\uff01");
                return msg.msg();
            }
            chainManage.where().addEq(LjglChainManage.CHAIN_UUID, (Object)chainManage.getChainUuid());
            this.dao.update((AbsModel)chainManage);
            msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteChain(List<String> chainUuids) {
        Return msg = new Return();
        if (chainUuids.isEmpty()) {
            msg.setFailMsg("\u8981\u5220\u9664\u7684chain_uuid\u4e0d\u80fd\u4e3a\u7a7a!");
            return msg.msg();
        }
        for (String chainUuid : chainUuids) {
            LjglChainManage chainManage = new LjglChainManage();
            chainManage.where().addEq(LjglChainManage.CHAIN_UUID, (Object)chainUuid);
            this.dao.delete((AbsModel)chainManage);
        }
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ModelAndView redirect(HttpServletRequest request, String shortUrl) {
        LjglChainManage chainManage = new LjglChainManage();
        chainManage.where().addLike(LjglChainManage.SHORT_CHAIN, (Object)shortUrl);
        LjglChainManage one = (LjglChainManage)this.dao.findOne((AbsModel)chainManage);
        if (one != null) {
            RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
            Map parameterMap = map.getParam();
            String originalLink = one.getOriginalChain();
            if (!StrUtils.isNull((Object)parameterMap) && parameterMap.size() > 0) {
                Ulog.info((String)("\u8fdb\u884c\u8f6c\u6362\u524d\u7684url--->" + originalLink));
                String[] urlSplit = originalLink.split("\\?");
                String baseUri = urlSplit[0];
                List<String> paramList = Arrays.asList(urlSplit[1].split("&"));
                HashMap<String, String> queryParams = new HashMap<String, String>();
                for (String string : paramList) {
                    String[] split = string.split("=");
                    if (split.length == 2) {
                        queryParams.put(split[0], split[1]);
                        continue;
                    }
                    queryParams.put(split[0], "");
                }
                for (Map.Entry entry : parameterMap.entrySet()) {
                    queryParams.put((String)entry.getKey(), StrUtils.isNull(entry.getValue()) ? "" : entry.getValue().toString());
                }
                StringBuilder urlBuilder = new StringBuilder(baseUri);
                urlBuilder.append("?");
                for (Map.Entry entry : queryParams.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    try {
                        value = URLEncoder.encode(value, "UTF-8");
                    }
                    catch (Exception e) {
                        Ulog.info((String)"\u7f16\u7801\u8f6c\u6362\u5f02\u5e38");
                    }
                    urlBuilder.append(key).append("=").append(value).append("&");
                }
                originalLink = urlBuilder.toString();
                Ulog.info((String)("\u91cd\u65b0\u8f6c\u6362\u540e\u7684url--->" + originalLink));
            }
            RedirectView redirectView = new RedirectView(originalLink);
            redirectView.setStatusCode(HttpStatus.MOVED_PERMANENTLY);
            return new ModelAndView((View)redirectView);
        }
        RedirectView redirectView = new RedirectView("404");
        redirectView.setStatusCode(HttpStatus.NOT_FOUND);
        ModelAndView modelAndView = new ModelAndView((View)redirectView);
        return modelAndView;
    }

    public String getShortChain(String shortUrlPrefix) {
        long snowId = UUID.snowId();
        int hash32 = Math.abs(MurmurHash.hash32((CharSequence)String.valueOf(snowId)));
        String shortUrl = ShortChainUtils.decimalToBase62(hash32);
        String shortLink = shortUrlPrefix + "s/" + shortUrl;
        return shortLink;
    }
}

