/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.service.impl;

import com.newtouch.base.config.TemplateConfig;
import com.newtouch.base.enums.BaseEnum;
import com.newtouch.base.model.FmCollection;
import com.newtouch.base.model.FmTemplate;
import com.newtouch.base.model.FmTemplateAttributes;
import com.newtouch.base.model.QsnPaper;
import com.newtouch.base.param.FkRulesReqParam;
import com.newtouch.base.service.DynamicFormService;
import com.newtouch.base.service.FmAttributesTypeService;
import com.newtouch.base.service.FormCollectionService;
import com.newtouch.base.service.FormTemplateService;
import com.newtouch.base.service.RuleUsedService;
import com.newtouch.base.utils.FilesUtil;
import com.newtouch.base.utils.UUIDUtils;
import com.newtouch.base.vo.ExportDataVo;
import com.newtouch.base.vo.FmCollectionVo;
import com.newtouch.base.vo.FmJsonReqParam;
import com.newtouch.flow.model.FmFlow;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.newtouch.tags.service.impl.TagsServiceImpl;
import com.uniapis.cache.CacheManager;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.FileUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.web.utils.RequestUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FormCollectionServiceImpl
implements FormCollectionService {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    FormTemplateService formTemplateService;
    @Autowired
    DynamicFormService dynamicFormService;
    @Autowired
    private TemplateConfig templateConfig;
    @Autowired
    private FmAttributesTypeService fmAttributesTypeService;
    @Autowired
    private RuleUsedService ruleUsedService;
    @Autowired
    private TagsServiceImpl tagsService;

    @Override
    public ReturnMsg addOrUpdateCollection(FmCollection fmCollection) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)fmCollection.getAppId())) {
            fmCollection.setAppId("0");
        }
        if (StrUtils.isNull((Object)fmCollection.getRenderMethod())) {
            msg.setFailMsg("[\u524d\u7aef\u6e32\u67d3\u65b9\u5f0f]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (fmCollection.getCollName().getBytes(Charset.forName("UTF-8")).length >= 256) {
            msg.setFailMsg("\u6a21\u5757\u540d\u79f0\u4e0d\u80fd\u8d85256\u5b57\u7b26\uff01");
            return msg.msg();
        }
        FmCollection fmCollectionCheck = new FmCollection();
        fmCollectionCheck.where().addEq(FmCollection.COLL_NAME, (Object)fmCollection.getCollName());
        fmCollectionCheck.where().addNotEq(FmCollection.COLL_ID, (Object)fmCollection.getCollId());
        List all = this.dao.findAll((AbsModel)fmCollectionCheck);
        if (CollectionUtils.isNotEmpty((Collection)all)) {
            msg.setFailMsg(new Message("6030005", "\u6a21\u5757\u540d\u79f0\u4e0d\u80fd\u91cd\u590d"));
            return msg.msg();
        }
        if (!StrUtils.isNull((Object)fmCollection.getCollId())) {
            String collId = fmCollection.getCollId();
            fmCollection.where().addEq(FmCollection.COLL_ID, (Object)collId).addEq(FmCollection.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
            this.dao.update((AbsModel)fmCollection);
            CacheManager.remove((String)("coll_list:" + collId));
            msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        } else {
            fmCollection.setCollId(UUIDUtils.uuid());
            this.dao.save((AbsModel)fmCollection);
            msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteCollection(String collIds) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)collIds)) {
            msg.setFailMsg(new Message("6030006", "\u6a21\u5757id\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        String[] collIdStrList = collIds.split(",");
        List<String> collIdList = Arrays.asList(collIdStrList);
        if (CollectionUtils.isEmpty(collIdList)) {
            msg.setFailMsg(new Message("6030006", "\u6a21\u5757id\u4e0d\u80fd\u4e3a\u7a7a"));
            return msg.msg();
        }
        FmTemplate fmTemplate = new FmTemplate();
        fmTemplate.where().addIn(FmTemplate.COLL_ID, collIdList);
        List all = this.dao.findAll((AbsModel)fmTemplate);
        if (CollectionUtils.isNotEmpty((Collection)all)) {
            msg.setFailMsg(new Message("6020003", "\u6a21\u5757\u4e0b\u6709\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\uff01"));
            return msg.msg();
        }
        List qsnPapers = this.dao.findAll(QsnPaper.n().where().addIn(QsnPaper.COLL_ID, collIdList).model());
        if (CollectionUtils.isNotEmpty((Collection)qsnPapers)) {
            msg.setFailMsg(new Message("6020007", "\u6a21\u5757\u4e0b\u6709\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\uff01"));
            return msg.msg();
        }
        List fmFlows = this.dao.findAll(FmFlow.n().where().addIn(FmFlow.COLL_ID, collIdList).model());
        if (CollectionUtils.isNotEmpty((Collection)fmFlows)) {
            msg.setFailMsg(new Message("6020008", "\u6a21\u5757\u4e0b\u6709\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\uff01"));
            return msg.msg();
        }
        FmCollection fmCollect = new FmCollection();
        fmCollect.setDataFlag(BaseEnum.DataFlag.UNUSABLE.getType());
        fmCollect.where().addIn(FmCollection.COLL_ID, collIdList);
        this.dao.update((AbsModel)fmCollect);
        for (String collId : collIdList) {
            CacheManager.remove((String)("coll_list:" + collId));
        }
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryCollectionList(FmCollectionVo fmCollectionVo) {
        String appId = fmCollectionVo.getAppId();
        String collName = fmCollectionVo.getCollName();
        String allFlag = fmCollectionVo.getAllFlag();
        String channelNo = fmCollectionVo.getChannelNo();
        Return msg = new Return();
        FmCollection fmCollection = new FmCollection();
        fmCollection.where().addEq(FmCollection.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
        fmCollection.where().addEq(FmCollection.APP_ID, (Object)appId);
        if (!StrUtils.isNull((Object)collName)) {
            fmCollection.where().addLike(FmCollection.COLL_NAME, (Object)collName);
        }
        if (!StrUtils.isNull((Object)channelNo)) {
            fmCollection.where().addEq(FmCollection.CHANNEL_NO, (Object)channelNo);
        }
        fmCollection.setOrderBy(FmCollection.CRT_DATE.desc());
        List fmCollections = this.dao.findAll((AbsModel)fmCollection, Boolean.valueOf(!"Y".equals(allFlag)));
        msg.getDataTable().put("collectionList", fmCollections);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryAllCollectionList() {
        Return msg = new Return();
        List fmCollections = this.dao.findAll(FmCollection.n().select(FmCollection.COLL_ID, FmCollection.COLL_NAME).where().addEq(FmCollection.DATA_FLAG, (Object)"1").model());
        msg.getDataTable().put("fmCollections", fmCollections);
        return msg.msg();
    }

    @Override
    public void exportFindJson(String[] dataIdList, HttpServletResponse response) {
        try {
            String currentTimeMillis = String.valueOf(System.currentTimeMillis());
            String baseAddress = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + "/";
            if (dataIdList != null && dataIdList.length > 0) {
                ArrayList<ExportDataVo> exportDataVos = new ArrayList<ExportDataVo>();
                for (String id : dataIdList) {
                    ExportDataVo exportDataVo = new ExportDataVo();
                    FmCollection fmCollection = new FmCollection();
                    fmCollection.where().addEq(FmCollection.COLL_ID, (Object)id);
                    fmCollection = (FmCollection)this.dao.findOne((AbsModel)fmCollection);
                    if (fmCollection == null) continue;
                    exportDataVo.setName(fmCollection.getCollName());
                    ReturnMsg msg = this.formTemplateService.queryCollectionForm(id);
                    if (msg.getDataTable().containsKey("templateList") && !StrUtils.isNull(msg.getDataTable().get("templateList"))) {
                        List fmTemplates = (List)msg.getDataTable().get("templateList");
                        FmJsonReqParam reqVo = new FmJsonReqParam();
                        for (FmTemplate fmTemplate : fmTemplates) {
                            reqVo.setTemplateId(fmTemplate.getTemplateId());
                            fmTemplate.setAttrList(this.dynamicFormService.getAttrListJson(reqVo));
                            FkRulesReqParam fkRulesReqParam = new FkRulesReqParam();
                            fkRulesReqParam.setRelateField("template_id");
                            fkRulesReqParam.setRelateTab("fm_template");
                            fkRulesReqParam.setRelateFk(fmTemplate.getTemplateId());
                            List saveRuleUsedParamsList = this.ruleUsedService.queryRulesByFk(fkRulesReqParam);
                            fmTemplate.setRules(saveRuleUsedParamsList);
                            List<ScpzMaterialTagsRelation> scpzTagsRelationList = this.tagsService.findScpzMaterialTagsRelationList(fmTemplate.getTemplateId(), "template_id", "fm_template");
                            fmTemplate.setScpzMaterialTagsRelationList(scpzTagsRelationList);
                        }
                        fmCollection.setTemplateList(fmTemplates);
                    }
                    exportDataVo.setJson(JsonUtils.toJson((Object)((Object)fmCollection)));
                    exportDataVos.add(exportDataVo);
                }
                for (ExportDataVo data : exportDataVos) {
                    FilesUtil.createFile(baseAddress + data.getName() + ".json");
                    FilesUtil.writeToFile(baseAddress + data.getName() + ".json", data.getJson(), false);
                }
            }
            String zipFile = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + ".zip";
            Ulog.info((String)("baseAddress----" + baseAddress));
            Ulog.info((String)("zipFile----" + zipFile));
            String zip = FileUtils.zip((String)baseAddress, (String)zipFile, (String[])new String[]{".json", ".xlsx"});
            Ulog.info((String)("zip----" + zip));
            File file = new File(zipFile);
            FileInputStream inputStream = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            inputStream.read(data);
            inputStream.close();
            response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
            response.setContentType("application/octet-stream;charset=ISO8859-1");
            response.addHeader("Content-Length", "" + file.length());
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(currentTimeMillis + ".zip", "UTF-8"));
            ServletOutputStream stream = response.getOutputStream();
            stream.write(data);
            stream.flush();
            stream.close();
            FilesUtil.delFile(baseAddress);
            FilesUtil.delFile(zipFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ReturnMsg uploadCollection(MultipartFile zipFile) {
        String pathName = this.templateConfig.getUploadFormCollectPath() + "/upload/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        Return msg = FilesUtil.unzipFile(zipFile, pathName);
        if (!msg.isSuccessflag()) {
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"));
            return msg.msg();
        }
        File importDir = new File(pathName);
        ArrayList<File> fileList = new ArrayList<File>();
        FilesUtil.getAllFiles(importDir, fileList);
        Ulog.info((String)("\u83b7\u53d6\u9700\u8981\u8bfb\u53d6\u7684\u6587\u4ef6" + JsonUtils.toJson(fileList)));
        Iterator iterator = fileList.iterator();
        block14: while (true) {
            if (!iterator.hasNext()) {
                FilesUtil.delFile(pathName);
                msg.setSuccessMsg(new Message("6030002", "\u6a21\u5757\u5bfc\u5165\u6210\u529f"));
                return msg.msg();
            }
            File jsonFile = (File)iterator.next();
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
                Throwable throwable = null;
                try {
                    ReturnMsg returnMsg;
                    int ch = 0;
                    StringBuilder sb = new StringBuilder();
                    while ((ch = ((Reader)reader).read()) != -1) {
                        sb.append((char)ch);
                    }
                    String jsonStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u6a21\u5757\u6570\u636e\u4e3a" + jsonStr));
                    FmCollection fmCollection = (FmCollection)((Object)JsonUtils.json2Class((String)jsonStr, FmCollection.class));
                    fmCollection.where().addEq(FmCollection.COLL_ID, (Object)fmCollection.getCollId());
                    int count = this.dao.delete((AbsModel)fmCollection);
                    List fmTemplateDbList = this.dao.findAll(FmTemplate.n().where().addEq(FmTemplate.COLL_ID, (Object)fmCollection.getCollId()).model());
                    int relCount = this.dao.delete(FmTemplate.n().where().addEq(FmTemplate.COLL_ID, (Object)fmCollection.getCollId()).model());
                    Ulog.info((String)("\u5220\u9664\u6a21\u5757\u548c\u6a21\u677f\u5173\u7cfb\u6210\u529f--\u6a21\u5757:" + count + "--\u6a21\u677f\u9875\u9762:" + relCount));
                    Ulog.info((String)("\u4fdd\u5b58\u7684\u6a21\u5757\u6570\u636e\u4e3a:" + JsonUtils.toJson((Object)((Object)fmCollection))));
                    this.dao.save((AbsModel)fmCollection);
                    List<FmTemplate> fmTemplates = fmCollection.getTemplateList();
                    Map<String, String> typeMap = this.fmAttributesTypeService.getAttrMap();
                    if (typeMap == null) {
                        msg.setFailMsg(new Message("6030003", "\u6570\u636e\u5e93\u7f3a\u5c11\u9875\u9762\u5bf9\u5e94\u5173\u7cfb"));
                        returnMsg = msg.msg();
                        return returnMsg;
                    }
                    returnMsg = fmTemplates.iterator();
                    while (true) {
                        if (!returnMsg.hasNext()) continue block14;
                        FmTemplate fmTemplate = returnMsg.next();
                        String templateId = fmTemplate.getTemplateId();
                        FmTemplate fmTemplateDb = new FmTemplate();
                        for (FmTemplate ft : fmTemplateDbList) {
                            if (!ft.getTemplateId().equals(templateId)) continue;
                            fmTemplateDb = ft;
                        }
                        int tableCount = this.dao.delete(FmTemplate.n().where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId).model());
                        this.ruleUsedService.deleteByRelateFks(templateId, "fm_template");
                        FmTemplateAttributes attr = new FmTemplateAttributes();
                        attr.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId);
                        List allOldAttr = this.dao.findAll((AbsModel)attr);
                        if (CollectionUtils.isNotEmpty((Collection)allOldAttr)) {
                            for (FmTemplateAttributes attributes : allOldAttr) {
                                this.ruleUsedService.deleteByRelateFks(attributes.getAttrId(), "fm_template_attributes");
                            }
                        }
                        int columnCount = this.dao.delete(FmTemplateAttributes.n().where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).model());
                        Ulog.info((String)("\u5220\u9664\u6a21\u677f\u548c\u5c5e\u6027\u5173\u7cfb\u6210\u529f--\u6a21\u677f\u9875\u9762:" + tableCount + "--\u6a21\u677f\u9875\u9762\u6240\u5c5e\u5c5e\u6027:" + columnCount));
                        ReturnMsg returnMsg2 = this.dynamicFormService.createFormTemplate(fmTemplate, fmTemplateDb, allOldAttr, typeMap);
                        Ulog.info((String)RequestUtils.return2Json((ReturnMsg)returnMsg2));
                        if (!returnMsg2.isSuccessflag()) {
                            msg.getDtildMsg().addAll(returnMsg2.getMsgList());
                        }
                        this.tagsService.saveScpzMaterialTagsRelationList(templateId, "template_id", "fm_template", fmTemplate.getScpzMaterialTagsRelationList());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Ulog.error((Throwable)e);
                e.printStackTrace();
                msg.setFailMsg(new Message("6030001", "\u6a21\u5757\u5bfc\u5165\u5931\u8d25"));
                return msg.msg();
            }
        }
    }
}

