/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.service.impl;

import com.newtouch.base.enums.BaseEnum;
import com.newtouch.base.model.JkDataInfo;
import com.newtouch.base.model.JkInterfaceInfo;
import com.newtouch.base.model.JkMappingRule;
import com.newtouch.base.service.JkInterfaceService;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class JkInterfaceServiceImpl
implements JkInterfaceService {
    @Autowired
    AbsModelRepository dao;

    @Override
    public ReturnMsg editJk(JkInterfaceInfo jkInterfaceInfo) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)jkInterfaceInfo.getJkUuid())) {
            String jkUuid = UUID.shortUUID();
            jkInterfaceInfo.setJkUuid(jkUuid);
            jkInterfaceInfo.setSerno(UUID.shortUUID());
            this.dao.save((AbsModel)jkInterfaceInfo);
            msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        } else {
            jkInterfaceInfo.where().addEq(JkInterfaceInfo.JK_UUID, (Object)jkInterfaceInfo.getJkUuid());
            this.dao.update((AbsModel)jkInterfaceInfo);
            msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg delJk(String jkDelList) {
        String[] jkDels;
        Return msg = new Return();
        if (StrUtils.isNull((Object)jkDelList)) {
            msg.setFailMsg("\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u63a5\u53e3");
            return msg.msg();
        }
        for (String jkDel : jkDels = jkDelList.split(",")) {
            JkInterfaceInfo jk = new JkInterfaceInfo();
            jk.where().addEq(JkInterfaceInfo.JK_UUID, (Object)jkDel);
            this.dao.delete((AbsModel)jk);
            List dataInfos = this.dao.findAll(JkDataInfo.n().where().addEq(JkDataInfo.JK_UUID, (Object)jkDel).model());
            if (CollectionUtils.isEmpty((Collection)dataInfos)) continue;
            List<String> delDataUuids = dataInfos.stream().map(p -> {
                if ("SOURCE".equals(p.getDataType())) {
                    return p.getDataUuid();
                }
                return null;
            }).collect(Collectors.toList());
            this.dao.delete(JkDataInfo.n().where().addEq(JkDataInfo.JK_UUID, (Object)jkDel).model());
            if (CollectionUtils.isEmpty(delDataUuids)) continue;
            this.dao.delete(JkMappingRule.n().where().addIn(JkMappingRule.SOURCE_DATA_UUID, delDataUuids.toArray(new String[0])).model());
        }
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryJk(JkInterfaceInfo jkInterfaceInfo) {
        Return msg = new Return();
        JkInterfaceInfo jkInfo = new JkInterfaceInfo();
        jkInfo.where().addLike(JkInterfaceInfo.JK_NAME, (Object)jkInterfaceInfo.getJkName());
        if (!StrUtils.isNull((Object)jkInterfaceInfo.getJkUuid())) {
            jkInfo.where().addEq(JkInterfaceInfo.JK_UUID, (Object)jkInterfaceInfo.getJkUuid());
        }
        if (!StrUtils.isNull((Object)jkInterfaceInfo.getJkNo())) {
            jkInfo.where().addEq(JkInterfaceInfo.JK_NO, (Object)jkInterfaceInfo.getJkNo());
        }
        if (!StrUtils.isNull((Object)jkInterfaceInfo.getDeliveryPlatform())) {
            jkInfo.where().addEq(JkInterfaceInfo.DELIVERY_PLATFORM, (Object)jkInterfaceInfo.getDeliveryPlatform());
        }
        if (!StrUtils.isNull((Object)jkInterfaceInfo.getReqType())) {
            jkInfo.where().addEq(JkInterfaceInfo.REQ_TYPE, (Object)jkInterfaceInfo.getReqType());
        }
        if (!StrUtils.isNull((Object)jkInterfaceInfo.getJkUrl())) {
            jkInfo.where().addLike(JkInterfaceInfo.JK_URL, (Object)jkInterfaceInfo.getJkUrl());
        }
        if (!StrUtils.isNull((Object)jkInterfaceInfo.getDataFormat())) {
            jkInfo.where().addEq(JkInterfaceInfo.DATA_FORMAT, (Object)jkInterfaceInfo.getDataFormat());
        }
        if (!StrUtils.isNull((Object)jkInterfaceInfo.getDataSource())) {
            jkInfo.where().addEq(JkInterfaceInfo.DATA_SOURCE, (Object)jkInterfaceInfo.getDataSource());
        }
        if (!StrUtils.isNull((Object)jkInterfaceInfo.getUseScen())) {
            jkInfo.where().addEq(JkInterfaceInfo.USE_SCEN, (Object)jkInterfaceInfo.getUseScen());
        }
        jkInfo.where().addEq(JkInterfaceInfo.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
        jkInfo.setOrderBy(JkInterfaceInfo.CRT_DATE.desc());
        List jkInterfaceInfos = this.dao.findAll((AbsModel)jkInfo, Boolean.valueOf(true));
        msg.getDataTable().put("jkList", jkInterfaceInfos);
        return msg.msg();
    }
}

