/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.flow.uploadParam;

import com.newtouch.base.model.FmCollection;
import com.newtouch.base.model.FmTemplate;
import com.newtouch.base.model.FmTemplateAttributes;
import com.newtouch.base.param.SaveRuleUsedParam;
import com.newtouch.base.service.DynamicFormService;
import com.newtouch.base.service.FmAttributesTypeService;
import com.newtouch.base.service.RuleUsedService;
import com.newtouch.flow.model.FmFlow;
import com.newtouch.flow.model.FmFlowRelation;
import com.newtouch.flow.model.FmNode;
import com.newtouch.flow.model.FmRouter;
import com.newtouch.flow.param.AddTagsRelationParam;
import com.newtouch.flow.param.QueryTagsRelationReturn;
import com.newtouch.issue.model.WtIssue;
import com.newtouch.issue.service.impl.WtIssueServiceImpl;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.newtouch.material.model.ScpzTags;
import com.newtouch.tags.service.impl.TagsServiceImpl;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import com.uniapis.web.utils.RequestUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class NodeAndTemplateParam {
    private AbsModelRepository dao = (AbsModelRepository)SpringContext.getBean(AbsModelRepository.class);
    private RuleUsedService ruleUsedService = (RuleUsedService)SpringContext.getBean(RuleUsedService.class);
    private TagsServiceImpl tagsService = (TagsServiceImpl)SpringContext.getBean(TagsServiceImpl.class);
    private WtIssueServiceImpl wtIssueServiceImpl = (WtIssueServiceImpl)SpringContext.getBean(WtIssueServiceImpl.class);
    private FmAttributesTypeService fmAttributesTypeService = (FmAttributesTypeService)SpringContext.getBean(FmAttributesTypeService.class);
    private DynamicFormService dynamicFormService = (DynamicFormService)SpringContext.getBean(DynamicFormService.class);
    private FmFlow flow;

    public NodeAndTemplateParam(String jsonStr) {
        this.flow = (FmFlow)((Object)JsonUtils.json2Class((String)jsonStr, FmFlow.class));
    }

    public void updateFlow() {
        FmFlow flowOld = new FmFlow();
        flowOld.where().addEq(FmFlow.FLOW_UUID, (Object)this.flow.getFlowUuid()).model();
        this.dao.delete((AbsModel)flowOld);
        this.dao.save((AbsModel)this.flow);
    }

    public void uploadTags() {
        ScpzMaterialTagsRelation scpzMaterialTagsRelation1 = new ScpzMaterialTagsRelation();
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)this.flow.getFlowUuid());
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)"flow_uuid");
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)"fm_flow");
        List<ScpzMaterialTagsRelation> scpzMaterialTagsRelationList = this.flow.getScpzMaterialTagsRelationList();
        this.dao.delete((AbsModel)scpzMaterialTagsRelation1);
        if (CollectionUtils.isNotEmpty(scpzMaterialTagsRelationList)) {
            this.dao.save(scpzMaterialTagsRelationList);
            for (ScpzMaterialTagsRelation s : scpzMaterialTagsRelationList) {
                ScpzTags scpzTagsJson = s.getScpzTags();
                ScpzTags scpzTagsOld = new ScpzTags();
                scpzTagsOld.where().addEq(ScpzTags.TAG_ID, (Object)s.getTagId());
                this.dao.delete((AbsModel)scpzTagsOld);
                this.dao.save((AbsModel)scpzTagsJson);
            }
        }
    }

    public void uploadTemplate() {
        FmCollection fmCollection = this.flow.getCollection();
        FmCollection fmCollectionOld = new FmCollection();
        fmCollectionOld.where().addEq(FmCollection.COLL_ID, (Object)fmCollection.getCollId()).model();
        this.dao.delete((AbsModel)fmCollectionOld);
        this.dao.save((AbsModel)fmCollection);
    }

    public void uploadRouters() {
        List flowUuids = this.flow.getFmFlowRelations().stream().map(FmFlowRelation::getChildFlowUuid).collect(Collectors.toList());
        flowUuids.add(this.flow.getFlowUuid());
        List<FmRouter> fmRouterList = this.flow.getFmRouterList();
        flowUuids.add(this.flow.getFlowUuid());
        FmRouter fmRouterOld = new FmRouter();
        fmRouterOld.where().addIn(FmRouter.FLOW_UUID, flowUuids).model();
        this.dao.delete((AbsModel)fmRouterOld);
        this.dao.save(fmRouterList);
        for (FmRouter fmRouter : fmRouterList) {
            this.ruleUsedService.deleteByRelateFks(fmRouter.getRouterUuid(), "fm_router");
            if (!CollectionUtils.isNotEmpty(fmRouter.getRules())) continue;
            List<SaveRuleUsedParam> rules = fmRouter.getRules();
            for (SaveRuleUsedParam saveRuleUsedParam : rules) {
                this.ruleUsedService.saveRuleUsed(saveRuleUsedParam);
            }
        }
    }

    public void uploadNodes() {
        List<FmNode> fmNodeList = this.flow.getFmNodeList();
        List flowUuids = this.flow.getFmFlowRelations().stream().map(FmFlowRelation::getChildFlowUuid).collect(Collectors.toList());
        flowUuids.add(this.flow.getFlowUuid());
        FmNode fmNodeOld = new FmNode();
        fmNodeOld.where().addIn(FmNode.FLOW_UUID, flowUuids).model();
        this.dao.delete((AbsModel)fmNodeOld);
        this.dao.save(fmNodeList);
        for (FmNode fmNode : fmNodeList) {
            this.ruleUsedService.deleteByRelateFks(fmNode.getNodeNo(), "fm_node");
            if (!CollectionUtils.isNotEmpty(fmNode.getRules())) continue;
            List<SaveRuleUsedParam> rules = fmNode.getRules();
            for (SaveRuleUsedParam saveRuleUsedParam : rules) {
                this.ruleUsedService.saveRuleUsed(saveRuleUsedParam);
            }
        }
    }

    public void uploadWtIssue() {
        List<WtIssue> wtIssueList = this.flow.getWtIssueList();
        if (!StrUtils.isNull(wtIssueList)) {
            for (WtIssue wtIssue : wtIssueList) {
                WtIssue wtIssueOld = new WtIssue();
                wtIssueOld.where().addEq(WtIssue.ISSUE_UUID, (Object)wtIssue.getIssueUuid()).model();
                this.dao.delete((AbsModel)wtIssueOld);
                this.tagsService.saveQueryTagsRelationReturn(wtIssue.getIssueUuid(), "issue_uuid", "wt_issue", wtIssue.getTags());
                this.insertWtIssue(wtIssue);
                AddTagsRelationParam addTagsRelationParam = new AddTagsRelationParam();
                for (QueryTagsRelationReturn tag : wtIssue.getTags()) {
                    ScpzMaterialTagsRelation scpzMaterialTagsRelationTemp = new ScpzMaterialTagsRelation();
                    scpzMaterialTagsRelationTemp.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)tag.getRelationFk());
                    scpzMaterialTagsRelationTemp.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)tag.getRelationField());
                    scpzMaterialTagsRelationTemp.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)tag.getRelationTab());
                    scpzMaterialTagsRelationTemp.where().addEq(ScpzMaterialTagsRelation.TAG_BELONGS, (Object)tag.getTagBelongs());
                    scpzMaterialTagsRelationTemp.where().addEq(ScpzMaterialTagsRelation.TAG_ID, (Object)tag.getTagId());
                    List scpzMaterialTagsRelationCheck = this.dao.findAll((AbsModel)scpzMaterialTagsRelationTemp);
                    if (scpzMaterialTagsRelationCheck.size() > 0) continue;
                    ScpzTags scpzTags1 = new ScpzTags();
                    scpzTags1.where().addEq(ScpzTags.TAG_ID, (Object)tag.getTagId());
                    List all = this.dao.findAll((AbsModel)scpzTags1);
                    if (ObjectUtils.isEmpty((Object)all)) {
                        ScpzTags scpzTags = new ScpzTags();
                        scpzTags.setTagId(tag.getTagId());
                        scpzTags.setTagName(tag.getTagName());
                        scpzTags.setTagCategories(tag.getTagCategories());
                        this.dao.save((AbsModel)scpzTags);
                    }
                    ScpzMaterialTagsRelation scpzMaterialTagsRelation = new ScpzMaterialTagsRelation();
                    String uUid = UUID.uuid();
                    scpzMaterialTagsRelation.setTagId(tag.getTagId());
                    scpzMaterialTagsRelation.setRelationFk(tag.getRelationFk());
                    scpzMaterialTagsRelation.setRelationUuid(uUid);
                    scpzMaterialTagsRelation.setRelationTab(tag.getRelationTab());
                    scpzMaterialTagsRelation.setRelationField(tag.getRelationField());
                    scpzMaterialTagsRelation.setTagBelongs(tag.getTagBelongs());
                    this.dao.save((AbsModel)scpzMaterialTagsRelation);
                }
            }
        }
    }

    public ReturnMsg insertWtIssue(WtIssue wtIssue) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)wtIssue.getIssueName())) {
            msg.setFailMsg("\u95ee\u9898\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)wtIssue.getAnser())) {
            msg.setFailMsg("\u95ee\u9898\u7b54\u6848\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)wtIssue.getDisplayOrder())) {
            msg.setFailMsg("\u95ee\u9898\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        WtIssue issue01 = new WtIssue();
        issue01.where().addIsNotNull(WtIssue.DISPLAY_ORDER);
        issue01.groupBy().max(WtIssue.DISPLAY_ORDER);
        WtIssue maxIssue = (WtIssue)this.dao.findOne((AbsModel)issue01);
        int maxDisplayOrder = StrUtils.isNull((Object)maxIssue.getOtherProperty("max_display_order")) || maxIssue.getOtherProperty("max_display_order").equals("") ? 0 : Integer.parseInt(maxIssue.getOtherProperty("max_display_order").toString());
        int finalDisplayOrder = wtIssue.getDisplayOrder();
        WtIssue issue02 = new WtIssue();
        issue02.setDisplayOrder(maxDisplayOrder + 1);
        issue02.setIssueUuid(wtIssue.getIssueUuid());
        issue02.setIssueName(wtIssue.getIssueName());
        issue02.setAnser(wtIssue.getAnser());
        this.dao.save((AbsModel)issue02);
        issue02.setDisplayOrder(finalDisplayOrder);
        this.wtIssueServiceImpl.updateDisplayorder(issue02);
        msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        WtIssue wtIssue03 = new WtIssue();
        wtIssue03.where().addEq(WtIssue.ISSUE_UUID, (Object)wtIssue.getIssueUuid());
        WtIssue issue04 = (WtIssue)this.dao.findOne((AbsModel)wtIssue03);
        msg.setDataTable(new Object[]{issue04});
        return msg.msg();
    }

    public void uploadTemplateLists() {
        List<FmTemplate> fmTemplates = this.flow.getFmTemplateList();
        Map<String, String> typeMap = this.fmAttributesTypeService.getAttrMap();
        if (typeMap == null) {
            throw new BusinessException(new Message("6030003", "\u6570\u636e\u5e93\u7f3a\u5c11\u9875\u9762\u5bf9\u5e94\u5173\u7cfb"));
        }
        if (StrUtils.isNull(fmTemplates)) {
            return;
        }
        for (FmTemplate fmTemplate : fmTemplates) {
            String templateId = fmTemplate.getTemplateId();
            FmTemplate fmTemplateDb = (FmTemplate)this.dao.findOne(FmTemplate.n().where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId).model());
            int tableCount = this.dao.delete(FmTemplate.n().where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId).model());
            this.ruleUsedService.deleteByRelateFks(templateId, "fm_template");
            FmTemplateAttributes attr = new FmTemplateAttributes();
            attr.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId);
            List allOldAttr = this.dao.findAll((AbsModel)attr);
            if (CollectionUtils.isNotEmpty((Collection)allOldAttr)) {
                for (FmTemplateAttributes attributes : allOldAttr) {
                    this.ruleUsedService.deleteByRelateFks(attributes.getAttrId(), "fm_template_attributes");
                }
            }
            int columnCount = this.dao.delete(FmTemplateAttributes.n().where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).model());
            Ulog.info((String)("\u5220\u9664\u6a21\u677f\u548c\u5c5e\u6027\u5173\u7cfb\u6210\u529f--\u6a21\u677f\u9875\u9762:" + tableCount + "--\u6a21\u677f\u9875\u9762\u6240\u5c5e\u5c5e\u6027:" + columnCount));
            ReturnMsg returnMsg = this.dynamicFormService.createFormTemplate(fmTemplate, fmTemplateDb, allOldAttr, typeMap);
            Ulog.info((String)RequestUtils.return2Json((ReturnMsg)returnMsg));
            if (!returnMsg.isSuccessflag()) {
                // empty if block
            }
            this.tagsService.saveScpzMaterialTagsRelationList(templateId, "template_id", "fm_template", fmTemplate.getScpzMaterialTagsRelationList());
        }
    }

    public void saveFlowRelation() {
        List<FmFlowRelation> relations = this.flow.getFmFlowRelations();
        FmFlowRelation fmFlowRelation = new FmFlowRelation();
        fmFlowRelation.where().addEq(FmFlowRelation.FLOW_UUID, (Object)this.flow.getFlowUuid());
        this.dao.delete((AbsModel)fmFlowRelation);
        if (CollectionUtils.isNotEmpty(relations)) {
            this.dao.save(relations);
            List strings = this.flow.getFmFlowRelations().stream().map(FmFlowRelation::getChildFlowUuid).collect(Collectors.toList());
            FmFlow fmFlow = new FmFlow();
            fmFlow.where().addIn(FmFlow.FLOW_UUID, strings);
            this.dao.delete((AbsModel)fmFlow);
            this.dao.save(this.flow.getChildFmFlows());
        }
    }

    public FmFlow getFlow() {
        return this.flow;
    }

    public void setFlow(FmFlow flow) {
        this.flow = flow;
    }
}

