/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.vo.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.base.enums.RelateEnum;
import com.newtouch.base.utils.export.EqualsUtils;
import com.newtouch.base.utils.export.ExportQueryUtils;
import com.newtouch.base.utils.export.UpdateUtils;
import com.newtouch.base.vo.export.SmtrInfo;
import com.newtouch.issue.model.WtIssue;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class WtIssueInfo
implements Comparable {
    @JsonProperty(value="wtIssueList")
    private List<WtIssue> wtIssueList;
    @JsonProperty(value="smtrList")
    private List<SmtrInfo> smtrList;

    public WtIssueInfo load(String url) {
        ExportQueryUtils query = (ExportQueryUtils)SpringContext.getBean(ExportQueryUtils.class);
        String patternString = "([^&?=]+)=([^&?=]*)";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(url);
        List<String> tagIdList = new ArrayList<String>();
        String tagBelongs = "";
        String allFlag = "";
        String issueName = "";
        while (matcher.find()) {
            String group = matcher.group(1);
            if (group.equals("tagIds") && !StrUtils.isNull((Object)matcher.group(2))) {
                String tagIdsStr = matcher.group(2).replaceAll("\\[|\\]", "");
                String[] tagIds = tagIdsStr.split(",");
                tagIdList = Arrays.asList(tagIds);
            }
            if (group.equals("tag_belongs") && !StrUtils.isNull((Object)matcher.group(2))) {
                tagBelongs = matcher.group(2);
            }
            if (group.equals("allFlag") && !StrUtils.isNull((Object)matcher.group(2))) {
                allFlag = matcher.group(2);
            }
            if (!group.equals("issueName") || StrUtils.isNull((Object)matcher.group(2))) continue;
            issueName = matcher.group(2);
        }
        if (CollectionUtils.isEmpty(tagIdList)) {
            return this;
        }
        this.wtIssueList = new ArrayList<WtIssue>();
        this.smtrList = new ArrayList<SmtrInfo>();
        List<ScpzMaterialTagsRelation> scpzMaterialTagsRelations = query.querySmtr(tagIdList, RelateEnum.issue.getRelateField(), RelateEnum.issue.getRelateTab());
        if (CollectionUtils.isNotEmpty(scpzMaterialTagsRelations)) {
            for (ScpzMaterialTagsRelation smtr : scpzMaterialTagsRelations) {
                SmtrInfo si = new SmtrInfo();
                si.setSmtr(smtr);
                si.load(smtr.getTagId());
                this.smtrList.add(si);
                String relationFk = smtr.getRelationFk();
                WtIssue wtIssue = query.queryWtIssue(relationFk);
                if (wtIssue == null) continue;
                this.wtIssueList.add(wtIssue);
            }
        }
        return this;
    }

    public void merge(WtIssueInfo wtIssueInfo) {
        this.wtIssueList = EqualsUtils.merge(this.wtIssueList, wtIssueInfo.getWtIssueList());
        this.smtrList = EqualsUtils.merge(this.smtrList, wtIssueInfo.getSmtrList(), SmtrInfo.class);
    }

    public void save() {
        UpdateUtils update = (UpdateUtils)SpringContext.getBean(UpdateUtils.class);
        if (this.wtIssueList != null) {
            this.wtIssueList.forEach(m -> {
                UpdateUtils.UpdateFlag updateFlag = (UpdateUtils.UpdateFlag)((Object)((Object)m.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class)));
                if (updateFlag == UpdateUtils.UpdateFlag.U || updateFlag == UpdateUtils.UpdateFlag.I) {
                    update.update((AbsModel)m);
                }
            });
        }
        if (this.smtrList != null) {
            this.smtrList.forEach(m -> m.save());
        }
    }

    public int compareTo(@NotNull Object o) {
        UpdateUtils.UpdateFlag flag = UpdateUtils.UpdateFlag.U;
        if (CollectionUtils.isNotEmpty(this.wtIssueList)) {
            flag = (UpdateUtils.UpdateFlag)((Object)this.wtIssueList.get(0).getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class));
        }
        if (flag == UpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == UpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == UpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }

    public List<WtIssue> getWtIssueList() {
        return this.wtIssueList;
    }

    public List<SmtrInfo> getSmtrList() {
        return this.smtrList;
    }

    @JsonProperty(value="wtIssueList")
    public void setWtIssueList(List<WtIssue> wtIssueList) {
        this.wtIssueList = wtIssueList;
    }

    @JsonProperty(value="smtrList")
    public void setSmtrList(List<SmtrInfo> smtrList) {
        this.smtrList = smtrList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WtIssueInfo)) {
            return false;
        }
        WtIssueInfo other = (WtIssueInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<WtIssue> this$wtIssueList = this.getWtIssueList();
        List<WtIssue> other$wtIssueList = other.getWtIssueList();
        if (this$wtIssueList == null ? other$wtIssueList != null : !((Object)this$wtIssueList).equals(other$wtIssueList)) {
            return false;
        }
        List<SmtrInfo> this$smtrList = this.getSmtrList();
        List<SmtrInfo> other$smtrList = other.getSmtrList();
        return !(this$smtrList == null ? other$smtrList != null : !((Object)this$smtrList).equals(other$smtrList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WtIssueInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<WtIssue> $wtIssueList = this.getWtIssueList();
        result = result * 59 + ($wtIssueList == null ? 43 : ((Object)$wtIssueList).hashCode());
        List<SmtrInfo> $smtrList = this.getSmtrList();
        result = result * 59 + ($smtrList == null ? 43 : ((Object)$smtrList).hashCode());
        return result;
    }

    public String toString() {
        return "WtIssueInfo(wtIssueList=" + this.getWtIssueList() + ", smtrList=" + this.getSmtrList() + ")";
    }
}

