/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.vo.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.base.enums.RelateEnum;
import com.newtouch.base.model.DsnRules;
import com.newtouch.base.utils.export.EqualsUtils;
import com.newtouch.base.utils.export.ExportQueryUtils;
import com.newtouch.base.utils.export.UpdateUtils;
import com.newtouch.base.vo.export.ExportRuleInfo;
import com.newtouch.base.vo.export.QsnQuestionOptionsInfo;
import com.newtouch.inform.model.QsnQuestionBlanks;
import com.newtouch.inform.model.QsnQuestionOptions;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class QsnQuestionBlanksInfo
implements Comparable {
    @JsonProperty(value="qsnQuestionBlank")
    private QsnQuestionBlanks qsnQuestionBlank;
    @JsonProperty(value="qsnQuestionOptionsInfos")
    private List<QsnQuestionOptionsInfo> qsnQuestionOptionsInfos;
    @JsonProperty(value="ruleInfos")
    private List<ExportRuleInfo> ruleInfos;

    public QsnQuestionBlanksInfo load(String blankUuid) {
        ExportQueryUtils query = (ExportQueryUtils)SpringContext.getBean(ExportQueryUtils.class);
        List<QsnQuestionOptions> qsnQuestionOptions = query.queryQsnQuestionOptions(RelateEnum.blank.getRelateField(), RelateEnum.blank.getRelateTab(), blankUuid);
        this.qsnQuestionOptionsInfos = new ArrayList<QsnQuestionOptionsInfo>();
        if (CollectionUtils.isNotEmpty(qsnQuestionOptions)) {
            for (QsnQuestionOptions qqo : qsnQuestionOptions) {
                QsnQuestionOptionsInfo qqoi = new QsnQuestionOptionsInfo();
                qqoi.load(qqo.getOptionUuid());
                qqoi.setQsnQuestionOption(qqo);
                this.qsnQuestionOptionsInfos.add(qqoi);
            }
        }
        this.ruleInfos = new ArrayList<ExportRuleInfo>();
        List<DsnRules> dsnRulesList = query.queryDsnRulesList(blankUuid, RelateEnum.blank.getRelateField(), RelateEnum.blank.getRelateTab());
        if (CollectionUtils.isNotEmpty(dsnRulesList)) {
            for (DsnRules dr : dsnRulesList) {
                ExportRuleInfo eri = new ExportRuleInfo();
                eri.load(dr);
                this.ruleInfos.add(eri);
            }
        }
        return this;
    }

    public void merge(QsnQuestionBlanksInfo qqbi) {
        this.qsnQuestionBlank = EqualsUtils.merge(this.qsnQuestionBlank, qqbi.getQsnQuestionBlank());
        this.qsnQuestionOptionsInfos = EqualsUtils.merge(this.qsnQuestionOptionsInfos, qqbi.getQsnQuestionOptionsInfos(), QsnQuestionOptionsInfo.class);
        this.ruleInfos = EqualsUtils.merge(this.ruleInfos, qqbi.getRuleInfos(), ExportRuleInfo.class);
    }

    public void save() {
        UpdateUtils update = (UpdateUtils)SpringContext.getBean(UpdateUtils.class);
        UpdateUtils.UpdateFlag updateFlag = UpdateUtils.UpdateFlag.U;
        if (this.qsnQuestionBlank != null && ((updateFlag = (UpdateUtils.UpdateFlag)((Object)this.qsnQuestionBlank.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class))) == UpdateUtils.UpdateFlag.U || updateFlag == UpdateUtils.UpdateFlag.I)) {
            update.save(this.qsnQuestionBlank);
            String blankUuid = this.qsnQuestionBlank.getBlankUuid();
            QsnQuestionOptions qsnQuestionOptions = new QsnQuestionOptions();
            qsnQuestionOptions.setRelateFk(blankUuid);
            qsnQuestionOptions.setRelateField(RelateEnum.blank.getRelateField());
            qsnQuestionOptions.setRelateTab(RelateEnum.blank.getRelateTab());
            update.del(qsnQuestionOptions);
            DsnRules dsnRules = new DsnRules();
            dsnRules.setRelateFk(blankUuid);
            dsnRules.setRelateField(RelateEnum.blank.getRelateField());
            dsnRules.setRelateTab(RelateEnum.blank.getRelateTab());
            update.del((AbsModel)dsnRules);
        }
        if (this.qsnQuestionOptionsInfos != null) {
            this.qsnQuestionOptionsInfos.forEach(m -> m.save());
        }
        if (this.ruleInfos != null) {
            this.ruleInfos.forEach(m -> m.save("N"));
        }
    }

    public int compareTo(@NotNull Object o) {
        UpdateUtils.UpdateFlag flag = (UpdateUtils.UpdateFlag)((Object)this.qsnQuestionBlank.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class));
        if (flag == UpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == UpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == UpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }

    public QsnQuestionBlanks getQsnQuestionBlank() {
        return this.qsnQuestionBlank;
    }

    public List<QsnQuestionOptionsInfo> getQsnQuestionOptionsInfos() {
        return this.qsnQuestionOptionsInfos;
    }

    public List<ExportRuleInfo> getRuleInfos() {
        return this.ruleInfos;
    }

    @JsonProperty(value="qsnQuestionBlank")
    public void setQsnQuestionBlank(QsnQuestionBlanks qsnQuestionBlank) {
        this.qsnQuestionBlank = qsnQuestionBlank;
    }

    @JsonProperty(value="qsnQuestionOptionsInfos")
    public void setQsnQuestionOptionsInfos(List<QsnQuestionOptionsInfo> qsnQuestionOptionsInfos) {
        this.qsnQuestionOptionsInfos = qsnQuestionOptionsInfos;
    }

    @JsonProperty(value="ruleInfos")
    public void setRuleInfos(List<ExportRuleInfo> ruleInfos) {
        this.ruleInfos = ruleInfos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QsnQuestionBlanksInfo)) {
            return false;
        }
        QsnQuestionBlanksInfo other = (QsnQuestionBlanksInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QsnQuestionBlanks this$qsnQuestionBlank = this.getQsnQuestionBlank();
        QsnQuestionBlanks other$qsnQuestionBlank = other.getQsnQuestionBlank();
        if (this$qsnQuestionBlank == null ? other$qsnQuestionBlank != null : !((Object)((Object)this$qsnQuestionBlank)).equals((Object)other$qsnQuestionBlank)) {
            return false;
        }
        List<QsnQuestionOptionsInfo> this$qsnQuestionOptionsInfos = this.getQsnQuestionOptionsInfos();
        List<QsnQuestionOptionsInfo> other$qsnQuestionOptionsInfos = other.getQsnQuestionOptionsInfos();
        if (this$qsnQuestionOptionsInfos == null ? other$qsnQuestionOptionsInfos != null : !((Object)this$qsnQuestionOptionsInfos).equals(other$qsnQuestionOptionsInfos)) {
            return false;
        }
        List<ExportRuleInfo> this$ruleInfos = this.getRuleInfos();
        List<ExportRuleInfo> other$ruleInfos = other.getRuleInfos();
        return !(this$ruleInfos == null ? other$ruleInfos != null : !((Object)this$ruleInfos).equals(other$ruleInfos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QsnQuestionBlanksInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QsnQuestionBlanks $qsnQuestionBlank = this.getQsnQuestionBlank();
        result = result * 59 + ($qsnQuestionBlank == null ? 43 : ((Object)((Object)$qsnQuestionBlank)).hashCode());
        List<QsnQuestionOptionsInfo> $qsnQuestionOptionsInfos = this.getQsnQuestionOptionsInfos();
        result = result * 59 + ($qsnQuestionOptionsInfos == null ? 43 : ((Object)$qsnQuestionOptionsInfos).hashCode());
        List<ExportRuleInfo> $ruleInfos = this.getRuleInfos();
        result = result * 59 + ($ruleInfos == null ? 43 : ((Object)$ruleInfos).hashCode());
        return result;
    }

    public String toString() {
        return "QsnQuestionBlanksInfo(qsnQuestionBlank=" + (Object)((Object)this.getQsnQuestionBlank()) + ", qsnQuestionOptionsInfos=" + this.getQsnQuestionOptionsInfos() + ", ruleInfos=" + this.getRuleInfos() + ")";
    }
}

