/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.vo.export;

import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.DsnRulesConst;
import com.newtouch.base.model.DsnRulesParam;
import com.newtouch.base.utils.export.EqualsUtils;
import com.newtouch.base.utils.export.ExportQueryUtils;
import com.newtouch.base.utils.export.UpdateUtils;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExportRuleInfo
implements Comparable {
    private DsnRules dsnRules;
    private List<DsnRulesParam> params;
    private List<DsnRulesConst> consts;

    public ExportRuleInfo load(DsnRules dsnRules) {
        this.dsnRules = dsnRules;
        if (this.dsnRules == null) {
            return this;
        }
        ExportQueryUtils utils = (ExportQueryUtils)SpringContext.getBean(ExportQueryUtils.class);
        this.params = utils.queryRuleParam(this.dsnRules.getRuleId());
        this.consts = utils.queryRuleConst(this.dsnRules.getRuleId());
        return this;
    }

    public void merge(ExportRuleInfo exportRuleInfo) {
        this.dsnRules = EqualsUtils.merge(this.dsnRules, exportRuleInfo.getDsnRules());
        this.params = EqualsUtils.merge(this.params, exportRuleInfo.getParams());
        this.consts = EqualsUtils.merge(this.consts, exportRuleInfo.getConsts());
    }

    public void save(String isDel) {
        UpdateUtils update = (UpdateUtils)SpringContext.getBean(UpdateUtils.class);
        UpdateUtils.UpdateFlag updateFlag = UpdateUtils.UpdateFlag.U;
        if (this.dsnRules != null) {
            updateFlag = (UpdateUtils.UpdateFlag)((Object)this.dsnRules.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class));
            if ("Y".equals(isDel)) {
                update.update((AbsModel)this.dsnRules);
            } else if (updateFlag == UpdateUtils.UpdateFlag.U || updateFlag == UpdateUtils.UpdateFlag.I) {
                update.save((AbsModel)this.dsnRules);
                String ruleId = this.dsnRules.getRuleId();
                DsnRulesParam dsnRulesParam = new DsnRulesParam();
                dsnRulesParam.setRuleId(ruleId);
                update.del((AbsModel)dsnRulesParam);
                DsnRulesConst dsnRulesConst = new DsnRulesConst();
                dsnRulesConst.setRuleId(ruleId);
                update.del((AbsModel)dsnRulesConst);
            }
        }
        for (DsnRulesConst dsnRulesConst : this.consts) {
            if ("Y".equals(isDel)) {
                update.update((AbsModel)dsnRulesConst);
                continue;
            }
            if (updateFlag != UpdateUtils.UpdateFlag.U && updateFlag != UpdateUtils.UpdateFlag.I) continue;
            update.save((AbsModel)dsnRulesConst);
        }
        for (DsnRulesParam dsnRulesParam : this.params) {
            if ("Y".equals(isDel)) {
                update.update((AbsModel)dsnRulesParam);
                continue;
            }
            if (updateFlag != UpdateUtils.UpdateFlag.U && updateFlag != UpdateUtils.UpdateFlag.I) continue;
            update.save((AbsModel)dsnRulesParam);
        }
    }

    public int compareTo(@NotNull Object o) {
        UpdateUtils.UpdateFlag flag = (UpdateUtils.UpdateFlag)((Object)this.dsnRules.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class));
        if (flag == UpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == UpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == UpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }

    public DsnRules getDsnRules() {
        return this.dsnRules;
    }

    public List<DsnRulesParam> getParams() {
        return this.params;
    }

    public List<DsnRulesConst> getConsts() {
        return this.consts;
    }

    public void setDsnRules(DsnRules dsnRules) {
        this.dsnRules = dsnRules;
    }

    public void setParams(List<DsnRulesParam> params) {
        this.params = params;
    }

    public void setConsts(List<DsnRulesConst> consts) {
        this.consts = consts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportRuleInfo)) {
            return false;
        }
        ExportRuleInfo other = (ExportRuleInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DsnRules this$dsnRules = this.getDsnRules();
        DsnRules other$dsnRules = other.getDsnRules();
        if (this$dsnRules == null ? other$dsnRules != null : !this$dsnRules.equals(other$dsnRules)) {
            return false;
        }
        List<DsnRulesParam> this$params = this.getParams();
        List<DsnRulesParam> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        List<DsnRulesConst> this$consts = this.getConsts();
        List<DsnRulesConst> other$consts = other.getConsts();
        return !(this$consts == null ? other$consts != null : !((Object)this$consts).equals(other$consts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExportRuleInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DsnRules $dsnRules = this.getDsnRules();
        result = result * 59 + ($dsnRules == null ? 43 : $dsnRules.hashCode());
        List<DsnRulesParam> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        List<DsnRulesConst> $consts = this.getConsts();
        result = result * 59 + ($consts == null ? 43 : ((Object)$consts).hashCode());
        return result;
    }

    public String toString() {
        return "ExportRuleInfo(dsnRules=" + this.getDsnRules() + ", params=" + this.getParams() + ", consts=" + this.getConsts() + ")";
    }
}

