/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.utils.export;

import com.newtouch.base.model.ComponentAttribute;
import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.DsnRulesConst;
import com.newtouch.base.model.DsnRulesParam;
import com.newtouch.base.model.FmAttributesType;
import com.newtouch.base.model.FmTemplateAttributes;
import com.newtouch.base.model.FmTemplateText;
import com.newtouch.flow.model.FmProductFlowLink;
import com.newtouch.inform.model.QsnQuestionBlanks;
import com.newtouch.inform.model.QsnQuestionOptions;
import com.newtouch.issue.model.WtIssue;
import com.newtouch.material.model.ScglAuthorized;
import com.newtouch.material.model.ScpzReference;
import com.newtouch.material.model.ScpzTags;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateUtils {
    @Autowired
    AbsModelRepository dao;

    public void update(AbsModel model) {
        if (model == null) {
            return;
        }
        String name = model.getClass().getName();
        UpdateFlag updateFlag = (UpdateFlag)((Object)model.getOtherProperty("update_flag", UpdateFlag.class));
        if (updateFlag == null) {
            return;
        }
        switch (updateFlag) {
            case I: {
                DsnRules rules;
                int delete = 0;
                if (!(model instanceof DsnRules || model instanceof DsnRulesConst || model instanceof DsnRulesParam || model instanceof WtIssue || model instanceof ScpzTags)) {
                    delete = this.dao.delete(model.getSerno(), model.getClass());
                }
                if (model instanceof DsnRules) {
                    rules = (DsnRules)model;
                    rules.where().addEq(DsnRules.RULE_ID, (Object)rules.getRuleId());
                    this.dao.delete((AbsModel)rules);
                }
                if (model instanceof DsnRulesConst) {
                    rules = (DsnRulesConst)model;
                    rules.where().addEq(DsnRulesConst.CONST_MAPPING, (Object)rules.getConstMapping());
                    rules.where().addEq(DsnRulesConst.RULE_ID, (Object)rules.getRuleId());
                    this.dao.delete((AbsModel)rules);
                }
                if (model instanceof DsnRulesParam) {
                    rules = (DsnRulesParam)model;
                    rules.where().addEq(DsnRulesParam.PARAM_ID, (Object)rules.getParamId());
                    rules.where().addEq(DsnRules.RULE_ID, (Object)rules.getRuleId());
                    this.dao.delete((AbsModel)rules);
                }
                if (model instanceof WtIssue) {
                    WtIssue wtIssue = (WtIssue)model;
                    wtIssue.where().addEq(WtIssue.ISSUE_UUID, (Object)wtIssue.getIssueUuid());
                    this.dao.delete((AbsModel)wtIssue);
                }
                if (model instanceof ScpzTags) {
                    ScpzTags scpzTags = (ScpzTags)model;
                    scpzTags.where().addEq(ScpzTags.TAG_ID, (Object)scpzTags.getTagId());
                    this.dao.delete((AbsModel)scpzTags);
                }
                this.dao.save(model);
                break;
            }
            case U: {
                this.dao.update(model.getSerno(), model);
                break;
            }
            case D: {
                DsnRules rules;
                if (!(model instanceof DsnRules || model instanceof DsnRulesConst || model instanceof DsnRulesParam)) {
                    this.dao.delete(model.getSerno(), model.getClass());
                }
                if (model instanceof DsnRules) {
                    rules = (DsnRules)model;
                    rules.where().addEq(DsnRules.RULE_ID, (Object)rules.getRuleId());
                    this.dao.delete((AbsModel)rules);
                }
                if (model instanceof DsnRulesConst) {
                    rules = (DsnRulesConst)model;
                    rules.where().addEq(DsnRulesConst.CONST_MAPPING, (Object)rules.getConstMapping());
                    rules.where().addEq(DsnRulesConst.RULE_ID, (Object)rules.getRuleId());
                    this.dao.delete((AbsModel)rules);
                }
                if (!(model instanceof DsnRulesParam)) break;
                rules = (DsnRulesParam)model;
                rules.where().addEq(DsnRulesParam.PARAM_ID, (Object)rules.getParamId());
                rules.where().addEq(DsnRules.RULE_ID, (Object)rules.getRuleId());
                this.dao.delete((AbsModel)rules);
                break;
            }
        }
    }

    public void del(AbsModel model) {
        FmProductFlowLink fmProductFlowLink;
        DsnRulesConst dsnRulesConst;
        DsnRulesParam dsnRulesParam;
        DsnRules dsnRules;
        ScglAuthorized sa;
        ScpzReference sr;
        FmAttributesType fat;
        ComponentAttribute ca;
        FmTemplateText ftt;
        FmTemplateAttributes fta;
        QsnQuestionOptions qsnQuestionOptions;
        if (model == null) {
            return;
        }
        if (model instanceof QsnQuestionBlanks) {
            QsnQuestionBlanks qsnQuestionBlanks = (QsnQuestionBlanks)model;
            if (!StrUtils.isNull((Object)qsnQuestionBlanks.getQuestionUuid())) {
                qsnQuestionBlanks.where().addEq(QsnQuestionBlanks.QUESTION_UUID, (Object)qsnQuestionBlanks.getQuestionUuid());
                this.dao.delete((AbsModel)qsnQuestionBlanks);
            } else {
                qsnQuestionBlanks.where().addEq(QsnQuestionOptions.RELATE_FIELD, (Object)qsnQuestionBlanks.getRelateField());
                qsnQuestionBlanks.where().addEq(QsnQuestionOptions.RELATE_TAB, (Object)qsnQuestionBlanks.getRelateTab());
                qsnQuestionBlanks.where().addEq(QsnQuestionOptions.RELATE_FK, (Object)qsnQuestionBlanks.getRelateFk());
                this.dao.delete((AbsModel)qsnQuestionBlanks);
            }
        }
        if (model instanceof QsnQuestionOptions && !StrUtils.isNull((Object)(qsnQuestionOptions = (QsnQuestionOptions)model).getRelateFk())) {
            qsnQuestionOptions.where().addEq(QsnQuestionOptions.RELATE_FIELD, (Object)qsnQuestionOptions.getRelateField());
            qsnQuestionOptions.where().addEq(QsnQuestionOptions.RELATE_TAB, (Object)qsnQuestionOptions.getRelateTab());
            qsnQuestionOptions.where().addEq(QsnQuestionOptions.RELATE_FK, (Object)qsnQuestionOptions.getRelateFk());
            this.dao.delete((AbsModel)qsnQuestionOptions);
        }
        if (model instanceof FmTemplateAttributes && !StrUtils.isNull((Object)(fta = (FmTemplateAttributes)model).getTemplateId())) {
            fta.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)fta.getTemplateId());
            this.dao.delete((AbsModel)fta);
        }
        if (model instanceof FmTemplateText && !StrUtils.isNull((Object)(ftt = (FmTemplateText)model).getAttrId())) {
            ftt.where().addEq(FmTemplateText.ATTR_ID, (Object)ftt.getAttrId());
            this.dao.delete((AbsModel)ftt);
        }
        if (model instanceof ComponentAttribute && !StrUtils.isNull((Object)(ca = (ComponentAttribute)model).getComponentId())) {
            ca.where().addEq(ComponentAttribute.COMPONENT_ID, (Object)ca.getComponentId());
            this.dao.delete((AbsModel)ca);
        }
        if (model instanceof FmAttributesType && !StrUtils.isNull((Object)(fat = (FmAttributesType)model).getComponentType())) {
            fat.where().addEq(FmAttributesType.COMPONENT_TYPE, (Object)fat.getComponentType());
            this.dao.delete((AbsModel)fat);
        }
        if (model instanceof ScpzReference && !StrUtils.isNull((Object)(sr = (ScpzReference)model).getMaterialId())) {
            sr.where().addEq(ScpzReference.MATERIAL_ID, (Object)sr.getMaterialId());
            this.dao.delete((AbsModel)sr);
        }
        if (model instanceof ScglAuthorized && !StrUtils.isNull((Object)(sa = (ScglAuthorized)model).getMaterialId())) {
            sa.where().addEq(ScglAuthorized.MATERIAL_ID, (Object)sa.getMaterialId());
            this.dao.delete((AbsModel)sa);
        }
        if (model instanceof DsnRules && !StrUtils.isNull((Object)(dsnRules = (DsnRules)model).getRelateFk())) {
            dsnRules.where().addEq(DsnRules.RELATE_FIELD, (Object)dsnRules.getRelateField());
            dsnRules.where().addEq(DsnRules.RELATE_TAB, (Object)dsnRules.getRelateTab());
            dsnRules.where().addEq(DsnRules.RELATE_FK, (Object)dsnRules.getRelateFk());
            this.dao.delete((AbsModel)dsnRules);
        }
        if (model instanceof DsnRulesParam && !StrUtils.isNull((Object)(dsnRulesParam = (DsnRulesParam)model).getRuleId())) {
            dsnRulesParam.where().addEq(DsnRulesParam.RULE_ID, (Object)dsnRulesParam.getRuleId());
            this.dao.delete((AbsModel)dsnRulesParam);
        }
        if (model instanceof DsnRulesConst && !StrUtils.isNull((Object)(dsnRulesConst = (DsnRulesConst)model).getRuleId())) {
            dsnRulesConst.where().addEq(DsnRulesConst.RULE_ID, (Object)dsnRulesConst.getRuleId());
            this.dao.delete((AbsModel)dsnRulesConst);
        }
        if (model instanceof FmProductFlowLink && !StrUtils.isNull((Object)(fmProductFlowLink = (FmProductFlowLink)model).getProductFlowUuid())) {
            fmProductFlowLink.where().addEq(FmProductFlowLink.PRODUCT_FLOW_UUID, (Object)fmProductFlowLink.getProductFlowUuid());
            this.dao.delete((AbsModel)fmProductFlowLink);
        }
    }

    public void save(AbsModel model) {
        UpdateFlag updateFlag = (UpdateFlag)((Object)model.getOtherProperty("update_flag", UpdateFlag.class));
        if (updateFlag == null) {
            return;
        }
        switch (updateFlag) {
            case I: {
                this.dao.save(model);
                break;
            }
            case U: {
                this.dao.update(model.getSerno(), model);
                break;
            }
        }
    }

    public static enum UpdateFlag {
        I,
        U,
        D;

    }
}

