/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.issue.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.newtouch.flow.param.QueryTagsRelationParam;
import com.newtouch.flow.param.QueryTagsRelationReturn;
import com.newtouch.issue.model.WtIssue;
import com.newtouch.issue.param.AddScpzMaterialTagsRelationParam;
import com.newtouch.issue.param.DeleteWtIssueParam;
import com.newtouch.issue.param.QueryWtIssueParam;
import com.newtouch.issue.service.IWtIssueService;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.newtouch.material.model.ScpzTags;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class WtIssueServiceImpl
implements IWtIssueService {
    @Autowired
    AbsModelRepository dao;
    private static final String relation_tab = "wt_issue";
    private static final String relation_field = "issue_uuid";

    @Override
    public ReturnMsg queryWtIssueList(QueryWtIssueParam queryWtIssueParam) {
        Return msg = new Return();
        QueryTagsRelationParam tag = new QueryTagsRelationParam();
        tag.setRelationTab(relation_tab);
        tag.setRelationField(relation_field);
        tag.setTagBelongs(queryWtIssueParam.getTagBelongs());
        tag.setTagsId(queryWtIssueParam.getTagIds());
        ReturnMsg msgTag = this.queryTagsRelation(tag);
        List tagsList = msgTag.getDataList(QueryTagsRelationReturn.class);
        List idList = null;
        Map<Object, Object> listMaps = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)tagsList)) {
            idList = tagsList.stream().map(QueryTagsRelationReturn::getRelationFk).collect(Collectors.toList());
            listMaps = tagsList.stream().collect(Collectors.groupingBy(QueryTagsRelationReturn::getRelationFk));
        }
        WtIssue wtIssue = new WtIssue();
        if (!StrUtils.isNull((Object)queryWtIssueParam.getIssueName())) {
            wtIssue.where().addLike(WtIssue.ISSUE_NAME, (Object)queryWtIssueParam.getIssueName());
        }
        if (CollectionUtils.isNotEmpty(queryWtIssueParam.getTagIds())) {
            if (CollectionUtils.isEmpty(idList)) {
                ArrayList wtIssueList = new ArrayList();
                msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
                msg.setDataList(wtIssueList, WtIssue.class);
                return msg.msg();
            }
            wtIssue.where().addIn(WtIssue.ISSUE_UUID, idList);
        }
        wtIssue.where().addEq(WtIssue.DATA_FLAG, (Object)1);
        wtIssue.setOrderBy(WtIssue.DISPLAY_ORDER.asc());
        List mapList = new ArrayList();
        String allFlag = queryWtIssueParam.getAllFlag();
        mapList = !StrUtils.isNull((Object)allFlag) && "Y".equals(allFlag) ? this.dao.findAll((AbsModel)wtIssue, Boolean.valueOf(false)) : this.dao.findAll((AbsModel)wtIssue, Boolean.valueOf(true));
        Map<Object, Object> finalListMaps = listMaps;
        mapList.stream().forEach(o -> {
            if (CollectionUtils.isNotEmpty((Collection)((Collection)finalListMaps.get(o.getIssueUuid())))) {
                o.setTags((List)finalListMaps.get(o.getIssueUuid()));
            }
        });
        msg.setDataList(mapList, WtIssue.class);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    private void setTagIds(List<Map<String, Object>> mapList) {
        mapList.stream().forEach(o -> {
            if (!StrUtils.isNull(o.get("tag_ids"))) {
                List<String> tags = Arrays.asList(String.valueOf(o.get("tag_ids")).split(","));
                ArrayList maps = new ArrayList();
                tags.stream().forEach(i -> {
                    ScpzTags scpzTags = (ScpzTags)this.dao.findOne(ScpzTags.n().where().addEq(ScpzTags.TAG_ID, i).model());
                    maps.add(scpzTags);
                });
                o.put("tags", maps);
            }
        });
    }

    @Override
    public ReturnMsg insertWtIssue(WtIssue wtIssue) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)wtIssue.getIssueName())) {
            msg.setFailMsg("\u95ee\u9898\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)wtIssue.getAnser())) {
            msg.setFailMsg("\u95ee\u9898\u7b54\u6848\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)wtIssue.getDisplayOrder())) {
            msg.setFailMsg("\u95ee\u9898\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        WtIssue issue01 = new WtIssue();
        issue01.where().addIsNotNull(WtIssue.DISPLAY_ORDER);
        issue01.groupBy().max(WtIssue.DISPLAY_ORDER);
        WtIssue maxIssue = (WtIssue)this.dao.findOne((AbsModel)issue01);
        int maxDisplayOrder = StrUtils.isNull((Object)maxIssue.getOtherProperty("max_display_order")) || maxIssue.getOtherProperty("max_display_order").equals("") ? 0 : Integer.parseInt(maxIssue.getOtherProperty("max_display_order").toString());
        int finalDisplayOrder = wtIssue.getDisplayOrder();
        WtIssue issue02 = new WtIssue();
        issue02.setDisplayOrder(maxDisplayOrder + 1);
        String uUid = UUID.shortUUID();
        issue02.setIssueUuid(uUid);
        issue02.setIssueName(wtIssue.getIssueName());
        issue02.setAnser(wtIssue.getAnser());
        this.dao.save((AbsModel)issue02);
        issue02.setDisplayOrder(finalDisplayOrder);
        this.updateDisplayorder(issue02);
        msg.setSuccessMsg(new Message("2010001", "\u65b0\u589e\u6210\u529f"));
        WtIssue wtIssue03 = new WtIssue();
        wtIssue03.where().addEq(WtIssue.ISSUE_UUID, (Object)uUid);
        WtIssue issue04 = (WtIssue)this.dao.findOne((AbsModel)wtIssue03);
        msg.setDataTable(new Object[]{issue04});
        return msg.msg();
    }

    @Override
    public ReturnMsg addScpzMaterialTagsRelation(AddScpzMaterialTagsRelationParam add) {
        Return msg = new Return();
        if (add == null) {
            msg.setFailMsg("\u6570\u636e\u4f20\u8f93\u4e3a\u7a7a!");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)add.getIssueUuid())) {
            msg.setFailMsg("\u95ee\u9898id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        WtIssue wtIssue = new WtIssue();
        wtIssue.where().addEq(WtIssue.ISSUE_UUID, (Object)add.getIssueUuid());
        WtIssue issue = (WtIssue)this.dao.findOne((AbsModel)wtIssue);
        if (ObjectUtils.isEmpty((Object)((Object)wtIssue))) {
            msg.setFailMsg("\u95ee\u9898id:" + add.getIssueUuid() + "\u4e0d\u5b58\u5728");
            return msg.msg();
        }
        ScpzMaterialTagsRelation scpzMaterialTagsRelation1 = new ScpzMaterialTagsRelation();
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)add.getIssueUuid());
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)relation_field);
        scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)relation_tab);
        List scpzMaterialTagsRelationList = this.dao.findAll((AbsModel)scpzMaterialTagsRelation1);
        if (!scpzMaterialTagsRelationList.isEmpty() && scpzMaterialTagsRelationList.size() > 0) {
            this.dao.delete(ScpzMaterialTagsRelation.n().where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)add.getIssueUuid()).addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)relation_field).addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)relation_tab).model());
        }
        for (String tagsId : add.getTagsId()) {
            if (StrUtils.isNull((Object)tagsId)) {
                msg.setFailMsg("\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return msg.msg();
            }
            ScpzMaterialTagsRelation scpzMaterialTagsRelation = new ScpzMaterialTagsRelation();
            ScpzTags scpzTags = new ScpzTags();
            scpzTags.where().addEq(ScpzTags.TAG_ID, (Object)tagsId);
            List scpzTagsList = this.dao.findAll((AbsModel)scpzTags);
            if (scpzTagsList.isEmpty() || scpzTagsList.size() == 0) {
                msg.setFailMsg("\u6807\u7b7eid:" + tagsId + "\u4e0d\u5b58\u5728");
                return msg.msg();
            }
            String uUid = UUID.shortUUID();
            scpzMaterialTagsRelation.setRelationFk(add.getIssueUuid());
            scpzMaterialTagsRelation.setTagId(tagsId);
            scpzMaterialTagsRelation.setRelationUuid(uUid);
            scpzMaterialTagsRelation.setRelationTab(relation_tab);
            scpzMaterialTagsRelation.setRelationField(relation_field);
            scpzMaterialTagsRelation.setTagBelongs(add.getTagBelongs());
            this.dao.save((AbsModel)scpzMaterialTagsRelation);
        }
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteWtIssue(DeleteWtIssueParam deleteWtIssueParam) {
        Return msg = new Return();
        if (ObjectUtil.isEmpty(deleteWtIssueParam.getIssueUuids())) {
            return msg.setFailMsg("\u6d41\u7a0buuid\u4e0d\u80fd\u4e3a\u7a7a").msg();
        }
        for (String issue : deleteWtIssueParam.getIssueUuids()) {
            ScpzMaterialTagsRelation scpzMaterialTagsRelation1 = new ScpzMaterialTagsRelation();
            scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)issue);
            scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)relation_field);
            scpzMaterialTagsRelation1.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)relation_tab);
            List scpzMaterialTagsRelationList = this.dao.findAll((AbsModel)scpzMaterialTagsRelation1);
            if (scpzMaterialTagsRelationList.isEmpty() || scpzMaterialTagsRelationList.size() <= 0) continue;
            this.dao.delete(ScpzMaterialTagsRelation.n().where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)issue).addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)relation_field).addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)relation_tab).model());
        }
        WtIssue issue01 = new WtIssue();
        issue01.where().addIsNotNull(WtIssue.DISPLAY_ORDER);
        issue01.groupBy().max(WtIssue.DISPLAY_ORDER);
        WtIssue maxIssue = (WtIssue)this.dao.findOne((AbsModel)issue01);
        int maxDisplayOrder = Integer.parseInt(maxIssue.getOtherProperty("max_display_order").toString());
        for (String issueUuid : deleteWtIssueParam.getIssueUuids()) {
            WtIssue issue = new WtIssue();
            issue.where().addEq(WtIssue.ISSUE_UUID, (Object)issueUuid);
            WtIssue one = (WtIssue)this.dao.findOne((AbsModel)issue);
            one.setDisplayOrder(maxDisplayOrder + 1);
            this.updateDisplayorder(one);
            one.where().addEq(WtIssue.ISSUE_UUID, (Object)one.getIssueUuid());
            this.dao.delete((AbsModel)one);
            --maxDisplayOrder;
        }
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg moveWtIssue(WtIssue wtIssue) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)wtIssue.getIssueUuid())) {
            msg.setFailMsg("\u95ee\u9898Uuid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)wtIssue.getDisplayOrder())) {
            msg.setFailMsg("\u95ee\u9898\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        this.updateDisplayorder(wtIssue);
        msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        return msg.msg();
    }

    public void updateDisplayorder(WtIssue wtIssue) {
        WtIssue issue = new WtIssue();
        int updateDisplayOrder = wtIssue.getDisplayOrder();
        WtIssue issue02 = new WtIssue();
        issue02.where().addEq(WtIssue.ISSUE_UUID, (Object)wtIssue.getIssueUuid());
        WtIssue currIssue = (WtIssue)this.dao.findOne((AbsModel)issue02);
        int currentDisplayOrder = currIssue.getDisplayOrder();
        WtIssue issue01 = new WtIssue();
        issue01.where().addIsNotNull(WtIssue.DISPLAY_ORDER);
        issue01.groupBy().max(WtIssue.DISPLAY_ORDER);
        WtIssue maxIssue = (WtIssue)this.dao.findOne((AbsModel)issue01);
        int maxDisplayOrder = Integer.parseInt(maxIssue.getOtherProperty("max_display_order").toString());
        if (updateDisplayOrder < 1) {
            updateDisplayOrder = 1;
        }
        if (updateDisplayOrder > maxDisplayOrder) {
            updateDisplayOrder = maxDisplayOrder;
        }
        if (updateDisplayOrder <= currentDisplayOrder) {
            for (int i = currentDisplayOrder - 1; i >= updateDisplayOrder; --i) {
                WtIssue issue03 = new WtIssue();
                issue03.setDisplayOrder(i + 1);
                issue03.where().addEq(WtIssue.DISPLAY_ORDER, (Object)i);
                this.dao.update((AbsModel)issue03);
            }
        } else if (updateDisplayOrder > currentDisplayOrder) {
            for (int i = currentDisplayOrder + 1; i <= updateDisplayOrder; ++i) {
                WtIssue issue04 = new WtIssue();
                issue04.setDisplayOrder(i - 1);
                issue04.where().addEq(WtIssue.DISPLAY_ORDER, (Object)i);
                this.dao.update((AbsModel)issue04);
            }
        }
        issue.setDisplayOrder(updateDisplayOrder);
        issue.where().addEq(WtIssue.ISSUE_UUID, (Object)wtIssue.getIssueUuid());
        this.dao.update((AbsModel)issue);
    }

    @Override
    public ReturnMsg updateWtIssue(WtIssue wtIssue) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)wtIssue.getIssueUuid())) {
            msg.setFailMsg("\u95ee\u9898Uuid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)wtIssue.getIssueName())) {
            msg.setFailMsg("\u95ee\u9898\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)wtIssue.getAnser())) {
            msg.setFailMsg("\u95ee\u9898\u7b54\u6848\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)wtIssue.getDisplayOrder())) {
            msg.setFailMsg("\u95ee\u9898\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        this.updateDisplayorder(wtIssue);
        WtIssue issue = new WtIssue();
        issue.setIssueName(wtIssue.getIssueName());
        issue.setAnser(wtIssue.getAnser());
        issue.where().addEq(WtIssue.ISSUE_UUID, (Object)wtIssue.getIssueUuid());
        this.dao.update((AbsModel)issue);
        msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryTagsRelation(QueryTagsRelationParam tag) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)tag.getRelationTab())) {
            msg.setFailMsg("\u5173\u8054\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)tag.getRelationField())) {
            msg.setFailMsg("\u5173\u8054\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        if (StrUtils.isNull((Object)tag.getTagBelongs())) {
            msg.setFailMsg("\u5f52\u5c5e\u5b57\u6bb5tag_belongs\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<String> sqlParam = new ArrayList<String>();
        sql.append("select\n\tsm.relation_tab ,\n\tsm.relation_field ,\n\tsm.relation_fk ,\n\tsm.tag_belongs ,\n\tst.tag_id ,\n\tst.tag_name ,\n\tst.tag_categories\nfrom\n\tscpz_material_tags_relation sm\nleft join scpz_tags st on\n\tsm.tag_id = st.tag_id\nwhere 1=1  ");
        sql.append(" and sm.relation_tab = ? ");
        sql.append(" and sm.relation_field = ? ");
        sql.append(" and sm.tag_belongs  = ? ");
        sqlParam.add(tag.getRelationTab());
        sqlParam.add(tag.getRelationField());
        sqlParam.add(tag.getTagBelongs());
        List<String> tagIdsList = tag.getTagsId();
        if (CollectionUtils.isNotEmpty(tagIdsList)) {
            sql.append(" and sm.tag_id  in ( ");
            for (int i = 0; i < tagIdsList.size(); ++i) {
                if (i == tagIdsList.size() - 1) {
                    sql.append(" ?  ");
                } else {
                    sql.append(" ?,  ");
                }
                sqlParam.add(tagIdsList.get(i));
            }
            sql.append(")");
        }
        List mapList = this.dao.findAll(sql.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(sqlParam)});
        ArrayList tagsList = new ArrayList();
        HashSet tagsIds = new HashSet();
        mapList.stream().forEach(t -> tagsIds.add((String)t.get("relation_fk")));
        ArrayList list = new ArrayList(tagsIds);
        if (CollectionUtils.isNotEmpty(tagIdsList)) {
            if (CollectionUtils.isNotEmpty(list)) {
                StringBuilder sql2 = new StringBuilder();
                ArrayList<String> sqlParam2 = new ArrayList<String>();
                sql2.append("select\n\tsm.relation_tab ,\n\tsm.relation_field ,\n\tsm.relation_fk ,\n\tsm.tag_belongs ,\n\tst.tag_id ,\n\tst.tag_name ,\n\tst.tag_categories\nfrom\n\tscpz_material_tags_relation sm\nleft join scpz_tags st on\n\tsm.tag_id = st.tag_id\nwhere 1=1  ");
                sql2.append(" and sm.relation_tab = ? ");
                sql2.append(" and sm.relation_field = ? ");
                sql2.append(" and sm.tag_belongs  = ? ");
                sqlParam2.add(tag.getRelationTab());
                sqlParam2.add(tag.getRelationField());
                sqlParam2.add(tag.getTagBelongs());
                sql2.append(" and sm.relation_fk  in ( ");
                for (int i = 0; i < list.size(); ++i) {
                    if (i == list.size() - 1) {
                        sql2.append(" ?  ");
                    } else {
                        sql2.append(" ?,  ");
                    }
                    sqlParam2.add((String)list.get(i));
                }
                sql2.append(")");
                List mapList2 = this.dao.findAll(sql2.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(sqlParam2)});
                mapList2.stream().forEach(o -> {
                    QueryTagsRelationReturn tagsRelationReturn = new QueryTagsRelationReturn();
                    tagsRelationReturn.setRelationTab((String)o.get("relation_tab"));
                    tagsRelationReturn.setRelationField((String)o.get("relation_field"));
                    tagsRelationReturn.setRelationFk((String)o.get("relation_fk"));
                    tagsRelationReturn.setTagBelongs((String)o.get("tag_belongs"));
                    tagsRelationReturn.setTagId((String)o.get("tag_id"));
                    tagsRelationReturn.setTagName((String)o.get("tag_name"));
                    tagsRelationReturn.setTagCategories((String)o.get("tag_categories"));
                    tagsList.add(tagsRelationReturn);
                });
            }
        } else {
            mapList.stream().forEach(o -> {
                QueryTagsRelationReturn tagsRelationReturn = new QueryTagsRelationReturn();
                tagsRelationReturn.setRelationTab((String)o.get("relation_tab"));
                tagsRelationReturn.setRelationField((String)o.get("relation_field"));
                tagsRelationReturn.setRelationFk((String)o.get("relation_fk"));
                tagsRelationReturn.setTagBelongs((String)o.get("tag_belongs"));
                tagsRelationReturn.setTagId((String)o.get("tag_id"));
                tagsRelationReturn.setTagName((String)o.get("tag_name"));
                tagsRelationReturn.setTagCategories((String)o.get("tag_categories"));
                tagsList.add(tagsRelationReturn);
            });
        }
        msg.setDataList(tagsList, QueryTagsRelationReturn.class);
        return msg.msg();
    }

    private List<Map<String, Object>> setTagsList2(QueryTagsRelationParam tag, List<String> tagIdsList, List<Map<String, Object>> mapList, HashSet<String> tagsIds, List<Map<String, Object>> mapList2) {
        if (CollectionUtils.isNotEmpty(tagIdsList)) {
            if (CollectionUtils.isNotEmpty(tagsIds)) {
                for (String m : tagsIds) {
                    StringBuilder sql2 = new StringBuilder();
                    ArrayList<String> sqlParam2 = new ArrayList<String>();
                    sql2.append("select\n\tsm.relation_tab ,\n\tsm.relation_field ,\n\tsm.relation_fk ,\n\tsm.tag_belongs ,\n\tst.tag_id ,\n\tst.tag_name ,\n\tst.tag_categories\nfrom\n\tscpz_material_tags_relation sm\nleft join scpz_tags st on\n\tsm.tag_id = st.tag_id\nwhere 1=1  ");
                    sql2.append(" and sm.relation_tab = ? ");
                    sql2.append(" and sm.relation_field = ? ");
                    sql2.append(" and sm.relation_fk  = ? ");
                    sqlParam2.add(tag.getRelationTab());
                    sqlParam2.add(tag.getRelationField());
                    sqlParam2.add(m);
                    List mapList3 = this.dao.findAll(sql2.toString(), Boolean.valueOf(false), new AbsModelRepository.Args[]{this.dao.args(sqlParam2)});
                    mapList2.add((Map)((Object)mapList3));
                }
            }
        } else {
            mapList2 = mapList;
        }
        return mapList2;
    }
}

