/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.flow.vo;

import com.newtouch.base.model.Component;
import com.newtouch.base.model.FmCollection;
import com.newtouch.base.model.FmTemplate;
import com.newtouch.base.model.FmTemplateAttributes;
import com.newtouch.flow.model.FmEmbedded;
import com.newtouch.flow.model.FmFlow;
import com.newtouch.flow.model.FmFlowRelation;
import com.newtouch.flow.model.FmNode;
import com.newtouch.flow.model.FmNodeTemplate;
import com.newtouch.flow.model.FmRouter;
import com.newtouch.flow.util.FlowQueryUtil;
import com.newtouch.flow.vo.ComponentVo;
import com.newtouch.flow.vo.EmbeddedVo;
import com.newtouch.flow.vo.FmNodeVo;
import com.newtouch.flow.vo.FmTemplateVo;
import com.newtouch.flow.vo.MaterialDataListVo;
import com.newtouch.flow.vo.RouterVo;
import com.newtouch.flow.vo.WtIssueVo;
import com.newtouch.issue.model.WtIssue;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;

public class FlowVo
extends FmFlow {
    private FmCollection collection;
    private List<FmNode> fmNodeList;
    private List<FmNodeTemplate> fmNodeTemplateList;
    private List<FmRouter> fmRouterList;
    private List<FmTemplate> fmTemplateList;
    private List<ScpzMaterialTagsRelation> scpzMaterialTagsRelationList;
    private List<WtIssue> wtIssueList;
    private List<Component> components;
    private Set<FmEmbedded> embeddeds = new HashSet<FmEmbedded>();
    private MaterialDataListVo materialDataListVo;
    private List<FmFlowRelation> fmFlowRelations;
    private List<FmFlow> childFmFlows;
    Set<String> component = new HashSet<String>();

    public FlowVo load(String flowUuid) {
        FlowQueryUtil utils = (FlowQueryUtil)SpringContext.getBean(FlowQueryUtil.class);
        FmFlow fmFlow = utils.queryFlow(flowUuid);
        BeanUtils.copyProperties((Object)((Object)fmFlow), (Object)((Object)this));
        this.collection = utils.queryCollection(flowUuid);
        RouterVo routerVo = new RouterVo();
        this.fmRouterList = routerVo.load(flowUuid);
        FmNodeVo fmNodeVo = new FmNodeVo();
        this.fmNodeList = fmNodeVo.load(flowUuid);
        this.fmTemplateList = this.getTemplates(this.fmNodeList);
        ComponentVo componentVo = new ComponentVo();
        this.components = componentVo.load(this.component.stream().collect(Collectors.toList()), "page");
        this.components.forEach(o -> {
            if (!StrUtils.isNull((Object)o.getEmbeddedJson())) {
                EmbeddedVo embeddedVo = new EmbeddedVo();
                this.embeddeds.addAll(embeddedVo.load(o.getEmbeddedJson()));
            }
        });
        WtIssueVo wtIssueVo = new WtIssueVo();
        this.wtIssueList = wtIssueVo.load(JsonUtils.toJson((Object)((Object)this)));
        MaterialDataListVo materialDataListVo = new MaterialDataListVo(JsonUtils.toJson((Object)((Object)this)));
        this.fmFlowRelations = utils.queryFlowRelation(flowUuid);
        this.childFmFlows = utils.queryChildFmFlows(flowUuid);
        this.setMaterialDataListVo(materialDataListVo);
        return this;
    }

    public void save() {
    }

    public List<FmTemplate> getTemplates(List<FmNode> fmNodeList) {
        HashSet templateIds = new HashSet();
        fmNodeList.stream().forEach(t -> {
            if (!StrUtils.isNull((Object)t.getRelateFk()) && !t.getNodeType().equals("child_flow")) {
                templateIds.add(t.getRelateFk().trim());
            }
        });
        ArrayList<FmTemplate> fmTemplates = new ArrayList<FmTemplate>();
        templateIds.forEach(t -> {
            FmTemplateVo fmTemplateVo = new FmTemplateVo();
            FmTemplate fmTemplate = fmTemplateVo.load((String)t);
            fmTemplates.add(fmTemplate);
            if (!StrUtils.isNull((Object)fmTemplate.getEmbeddedJson())) {
                EmbeddedVo embeddedVo = new EmbeddedVo();
                this.embeddeds.addAll(embeddedVo.load(fmTemplate.getEmbeddedJson()));
            }
            this.getComponent(fmTemplate.getAttrList());
        });
        return fmTemplates;
    }

    public void getComponent(List<FmTemplateAttributes> attr) {
        if (attr != null && attr.size() > 0) {
            attr.stream().forEach(o -> {
                if (!StrUtils.isNull((Object)o.getAttrJson())) {
                    this.getAttrIds(JsonUtils.json2Map((String)o.getAttrJson()), this.component);
                }
            });
        }
    }

    private void getAttrIds(Map<String, Object> map, Set<String> list) {
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            Object value = map.get(key);
            if (value instanceof List) {
                ((List)value).stream().forEach(o -> {
                    if (o instanceof Map) {
                        this.getAttrIds((Map)o, list);
                    }
                    if (o instanceof String && ((String)key).contains("component_type")) {
                        list.add((String)value);
                    }
                });
            }
            if (value instanceof Map) {
                this.getAttrIds((Map)value, list);
            }
            if (!(value instanceof String) || !key.contains("component_type")) continue;
            list.add((String)value);
        }
    }

    @Override
    public FmCollection getCollection() {
        return this.collection;
    }

    @Override
    public void setCollection(FmCollection collection) {
        this.collection = collection;
    }

    @Override
    public List<FmNode> getFmNodeList() {
        return this.fmNodeList;
    }

    @Override
    public void setFmNodeList(List<FmNode> fmNodeList) {
        this.fmNodeList = fmNodeList;
    }

    @Override
    public List<FmNodeTemplate> getFmNodeTemplateList() {
        return this.fmNodeTemplateList;
    }

    @Override
    public void setFmNodeTemplateList(List<FmNodeTemplate> fmNodeTemplateList) {
        this.fmNodeTemplateList = fmNodeTemplateList;
    }

    @Override
    public List<FmRouter> getFmRouterList() {
        return this.fmRouterList;
    }

    @Override
    public void setFmRouterList(List<FmRouter> fmRouterList) {
        this.fmRouterList = fmRouterList;
    }

    @Override
    public List<FmTemplate> getFmTemplateList() {
        return this.fmTemplateList;
    }

    @Override
    public void setFmTemplateList(List<FmTemplate> fmTemplateList) {
        this.fmTemplateList = fmTemplateList;
    }

    @Override
    public List<ScpzMaterialTagsRelation> getScpzMaterialTagsRelationList() {
        return this.scpzMaterialTagsRelationList;
    }

    @Override
    public void setScpzMaterialTagsRelationList(List<ScpzMaterialTagsRelation> scpzMaterialTagsRelationList) {
        this.scpzMaterialTagsRelationList = scpzMaterialTagsRelationList;
    }

    @Override
    public List<WtIssue> getWtIssueList() {
        return this.wtIssueList;
    }

    @Override
    public void setWtIssueList(List<WtIssue> wtIssueList) {
        this.wtIssueList = wtIssueList;
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    public Set<FmEmbedded> getEmbeddeds() {
        return this.embeddeds;
    }

    public void setEmbeddeds(Set<FmEmbedded> embeddeds) {
        this.embeddeds = embeddeds;
    }

    public MaterialDataListVo getMaterialDataListVo() {
        return this.materialDataListVo;
    }

    public void setMaterialDataListVo(MaterialDataListVo materialDataListVo) {
        this.materialDataListVo = materialDataListVo;
    }

    @Override
    public List<FmFlowRelation> getFmFlowRelations() {
        return this.fmFlowRelations;
    }

    @Override
    public void setFmFlowRelations(List<FmFlowRelation> fmFlowRelations) {
        this.fmFlowRelations = fmFlowRelations;
    }

    @Override
    public List<FmFlow> getChildFmFlows() {
        return this.childFmFlows;
    }

    @Override
    public void setChildFmFlows(List<FmFlow> childFmFlows) {
        this.childFmFlows = childFmFlows;
    }
}

