/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.vo.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.base.enums.RelateEnum;
import com.newtouch.base.utils.export.EqualsUtils;
import com.newtouch.base.utils.export.ExportQueryUtils;
import com.newtouch.base.utils.export.UpdateUtils;
import com.newtouch.base.vo.export.QsnQuestionBlanksInfo;
import com.newtouch.base.vo.export.QsnQuestionOptionsInfo;
import com.newtouch.inform.model.QsnCoreQuestions;
import com.newtouch.inform.model.QsnQuestionBlanks;
import com.newtouch.inform.model.QsnQuestionOptions;
import com.newtouch.inform.model.QsnQuestions;
import com.newtouch.inform.model.QsnTitleRelation;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class QsnInfo
implements Comparable {
    @JsonProperty(value="qsnTitleRelation")
    private QsnTitleRelation qsnTitleRelation;
    @JsonProperty(value="qsnQuestions")
    private QsnQuestions qsnQuestions;
    @JsonProperty(value="qsnCoreQuestions")
    private QsnCoreQuestions qsnCoreQuestions;
    @JsonProperty(value="qsnQuestionBlanksInfos")
    private List<QsnQuestionBlanksInfo> qsnQuestionBlanksInfos;
    @JsonProperty(value="qsnQuestionOptionsInfos")
    private List<QsnQuestionOptionsInfo> qsnQuestionOptionsInfos;
    @JsonProperty(value="childQsnInfoList")
    private List<QsnInfo> childQsnInfoList;

    public QsnInfo load(String qsnUuid, String upQsnUuid) {
        ExportQueryUtils query = (ExportQueryUtils)SpringContext.getBean(ExportQueryUtils.class);
        if (StrUtils.isNull((Object)((Object)this.qsnQuestions)) && "0".equals(upQsnUuid)) {
            this.qsnQuestions = query.queryQsnQuestions(qsnUuid);
        }
        if (StrUtils.isNull((Object)((Object)this.qsnQuestions))) {
            return null;
        }
        this.qsnCoreQuestions = query.queryQsnCoreQuestions(this.qsnQuestions.getCoreQuestionUuid());
        List<QsnQuestionBlanks> qsnQuestionBlanksList = query.queryQsnQuestionBlanks(qsnUuid);
        this.qsnQuestionBlanksInfos = new ArrayList<QsnQuestionBlanksInfo>();
        if (CollectionUtils.isNotEmpty(qsnQuestionBlanksList)) {
            for (QsnQuestionBlanks qsnQuestionBlanks : qsnQuestionBlanksList) {
                QsnQuestionBlanksInfo qqbi = new QsnQuestionBlanksInfo();
                qqbi.setQsnQuestionBlank(qsnQuestionBlanks);
                qqbi.load(qsnQuestionBlanks.getBlankUuid());
                this.qsnQuestionBlanksInfos.add(qqbi);
            }
        }
        List<QsnQuestionOptions> qsnQuestionOptions = query.queryQsnQuestionOptions(RelateEnum.qsn.getRelateField(), RelateEnum.qsn.getRelateTab(), qsnUuid);
        this.qsnQuestionOptionsInfos = new ArrayList<QsnQuestionOptionsInfo>();
        if (CollectionUtils.isNotEmpty(qsnQuestionOptions)) {
            for (QsnQuestionOptions qqo : qsnQuestionOptions) {
                QsnQuestionOptionsInfo qqoi = new QsnQuestionOptionsInfo();
                qqoi.load(qqo.getOptionUuid());
                qqoi.setQsnQuestionOption(qqo);
                this.qsnQuestionOptionsInfos.add(qqoi);
            }
        }
        if (!StrUtils.isNull((Object)((Object)this.qsnTitleRelation)) && !StrUtils.isNull((Object)this.qsnTitleRelation.getChildUuid())) {
            this.childQsnInfoList = new ArrayList<QsnInfo>();
            List<QsnQuestions> list = query.queryChildQsnQuestions(qsnUuid, this.qsnTitleRelation.getChildUuid());
            if (CollectionUtils.isNotEmpty(list)) {
                for (QsnQuestions qq : list) {
                    QsnInfo qi = new QsnInfo();
                    qi.setQsnQuestions(qq);
                    qi.load(qq.getQsnUuid(), qsnUuid);
                    this.childQsnInfoList.add(qi);
                }
            }
        }
        return this;
    }

    public void merge(QsnInfo qsnInfo) {
        this.qsnTitleRelation = EqualsUtils.merge(this.qsnTitleRelation, qsnInfo.getQsnTitleRelation());
        this.qsnQuestions = EqualsUtils.merge(this.qsnQuestions, qsnInfo.getQsnQuestions());
        this.qsnCoreQuestions = EqualsUtils.merge(this.qsnCoreQuestions, qsnInfo.getQsnCoreQuestions());
        this.qsnQuestionBlanksInfos = EqualsUtils.merge(this.qsnQuestionBlanksInfos, qsnInfo.getQsnQuestionBlanksInfos(), QsnQuestionBlanksInfo.class);
        this.qsnQuestionOptionsInfos = EqualsUtils.merge(this.qsnQuestionOptionsInfos, qsnInfo.getQsnQuestionOptionsInfos(), QsnQuestionOptionsInfo.class);
        this.childQsnInfoList = EqualsUtils.merge(this.childQsnInfoList, qsnInfo.getChildQsnInfoList(), QsnInfo.class);
    }

    public void save() {
        UpdateUtils.UpdateFlag flag;
        UpdateUtils update = (UpdateUtils)SpringContext.getBean(UpdateUtils.class);
        if (this.qsnTitleRelation != null) {
            update.update(this.qsnTitleRelation);
        }
        UpdateUtils.UpdateFlag updateFlag = UpdateUtils.UpdateFlag.U;
        if (this.qsnQuestions != null && ((updateFlag = (UpdateUtils.UpdateFlag)((Object)this.qsnQuestions.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class))) == UpdateUtils.UpdateFlag.U || updateFlag == UpdateUtils.UpdateFlag.I)) {
            update.update(this.qsnQuestions);
            QsnQuestionBlanks qsnQuestionBlanks = new QsnQuestionBlanks();
            String qsnUuid = this.qsnQuestions.getQsnUuid();
            qsnQuestionBlanks.setQuestionUuid(qsnUuid);
            update.del(qsnQuestionBlanks);
            QsnQuestionOptions qsnQuestionOptions = new QsnQuestionOptions();
            qsnQuestionOptions.setRelateFk(qsnUuid);
            qsnQuestionOptions.setRelateField(RelateEnum.qsn.getRelateField());
            qsnQuestionOptions.setRelateTab(RelateEnum.qsn.getRelateTab());
            update.del(qsnQuestionOptions);
        }
        if (this.qsnCoreQuestions != null && ((flag = (UpdateUtils.UpdateFlag)((Object)this.qsnCoreQuestions.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class))) == UpdateUtils.UpdateFlag.U || flag == UpdateUtils.UpdateFlag.I)) {
            update.update(this.qsnCoreQuestions);
        }
        if (CollectionUtils.isNotEmpty(this.qsnQuestionBlanksInfos)) {
            this.qsnQuestionBlanksInfos.forEach(m -> m.save());
        }
        if (CollectionUtils.isNotEmpty(this.qsnQuestionOptionsInfos)) {
            this.qsnQuestionOptionsInfos.forEach(m -> m.save());
        }
        if (this.childQsnInfoList != null) {
            this.childQsnInfoList.forEach(m -> m.save());
        }
    }

    public int compareTo(@NotNull Object o) {
        UpdateUtils.UpdateFlag flag = (UpdateUtils.UpdateFlag)((Object)this.qsnQuestions.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class));
        if (flag == UpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == UpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == UpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }

    public QsnTitleRelation getQsnTitleRelation() {
        return this.qsnTitleRelation;
    }

    public QsnQuestions getQsnQuestions() {
        return this.qsnQuestions;
    }

    public QsnCoreQuestions getQsnCoreQuestions() {
        return this.qsnCoreQuestions;
    }

    public List<QsnQuestionBlanksInfo> getQsnQuestionBlanksInfos() {
        return this.qsnQuestionBlanksInfos;
    }

    public List<QsnQuestionOptionsInfo> getQsnQuestionOptionsInfos() {
        return this.qsnQuestionOptionsInfos;
    }

    public List<QsnInfo> getChildQsnInfoList() {
        return this.childQsnInfoList;
    }

    @JsonProperty(value="qsnTitleRelation")
    public void setQsnTitleRelation(QsnTitleRelation qsnTitleRelation) {
        this.qsnTitleRelation = qsnTitleRelation;
    }

    @JsonProperty(value="qsnQuestions")
    public void setQsnQuestions(QsnQuestions qsnQuestions) {
        this.qsnQuestions = qsnQuestions;
    }

    @JsonProperty(value="qsnCoreQuestions")
    public void setQsnCoreQuestions(QsnCoreQuestions qsnCoreQuestions) {
        this.qsnCoreQuestions = qsnCoreQuestions;
    }

    @JsonProperty(value="qsnQuestionBlanksInfos")
    public void setQsnQuestionBlanksInfos(List<QsnQuestionBlanksInfo> qsnQuestionBlanksInfos) {
        this.qsnQuestionBlanksInfos = qsnQuestionBlanksInfos;
    }

    @JsonProperty(value="qsnQuestionOptionsInfos")
    public void setQsnQuestionOptionsInfos(List<QsnQuestionOptionsInfo> qsnQuestionOptionsInfos) {
        this.qsnQuestionOptionsInfos = qsnQuestionOptionsInfos;
    }

    @JsonProperty(value="childQsnInfoList")
    public void setChildQsnInfoList(List<QsnInfo> childQsnInfoList) {
        this.childQsnInfoList = childQsnInfoList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QsnInfo)) {
            return false;
        }
        QsnInfo other = (QsnInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QsnTitleRelation this$qsnTitleRelation = this.getQsnTitleRelation();
        QsnTitleRelation other$qsnTitleRelation = other.getQsnTitleRelation();
        if (this$qsnTitleRelation == null ? other$qsnTitleRelation != null : !((Object)((Object)this$qsnTitleRelation)).equals((Object)other$qsnTitleRelation)) {
            return false;
        }
        QsnQuestions this$qsnQuestions = this.getQsnQuestions();
        QsnQuestions other$qsnQuestions = other.getQsnQuestions();
        if (this$qsnQuestions == null ? other$qsnQuestions != null : !((Object)((Object)this$qsnQuestions)).equals((Object)other$qsnQuestions)) {
            return false;
        }
        QsnCoreQuestions this$qsnCoreQuestions = this.getQsnCoreQuestions();
        QsnCoreQuestions other$qsnCoreQuestions = other.getQsnCoreQuestions();
        if (this$qsnCoreQuestions == null ? other$qsnCoreQuestions != null : !((Object)((Object)this$qsnCoreQuestions)).equals((Object)other$qsnCoreQuestions)) {
            return false;
        }
        List<QsnQuestionBlanksInfo> this$qsnQuestionBlanksInfos = this.getQsnQuestionBlanksInfos();
        List<QsnQuestionBlanksInfo> other$qsnQuestionBlanksInfos = other.getQsnQuestionBlanksInfos();
        if (this$qsnQuestionBlanksInfos == null ? other$qsnQuestionBlanksInfos != null : !((Object)this$qsnQuestionBlanksInfos).equals(other$qsnQuestionBlanksInfos)) {
            return false;
        }
        List<QsnQuestionOptionsInfo> this$qsnQuestionOptionsInfos = this.getQsnQuestionOptionsInfos();
        List<QsnQuestionOptionsInfo> other$qsnQuestionOptionsInfos = other.getQsnQuestionOptionsInfos();
        if (this$qsnQuestionOptionsInfos == null ? other$qsnQuestionOptionsInfos != null : !((Object)this$qsnQuestionOptionsInfos).equals(other$qsnQuestionOptionsInfos)) {
            return false;
        }
        List<QsnInfo> this$childQsnInfoList = this.getChildQsnInfoList();
        List<QsnInfo> other$childQsnInfoList = other.getChildQsnInfoList();
        return !(this$childQsnInfoList == null ? other$childQsnInfoList != null : !((Object)this$childQsnInfoList).equals(other$childQsnInfoList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QsnInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QsnTitleRelation $qsnTitleRelation = this.getQsnTitleRelation();
        result = result * 59 + ($qsnTitleRelation == null ? 43 : ((Object)((Object)$qsnTitleRelation)).hashCode());
        QsnQuestions $qsnQuestions = this.getQsnQuestions();
        result = result * 59 + ($qsnQuestions == null ? 43 : ((Object)((Object)$qsnQuestions)).hashCode());
        QsnCoreQuestions $qsnCoreQuestions = this.getQsnCoreQuestions();
        result = result * 59 + ($qsnCoreQuestions == null ? 43 : ((Object)((Object)$qsnCoreQuestions)).hashCode());
        List<QsnQuestionBlanksInfo> $qsnQuestionBlanksInfos = this.getQsnQuestionBlanksInfos();
        result = result * 59 + ($qsnQuestionBlanksInfos == null ? 43 : ((Object)$qsnQuestionBlanksInfos).hashCode());
        List<QsnQuestionOptionsInfo> $qsnQuestionOptionsInfos = this.getQsnQuestionOptionsInfos();
        result = result * 59 + ($qsnQuestionOptionsInfos == null ? 43 : ((Object)$qsnQuestionOptionsInfos).hashCode());
        List<QsnInfo> $childQsnInfoList = this.getChildQsnInfoList();
        result = result * 59 + ($childQsnInfoList == null ? 43 : ((Object)$childQsnInfoList).hashCode());
        return result;
    }

    public String toString() {
        return "QsnInfo(qsnTitleRelation=" + (Object)((Object)this.getQsnTitleRelation()) + ", qsnQuestions=" + (Object)((Object)this.getQsnQuestions()) + ", qsnCoreQuestions=" + (Object)((Object)this.getQsnCoreQuestions()) + ", qsnQuestionBlanksInfos=" + this.getQsnQuestionBlanksInfos() + ", qsnQuestionOptionsInfos=" + this.getQsnQuestionOptionsInfos() + ", childQsnInfoList=" + this.getChildQsnInfoList() + ")";
    }
}

