/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.vo.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.base.enums.RelateEnum;
import com.newtouch.base.utils.export.EqualsUtils;
import com.newtouch.base.utils.export.ExportQueryUtils;
import com.newtouch.base.utils.export.UpdateUtils;
import com.newtouch.base.vo.export.SmtrInfo;
import com.newtouch.material.model.ScglAuthorized;
import com.newtouch.material.model.ScglMaterial;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.newtouch.material.model.ScpzReference;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class MaterialInfo
implements Comparable {
    @JsonProperty(value="scglMaterial")
    private ScglMaterial scglMaterial;
    @JsonProperty(value="scpzReferenceList")
    private List<ScpzReference> scpzReferenceList;
    @JsonProperty(value="scglAuthorized")
    private ScglAuthorized scglAuthorized;
    @JsonProperty(value="smtrList")
    private List<SmtrInfo> smtrList;

    public MaterialInfo load(ScglMaterial sm) {
        this.scglMaterial = sm;
        String materialId = sm.getMaterialId();
        return this.load(materialId);
    }

    public MaterialInfo load(String materialId) {
        ExportQueryUtils query = (ExportQueryUtils)SpringContext.getBean(ExportQueryUtils.class);
        this.scpzReferenceList = query.queryScpzReferences(materialId);
        this.scglAuthorized = query.queryScglAuthorized(materialId);
        this.smtrList = new ArrayList<SmtrInfo>();
        List<ScpzMaterialTagsRelation> scpzMaterialTagsRelations = query.querySmtr(materialId, RelateEnum.material.getRelateField(), RelateEnum.material.getRelateTab());
        if (CollectionUtils.isNotEmpty(scpzMaterialTagsRelations)) {
            for (ScpzMaterialTagsRelation smtr : scpzMaterialTagsRelations) {
                SmtrInfo si = new SmtrInfo();
                si.setSmtr(smtr);
                si.load(smtr.getTagId());
                this.smtrList.add(si);
            }
        }
        return this;
    }

    public void merge(MaterialInfo materialInfo) {
        this.scglMaterial = EqualsUtils.merge(this.scglMaterial, materialInfo.getScglMaterial());
        this.scpzReferenceList = EqualsUtils.merge(this.scpzReferenceList, materialInfo.getScpzReferenceList());
        this.scglAuthorized = EqualsUtils.merge(this.scglAuthorized, materialInfo.getScglAuthorized());
        this.smtrList = EqualsUtils.merge(this.smtrList, materialInfo.getSmtrList(), SmtrInfo.class);
    }

    public void save() {
        UpdateUtils update = (UpdateUtils)SpringContext.getBean(UpdateUtils.class);
        UpdateUtils.UpdateFlag updateFlag = UpdateUtils.UpdateFlag.D;
        if (this.scglMaterial != null && ((updateFlag = (UpdateUtils.UpdateFlag)((Object)this.scglMaterial.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class))) == UpdateUtils.UpdateFlag.U || updateFlag == UpdateUtils.UpdateFlag.I)) {
            update.update(this.scglMaterial);
            String materialId = this.scglMaterial.getMaterialId();
            ScpzReference sr = new ScpzReference();
            sr.setMaterialId(materialId);
            update.del(sr);
            ScglAuthorized sa = new ScglAuthorized();
            sa.setMaterialId(materialId);
            update.del(sa);
        }
        if (updateFlag == UpdateUtils.UpdateFlag.U || updateFlag == UpdateUtils.UpdateFlag.I) {
            if (this.scpzReferenceList != null) {
                this.scpzReferenceList.forEach(m -> update.save((AbsModel)m));
            }
            if (this.scglAuthorized != null) {
                update.save(this.scglAuthorized);
            }
        }
        if (this.smtrList != null) {
            this.smtrList.forEach(m -> m.save());
        }
    }

    public int compareTo(@NotNull Object o) {
        UpdateUtils.UpdateFlag flag = (UpdateUtils.UpdateFlag)((Object)this.scglMaterial.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class));
        if (flag == UpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == UpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == UpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }

    public ScglMaterial getScglMaterial() {
        return this.scglMaterial;
    }

    public List<ScpzReference> getScpzReferenceList() {
        return this.scpzReferenceList;
    }

    public ScglAuthorized getScglAuthorized() {
        return this.scglAuthorized;
    }

    public List<SmtrInfo> getSmtrList() {
        return this.smtrList;
    }

    @JsonProperty(value="scglMaterial")
    public void setScglMaterial(ScglMaterial scglMaterial) {
        this.scglMaterial = scglMaterial;
    }

    @JsonProperty(value="scpzReferenceList")
    public void setScpzReferenceList(List<ScpzReference> scpzReferenceList) {
        this.scpzReferenceList = scpzReferenceList;
    }

    @JsonProperty(value="scglAuthorized")
    public void setScglAuthorized(ScglAuthorized scglAuthorized) {
        this.scglAuthorized = scglAuthorized;
    }

    @JsonProperty(value="smtrList")
    public void setSmtrList(List<SmtrInfo> smtrList) {
        this.smtrList = smtrList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaterialInfo)) {
            return false;
        }
        MaterialInfo other = (MaterialInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScglMaterial this$scglMaterial = this.getScglMaterial();
        ScglMaterial other$scglMaterial = other.getScglMaterial();
        if (this$scglMaterial == null ? other$scglMaterial != null : !((Object)((Object)this$scglMaterial)).equals((Object)other$scglMaterial)) {
            return false;
        }
        List<ScpzReference> this$scpzReferenceList = this.getScpzReferenceList();
        List<ScpzReference> other$scpzReferenceList = other.getScpzReferenceList();
        if (this$scpzReferenceList == null ? other$scpzReferenceList != null : !((Object)this$scpzReferenceList).equals(other$scpzReferenceList)) {
            return false;
        }
        ScglAuthorized this$scglAuthorized = this.getScglAuthorized();
        ScglAuthorized other$scglAuthorized = other.getScglAuthorized();
        if (this$scglAuthorized == null ? other$scglAuthorized != null : !((Object)((Object)this$scglAuthorized)).equals((Object)other$scglAuthorized)) {
            return false;
        }
        List<SmtrInfo> this$smtrList = this.getSmtrList();
        List<SmtrInfo> other$smtrList = other.getSmtrList();
        return !(this$smtrList == null ? other$smtrList != null : !((Object)this$smtrList).equals(other$smtrList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaterialInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScglMaterial $scglMaterial = this.getScglMaterial();
        result = result * 59 + ($scglMaterial == null ? 43 : ((Object)((Object)$scglMaterial)).hashCode());
        List<ScpzReference> $scpzReferenceList = this.getScpzReferenceList();
        result = result * 59 + ($scpzReferenceList == null ? 43 : ((Object)$scpzReferenceList).hashCode());
        ScglAuthorized $scglAuthorized = this.getScglAuthorized();
        result = result * 59 + ($scglAuthorized == null ? 43 : ((Object)((Object)$scglAuthorized)).hashCode());
        List<SmtrInfo> $smtrList = this.getSmtrList();
        result = result * 59 + ($smtrList == null ? 43 : ((Object)$smtrList).hashCode());
        return result;
    }

    public String toString() {
        return "MaterialInfo(scglMaterial=" + (Object)((Object)this.getScglMaterial()) + ", scpzReferenceList=" + this.getScpzReferenceList() + ", scglAuthorized=" + (Object)((Object)this.getScglAuthorized()) + ", smtrList=" + this.getSmtrList() + ")";
    }
}

