/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.vo.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.base.enums.RelateEnum;
import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.FmTemplate;
import com.newtouch.base.model.FmTemplateAttributes;
import com.newtouch.base.utils.export.EqualsUtils;
import com.newtouch.base.utils.export.ExportQueryUtils;
import com.newtouch.base.utils.export.UpdateUtils;
import com.newtouch.base.vo.export.AttrInfo;
import com.newtouch.base.vo.export.ExportRuleInfo;
import com.newtouch.base.vo.export.SmtrInfo;
import com.newtouch.flow.model.FmEmbedded;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.uniapis.cache.CacheManager;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class FormInfo
implements Comparable {
    @JsonProperty(value="fmTemplate")
    private FmTemplate fmTemplate;
    @JsonProperty(value="attrInfoList")
    private List<AttrInfo> attrInfoList;
    @JsonProperty(value="ruleInfos")
    private List<ExportRuleInfo> ruleInfos;
    @JsonProperty(value="smtrList")
    private List<SmtrInfo> smtrList;
    @JsonProperty(value="embeddedList")
    private List<FmEmbedded> embeddedList;

    public FormInfo load(String templateId) {
        ExportQueryUtils query = (ExportQueryUtils)SpringContext.getBean(ExportQueryUtils.class);
        this.fmTemplate = query.queryFmTemplate(templateId);
        this.attrInfoList = new ArrayList<AttrInfo>();
        List<FmTemplateAttributes> attrList = query.queryAttrList(templateId);
        String templateType = this.fmTemplate.getTemplateType();
        if (CollectionUtils.isNotEmpty(attrList)) {
            for (FmTemplateAttributes fmTemplateAttributes : attrList) {
                AttrInfo attrInfo = new AttrInfo();
                attrInfo.setFmTemplateAttributes(fmTemplateAttributes);
                attrInfo.load(fmTemplateAttributes);
                this.attrInfoList.add(attrInfo);
                String string = fmTemplateAttributes.getComponentType();
            }
        }
        this.ruleInfos = new ArrayList<ExportRuleInfo>();
        List<DsnRules> dsnRulesList = query.queryDsnRulesList(templateId, RelateEnum.template.getRelateField(), RelateEnum.template.getRelateTab());
        if (CollectionUtils.isNotEmpty(dsnRulesList)) {
            for (DsnRules dsnRules : dsnRulesList) {
                ExportRuleInfo eri = new ExportRuleInfo();
                eri.load(dsnRules);
                this.ruleInfos.add(eri);
            }
        }
        this.smtrList = new ArrayList<SmtrInfo>();
        List<ScpzMaterialTagsRelation> list = query.querySmtr(templateId, RelateEnum.template.getRelateField(), RelateEnum.template.getRelateTab());
        if (CollectionUtils.isNotEmpty(list)) {
            for (ScpzMaterialTagsRelation smtr : list) {
                SmtrInfo si = new SmtrInfo();
                si.setSmtr(smtr);
                si.load(smtr.getTagId());
                this.smtrList.add(si);
            }
        }
        this.embeddedList = new ArrayList<FmEmbedded>();
        if (!StrUtils.isNull((Object)this.fmTemplate.getEmbeddedJson())) {
            List list2 = JsonUtils.json2List((String)this.fmTemplate.getEmbeddedJson());
            list2.forEach(l -> {
                FmEmbedded fmEmbedded = new FmEmbedded();
                fmEmbedded.setEmbeddedElementCn((String)l.get("embedded_element_cn"));
                fmEmbedded.setEmbeddedElementEn((String)l.get("embedded_element_en"));
                fmEmbedded.setDeliveryPlatform((String)l.get("delivery_platform"));
                List<FmEmbedded> fmEmbeddedList = query.queryFmEmbeddedList(fmEmbedded);
                this.embeddedList.addAll(fmEmbeddedList);
            });
        }
        return this;
    }

    public void merge(FormInfo formInfo) {
        this.fmTemplate = EqualsUtils.merge(this.fmTemplate, formInfo.getFmTemplate());
        this.attrInfoList = EqualsUtils.merge(this.attrInfoList, formInfo.getAttrInfoList(), AttrInfo.class);
        this.ruleInfos = EqualsUtils.merge(this.ruleInfos, formInfo.getRuleInfos(), ExportRuleInfo.class);
        this.smtrList = EqualsUtils.merge(this.smtrList, formInfo.getSmtrList(), SmtrInfo.class);
        this.embeddedList = EqualsUtils.merge(this.embeddedList, formInfo.getEmbeddedList());
    }

    public void save(String isDel) {
        UpdateUtils update = (UpdateUtils)SpringContext.getBean(UpdateUtils.class);
        UpdateUtils.UpdateFlag updateFlag = UpdateUtils.UpdateFlag.D;
        if (this.fmTemplate != null) {
            updateFlag = (UpdateUtils.UpdateFlag)((Object)this.fmTemplate.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class));
            String templateId = this.fmTemplate.getTemplateId();
            String templateKey = "template_" + templateId;
            CacheManager.remove((String)templateKey);
            if ("Y".equals(isDel)) {
                update.update(this.fmTemplate);
            } else if (updateFlag == UpdateUtils.UpdateFlag.U || updateFlag == UpdateUtils.UpdateFlag.I) {
                update.update(this.fmTemplate);
                FmTemplateAttributes fta = new FmTemplateAttributes();
                fta.setTemplateId(templateId);
                update.del(fta);
                DsnRules dsnRules = new DsnRules();
                dsnRules.setRelateFk(templateId);
                dsnRules.setRelateField(RelateEnum.template.getRelateField());
                dsnRules.setRelateTab(RelateEnum.template.getRelateTab());
                update.del((AbsModel)dsnRules);
            }
        }
        if (this.attrInfoList != null) {
            this.attrInfoList.forEach(m -> m.save(isDel));
        }
        if (this.ruleInfos != null) {
            this.ruleInfos.forEach(m -> m.save(isDel));
        }
        if (this.smtrList != null) {
            this.smtrList.forEach(m -> m.save());
        }
        if ((updateFlag == UpdateUtils.UpdateFlag.U || updateFlag == UpdateUtils.UpdateFlag.I) && this.embeddedList != null) {
            this.embeddedList.forEach(m -> update.update((AbsModel)m));
        }
    }

    public int compareTo(@NotNull Object o) {
        UpdateUtils.UpdateFlag flag = (UpdateUtils.UpdateFlag)((Object)this.fmTemplate.getOtherProperty("update_flag", UpdateUtils.UpdateFlag.class));
        if (flag == UpdateUtils.UpdateFlag.D) {
            return -1;
        }
        if (flag == UpdateUtils.UpdateFlag.U) {
            return 0;
        }
        if (flag == UpdateUtils.UpdateFlag.I) {
            return 1;
        }
        return 0;
    }

    public FmTemplate getFmTemplate() {
        return this.fmTemplate;
    }

    public List<AttrInfo> getAttrInfoList() {
        return this.attrInfoList;
    }

    public List<ExportRuleInfo> getRuleInfos() {
        return this.ruleInfos;
    }

    public List<SmtrInfo> getSmtrList() {
        return this.smtrList;
    }

    public List<FmEmbedded> getEmbeddedList() {
        return this.embeddedList;
    }

    @JsonProperty(value="fmTemplate")
    public void setFmTemplate(FmTemplate fmTemplate) {
        this.fmTemplate = fmTemplate;
    }

    @JsonProperty(value="attrInfoList")
    public void setAttrInfoList(List<AttrInfo> attrInfoList) {
        this.attrInfoList = attrInfoList;
    }

    @JsonProperty(value="ruleInfos")
    public void setRuleInfos(List<ExportRuleInfo> ruleInfos) {
        this.ruleInfos = ruleInfos;
    }

    @JsonProperty(value="smtrList")
    public void setSmtrList(List<SmtrInfo> smtrList) {
        this.smtrList = smtrList;
    }

    @JsonProperty(value="embeddedList")
    public void setEmbeddedList(List<FmEmbedded> embeddedList) {
        this.embeddedList = embeddedList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormInfo)) {
            return false;
        }
        FormInfo other = (FormInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FmTemplate this$fmTemplate = this.getFmTemplate();
        FmTemplate other$fmTemplate = other.getFmTemplate();
        if (this$fmTemplate == null ? other$fmTemplate != null : !((Object)((Object)this$fmTemplate)).equals((Object)other$fmTemplate)) {
            return false;
        }
        List<AttrInfo> this$attrInfoList = this.getAttrInfoList();
        List<AttrInfo> other$attrInfoList = other.getAttrInfoList();
        if (this$attrInfoList == null ? other$attrInfoList != null : !((Object)this$attrInfoList).equals(other$attrInfoList)) {
            return false;
        }
        List<ExportRuleInfo> this$ruleInfos = this.getRuleInfos();
        List<ExportRuleInfo> other$ruleInfos = other.getRuleInfos();
        if (this$ruleInfos == null ? other$ruleInfos != null : !((Object)this$ruleInfos).equals(other$ruleInfos)) {
            return false;
        }
        List<SmtrInfo> this$smtrList = this.getSmtrList();
        List<SmtrInfo> other$smtrList = other.getSmtrList();
        if (this$smtrList == null ? other$smtrList != null : !((Object)this$smtrList).equals(other$smtrList)) {
            return false;
        }
        List<FmEmbedded> this$embeddedList = this.getEmbeddedList();
        List<FmEmbedded> other$embeddedList = other.getEmbeddedList();
        return !(this$embeddedList == null ? other$embeddedList != null : !((Object)this$embeddedList).equals(other$embeddedList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FormInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FmTemplate $fmTemplate = this.getFmTemplate();
        result = result * 59 + ($fmTemplate == null ? 43 : ((Object)((Object)$fmTemplate)).hashCode());
        List<AttrInfo> $attrInfoList = this.getAttrInfoList();
        result = result * 59 + ($attrInfoList == null ? 43 : ((Object)$attrInfoList).hashCode());
        List<ExportRuleInfo> $ruleInfos = this.getRuleInfos();
        result = result * 59 + ($ruleInfos == null ? 43 : ((Object)$ruleInfos).hashCode());
        List<SmtrInfo> $smtrList = this.getSmtrList();
        result = result * 59 + ($smtrList == null ? 43 : ((Object)$smtrList).hashCode());
        List<FmEmbedded> $embeddedList = this.getEmbeddedList();
        result = result * 59 + ($embeddedList == null ? 43 : ((Object)$embeddedList).hashCode());
        return result;
    }

    public String toString() {
        return "FormInfo(fmTemplate=" + (Object)((Object)this.getFmTemplate()) + ", attrInfoList=" + this.getAttrInfoList() + ", ruleInfos=" + this.getRuleInfos() + ", smtrList=" + this.getSmtrList() + ", embeddedList=" + this.getEmbeddedList() + ")";
    }
}

