/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.inform.service.impl;

import com.newtouch.base.config.TemplateConfig;
import com.newtouch.base.enums.BaseEnum;
import com.newtouch.base.utils.FilesUtil;
import com.newtouch.inform.model.QsnRiskRelation;
import com.newtouch.inform.service.IRiskInformService;
import com.newtouch.inform.vo.ExportRiskInformVo;
import com.newtouch.nms.sip.model.SipProductSyncTask;
import com.newtouch.nms.sip.model.SipRisks;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.FileUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RiskInformServiceImpl
implements IRiskInformService {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    private TemplateConfig templateConfig;
    private static final String ALLOW_SUFFIX = ".zip";

    @Override
    public ReturnMsg addRiskInform(QsnRiskRelation qsnRiskRelation) {
        Return msg = new Return();
        QsnRiskRelation qsnRiskRelation1 = new QsnRiskRelation();
        qsnRiskRelation1.where().addEq(QsnRiskRelation.RISK_CODE, (Object)qsnRiskRelation.getRiskCode());
        qsnRiskRelation1.where().addEq(QsnRiskRelation.DP_TYPE, (Object)qsnRiskRelation.getDpType());
        qsnRiskRelation1.where().addEq(QsnRiskRelation.PARTY_TYPE, (Object)qsnRiskRelation.getPartyType());
        QsnRiskRelation one1 = (QsnRiskRelation)this.dao.findOne((AbsModel)qsnRiskRelation1);
        if (one1 != null && !StrUtils.isNull((Object)one1.getRrUuid())) {
            throw new BusinessException("\u9669\u79cd\u5df2\u5173\u8054\u544a\u77e5\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
        }
        String rrUuid = UUID.shortUUID();
        qsnRiskRelation.setRrUuid(rrUuid);
        this.dao.save((AbsModel)qsnRiskRelation);
        msg.setSuccessMsg(new Message("2010001", "2010001"));
        return msg.msg();
    }

    @Override
    public ReturnMsg deleteRiskInform(String rrUuidStr) {
        String[] array = rrUuidStr.split(",");
        Return msg = new Return();
        for (String rrUuid : array) {
            QsnRiskRelation qsnRiskRelation = new QsnRiskRelation();
            qsnRiskRelation.where().addEq(QsnRiskRelation.RR_UUID, (Object)rrUuid);
            this.dao.delete((AbsModel)qsnRiskRelation);
        }
        msg.setSuccessMsg(new Message("2010003", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg updateRiskInform(QsnRiskRelation qsnRiskRelation) {
        Return msg = new Return();
        qsnRiskRelation.where().addEq(QsnRiskRelation.RR_UUID, (Object)qsnRiskRelation.getRrUuid());
        QsnRiskRelation qsnRiskRelation1 = new QsnRiskRelation();
        qsnRiskRelation1.where().addEq(QsnRiskRelation.RISK_CODE, (Object)qsnRiskRelation.getRiskCode());
        qsnRiskRelation1.where().addEq(QsnRiskRelation.DP_TYPE, (Object)qsnRiskRelation.getDpType());
        qsnRiskRelation1.where().addEq(QsnRiskRelation.PARTY_TYPE, (Object)qsnRiskRelation.getPartyType());
        qsnRiskRelation1.where().addNotEq(QsnRiskRelation.RR_UUID, (Object)qsnRiskRelation.getRrUuid());
        QsnRiskRelation one1 = (QsnRiskRelation)this.dao.findOne((AbsModel)qsnRiskRelation1);
        if (one1 != null && !StrUtils.isNull((Object)one1.getRrUuid())) {
            throw new BusinessException("\u9669\u79cd\u5df2\u5173\u8054\u544a\u77e5\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
        }
        this.dao.update((AbsModel)qsnRiskRelation);
        msg.setSuccessMsg(new Message("2010002", "\u66f4\u65b0\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRiskInform(QsnRiskRelation qsnRiskRelation) {
        Return msg = new Return();
        QsnRiskRelation qsnRiskRelation1 = new QsnRiskRelation();
        if (!StrUtils.isNull((Object)qsnRiskRelation.getRiskCode())) {
            qsnRiskRelation1.where().addEq(QsnRiskRelation.RISK_CODE, (Object)qsnRiskRelation.getRiskCode());
        }
        if (!StrUtils.isNull((Object)qsnRiskRelation.getRiskName())) {
            qsnRiskRelation1.where().addLike(QsnRiskRelation.RISK_NAME, (Object)qsnRiskRelation.getRiskName());
        }
        if (!StrUtils.isNull((Object)qsnRiskRelation.getPartyType())) {
            qsnRiskRelation1.where().addEq(QsnRiskRelation.PARTY_TYPE, (Object)qsnRiskRelation.getPartyType());
        }
        if (!StrUtils.isNull((Object)qsnRiskRelation.getDpType())) {
            qsnRiskRelation1.where().addEq(QsnRiskRelation.DP_TYPE, (Object)qsnRiskRelation.getDpType());
        }
        if (!StrUtils.isNull((Object)qsnRiskRelation.getPaperName())) {
            qsnRiskRelation1.where().addLike(QsnRiskRelation.PAPER_NAME, (Object)qsnRiskRelation.getPaperName());
        }
        qsnRiskRelation1.where().addEq(QsnRiskRelation.DATA_FLAG, (Object)"1");
        qsnRiskRelation1.setOrderBy(QsnRiskRelation.MDF_DATE.desc());
        List qsnRiskRelationList = this.dao.findAll((AbsModel)qsnRiskRelation1, Boolean.valueOf(true));
        msg.setDataList(qsnRiskRelationList, QsnRiskRelation.class);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg queryRisks(Map<String, Object> param) {
        Return msg = new Return();
        SipRisks sipRisks = new SipRisks();
        sipRisks.where().addEq(SipRisks.IS_MAIN_RISK, (Object)BaseEnum.ISMAINRISK.M.getType());
        sipRisks.where().addEq(SipRisks.DATA_FLAG, (Object)BaseEnum.DataFlag.USABLE.getType());
        sipRisks.setOrderBy(new Sort.Order[]{SipRisks.CRT_DATE.desc()});
        List sipRisksList = this.dao.findAll((AbsModel)sipRisks, Boolean.valueOf(false));
        msg.setDataList(sipRisksList, SipRisks.class);
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg exportRiskInformJsons(String[] riskInformUuidList, HttpServletResponse response) {
        Return msg = new Return();
        SipProductSyncTask task = new SipProductSyncTask();
        task.setFuncModule("FLOW");
        task.setIsZipDel("1");
        task.setTaskType("EXP");
        task.setCrtDate(new Date());
        StringJoiner joiner = new StringJoiner(",");
        String zipFile = "";
        String currentTimeMillis = String.valueOf(System.currentTimeMillis());
        String baseAddress = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + "/";
        if (riskInformUuidList != null && riskInformUuidList.length > 0) {
            ArrayList<QsnRiskRelation> riskInformList = new ArrayList<QsnRiskRelation>();
            ArrayList exportDataVos = new ArrayList();
            ExportRiskInformVo exportRiskInformVo = new ExportRiskInformVo();
            for (String riskInformUuid : riskInformUuidList) {
                QsnRiskRelation qsnRiskRelation = new QsnRiskRelation();
                qsnRiskRelation.where().addEq(QsnRiskRelation.RR_UUID, (Object)riskInformUuid);
                QsnRiskRelation riskInform = (QsnRiskRelation)this.dao.findOne((AbsModel)qsnRiskRelation);
                if (riskInform == null) continue;
                riskInformList.add(riskInform);
            }
            exportRiskInformVo.setJson(JsonUtils.toJson(riskInformList));
            exportRiskInformVo.setName("QsnRiskRelation");
            try {
                FilesUtil.createFile(baseAddress + "/" + exportRiskInformVo.getName() + "/" + exportRiskInformVo.getName() + ".json");
                FilesUtil.writeToFile(baseAddress + "/" + exportRiskInformVo.getName() + "/" + exportRiskInformVo.getName() + ".json", exportRiskInformVo.getJson(), false);
                zipFile = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + ALLOW_SUFFIX;
                Ulog.info((String)("baseAddress----" + baseAddress));
                Ulog.info((String)("zipFile----" + zipFile));
                String zip = FileUtils.zip((String)baseAddress, (String)zipFile, (String[])new String[]{".txt", ".json", ".xlsx", ".png", ".jpg", "jpeg", "gif", "mp4", "pdf"});
                Ulog.info((String)("zip----" + zip));
                File file = new File(zipFile);
                FileInputStream inputStream = new FileInputStream(file);
                byte[] data = new byte[(int)file.length()];
                inputStream.read(data);
                inputStream.close();
                response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
                response.setContentType("application/octet-stream;charset=ISO8859-1");
                response.addHeader("Content-Length", "" + file.length());
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(currentTimeMillis + ALLOW_SUFFIX, "UTF-8"));
                ServletOutputStream stream = response.getOutputStream();
                stream.write(data);
                stream.flush();
                stream.close();
                FilesUtil.delFile(baseAddress);
                String taskName = joiner.toString();
                task.setTaskName(taskName);
                task.setTaskState("FINISH");
                task.setFinishDate(new Date());
                task.setZipPath(zipFile);
                this.dao.save((AbsModel)task);
            }
            catch (Exception e) {
                e.printStackTrace();
                String taskName = joiner.toString();
                task.setTaskName(taskName);
                task.setTaskState("FAIL");
                task.setErrorInfo(e.getMessage());
                task.setFinishDate(new Date());
                this.dao.save((AbsModel)task);
            }
        }
        return null;
    }

    @Override
    public ReturnMsg exportRiskInformJson(String riskCodeLists, HttpServletResponse response) {
        Return msg = new Return();
        SipProductSyncTask task = new SipProductSyncTask();
        task.setFuncModule("FLOW");
        task.setIsZipDel("1");
        task.setTaskType("EXP");
        task.setCrtDate(new Date());
        StringJoiner joiner = new StringJoiner(",");
        String zipFile = "";
        String currentTimeMillis = String.valueOf(System.currentTimeMillis());
        String baseAddress = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + "/";
        String[] riskCodeList1 = riskCodeLists.split(",");
        ArrayList riskInformList = new ArrayList();
        ArrayList exportDataVos = new ArrayList();
        ExportRiskInformVo exportRiskInformVo = new ExportRiskInformVo();
        HashSet<String> set = new HashSet<String>(Arrays.asList(riskCodeList1));
        String[] riskCodeList = set.toArray(set.toArray(new String[0]));
        if (!riskCodeLists.isEmpty()) {
            for (String riskCode : riskCodeList) {
                QsnRiskRelation qsnRiskRelation = new QsnRiskRelation();
                qsnRiskRelation.where().addEq(QsnRiskRelation.RISK_CODE, (Object)riskCode);
                List riskInform = this.dao.findAll((AbsModel)qsnRiskRelation);
                if (riskInform == null) continue;
                riskInformList.addAll(riskInform);
            }
        } else {
            QsnRiskRelation qsnRiskRelation = new QsnRiskRelation();
            qsnRiskRelation.where().addEq(QsnRiskRelation.DATA_FLAG, (Object)"1");
            List riskInform = this.dao.findAll((AbsModel)qsnRiskRelation);
            riskInformList.addAll(riskInform);
        }
        exportRiskInformVo.setJson(JsonUtils.toJson(riskInformList));
        exportRiskInformVo.setName("QsnRiskRelation");
        try {
            FilesUtil.createFile(baseAddress + "/" + exportRiskInformVo.getName() + "/" + exportRiskInformVo.getName() + ".json");
            FilesUtil.writeToFile(baseAddress + "/" + exportRiskInformVo.getName() + "/" + exportRiskInformVo.getName() + ".json", exportRiskInformVo.getJson(), false);
            zipFile = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + ALLOW_SUFFIX;
            Ulog.info((String)("baseAddress----" + baseAddress));
            Ulog.info((String)("zipFile----" + zipFile));
            String zip = FileUtils.zip((String)baseAddress, (String)zipFile, (String[])new String[]{".txt", ".json", ".xlsx", ".png", ".jpg", "jpeg", "gif", "mp4", "pdf"});
            Ulog.info((String)("zip----" + zip));
            File file = new File(zipFile);
            FileInputStream inputStream = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            inputStream.read(data);
            inputStream.close();
            response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
            response.setContentType("application/octet-stream;charset=ISO8859-1");
            response.addHeader("Content-Length", "" + file.length());
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(currentTimeMillis + ALLOW_SUFFIX, "UTF-8"));
            ServletOutputStream stream = response.getOutputStream();
            stream.write(data);
            stream.flush();
            stream.close();
            FilesUtil.delFile(baseAddress);
            String taskName = joiner.toString();
            task.setTaskName(taskName);
            task.setTaskState("FINISH");
            task.setFinishDate(new Date());
            task.setZipPath(zipFile);
            this.dao.save((AbsModel)task);
        }
        catch (Exception e) {
            e.printStackTrace();
            String taskName = joiner.toString();
            task.setTaskName(taskName);
            task.setTaskState("FAIL");
            task.setErrorInfo(e.getMessage());
            task.setFinishDate(new Date());
            this.dao.save((AbsModel)task);
        }
        return null;
    }

    @Override
    public ReturnMsg uploadRiskInform(MultipartFile zipFile) {
        SipProductSyncTask task = new SipProductSyncTask();
        task.setCrtDate(new Date());
        String pathName = this.templateConfig.getUploadFormCollectPath() + "/upload/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        Return msg = this.unzipFile(zipFile, pathName);
        if (!msg.isSuccessflag()) {
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"));
            return msg.msg();
        }
        File importDir = new File(pathName);
        ArrayList<File> fileList = new ArrayList<File>();
        this.getAllFiles(importDir, fileList, ".json");
        StringJoiner joiner = new StringJoiner(",");
        for (File jsonFile : fileList) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
                Throwable throwable = null;
                try {
                    int ch = 0;
                    StringBuilder sb = new StringBuilder();
                    while ((ch = ((Reader)reader).read()) != -1) {
                        sb.append((char)ch);
                    }
                    String txtStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u7684\u9669\u79cd\u544a\u77e5\u5173\u7cfb\u4e3a" + txtStr));
                    joiner.add(jsonFile.getName());
                    List qsnRiskRelation = JsonUtils.json2List((String)txtStr, QsnRiskRelation.class);
                    this.dao.delete(QsnRiskRelation.n().where().addIn(QsnRiskRelation.RISK_CODE, qsnRiskRelation.stream().map(QsnRiskRelation::getRiskCode).collect(Collectors.toList())).model());
                    this.dao.save(qsnRiskRelation);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Ulog.debug((Object)e);
                Ulog.info((String)("\u9669\u79cd\u544a\u77e5\u5173\u7cfb\u6587\u4ef6\u5bfc\u5165\u5f02\u5e38--->" + e.getMessage()));
                msg.setFailMsg("\u9669\u79cd\u544a\u77e5\u5173\u7cfb\u6587\u4ef6\u5bfc\u5165\u5f02\u5e38--->" + e.getMessage());
                return msg.msg();
            }
        }
        FilesUtil.delFile(pathName);
        String taskName = joiner.toString();
        task.setFuncModule("QSNRISKRELATION");
        task.setTaskType("IMP");
        task.setTaskName("QsnRiskRelation");
        task.setTaskState("FINISH");
        task.setFinishDate(new Date());
        this.dao.save((AbsModel)task);
        msg.setSuccessMsg("\u9669\u79cd\u544a\u77e5\u5173\u7cfb\u6587\u4ef6\u6210\u529f");
        return msg.msg();
    }

    private Return unzipFile(MultipartFile file, String path) {
        String fileName = file.getOriginalFilename();
        long fileSize = file.getSize();
        Return msg = this.checkFile(fileName, fileSize);
        try {
            File destFile = new File(path);
            if (!destFile.exists()) {
                destFile.mkdirs();
            }
            FileUtils.unzip((InputStream)file.getInputStream(), (String)path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return msg;
    }

    private Return checkFile(String fileName, long fileSize) {
        String suffix;
        Return msg = new Return();
        if (fileName.indexOf(".") < 0) {
            msg.setFailMsg(new Message("6030004", "\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[.zip]\u7684\u6587\u4ef6"));
        }
        if (ALLOW_SUFFIX.indexOf(suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase()) == -1) {
            msg.setFailMsg(new Message("6030004", "\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[.zip]\u7684\u6587\u4ef6"));
        }
        if (fileSize <= 0L) {
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u5fc5\u987b\u5927\u4e8e0KB"));
        }
        return msg;
    }

    public void getAllFiles(File dir, List<File> file, String fileType) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.getAllFiles(files[i], file, fileType);
                continue;
            }
            String name = files[i].getName();
            if (name.endsWith(fileType)) {
                File file1 = files[i];
                file.add(file1);
            }
            Ulog.info((Object)files[i]);
        }
    }
}

