/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.utils.export;

import com.newtouch.base.model.ComponentAttribute;
import com.newtouch.base.model.DsnRules;
import com.newtouch.base.model.DsnRulesConst;
import com.newtouch.base.model.DsnRulesParam;
import com.newtouch.base.model.FmAttributesType;
import com.newtouch.base.model.FmCollection;
import com.newtouch.base.model.FmTemplate;
import com.newtouch.base.model.FmTemplateAttributes;
import com.newtouch.base.model.FmTemplateText;
import com.newtouch.base.model.QsnPaper;
import com.newtouch.base.model.QsnPaperTemplate;
import com.newtouch.base.service.FormTemplateService;
import com.newtouch.base.service.RuleUsedService;
import com.newtouch.base.utils.export.Md5Callback;
import com.newtouch.flow.model.FmEmbedded;
import com.newtouch.flow.model.FmFlow;
import com.newtouch.flow.model.FmNode;
import com.newtouch.flow.model.FmNodeTemplate;
import com.newtouch.flow.model.FmProductFlow;
import com.newtouch.flow.model.FmRouter;
import com.newtouch.inform.model.QsnCoreQuestions;
import com.newtouch.inform.model.QsnQuestionBlanks;
import com.newtouch.inform.model.QsnQuestionOptions;
import com.newtouch.inform.model.QsnQuestions;
import com.newtouch.inform.model.QsnTitleRelation;
import com.newtouch.issue.model.WtIssue;
import com.newtouch.material.model.ScglAuthorized;
import com.newtouch.material.model.ScglMaterial;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.newtouch.material.model.ScpzReference;
import com.newtouch.material.model.ScpzTags;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.stereotype.Component;

@Component
@CacheConfig(cacheNames={"exportQueryUtils"})
public class ExportQueryUtils {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    FormTemplateService formTemplateService;
    @Autowired
    RuleUsedService ruleUsedService;
    private final Md5Callback<AbsModel> md5Callback = new Md5Callback();

    public QsnPaper queryPaper(String paperUuid) {
        QsnPaper qsnPaper = new QsnPaper();
        qsnPaper.where().addEq(QsnPaper.PAPER_UUID, (Object)paperUuid);
        qsnPaper.where().addCallback(this.md5Callback);
        qsnPaper = (QsnPaper)this.dao.findOne((AbsModel)qsnPaper);
        if (StrUtils.isNull((Object)((Object)qsnPaper))) {
            return null;
        }
        return qsnPaper;
    }

    public FmTemplate queryFmTemplate(String templateId) {
        FmTemplate fmTemplate = new FmTemplate();
        fmTemplate.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
        fmTemplate.where().addCallback(this.md5Callback);
        FmTemplate fmTemplateDb = (FmTemplate)this.dao.findOne((AbsModel)fmTemplate);
        if (StrUtils.isNull((Object)((Object)fmTemplateDb))) {
            return null;
        }
        return fmTemplateDb;
    }

    public List<QsnTitleRelation> queryQsnTitleRelationList(String paperUuid) {
        QsnTitleRelation qsnTitleRelation = new QsnTitleRelation();
        qsnTitleRelation.where().addEq(QsnTitleRelation.PAPER_UUID, (Object)paperUuid);
        qsnTitleRelation.where().addCallback(this.md5Callback);
        List qsnTitleRelationList = this.dao.findAll((AbsModel)qsnTitleRelation);
        if (CollectionUtils.isEmpty((Collection)qsnTitleRelationList)) {
            return new ArrayList<QsnTitleRelation>();
        }
        return qsnTitleRelationList;
    }

    public QsnQuestions queryQsnQuestions(String qsnUuid) {
        QsnQuestions qsnQuestions = new QsnQuestions();
        qsnQuestions.where().addEq(QsnQuestions.QSN_UUID, (Object)qsnUuid);
        qsnQuestions.where().addCallback(this.md5Callback);
        qsnQuestions = (QsnQuestions)this.dao.findOne((AbsModel)qsnQuestions);
        if (StrUtils.isNull((Object)((Object)qsnQuestions))) {
            return null;
        }
        return qsnQuestions;
    }

    public List<QsnQuestions> queryChildQsnQuestions(String qsnUuid, String childUuid) {
        QsnQuestions qsnQuestions = new QsnQuestions();
        qsnQuestions.where().addEq(QsnQuestions.UP_QUESTION_ID, (Object)qsnUuid);
        qsnQuestions.where().addIn(QsnQuestions.QSN_UUID, Arrays.asList(childUuid.split(",")));
        qsnQuestions.where().addCallback(this.md5Callback);
        return this.dao.findAll((AbsModel)qsnQuestions);
    }

    public QsnCoreQuestions queryQsnCoreQuestions(String coreQuestionUuid) {
        QsnCoreQuestions qsnCoreQuestions = new QsnCoreQuestions();
        qsnCoreQuestions.where().addEq(QsnCoreQuestions.CORE_QUESTION_UUID, (Object)coreQuestionUuid);
        qsnCoreQuestions.where().addCallback(this.md5Callback);
        qsnCoreQuestions = (QsnCoreQuestions)this.dao.findOne((AbsModel)qsnCoreQuestions);
        if (StrUtils.isNull((Object)((Object)qsnCoreQuestions))) {
            return null;
        }
        return qsnCoreQuestions;
    }

    public List<QsnQuestionBlanks> queryQsnQuestionBlanks(String qsnUuid) {
        QsnQuestionBlanks qsnQuestionBlanks = new QsnQuestionBlanks();
        qsnQuestionBlanks.where().addEq(QsnQuestionBlanks.QUESTION_UUID, (Object)qsnUuid);
        qsnQuestionBlanks.where().addCallback(this.md5Callback);
        qsnQuestionBlanks.setOrderBy(QsnQuestionBlanks.DISPLAY_ORDER.asc());
        List qsnQuestionBlanksList = this.dao.findAll((AbsModel)qsnQuestionBlanks);
        if (CollectionUtils.isEmpty((Collection)qsnQuestionBlanksList)) {
            return new ArrayList<QsnQuestionBlanks>();
        }
        return qsnQuestionBlanksList;
    }

    public List<QsnQuestionBlanks> queryQsnQuestionBlanks(String relateField, String relateTab, String relateFk) {
        QsnQuestionBlanks qsnQuestionBlanks = new QsnQuestionBlanks();
        qsnQuestionBlanks.where().addEq(QsnQuestionBlanks.RELATE_FK, (Object)relateFk);
        qsnQuestionBlanks.where().addEq(QsnQuestionBlanks.RELATE_FIELD, (Object)relateField);
        qsnQuestionBlanks.where().addEq(QsnQuestionBlanks.RELATE_TAB, (Object)relateTab);
        qsnQuestionBlanks.where().addCallback(this.md5Callback);
        qsnQuestionBlanks.setOrderBy(QsnQuestionBlanks.DISPLAY_ORDER.asc());
        List qsnQuestionBlanksList = this.dao.findAll((AbsModel)qsnQuestionBlanks);
        if (CollectionUtils.isEmpty((Collection)qsnQuestionBlanksList)) {
            return new ArrayList<QsnQuestionBlanks>();
        }
        return qsnQuestionBlanksList;
    }

    public List<QsnQuestionOptions> queryQsnQuestionOptions(String relateField, String relateTab, String relateFk) {
        QsnQuestionOptions qsnQuestionOptions = new QsnQuestionOptions();
        qsnQuestionOptions.where().addEq(QsnQuestionOptions.RELATE_FK, (Object)relateFk);
        qsnQuestionOptions.where().addEq(QsnQuestionOptions.RELATE_FIELD, (Object)relateField);
        qsnQuestionOptions.where().addEq(QsnQuestionOptions.RELATE_TAB, (Object)relateTab);
        qsnQuestionOptions.where().addCallback(this.md5Callback);
        qsnQuestionOptions.setOrderBy(QsnQuestionOptions.DISPLAY_ORDER.asc());
        List qsnQuestionOptionsList = this.dao.findAll((AbsModel)qsnQuestionOptions);
        if (CollectionUtils.isEmpty((Collection)qsnQuestionOptionsList)) {
            return new ArrayList<QsnQuestionOptions>();
        }
        return qsnQuestionOptionsList;
    }

    public List<DsnRules> queryDsnRulesList(String relateFk, String relateField, String relateTab) {
        DsnRules dsnRules = new DsnRules();
        dsnRules.where().addEq(DsnRules.RELATE_TAB, (Object)relateTab);
        dsnRules.where().addEq(DsnRules.RELATE_FIELD, (Object)relateField);
        dsnRules.where().addEq(DsnRules.RELATE_FK, (Object)relateFk);
        dsnRules.where().addCallback(this.md5Callback);
        List dsnRulesList = this.dao.findAll((AbsModel)dsnRules);
        if (CollectionUtils.isEmpty((Collection)dsnRulesList)) {
            return new ArrayList<DsnRules>();
        }
        return dsnRulesList;
    }

    public List<QsnPaperTemplate> queryQsnPaperTemplateList(String paperUuid) {
        QsnPaperTemplate qsnPaperTemplateSelect = new QsnPaperTemplate();
        qsnPaperTemplateSelect.where().addEq(QsnPaperTemplate.PAPER_UUID, (Object)paperUuid);
        qsnPaperTemplateSelect.where().addCallback(this.md5Callback);
        List qsnPaperTemplateList = this.dao.findAll((AbsModel)qsnPaperTemplateSelect);
        if (CollectionUtils.isEmpty((Collection)qsnPaperTemplateList)) {
            return new ArrayList<QsnPaperTemplate>();
        }
        return qsnPaperTemplateList;
    }

    public List<ScpzMaterialTagsRelation> querySmtr(String relationFk, String relationField, String relationTab) {
        ScpzMaterialTagsRelation scpzMaterialTagsRelation = new ScpzMaterialTagsRelation();
        scpzMaterialTagsRelation.where().addEq(ScpzMaterialTagsRelation.RELATION_FK, (Object)relationFk);
        scpzMaterialTagsRelation.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)relationField);
        scpzMaterialTagsRelation.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)relationTab);
        scpzMaterialTagsRelation.where().addCallback(this.md5Callback);
        List scpzMaterialTagsRelationList = this.dao.findAll((AbsModel)scpzMaterialTagsRelation);
        if (CollectionUtils.isEmpty((Collection)scpzMaterialTagsRelationList)) {
            return new ArrayList<ScpzMaterialTagsRelation>();
        }
        return scpzMaterialTagsRelationList;
    }

    public List<ScpzMaterialTagsRelation> querySmtr(List<String> tagIdList, String relationField, String relationTab) {
        ScpzMaterialTagsRelation scpzMaterialTagsRelation = new ScpzMaterialTagsRelation();
        scpzMaterialTagsRelation.where().addIn(ScpzMaterialTagsRelation.TAG_ID, tagIdList);
        scpzMaterialTagsRelation.where().addEq(ScpzMaterialTagsRelation.RELATION_FIELD, (Object)relationField);
        scpzMaterialTagsRelation.where().addEq(ScpzMaterialTagsRelation.RELATION_TAB, (Object)relationTab);
        scpzMaterialTagsRelation.where().addCallback(this.md5Callback);
        List scpzMaterialTagsRelationList = this.dao.findAll((AbsModel)scpzMaterialTagsRelation);
        if (CollectionUtils.isEmpty((Collection)scpzMaterialTagsRelationList)) {
            return new ArrayList<ScpzMaterialTagsRelation>();
        }
        return scpzMaterialTagsRelationList;
    }

    public ScpzTags queryScpzTags(String tagId) {
        ScpzTags scpzTags = new ScpzTags();
        scpzTags.where().addEq(ScpzTags.TAG_ID, (Object)tagId);
        scpzTags.where().addCallback(this.md5Callback);
        ScpzTags st = (ScpzTags)this.dao.findOne((AbsModel)scpzTags);
        if (StrUtils.isNull((Object)((Object)st))) {
            return null;
        }
        return st;
    }

    public List<FmTemplateAttributes> queryAttrList(String templateId) {
        FmTemplateAttributes fmTemplateAttributes = new FmTemplateAttributes();
        fmTemplateAttributes.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId);
        fmTemplateAttributes.where().addCallback(this.md5Callback);
        List fmTemplateAttrAll = this.dao.findAll((AbsModel)fmTemplateAttributes);
        if (CollectionUtils.isEmpty((Collection)fmTemplateAttrAll)) {
            return new ArrayList<FmTemplateAttributes>();
        }
        return fmTemplateAttrAll;
    }

    public FmTemplateText queryFmTemplateText(String attrId) {
        FmTemplateText fmTemplateText = new FmTemplateText();
        fmTemplateText.where().addEq(FmTemplateText.ATTR_ID, (Object)attrId);
        fmTemplateText.where().addCallback(this.md5Callback);
        FmTemplateText fmTemplateTexDb = (FmTemplateText)this.dao.findOne((AbsModel)fmTemplateText);
        if (StrUtils.isNull((Object)((Object)fmTemplateTexDb))) {
            return null;
        }
        return fmTemplateTexDb;
    }

    public List<DsnRulesConst> queryRuleConst(String ruleId) {
        DsnRulesConst danRulesConst = new DsnRulesConst();
        danRulesConst.where().addEq(DsnRulesConst.RULE_ID, (Object)ruleId);
        danRulesConst.where().addCallback(this.md5Callback);
        return this.dao.findAll((AbsModel)danRulesConst);
    }

    public List<DsnRulesParam> queryRuleParam(String ruleId) {
        DsnRulesParam dsnRulesParam = new DsnRulesParam();
        dsnRulesParam.where().addEq(DsnRulesParam.RULE_ID, (Object)ruleId);
        dsnRulesParam.where().addCallback(this.md5Callback);
        return this.dao.findAll((AbsModel)dsnRulesParam);
    }

    public FmCollection queryFmCollection(String collId) {
        FmCollection fmCollection = new FmCollection();
        fmCollection.where().addEq(FmCollection.COLL_ID, (Object)collId);
        fmCollection.where().addCallback(this.md5Callback);
        return (FmCollection)this.dao.findOne((AbsModel)fmCollection);
    }

    public FmFlow queryFmFlow(String flowUuid) {
        FmFlow fmFlow = new FmFlow();
        fmFlow.where().addEq(FmFlow.FLOW_UUID, (Object)flowUuid);
        fmFlow.where().addCallback(this.md5Callback);
        return (FmFlow)this.dao.findOne((AbsModel)fmFlow);
    }

    public List<FmNode> queryFmNodeList(String flowUuid) {
        FmNode fmNode = new FmNode();
        fmNode.where().addEq(FmNode.FLOW_UUID, (Object)flowUuid);
        fmNode.where().addCallback(this.md5Callback);
        List fmNodeList = this.dao.findAll((AbsModel)fmNode);
        if (CollectionUtils.isEmpty((Collection)fmNodeList)) {
            return new ArrayList<FmNode>();
        }
        return fmNodeList;
    }

    public List<FmRouter> queryFmRouterList(String flowUuid) {
        FmRouter fmRouter = new FmRouter();
        fmRouter.where().addEq(FmRouter.FLOW_UUID, (Object)flowUuid);
        fmRouter.where().addCallback(this.md5Callback);
        List fmRouterList = this.dao.findAll((AbsModel)fmRouter);
        if (CollectionUtils.isEmpty((Collection)fmRouterList)) {
            return new ArrayList<FmRouter>();
        }
        return fmRouterList;
    }

    public List<FmEmbedded> queryFmEmbeddedList(FmEmbedded fmEmbedded) {
        FmEmbedded fmEmbeddedSelect = new FmEmbedded();
        fmEmbeddedSelect.where().addEq(FmEmbedded.EMBEDDED_ELEMENT_CN, (Object)fmEmbedded.getEmbeddedElementCn());
        fmEmbeddedSelect.where().addEq(FmEmbedded.EMBEDDED_ELEMENT_EN, (Object)fmEmbedded.getEmbeddedElementEn());
        fmEmbeddedSelect.where().addIn(FmEmbedded.DELIVERY_PLATFORM, Arrays.asList(fmEmbedded.getDeliveryPlatform().split(",")));
        fmEmbeddedSelect.where().addCallback(this.md5Callback);
        List embeddeds = this.dao.findAll((AbsModel)fmEmbeddedSelect);
        if (CollectionUtils.isEmpty((Collection)embeddeds)) {
            return new ArrayList<FmEmbedded>();
        }
        return embeddeds;
    }

    public com.newtouch.base.model.Component queryComponent(String componentType, String templateType) {
        com.newtouch.base.model.Component c = new com.newtouch.base.model.Component();
        c.where().addEq(com.newtouch.base.model.Component.COMPONENT_TYPE, (Object)componentType);
        c.where().addEq(com.newtouch.base.model.Component.COMPONENT_CLASS, (Object)templateType);
        c.where().addCallback(this.md5Callback);
        com.newtouch.base.model.Component component = (com.newtouch.base.model.Component)this.dao.findOne((AbsModel)c);
        if (StrUtils.isNull((Object)((Object)component))) {
            return null;
        }
        return component;
    }

    public List<ComponentAttribute> queryCaList(String componentId) {
        ComponentAttribute ca = new ComponentAttribute();
        ca.where().addEq(ComponentAttribute.COMPONENT_ID, (Object)componentId);
        ca.where().addEq(ComponentAttribute.DATA_FLAG, (Object)"1");
        ca.where().addCallback(this.md5Callback);
        List caList = this.dao.findAll((AbsModel)ca);
        if (CollectionUtils.isEmpty((Collection)caList)) {
            return new ArrayList<ComponentAttribute>();
        }
        return caList;
    }

    public FmAttributesType queryFmAttributesType(String componentType) {
        FmAttributesType fat = (FmAttributesType)this.dao.findOne(FmAttributesType.n().where().addEq(FmAttributesType.COMPONENT_TYPE, (Object)componentType).addCallback(this.md5Callback).model());
        if (StrUtils.isNull((Object)((Object)fat))) {
            return null;
        }
        return fat;
    }

    public List<FmProductFlow> queryFmProductFlow(String addBatch) {
        List fpfList = this.dao.findAll((AbsModel)((FmProductFlow)FmProductFlow.n().where().addEq(FmProductFlow.ADD_BATCH, (Object)addBatch).addEq(FmProductFlow.DATA_FLAG, (Object)"1").addCallback(this.md5Callback).model()).setOrderBy(FmProductFlow.PRODUCT_FLOW_UUID.asc()));
        if (CollectionUtils.isEmpty((Collection)fpfList)) {
            return new ArrayList<FmProductFlow>();
        }
        return fpfList;
    }

    public List<FmNodeTemplate> queryNodeTemplateList(String productFlowUuid) {
        List fntList = this.dao.findAll((AbsModel)((FmNodeTemplate)FmNodeTemplate.n().where().addEq(FmNodeTemplate.PRODUCT_FLOW_UUID, (Object)productFlowUuid).addEq(FmNodeTemplate.DATA_FLAG, (Object)"1").addCallback(this.md5Callback).model()).setOrderBy(FmNodeTemplate.NODE_TEMPLATE_UUID.asc()));
        if (CollectionUtils.isEmpty((Collection)fntList)) {
            return new ArrayList<FmNodeTemplate>();
        }
        return fntList;
    }

    public WtIssue queryWtIssue(String relationFk) {
        WtIssue wtIssue = (WtIssue)this.dao.findOne(WtIssue.n().where().addEq(WtIssue.ISSUE_UUID, (Object)relationFk).addCallback(this.md5Callback).model());
        if (StrUtils.isNull((Object)((Object)wtIssue))) {
            return null;
        }
        return wtIssue;
    }

    public List<ScpzReference> queryScpzReferences(String materialId) {
        List srList = this.dao.findAll(ScpzReference.n().where().addEq(ScpzReference.MATERIAL_ID, (Object)materialId).addCallback(this.md5Callback).model());
        if (CollectionUtils.isEmpty((Collection)srList)) {
            return new ArrayList<ScpzReference>();
        }
        return srList;
    }

    public ScglAuthorized queryScglAuthorized(String materialId) {
        ScglAuthorized sa = (ScglAuthorized)this.dao.findOne(ScglAuthorized.n().where().addEq(ScglAuthorized.MATERIAL_ID, (Object)materialId).addCallback(this.md5Callback).model());
        if (StrUtils.isNull((Object)((Object)sa))) {
            return null;
        }
        return sa;
    }

    public List<ScglMaterial> queryScglMaterials(Set<String> paths) {
        List scglMaterials = this.dao.findAll(ScglMaterial.n().where().addIn(ScglMaterial.FILE_NAME, new ArrayList<String>(paths)).addCallback(this.md5Callback).model());
        if (CollectionUtils.isEmpty((Collection)scglMaterials)) {
            return new ArrayList<ScglMaterial>();
        }
        return scglMaterials;
    }
}

