/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.service.impl;

import com.newtouch.base.config.ObsConfig;
import com.newtouch.base.config.TemplateConfig;
import com.newtouch.base.model.FmTemplate;
import com.newtouch.base.model.FmTemplateAttributes;
import com.newtouch.base.model.QsnPaper;
import com.newtouch.base.model.QsnPaperTemplate;
import com.newtouch.base.service.DynamicFormService;
import com.newtouch.base.service.FmAttributesTypeService;
import com.newtouch.base.service.FormTemplateService;
import com.newtouch.base.service.PaperConfigService;
import com.newtouch.base.service.RuleUsedService;
import com.newtouch.base.service.SysDataService;
import com.newtouch.base.utils.FilesUtil;
import com.newtouch.base.utils.QueryUtils;
import com.newtouch.base.utils.hwobs.HWYObsSDKUtis;
import com.newtouch.base.vo.ExportDataVo;
import com.newtouch.base.vo.FmJsonAndValueVo;
import com.newtouch.base.vo.FmJsonReqParam;
import com.newtouch.base.vo.PaperQueryVo;
import com.newtouch.base.vo.export.PaperAllInfo;
import com.newtouch.flow.param.MaterialDataList;
import com.newtouch.flow.param.QueryTagsRelationParam;
import com.newtouch.flow.param.QueryTagsRelationReturn;
import com.newtouch.flow.service.IFmFlowService;
import com.newtouch.inform.model.PaperInfoListObj;
import com.newtouch.inform.model.QsnQuestions;
import com.newtouch.inform.model.QsnTitleRelation;
import com.newtouch.inform.param.QsnQuestionsInfo2;
import com.newtouch.inform.service.QsnQuestionsService;
import com.newtouch.inform.service.QsnTitleRelationService;
import com.newtouch.issue.service.IWtIssueService;
import com.newtouch.material.model.ScglAuthorized;
import com.newtouch.material.model.ScglMaterial;
import com.newtouch.material.model.ScpzMaterialTagsRelation;
import com.newtouch.material.model.ScpzReference;
import com.newtouch.material.model.ScpzTags;
import com.newtouch.nms.sip.model.SipProductSyncTask;
import com.newtouch.tags.service.impl.TagsServiceImpl;
import com.uniapis.cache.CacheManager;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.FileUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class PaperConfigServiceImpl
implements PaperConfigService {
    @Autowired
    AbsModelRepository dao;
    @Autowired
    private TemplateConfig templateConfig;
    @Autowired
    DynamicFormService dynamicFormService;
    @Autowired
    private RuleUsedService ruleUsedService;
    @Autowired
    HWYObsSDKUtis hwyObsSDKUtis;
    @Autowired
    private ObsConfig obsConfig;
    @Autowired
    private SysDataService sysDataService;
    @Autowired
    FormTemplateService formTemplateService;
    @Autowired
    IFmFlowService iFmFlowService;
    @Autowired
    private IWtIssueService iWtIssueService;
    @Autowired
    private FmAttributesTypeService fmAttributesTypeService;
    @Autowired
    private TagsServiceImpl tagsService;
    @Autowired
    private QsnQuestionsService qsnQuestionsService;
    @Autowired
    private QsnTitleRelationService qsnTitleRelationService;
    private static final String ALLOW_SUFFIX = ".zip";

    @Override
    public ReturnMsg queryPaper(PaperQueryVo paperQueryVo) {
        List resultList;
        String paperName = paperQueryVo.getPaperName();
        String paperType = paperQueryVo.getPaperType();
        String collId = paperQueryVo.getCollId();
        String deliveryPlatform = paperQueryVo.getDeliveryPlatform();
        Return msg = new Return();
        QueryTagsRelationParam tag = new QueryTagsRelationParam();
        tag.setRelationTab("qsn_paper");
        tag.setRelationField("paper_uuid");
        tag.setTagBelongs(paperQueryVo.getTagBelongs());
        tag.setTagsId(paperQueryVo.getTagIds());
        ReturnMsg msgTag = this.iWtIssueService.queryTagsRelation(tag);
        List tagsList = msgTag.getDataList(QueryTagsRelationReturn.class);
        List idList = null;
        Map<Object, Object> listMaps = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)tagsList)) {
            idList = tagsList.stream().map(QueryTagsRelationReturn::getRelationFk).collect(Collectors.toList());
            listMaps = tagsList.stream().collect(Collectors.groupingBy(QueryTagsRelationReturn::getRelationFk));
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        stringBuilder.append("select qsp.* ");
        stringBuilder.append("from qsn_paper qsp where 1=1 ");
        if (!StrUtils.isNull((Object)collId)) {
            stringBuilder.append("and qsp.coll_id = ? ");
            list.add(collId);
        }
        if (!StrUtils.isNull((Object)deliveryPlatform)) {
            String deliveryPlatformList = deliveryPlatform;
            String[] platformList = deliveryPlatformList.split(",");
            List<String> platformIdList = Arrays.asList(platformList);
            stringBuilder.append(" and ( ");
            for (int i = 0; i < platformIdList.size(); ++i) {
                if (i == platformIdList.size() - 1) {
                    stringBuilder.append("qsp.delivery_platform like ? ");
                    list.add("%" + platformIdList.get(i) + "%");
                    continue;
                }
                stringBuilder.append("qsp.delivery_platform like ?  or ");
                list.add("%" + platformIdList.get(i) + "%");
            }
            stringBuilder.append(")");
        }
        if (CollectionUtils.isNotEmpty(paperQueryVo.getTagIds())) {
            if (CollectionUtils.isEmpty(idList)) {
                ArrayList qsnPapers = new ArrayList();
                msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
                msg.setDataList(qsnPapers, QsnPaper.class);
                return msg.msg();
            }
            stringBuilder.append("and ( qsp.paper_uuid in (");
            for (int i = 0; i < idList.size(); ++i) {
                if (i == idList.size() - 1) {
                    stringBuilder.append(" ?  ");
                } else {
                    stringBuilder.append(" ?,  ");
                }
                list.add((String)idList.get(i));
            }
            stringBuilder.append("))");
        }
        boolean isPaginate = true;
        if ("Y".equals(paperQueryVo.getAllFlag())) {
            isPaginate = false;
        }
        Map<Object, Object> finalListMaps = listMaps;
        if (StrUtils.isNull((Object)paperName) && StrUtils.isNull((Object)paperType)) {
            stringBuilder.append("and qsp.data_flag = ? ");
            list.add("1");
            stringBuilder.append("order by qsp.crt_date desc \uff03NOTCHECK");
            resultList = this.dao.findAll(stringBuilder.toString(), QsnPaper.class, Boolean.valueOf(isPaginate), new AbsModelRepository.Args[]{this.dao.args(list)});
            resultList.stream().forEach(o -> {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)finalListMaps.get(o.getPaperUuid())))) {
                    o.setTags((List)finalListMaps.get(o.getPaperUuid()));
                }
            });
            msg.setDataList4includes(resultList, QsnPaper.class, new String[]{"paper_uuid", "delivery_platform", "paper_no", "paper_name", "paper_type", "is_ty_inform", "level_ty_inform", "crt_user", "crt_date", "status", "effective_date", "expiration_date", "tags"});
        } else {
            if (!StrUtils.isNull((Object)paperName)) {
                stringBuilder.append("and qsp.paper_name like ? ");
                list.add("%" + paperName + "%");
            }
            if (!StrUtils.isNull((Object)paperType)) {
                stringBuilder.append("and qsp.paper_type like ? ");
                list.add("%" + paperType + "%");
            }
            stringBuilder.append("order by qsp.crt_date desc \uff03NOTCHECK");
            resultList = this.dao.findAll(stringBuilder.toString(), QsnPaper.class, Boolean.valueOf(isPaginate), new AbsModelRepository.Args[]{this.dao.args(list)});
            resultList.stream().forEach(o -> {
                if (CollectionUtils.isNotEmpty((Collection)((Collection)finalListMaps.get(o.getPaperUuid())))) {
                    o.setTags((List)finalListMaps.get(o.getPaperUuid()));
                }
            });
            msg.setDataList4includes(resultList, QsnPaper.class, new String[]{"paper_uuid", "delivery_platform", "paper_no", "paper_name", "paper_type", "is_ty_inform", "level_ty_inform", "crt_user", "crt_date", "crt_date", "status", "effective_date", "expiration_date", "tags"});
        }
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg deletePaper(Map<String, Object> param) {
        Return msg = new Return();
        List proListParam = (List)param.get("paper_list");
        for (Map proMap : proListParam) {
            String paper_uuid = StrUtils.trimStr(proMap.get("paper_uuid"));
            QsnPaper qsnPaper = new QsnPaper();
            qsnPaper.where().addEq(QsnPaper.PAPER_UUID, (Object)paper_uuid);
            QsnPaper qp = (QsnPaper)this.dao.findOne((AbsModel)qsnPaper);
            if (Objects.equals(qp.getStatus(), "isActive")) {
                msg.setFailMsg("\u5df2\u7ecf\u542f\u7528\u7684\u95ee\u5377\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff01");
                return msg.msg();
            }
            qsnPaper.where().addEq(QsnPaper.PAPER_UUID, (Object)paper_uuid);
            this.dao.delete((AbsModel)qsnPaper);
            QsnPaperTemplate qsnPaperTemplate = new QsnPaperTemplate();
            qsnPaperTemplate.where().addEq(QsnPaperTemplate.PAPER_UUID, (Object)paper_uuid);
            List qsnPaperTemplateList = this.dao.findAll((AbsModel)qsnPaperTemplate);
            for (QsnPaperTemplate paperTemplate : qsnPaperTemplateList) {
                FmTemplate fmTemplate = (FmTemplate)this.dao.findOne(FmTemplate.n().where().addEq(FmTemplate.TEMPLATE_ID, (Object)paperTemplate.getTemplateId()).model());
                String templateId = fmTemplate.getTemplateId();
                this.dao.delete(FmTemplate.n().where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId).model());
                this.ruleUsedService.deleteByRelateFks(templateId, "fm_template");
                FmTemplateAttributes attr = new FmTemplateAttributes();
                attr.where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId);
                List allOldAttr = this.dao.findAll((AbsModel)attr);
                if (CollectionUtils.isNotEmpty((Collection)allOldAttr)) {
                    for (FmTemplateAttributes attributes : allOldAttr) {
                        this.ruleUsedService.deleteByRelateFks(attributes.getAttrId(), "fm_template_attributes");
                    }
                }
                this.dao.delete(FmTemplateAttributes.n().where().addEq(FmTemplateAttributes.TEMPLATE_ID, (Object)templateId).model());
            }
            this.dao.delete(QsnTitleRelation.n().where().addEq(QsnTitleRelation.PAPER_UUID, (Object)paper_uuid).model());
            this.dao.delete(QsnPaperTemplate.n().where().addEq(QsnPaperTemplate.PAPER_UUID, (Object)paper_uuid).model());
        }
        msg.setSuccessMsg(new Message("2010005", "\u5220\u9664\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public void exportJson(String paperUuids, HttpServletResponse response) {
        SipProductSyncTask task = new SipProductSyncTask();
        task.setFuncModule("PAPER");
        task.setIsZipDel("1");
        task.setTaskType("EXP");
        task.setCrtDate(new Date());
        StringJoiner joiner = new StringJoiner(",");
        String zipFile = "";
        try {
            String currentTimeMillis = String.valueOf(System.currentTimeMillis());
            String baseAddress = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + "/";
            if (!StrUtils.isNull((Object)paperUuids)) {
                ArrayList<ExportDataVo> exportDataVos = new ArrayList<ExportDataVo>();
                String[] paperUuidList = paperUuids.split(",");
                for (String paperUuid : paperUuidList) {
                    ExportDataVo exportDataVo = new ExportDataVo();
                    PaperAllInfo paperAllInfo = new PaperAllInfo();
                    paperAllInfo.load(paperUuid);
                    joiner.add(paperAllInfo.getQsnPaper().getPaperName());
                    exportDataVo.setName(paperUuid);
                    exportDataVo.setJson(JsonUtils.toJson((Object)paperAllInfo));
                    MaterialDataList materialDataList = this.iFmFlowService.getMaterial(JsonUtils.json2Map((String)exportDataVo.getJson()));
                    exportDataVo.setMaterialDataList(materialDataList);
                    exportDataVos.add(exportDataVo);
                }
                for (ExportDataVo data : exportDataVos) {
                    FilesUtil.createFile(baseAddress + "/" + data.getName() + ".json");
                    FilesUtil.writeToFile(baseAddress + "/" + data.getName() + ".json", data.getJson(), false);
                    if (StrUtils.isNull((Object)data.getMaterialDataList()) || data.getMaterialDataList().getStringSet().isEmpty()) continue;
                    FilesUtil.createFile(baseAddress + "/" + data.getName() + "/" + "fileList" + ".txt");
                    FilesUtil.writeToFile(baseAddress + "/" + data.getName() + "/" + "fileList" + ".txt", JsonUtils.toJson((Object)data.getMaterialDataList()), false);
                    data.getMaterialDataList().getStringSet().stream().forEach(o -> {
                        try {
                            String[] str = new String[]{};
                            String objectPath = o;
                            if (o.contains("/smp/")) {
                                str = o.split("/smp/");
                                objectPath = str[str.length - 1];
                            }
                            if (o.contains("/pscp-service/")) {
                                str = o.split("/pscp-service/");
                                objectPath = str[str.length - 1];
                            }
                            InputStream inStream = this.hwyObsSDKUtis.getObject(objectPath);
                            String filePath = baseAddress + "/" + data.getName() + "/" + "fileList" + "/" + objectPath;
                            File file = new File(filePath);
                            if (!file.getParentFile().exists() || !file.isDirectory()) {
                                file.getParentFile().mkdirs();
                            }
                            BufferedInputStream in = null;
                            BufferedOutputStream out = null;
                            in = new BufferedInputStream(inStream);
                            out = new BufferedOutputStream(new FileOutputStream(filePath));
                            int len = -1;
                            byte[] b = new byte[1024];
                            while ((len = in.read(b)) != -1) {
                                out.write(b, 0, len);
                            }
                            in.close();
                            out.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }
            }
            zipFile = this.templateConfig.getUploadFormCollectPath() + "/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + currentTimeMillis + ALLOW_SUFFIX;
            Ulog.info((String)("baseAddress----" + baseAddress));
            Ulog.info((String)("zipFile----" + zipFile));
            String zip = FileUtils.zip((String)baseAddress, (String)zipFile, (String[])new String[]{".txt", ".json", ".xlsx", ".png", ".jpg", "jpeg", "gif", "mp4", "pdf"});
            Ulog.info((String)("zip----" + zip));
            File file = new File(zipFile);
            FileInputStream inputStream = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            inputStream.read(data);
            inputStream.close();
            response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
            response.setContentType("application/octet-stream;charset=ISO8859-1");
            response.addHeader("Content-Length", "" + file.length());
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(currentTimeMillis + ALLOW_SUFFIX, "UTF-8"));
            ServletOutputStream stream = response.getOutputStream();
            stream.write(data);
            stream.flush();
            stream.close();
            FilesUtil.delFile(baseAddress);
            String taskName = joiner.toString();
            task.setTaskName(taskName);
            task.setTaskState("FINISH");
            task.setFinishDate(new Date());
            task.setZipPath(zipFile);
            this.dao.save((AbsModel)task);
        }
        catch (Exception e) {
            e.printStackTrace();
            String taskName = joiner.toString();
            task.setTaskName(taskName);
            task.setTaskState("FAIL");
            task.setErrorInfo(e.getMessage());
            task.setFinishDate(new Date());
            this.dao.save((AbsModel)task);
        }
    }

    @Override
    public ReturnMsg uploadPaper(MultipartFile zipFile) {
        SipProductSyncTask task = new SipProductSyncTask();
        task.setCrtDate(new Date());
        String pathName = this.templateConfig.getUploadFormCollectPath() + "/upload/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/" + System.currentTimeMillis() + "/";
        Return msg = this.unzipFile(zipFile, pathName);
        if (!msg.isSuccessflag()) {
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25"));
            return msg.msg();
        }
        File importDir = new File(pathName);
        ArrayList<File> jsonList = new ArrayList<File>();
        ArrayList<File> fileList = new ArrayList<File>();
        FilesUtil.getAllFiles(importDir, jsonList, fileList);
        Ulog.info((String)("\u95ee\u5377\u7ba1\u7406\u5bfc\u5165\u83b7\u53d6\u9700\u8981\u8bfb\u53d6\u7684\u6587\u4ef6" + JsonUtils.toJson(jsonList)));
        Ulog.info((String)("\u95ee\u5377\u7ba1\u7406\u5bfc\u5165\u83b7\u53d6\u9700\u8981\u4e0a\u4f20\u7684\u7d20\u6750" + JsonUtils.toJson(fileList)));
        StringJoiner joiner = new StringJoiner(",");
        for (File jsonFile : jsonList) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
                Throwable throwable = null;
                try {
                    int ch = 0;
                    StringBuilder sb = new StringBuilder();
                    while ((ch = ((Reader)reader).read()) != -1) {
                        sb.append((char)ch);
                    }
                    String jsonStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u95ee\u5377\u6570\u636e\u4e3a------->" + jsonStr));
                    PaperAllInfo paperAllInfo = (PaperAllInfo)JsonUtils.json2Class((String)jsonStr, PaperAllInfo.class);
                    PaperAllInfo dbPaperAllInfo = new PaperAllInfo();
                    String paperUuid = jsonFile.getName().substring(0, jsonFile.getName().lastIndexOf("."));
                    dbPaperAllInfo.load(paperUuid);
                    String dbPaper = JsonUtils.toJson((Object)dbPaperAllInfo);
                    Ulog.info((String)("\u67e5\u51fa\u6765\u539f\u6765\u7684\u95ee\u5377\u6570\u636e\u4e3a------->" + dbPaper));
                    dbPaperAllInfo.merge(paperAllInfo);
                    dbPaper = JsonUtils.toJson((Object)dbPaperAllInfo);
                    Ulog.info((String)("merger\u540e\u7684\u7684\u95ee\u5377\u6570\u636e\u4e3a------->" + dbPaper));
                    dbPaperAllInfo.save();
                }
                catch (Throwable ch) {
                    throwable = ch;
                    throw ch;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable ch) {
                            throwable.addSuppressed(ch);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Ulog.error((Throwable)e);
                e.printStackTrace();
                msg.setFailMsg(new Message("6050005", "\u5bfc\u5165\u5931\u8d25"));
                return msg.msg();
            }
        }
        this.materialTableHandler(importDir);
        try {
            for (File pic : fileList) {
                String path = pic.getPath();
                String[] str = new String[]{};
                String obsSplitPath = this.obsConfig.getObsSplitPath();
                if (path.contains("page/")) {
                    str = path.split("page/");
                } else if (path.contains(obsSplitPath)) {
                    str = path.split(obsSplitPath);
                }
                String filePath = str[str.length - 1];
                filePath = filePath.replaceAll("/" + pic.getName(), "");
                this.sysDataService.uploadFileById(pic, filePath, pic.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Ulog.debug((Object)e);
            Ulog.info((String)("\u95ee\u5377\u7ba1\u7406\u7d20\u6750\u6587\u4ef6\u5bfc\u5165\u5f02\u5e38--->" + e.getMessage()));
        }
        FilesUtil.delFile(pathName);
        String taskName = joiner.toString();
        task.setFuncModule("PAPER");
        task.setTaskType("IMP");
        task.setTaskName(taskName);
        task.setTaskState("FINISH");
        task.setFinishDate(new Date());
        this.dao.save((AbsModel)task);
        msg.setSuccessMsg(new Message("6050004", "\u5bfc\u5165\u6210\u529f"));
        return msg.msg();
    }

    public void materialTableHandler(File importDir) {
        ArrayList<File> fileList1 = new ArrayList<File>();
        this.getAllFiles(importDir, fileList1, ".txt");
        for (File jsonFile : fileList1) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), "utf-8");
                Throwable throwable = null;
                try {
                    int ch = 0;
                    StringBuilder sb = new StringBuilder();
                    while ((ch = ((Reader)reader).read()) != -1) {
                        sb.append((char)ch);
                    }
                    String txtStr = sb.toString();
                    Ulog.info((String)("\u9700\u8981\u5bfc\u5165\u7684\u7d20\u6750\u6570\u636e\u4e3a" + txtStr));
                    MaterialDataList scglMaterials = (MaterialDataList)JsonUtils.json2Class((String)txtStr, MaterialDataList.class);
                    List tagIds = scglMaterials.getScpzTags().stream().map(ScpzTags::getTagId).collect(Collectors.toList());
                    if (!tagIds.isEmpty()) {
                        this.dao.delete(ScpzTags.n().where().addIn(ScpzTags.TAG_ID, tagIds).model());
                    }
                    this.dao.save(scglMaterials.getScpzTags());
                    List authorizationIds = scglMaterials.getScglAuthorizeds().stream().map(ScglAuthorized::getAuthorizationId).collect(Collectors.toList());
                    if (!authorizationIds.isEmpty()) {
                        this.dao.delete(ScglAuthorized.n().where().addIn(ScglAuthorized.AUTHORIZATION_ID, authorizationIds).model());
                    }
                    this.dao.save(scglMaterials.getScglAuthorizeds());
                    List materialIds = scglMaterials.getScglMaterials().stream().map(ScglMaterial::getMaterialId).collect(Collectors.toList());
                    if (!materialIds.isEmpty()) {
                        this.dao.delete(ScglMaterial.n().where().addIn(ScglMaterial.MATERIAL_ID, materialIds).model());
                    }
                    this.dao.save(scglMaterials.getScglMaterials());
                    List relationUuids = scglMaterials.getScpzMaterialTagsRelations().stream().map(ScpzMaterialTagsRelation::getRelationUuid).collect(Collectors.toList());
                    if (!relationUuids.isEmpty()) {
                        this.dao.delete(ScpzMaterialTagsRelation.n().where().addIn(ScpzMaterialTagsRelation.RELATION_UUID, relationUuids).model());
                    }
                    this.dao.save(scglMaterials.getScpzMaterialTagsRelations());
                    List referencedIds = scglMaterials.getScpzReferences().stream().map(ScpzReference::getReferencedId).collect(Collectors.toList());
                    if (!referencedIds.isEmpty()) {
                        this.dao.delete(ScpzReference.n().where().addIn(ScpzReference.REFERENCED_ID, referencedIds).model());
                    }
                    this.dao.save(scglMaterials.getScpzReferences());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                System.out.println(e);
                Ulog.debug((Object)e);
            }
        }
    }

    @Override
    public ReturnMsg queryPaperCache(QsnPaper qsnPaper) {
        Return msg = new Return();
        String paperUuid = qsnPaper.getPaperUuid();
        if (StrUtils.isNull((Object)paperUuid)) {
            msg.setFailMsg(new Message("9999999", "\u5931\u8d25"));
            return msg.msg();
        }
        this.setQsnQuestionsInfosCache(paperUuid);
        msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg cachePaperRemove(String paperUuid, String fmTemplateId) {
        Return msg = new Return();
        this.removeQsnQuestionsInfosCache(paperUuid);
        msg.setSuccessMsg("\u6e05\u9664\u7f13\u5b58\u6210\u529f\uff01");
        return msg.msg();
    }

    @Override
    public ReturnMsg queryPaperDetail(String paperUuid, String fmTemplateId) {
        Return msg = new Return();
        if (StrUtils.isNull((Object)paperUuid) || StrUtils.isNull((Object)fmTemplateId)) {
            msg.setFailMsg("id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return msg.msg();
        }
        QsnPaper qsnPaper = new QsnPaper();
        qsnPaper.where().addEq(QsnPaper.PAPER_UUID, (Object)paperUuid);
        qsnPaper = (QsnPaper)this.dao.findOne((AbsModel)qsnPaper);
        FmTemplate fmTemplate = new FmTemplate();
        fmTemplate.where().addEq(FmTemplate.TEMPLATE_ID, (Object)fmTemplateId);
        fmTemplate = (FmTemplate)this.dao.findOne((AbsModel)fmTemplate);
        if (StrUtils.isNull((Object)((Object)qsnPaper)) || StrUtils.isNull((Object)((Object)fmTemplate))) {
            msg.setFailMsg("\u672a\u67e5\u5230\u5bf9\u5e94\u4fe1\u606f\uff01");
            return msg.msg();
        }
        String cacheKey = qsnPaper.getPaperType() + ":" + qsnPaper.getPaperUuid() + ":" + fmTemplate.getTemplateId();
        String cacheJson = (String)CacheManager.get((String)cacheKey);
        if (!StrUtils.isNull((Object)cacheJson)) {
            FmJsonAndValueVo valueVo = (FmJsonAndValueVo)JsonUtils.json2Class((String)cacheJson, FmJsonAndValueVo.class);
            msg.setDataTable(new Object[]{valueVo});
            msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
            return msg.msg();
        }
        QsnPaper paperQuery = new QsnPaper();
        paperQuery.where().addEq(QsnPaper.PAPER_UUID, (Object)paperUuid);
        QsnPaper qsnPaperQuery = (QsnPaper)this.dao.findOne((AbsModel)paperQuery);
        FmJsonReqParam fmJsonReqParam = new FmJsonReqParam();
        fmJsonReqParam.setTemplateId(fmTemplateId);
        FmJsonAndValueVo fmJsonAndValueVo = this.formTemplateService.getPaperFormJsonAndValue(fmJsonReqParam);
        fmJsonAndValueVo.setPaperDetails(qsnPaperQuery);
        CacheManager.put((String)cacheKey, (Object)JsonUtils.toJson((Object)fmJsonAndValueVo));
        msg.setDataTable(new Object[]{fmJsonAndValueVo});
        msg.setSuccessMsg(new Message("2010004", "\u67e5\u8be2\u6210\u529f"));
        return msg.msg();
    }

    private Return unzipFile(MultipartFile file, String path) {
        String fileName = file.getOriginalFilename();
        long fileSize = file.getSize();
        Return msg = this.checkFile(fileName, fileSize);
        try {
            File destFile = new File(path);
            if (!destFile.exists()) {
                destFile.mkdirs();
            }
            FileUtils.unzip((InputStream)file.getInputStream(), (String)path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return msg;
    }

    private Return checkFile(String fileName, long fileSize) {
        String suffix;
        Return msg = new Return();
        if (fileName.indexOf(".") < 0) {
            msg.setFailMsg(new Message("6030004", "\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[.zip]\u7684\u6587\u4ef6"));
        }
        if (ALLOW_SUFFIX.indexOf(suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase()) == -1) {
            msg.setFailMsg(new Message("6030004", "\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[.zip]\u7684\u6587\u4ef6"));
        }
        if (fileSize <= 0L) {
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u5fc5\u987b\u5927\u4e8e0KB"));
        }
        return msg;
    }

    public void getAllFiles(File dir, List<File> file, String type) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.getAllFiles(files[i], file, type);
                continue;
            }
            String name = files[i].getName();
            if (name.endsWith(type)) {
                File file1 = files[i];
                file.add(file1);
            }
            Ulog.info((Object)files[i]);
        }
    }

    public void setQsnQuestionsInfosCache(String paperUuid) {
        if (StrUtils.isNull((Object)paperUuid)) {
            throw new BusinessException("\u5165\u53c2paperUuid\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        QsnPaper qsnPaper = new QsnPaper();
        qsnPaper.where().addIn(QsnPaper.PAPER_UUID, new String[]{paperUuid});
        QsnPaper qsnPaper1 = (QsnPaper)this.dao.findOne((AbsModel)qsnPaper);
        List<QsnTitleRelation> all = this.qsnTitleRelationService.getQsnTitleRelationsOrderBy(paperUuid);
        if (all == null || all.isEmpty()) {
            throw new BusinessException("\u6b64\u544a\u77e5\u672a\u5173\u8054\u9898\u76ee\uff0c\u8bf7\u68c0\u67e5");
        }
        ArrayList<QsnQuestionsInfo2> qsnQuestionsInfos = new ArrayList<QsnQuestionsInfo2>();
        for (QsnTitleRelation qsnTitleRelation : all) {
            String qsnUuid = qsnTitleRelation.getQsnUuid();
            String childUuid = qsnTitleRelation.getChildUuid();
            this.qsnQuestionsService.queryQsnQuestionsInfo(paperUuid, qsnQuestionsInfos, qsnUuid);
            QueryUtils query = (QueryUtils)SpringContext.getBean(QueryUtils.class);
            List<QsnQuestions> childQsnList = query.queryChildQsnQuestions222(qsnUuid, childUuid);
            if (childQsnList.isEmpty()) continue;
            for (QsnQuestions qsnQuestions : childQsnList) {
                this.qsnQuestionsService.queryQsnQuestionsInfo(paperUuid, qsnQuestionsInfos, qsnQuestions.getQsnUuid());
            }
        }
        PaperInfoListObj paperInfoListObj1 = new PaperInfoListObj();
        paperInfoListObj1.setQuestionInfoList(qsnQuestionsInfos);
        paperInfoListObj1.setQsnPaper(qsnPaper1);
        CacheManager.put((String)("InformData:" + paperUuid), (Object)JsonUtils.toJson((Object)paperInfoListObj1));
    }

    public void removeQsnQuestionsInfosCache(String paperUuid) {
        CacheManager.remove((String)("InformData:" + paperUuid));
    }
}

