/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.service.impl;

import com.newtouch.base.enums.BaseEnum;
import com.newtouch.base.model.FmTemplate;
import com.newtouch.base.service.FormDataService;
import com.newtouch.base.utils.ConditionUtil;
import com.newtouch.base.utils.EasyExcelUtil;
import com.newtouch.base.utils.FilesUtil;
import com.newtouch.base.utils.ListUtil;
import com.newtouch.base.vo.FmDataVo;
import com.newtouch.base.vo.GenerateConditionParam;
import com.uniapis.context.ThreadLocalContext;
import com.uniapis.logger.Env;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.utils.DBFunction;
import com.uniapis.repository.core.utils.SqlMapper;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@Service
public class FormDataServiceImpl
implements FormDataService {
    @Autowired
    AbsModelRepository dao;

    @Override
    public ReturnMsg downloadTemplate(HttpServletResponse response, FmDataVo fmDataVo) {
        Return msg = new Return();
        String templateId = fmDataVo.getTemplateId();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        FmTemplate fmTemplateDb = new FmTemplate();
        fmTemplateDb.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
        fmTemplateDb = (FmTemplate)this.dao.findOne((AbsModel)fmTemplateDb);
        if (fmTemplateDb == null) {
            Ulog.info((String)("templateId-->" + templateId + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6570\u636e"));
            msg.setFailMsg(new Message("6050001", "\u5bfc\u51fa\u6a21\u677f\u5931\u8d25"));
            return msg.msg();
        }
        String templateCode = fmTemplateDb.getTemplateCode();
        String templateName = fmTemplateDb.getTemplateName();
        String currentTimeMillis = String.valueOf(System.currentTimeMillis());
        String filePath = Env.env().baseDir() + "formData/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/";
        String fileName = filePath + currentTimeMillis + templateName + ".xlsx";
        Ulog.info((String)("\u52a8\u6001\u8868\u6a21\u677f\u4e0b\u8f7d\u4e34\u65f6\u6587\u4ef6\u8def\u5f84\u4e3a--->" + fileName));
        File destFile = new File(filePath);
        if (!destFile.exists()) {
            destFile.mkdirs();
        }
        List<Map<String, Object>> excelColumnDate = new ArrayList<Map<String, Object>>();
        ArrayList<String> head = new ArrayList<String>();
        ArrayList<String> fieldList = new ArrayList<String>();
        excelColumnDate = this.getExcelColumnDate(templateCode, excelColumnDate);
        List<String> removeList = Arrays.asList("serno", "instance_id", "crt_date", "mdf_date", "crt_user", "mdf_user", "data_flag", "patch_memo", "rn");
        if (CollectionUtils.isNotEmpty(excelColumnDate)) {
            for (Map<String, Object> map : excelColumnDate) {
                String columnName = map.get("column_name").toString();
                if (removeList.contains(columnName)) continue;
                head.add(StrUtils.isNull((Object)map.get("column_comment")) ? columnName : map.get("column_comment").toString());
                fieldList.add(columnName);
            }
            EasyExcelUtil.writeExcel(null, fileName, templateName, head, fieldList, data);
            try {
                File file = new File(fileName);
                FileInputStream inputStream = new FileInputStream(file);
                byte[] dataByte = new byte[(int)file.length()];
                inputStream.read(dataByte);
                inputStream.close();
                response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
                response.setContentType("application/octet-stream;charset=ISO8859-1");
                response.addHeader("Content-Length", "" + file.length());
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(currentTimeMillis + templateName + ".xlsx", "UTF-8"));
                ServletOutputStream stream = response.getOutputStream();
                stream.write(dataByte);
                stream.flush();
                stream.close();
                FilesUtil.delFile(fileName);
            }
            catch (Exception e) {
                e.printStackTrace();
                msg.setFailMsg(new Message("6050001", "\u5bfc\u51fa\u6a21\u677f\u5931\u8d25"));
                return msg.msg();
            }
        }
        msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public void downloadExcel(HttpServletResponse response, FmDataVo fmDataVo) {
        String templateName = fmDataVo.getTemplateName();
        List<FmDataVo.FmDataAttrVo> fields = fmDataVo.getFields();
        String templateCode = fmDataVo.getTemplateCode();
        String currentTimeMillis = String.valueOf(System.currentTimeMillis());
        String filePath = Env.env().baseDir() + "formData/export/" + DateUtils.date2String((Date)new Date(), (String)"yyyy/MM/dd") + "/";
        String fileName = filePath + currentTimeMillis + templateName + ".xlsx";
        File destFile = new File(filePath);
        Ulog.info((String)("\u52a8\u6001\u8868\u6570\u636e\u4e0b\u8f7d\u4e34\u65f6\u6587\u4ef6\u8def\u5f84\u4e3a--->" + fileName));
        if (!destFile.exists()) {
            destFile.mkdirs();
        }
        if (CollectionUtils.isEmpty(fields)) {
            EasyExcelUtil.writeExcel(null, fileName, templateName, null, null, null);
        } else {
            List data;
            ArrayList<String> head = new ArrayList<String>();
            ArrayList<String> fieldList = new ArrayList<String>();
            StringBuilder sql = new StringBuilder();
            sql.append("select ");
            for (FmDataVo.FmDataAttrVo fieldParam : fields) {
                String attrCode = fieldParam.getAttrCode();
                sql.append(attrCode).append(",");
                head.add(fieldParam.getAttrName());
                fieldList.add(attrCode);
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(" from ").append(templateCode);
            List<FmDataVo.FmDataAttrVo> filterParamList = fmDataVo.getFilters();
            if (!CollectionUtils.isEmpty(filterParamList)) {
                sql.append(" where ");
                Tuple2<String, Object[]> objects = this.getFilter(filterParamList, templateCode, fmDataVo.getRel());
                String s = (String)objects.getT1();
                sql.append(s);
                sql.append("\uff03NOTCHECK");
                Object[] param = (Object[])objects.getT2();
                data = this.dao.findAll(String.valueOf(sql), new AbsModelRepository.Args[]{this.dao.args(param)});
            } else {
                sql.append(" where data_flag = ? ");
                sql.append("\uff03NOTCHECK");
                data = this.dao.findAll(String.valueOf(sql), new AbsModelRepository.Args[]{this.dao.args(new Object[]{"1"})});
            }
            EasyExcelUtil.writeExcel(null, fileName, templateName, head, fieldList, data);
        }
        try {
            File file = new File(fileName);
            FileInputStream inputStream = new FileInputStream(file);
            byte[] dataByte = new byte[(int)file.length()];
            inputStream.read(dataByte);
            inputStream.close();
            response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
            response.setContentType("application/octet-stream;charset=ISO8859-1");
            response.addHeader("Content-Length", "" + file.length());
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(currentTimeMillis + templateName + ".xlsx", "UTF-8"));
            ServletOutputStream stream = response.getOutputStream();
            stream.write(dataByte);
            stream.flush();
            stream.close();
            FilesUtil.delFile(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ReturnMsg uploadExcel(MultipartFile file, String templateId) {
        Return msg = new Return();
        try {
            InputStream inputStream = file.getInputStream();
            FmTemplate fmTemplateDb = new FmTemplate();
            fmTemplateDb.where().addEq(FmTemplate.TEMPLATE_ID, (Object)templateId);
            fmTemplateDb = (FmTemplate)this.dao.findOne((AbsModel)fmTemplateDb);
            if (fmTemplateDb == null) {
                msg.setFailMsg(new Message("6050001", "\u5bfc\u51fa\u6a21\u677f\u5931\u8d25"));
                return msg.msg();
            }
            String templateCode = fmTemplateDb.getTemplateCode();
            List<Map<String, Object>> excelColumnDate = new ArrayList<Map<String, Object>>();
            if (CollectionUtils.isNotEmpty(excelColumnDate = this.getExcelColumnDate(templateCode, excelColumnDate))) {
                List<Map<String, Object>> maps = EasyExcelUtil.readExcel(inputStream);
                this.importData(maps, templateCode, excelColumnDate, "N");
            }
            msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
            return msg.msg();
        }
        catch (Exception e) {
            e.printStackTrace();
            Ulog.info((String)("\u5bfc\u5165\u6570\u636e\u5f02\u5e38" + e.getMessage()));
            msg.setFailMsg(new Message("6050002", "\u4fdd\u5b58\u6570\u636e\u5931\u8d25"));
            return msg.msg();
        }
    }

    @Override
    public ReturnMsg importData(FmDataVo fmDataVo) {
        Return msg = new Return();
        FmTemplate fmTemplateDb = new FmTemplate();
        fmTemplateDb.where().addEq(FmTemplate.TEMPLATE_ID, (Object)fmDataVo.getTemplateId());
        fmTemplateDb = (FmTemplate)this.dao.findOne((AbsModel)fmTemplateDb);
        if (fmTemplateDb == null) {
            msg.setFailMsg(new Message("6050002", "\u4fdd\u5b58\u6570\u636e\u5931\u8d25"));
            return msg.msg();
        }
        List<Map<String, Object>> excelColumnDate = new ArrayList<Map<String, Object>>();
        String templateCode = fmTemplateDb.getTemplateCode();
        excelColumnDate = this.getExcelColumnDate(templateCode, excelColumnDate);
        if (CollectionUtils.isNotEmpty(excelColumnDate)) {
            this.importData(fmDataVo.getData(), templateCode, excelColumnDate, "N");
        }
        msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msg.msg();
    }

    @Override
    public ReturnMsg addOrUpdateFormData(FmDataVo fmDataVo) {
        Return msg = new Return();
        FmTemplate fmTemplateDb = new FmTemplate();
        fmTemplateDb.where().addEq(FmTemplate.TEMPLATE_ID, (Object)fmDataVo.getTemplateId());
        fmTemplateDb = (FmTemplate)this.dao.findOne((AbsModel)fmTemplateDb);
        if (fmTemplateDb == null) {
            msg.setFailMsg(new Message("6050002", "\u4fdd\u5b58\u6570\u636e\u5931\u8d25"));
            return msg.msg();
        }
        List<Map<String, Object>> data = fmDataVo.getData();
        ArrayList<Map<String, Object>> addData = new ArrayList<Map<String, Object>>();
        String templateCode = fmTemplateDb.getTemplateCode();
        List<Map<String, Object>> excelColumnDate = new ArrayList<Map<String, Object>>();
        if (CollectionUtils.isEmpty(excelColumnDate = this.getExcelColumnDate(templateCode, excelColumnDate))) {
            msg.setFailMsg(new Message("6050002", "\u4fdd\u5b58\u6570\u636e\u5931\u8d25"));
            return msg.msg();
        }
        for (Map<String, Object> map : data) {
            if (StrUtils.isNull((Object)map.get("instance_id"))) {
                msg.setFailMsg(new Message("6050002", "\u4fdd\u5b58\u6570\u636e\u5931\u8d25"));
                return msg.msg();
            }
            String instanceId = map.get("instance_id").toString();
            String querySql = "select serno from " + templateCode + " where data_flag=? and instance_id = ? order by mdf_date desc limit 1  \uff03NOTCHECK";
            List mapList = this.dao.findAll(querySql, new AbsModelRepository.Args[]{this.dao.args(new Object[]{BaseEnum.DataFlag.USABLE.getType(), instanceId})});
            if (CollectionUtils.isEmpty((Collection)mapList)) {
                addData.add(map);
                continue;
            }
            String serno = ((Map)mapList.get(0)).get("serno").toString();
            this.updateFormData(templateCode, excelColumnDate, map, serno);
        }
        if (CollectionUtils.isNotEmpty(addData)) {
            this.importData(addData, templateCode, excelColumnDate, "N");
        }
        msg.setSuccessMsg(new Message("2010000", "\u6210\u529f"));
        return msg.msg();
    }

    private Tuple2<String, Object[]> getFilter(List<FmDataVo.FmDataAttrVo> filterParamList, String tableName, String rel) {
        ArrayList<GenerateConditionParam> gcpList = new ArrayList<GenerateConditionParam>();
        for (FmDataVo.FmDataAttrVo f : filterParamList) {
            Object gcp;
            ArrayList<Object> objects;
            ArrayList<GenerateConditionParam> childCondition;
            Object sb;
            String attrCode = f.getAttrCode();
            if ("group_eq".equals(f.getMethod())) {
                ArrayList<Object> objects2 = new ArrayList<Object>();
                sb = new StringBuilder();
                for (Object o : f.getValue()) {
                    if (!Objects.nonNull(o)) continue;
                    ((StringBuilder)sb).append(o).append("/");
                }
                ((StringBuilder)sb).deleteCharAt(((StringBuilder)sb).length() - 1);
                objects2.add(((StringBuilder)sb).toString());
                GenerateConditionParam generateConditionParam = new GenerateConditionParam(tableName, attrCode, objects2, f.getMethod(), rel);
                gcpList.add(generateConditionParam);
                continue;
            }
            if ("group_nin".equals(f.getMethod())) {
                ArrayList<Object> objects2 = new ArrayList<Object>();
                sb = new StringBuilder();
                for (Object o : f.getValue()) {
                    if (!Objects.nonNull(o)) continue;
                    ((StringBuilder)sb).append(o).append("/");
                }
                ((StringBuilder)sb).deleteCharAt(((StringBuilder)sb).length() - 1);
                objects2.add(((StringBuilder)sb).toString());
                GenerateConditionParam generateConditionParam = new GenerateConditionParam(tableName, attrCode, objects2, f.getMethod(), rel);
                gcpList.add(generateConditionParam);
                continue;
            }
            if ("group_in".equals(f.getMethod())) {
                childCondition = new ArrayList<GenerateConditionParam>();
                for (Object e : f.getValue()) {
                    objects = new ArrayList<Object>();
                    objects.add(e);
                    GenerateConditionParam gcp2 = new GenerateConditionParam(tableName, attrCode, objects, f.getMethod(), "or");
                    childCondition.add(gcp2);
                }
                gcp = new GenerateConditionParam(tableName, attrCode, null, f.getMethod(), rel, childCondition, true);
                gcpList.add((GenerateConditionParam)gcp);
                continue;
            }
            if ("all".equals(f.getMethod())) {
                childCondition = new ArrayList();
                for (Object object : f.getValue()) {
                    objects = new ArrayList();
                    objects.add(object);
                    GenerateConditionParam gcp2 = new GenerateConditionParam(tableName, attrCode, objects, f.getMethod(), "and");
                    childCondition.add(gcp2);
                }
                gcp = new GenerateConditionParam(tableName, attrCode, null, f.getMethod(), rel, childCondition, true);
                gcpList.add((GenerateConditionParam)gcp);
                continue;
            }
            GenerateConditionParam gcp4 = new GenerateConditionParam(tableName, attrCode, f.getValue(), f.getMethod(), rel);
            gcpList.add(gcp4);
        }
        Tuple2<String, Object[]> objects = ConditionUtil.generatePlaceholderConditionByList(gcpList);
        List<Object> objectsList = Arrays.asList((Object[])objects.getT2());
        ArrayList<Object> placeholderList = new ArrayList<Object>(objectsList);
        placeholderList.add("1");
        return Tuples.of((Object)("(" + ((String)objects.getT1()).substring(5) + ") and data_flag = ?"), (Object)placeholderList.toArray(new Object[0]));
    }

    private List<Map<String, Object>> getExcelColumnDate(String templateCode, List<Map<String, Object>> excelColumnDate) {
        try {
            SqlMapper columnSqlMapper = new SqlMapper();
            columnSqlMapper.setSql("SELECT col.table_name, col.column_name,col.is_nullable ,col.ordinal_position AS o, d.description AS column_comment\nFROM information_schema.columns col\n         JOIN pg_class c ON c.relname = col.table_name\n         LEFT JOIN pg_description d ON d.objoid = c.oid AND d.objsubid = col.ordinal_position\nWHERE col.table_Name = ? \nORDER BY col.table_name, col.ordinal_position");
            ArrayList<String> fileNameList = new ArrayList<String>();
            fileNameList.add(templateCode);
            columnSqlMapper.setValue(fileNameList);
            excelColumnDate = this.dao.findAll(columnSqlMapper.getSql() + " \uff03NOTCHECK", new AbsModelRepository.Args[]{this.dao.args(columnSqlMapper.getValue())});
            Ulog.info((String)("\u67e5\u8be2\u5230\u7684\u8868\u5934\u4fe1\u606f\u4e3a--->" + JsonUtils.toJson((Object)excelColumnDate)));
            if (CollectionUtils.isNotEmpty((Collection)excelColumnDate)) {
                return excelColumnDate.stream().distinct().collect(Collectors.toList());
            }
            return excelColumnDate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReturnMsg importData(List<Map<String, Object>> excelData, String tableName, List<Map<String, Object>> excelColumnDate, String truncateFlag) {
        String timestamp = DBFunction.F.timestamp((Object)DateUtils.date2String((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), this.dao.getDbType());
        ArrayList<String> insertList = new ArrayList<String>();
        Ulog.info((String)("\u52a8\u6001\u8868--->" + tableName + "\u5bfc\u5165\u4fe1\u606f--->" + JsonUtils.toJson(excelData)));
        Return msg = new Return();
        if ("Y".equals(truncateFlag)) {
            Ulog.info((String)("\u52a8\u6001\u8868--->" + tableName + "\u5148\u6e05\u7a7a\u8868"));
            String delSql = "TRUNCATE " + tableName;
            this.dao.getJdbcTemplate().update(delSql);
        }
        for (Map<String, Object> map : excelData) {
            StringBuilder sql = new StringBuilder();
            StringBuilder value = new StringBuilder();
            String pkUuid = ThreadLocalContext.get().getUser().getPkUuid();
            if (StrUtils.isNull((Object)map.get("instance_id"))) {
                sql = new StringBuilder("INSERT INTO " + tableName + " (serno, instance_id, crt_user, mdf_user, data_flag, crt_date, mdf_date");
                value = new StringBuilder(" VALUES('" + UUID.shortUUID() + "', '" + UUID.uuid() + "', '" + pkUuid + "', '" + pkUuid + "', '1', " + timestamp + ", " + timestamp);
            } else {
                sql = new StringBuilder("INSERT INTO " + tableName + " (serno, instance_id, crt_user, mdf_user, data_flag, crt_date, mdf_date");
                value = new StringBuilder(" VALUES('" + UUID.shortUUID() + "', '" + map.get("instance_id").toString() + "', '" + pkUuid + "', '" + pkUuid + "', '1', " + timestamp + ", " + timestamp);
            }
            for (Map.Entry entry : map.entrySet()) {
                String key = "";
                for (Map<String, Object> columnMap : excelColumnDate) {
                    String columnName = columnMap.get("column_name").toString();
                    String isNullable = columnMap.get("is_nullable").toString();
                    if (((String)entry.getKey()).equals(columnName)) {
                        key = columnName;
                        if (!"NO".equals(isNullable) || !StrUtils.isNull(entry.getValue())) continue;
                        msg.setFailMsg(new Message("6050003", "\u4fdd\u5b58\u6570\u636e\u5931\u8d25\uff1a\u8bf7\u586b\u5199\u5fc5\u586b\u9879"));
                        return msg.msg();
                    }
                    if (!((String)entry.getKey()).equals(columnMap.get("column_comment"))) continue;
                    key = columnName;
                    if (!"NO".equals(isNullable) || !StrUtils.isNull(entry.getValue())) continue;
                    msg.setFailMsg(new Message("6050003", "\u4fdd\u5b58\u6570\u636e\u5931\u8d25\uff1a\u8bf7\u586b\u5199\u5fc5\u586b\u9879"));
                    return msg.msg();
                }
                if (StrUtils.isNull((Object)key) || "instance_id".equals(key)) continue;
                sql.append(", " + key);
                value.append(", '" + entry.getValue() + "'");
            }
            insertList.add(sql.append(") ").append((CharSequence)value).append(")").toString());
        }
        List<List<String>> taskList = ListUtil.splitList(insertList, 1000, String.class);
        Ulog.info((String)("\u6570\u636e\u603b\u91cf\u4e3a===>" + insertList.size() + "  \u5206\u7ec4\u6570\u91cf\u4e3a===>" + taskList.size()));
        ScheduledThreadPoolExecutor fixedThreadPool = new ScheduledThreadPoolExecutor(5, (ThreadFactory)new CustomizableThreadFactory("rateDataImport-%d"));
        CountDownLatch countDownLatch = new CountDownLatch(taskList.size());
        Timestamp start1 = DateUtils.sysTimestamp();
        for (List<String> list : taskList) {
            fixedThreadPool.execute(() -> {
                try {
                    this.dao.getJdbcTemplate().batchUpdate(date.toArray(new String[0]));
                }
                catch (Exception e) {
                    Ulog.error((Throwable)e);
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Ulog.error((Throwable)e);
        }
        finally {
            Ulog.info((String)("excel\u6570\u636e\u5bfc\u5165\u5b8c\u6210,\u7528\u65f6[" + DateUtils.dateBetween((Date)new Date(), (Date)start1, (DateUtils.DateType)DateUtils.DateType.SS) + "]\u79d2"));
        }
        return null;
    }

    private ReturnMsg updateFormData(String templateCode, List<Map<String, Object>> excelColumnDate, Map<String, Object> map, String serno) {
        Ulog.info((String)("\u52a8\u6001\u8868--->" + templateCode + "--serno--->" + serno + "--\u66f4\u65b0\u4fe1\u606f--->" + JsonUtils.toJson(map)));
        Return msg = new Return();
        String timestamp = DBFunction.F.timestamp((Object)DateUtils.date2String((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), this.dao.getDbType());
        StringBuilder sql = new StringBuilder();
        String pkUuid = ThreadLocalContext.get().getUser().getPkUuid();
        sql.append("update  ").append(templateCode).append(" set ");
        Boolean updateSql = false;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = "";
            for (Map<String, Object> columnMap : excelColumnDate) {
                String columnName = columnMap.get("column_name").toString();
                String isNullable = columnMap.get("is_nullable").toString();
                if (!entry.getKey().equals(columnName)) continue;
                key = columnName;
                if (!"NO".equals(isNullable) || !StrUtils.isNull((Object)entry.getValue())) continue;
                msg.setFailMsg(new Message("6050003", "\u4fdd\u5b58\u6570\u636e\u5931\u8d25\uff1a\u8bf7\u586b\u5199\u5fc5\u586b\u9879"));
                return msg.msg();
            }
            if (StrUtils.isNull((Object)key)) continue;
            updateSql = true;
            sql.append(key).append("='").append(entry.getValue()).append("',");
        }
        if (!updateSql.booleanValue()) {
            Ulog.info((String)("\u52a8\u6001\u8868--->" + templateCode + "--serno--->" + serno + "--\u65e0\u9700\u66f4\u65b0"));
            return null;
        }
        sql.append("mdf_date=").append(timestamp).append(",mdf_user='").append(pkUuid).append("'");
        if (!ObjectUtils.isEmpty((Object)serno)) {
            sql.append(" where serno= ? and data_flag = ?");
            sql.append("\uff03NOTCHECK");
            int update = this.dao.update(String.valueOf(sql), new Object[]{serno, "1"});
            Ulog.info((String)("\u52a8\u6001\u8868--->" + templateCode + "--serno--->" + serno + "--\u66f4\u65b0\u4fe1\u606f\u7ed3\u679c--->" + update));
        }
        return null;
    }
}

