/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.service.impl;

import com.newtouch.base.service.SipProductSyncTaskService;
import com.newtouch.base.vo.SipProductSyncTaskVo;
import com.newtouch.nms.sip.model.SipProductSyncTask;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.utils.StrUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component
public class SipProductSyncTaskServiceImpl
implements SipProductSyncTaskService {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public ReturnMsg queryTaskList(SipProductSyncTaskVo taskVo) {
        Return aReturn = new Return();
        SipProductSyncTask task = SipProductSyncTask.n();
        BeanUtils.copyProperties((Object)taskVo, (Object)task);
        if (!StrUtils.isNull((Object)taskVo.getTaskName())) {
            task.where().addLike(SipProductSyncTask.TASK_NAME, (Object)taskVo.getTaskName());
        }
        if (!StrUtils.isNull((Object)taskVo.getFuncModule())) {
            task.where().addLike(SipProductSyncTask.FUNC_MODULE, (Object)taskVo.getFuncModule());
        }
        if (!StrUtils.isNull((Object)taskVo.getTaskType())) {
            task.where().addLike(SipProductSyncTask.TASK_TYPE, (Object)taskVo.getTaskType());
        }
        if (!StrUtils.isNull((Object)taskVo.getTaskState())) {
            task.where().addLike(SipProductSyncTask.TASK_STATE, (Object)taskVo.getTaskState());
        }
        if (!StrUtils.isNull((Object)taskVo.getCrtDateStart()) && !StrUtils.isNull((Object)taskVo.getCrtDateEnd())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                sdf.parse(taskVo.getCrtDateStart());
            }
            catch (ParseException e) {
                throw new BusinessException("\u8bf7\u8f93\u5165\u6b63\u786e\u65f6\u95f4\u683c\u5f0f");
            }
            task.where().addBetween(SipProductSyncTask.CRT_DATE, taskVo.getCrtDateStart(), taskVo.getCrtDateEnd());
        }
        task.where().addEq(SipProductSyncTask.DATA_FLAG, (Object)"1");
        task.setOrderBy(new Sort.Order[]{SipProductSyncTask.CRT_DATE.desc()});
        List list = this.dao.findAll((AbsModel)task, Boolean.valueOf(true));
        aReturn.setDataList(list, SipProductSyncTask.class);
        return aReturn.msg();
    }

    @Override
    public void downLoadZipFile(String zipPath, HttpServletResponse response) {
        try {
            String fileName = zipPath.substring(zipPath.lastIndexOf("/") + 1);
            File file = new File(zipPath);
            FileInputStream inputStream = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            inputStream.read(data);
            inputStream.close();
            response.setHeader("content-type", "application/octet-stream;charset=ISO8859-1");
            response.setContentType("application/octet-stream;charset=ISO8859-1");
            response.addHeader("Content-Length", "" + file.length());
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            ServletOutputStream stream = response.getOutputStream();
            stream.write(data);
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

