/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.issue.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.newtouch.base.model.ComponentAttribute;
import com.newtouch.flow.param.QueryTagsRelationReturn;
import com.uniapis.msg.Return;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.Field;
import com.uniapis.repository.core.group.GroupBy;
import com.uniapis.repository.core.where.Where;
import com.uniapis.utils.StrUtils;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.data.domain.Sort;

@Table(name="wt_issue")
public class WtIssue
extends AbsModel {
    @Column(name="anser")
    @JsonProperty(value="anser")
    private String anser;
    @Column(name="display_order")
    @JsonProperty(value="display_order")
    private Integer displayOrder;
    @Column(name="issue_name")
    @JsonProperty(value="issue_name")
    private String issueName;
    @Column(name="issue_uuid")
    @JsonProperty(value="issue_uuid")
    private String issueUuid;
    @Column(name="patch_memo")
    @JsonProperty(value="patch_memo")
    private String patchMemo;
    List<QueryTagsRelationReturn> tags;
    @Transient
    @JsonIgnore
    private Where<WtIssue> where = Where.getInstance((AbsModel)this);
    @Transient
    @JsonIgnore
    private GroupBy<WtIssue> groupby = GroupBy.getInstance((AbsModel)this);
    @Transient
    public static final Field ANSER = new Field("anser", "anser");
    @Transient
    public static final Field ISSUE_NAME = new Field("issueName", "issue_name");
    @Transient
    public static final Field ISSUE_UUID = new Field("issueUuid", "issue_uuid");
    @Transient
    public static final Field PATCH_MEMO = new Field("patchMemo", "patch_memo");
    @Transient
    public static final Field DISPLAY_ORDER = new Field("displayOrder", "display_order");

    public WtIssue() {
    }

    public WtIssue(boolean appendWhere) {
        super(appendWhere);
    }

    public Return checkValue() {
        String patchMemo;
        String issueUuid;
        String issueName;
        Return ret = new Return();
        String anser = StrUtils.trimStr((Object)this.anser);
        if (anser.length() > 2048) {
            ret.setFailMsg("[]\u4e0d\u80fd\u8d85\u8fc7[2048]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + anser.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.anser)) {
            ret.setFailMsg("[]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((issueName = StrUtils.trimStr((Object)this.issueName)).length() > 256) {
            ret.setFailMsg("[]\u4e0d\u80fd\u8d85\u8fc7[256]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + issueName.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.issueName)) {
            ret.setFailMsg("[]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((issueUuid = StrUtils.trimStr((Object)this.issueUuid)).length() > 64) {
            ret.setFailMsg("[]\u4e0d\u80fd\u8d85\u8fc7[64]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + issueUuid.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.issueUuid)) {
            ret.setFailMsg("[]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StrUtils.isNull((Object)this.displayOrder) && !StrUtils.isNum((Object)this.displayOrder)) {
            ret.setFailMsg("[\u663e\u793a\u987a\u5e8f]\u5fc5\u987b\u4e3a\u6570\u5b57\uff0c\u5b9e\u9645\u4e3a[" + this.displayOrder + "]");
        }
        if ((patchMemo = StrUtils.trimStr((Object)this.patchMemo)).length() > 32) {
            ret.setFailMsg("[]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + patchMemo.length() + "]\u4f4d");
        }
        return ret;
    }

    public WtIssue setAnser(String anser) {
        this.anser = anser;
        this.where().setChangeColumn(ANSER);
        return this;
    }

    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    public WtIssue setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
        this.where().setChangeColumn(ComponentAttribute.DISPLAY_ORDER);
        return this;
    }

    public String getAnser() {
        return this.anser;
    }

    public WtIssue setIssueName(String issueName) {
        this.issueName = issueName;
        this.where().setChangeColumn(ISSUE_NAME);
        return this;
    }

    public String getIssueName() {
        return this.issueName;
    }

    public WtIssue setIssueUuid(String issueUuid) {
        this.issueUuid = issueUuid;
        this.where().setChangeColumn(ISSUE_UUID);
        return this;
    }

    public String getIssueUuid() {
        return this.issueUuid;
    }

    public WtIssue setPatchMemo(String patchMemo) {
        this.patchMemo = patchMemo;
        this.where().setChangeColumn(PATCH_MEMO);
        return this;
    }

    public String getPatchMemo() {
        return this.patchMemo;
    }

    @JsonIgnore
    public WtIssue select(Field ... fields) {
        super.select(fields);
        return this;
    }

    @JsonIgnore
    public Where<WtIssue> where() {
        return this.where;
    }

    @JsonIgnore
    public GroupBy<WtIssue> groupBy() {
        return this.groupby;
    }

    @JsonIgnore
    public WtIssue setOrderBy(Sort.Order ... order) {
        super.setOrderBy(order);
        return this;
    }

    @JsonIgnore
    public static WtIssue n() {
        return new WtIssue();
    }

    @JsonIgnore
    public static WtIssue n(boolean appendWhere) {
        return new WtIssue(appendWhere);
    }

    public List<QueryTagsRelationReturn> getTags() {
        return this.tags;
    }

    public void setTags(List<QueryTagsRelationReturn> tags) {
        this.tags = tags;
    }
}

