/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.web.controller;

import com.newtouch.base.service.SysDataService;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/sysData"})
public class SysDataController {
    @Autowired
    private SysDataService sysDataService;

    @RequestMapping(value={"/uploadFile", "/uploadFile.do"})
    public String uploadFile(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String fileType = map.get("fileType");
        MultipartFile file = ((MultipartHttpServletRequest)request).getFile("file");
        ReturnMsg msg = this.sysDataService.uploadFile(file, fileType);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/downloadFile", "/downloadFile.do"})
    public String downloadFile(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Map param = map.getParam();
        String key = map.get("key");
        ReturnMsg msg = this.sysDataService.downloadFile(key, response);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @GetMapping(value={"/getObjectStorage"})
    public String getObjectStorage(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="imagePath") String imagePath) {
        ReturnMsg msg = this.sysDataService.getObjectStorage(imagePath, response);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @GetMapping(value={"/hwyObsListAllMyBuckets"})
    public String hwyObsListAllMyBuckets() {
        ReturnMsg msg = this.sysDataService.hwyObsListAllMyBuckets();
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/putObjectToBucket", "/putObjectToBucket.do"})
    public String putObjectToBucket(HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String fileType = map.get("fileType");
        MultipartFile file = ((MultipartHttpServletRequest)request).getFile("file");
        ReturnMsg msg = this.sysDataService.putObjectToBucket(file, fileType);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/downloadObjectFromBucket", "/downloadObjectFromBucket.do"})
    public String downloadObjectFromBucket(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        String objectPath = map.get("objectPath");
        ReturnMsg msg = this.sysDataService.downloadObjectFromBucket(objectPath, response);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }

    @RequestMapping(value={"/getObjectStorageNew", "/getObjectStorageNew.do"})
    public String getObjectStorageNew(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="imagePath") String imagePath) {
        ReturnMsg msg = this.sysDataService.downloadObjectFromBucket(imagePath, response);
        return RequestUtils.return2Json((ReturnMsg)msg);
    }
}

