/*
 * Decompiled with CFR 0.152.
 */
package com.newtouch.base.utils;

import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.pojo.Message;
import com.uniapis.utils.StrUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

public class FilesUtil
extends FileUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final String ALLOW_SUFFIX = ".zip";
    private static final String FILE_SUFFIX = "GIF,JPG,JPEG,PNG,MP4,PDF,HTML,gif,jpg,jpeg,png,mp4,pdf,html";

    public static void zip(String targetSrc, String zipSrc, String zipName) throws IOException {
        if (StrUtils.isNull((Object)targetSrc) || StrUtils.isNull((Object)zipSrc)) {
            throw new IOException("\u538b\u7f29\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FilesUtil.zip(new File(targetSrc), new File(zipSrc), zipName);
    }

    public static void zip(File targetSrc, File zipSrc, String zipName) throws IOException {
        if (targetSrc == null || !targetSrc.exists()) {
            throw new IOException("\u5e26\u538b\u7f29\u6587\u4ef6\u4e3a\u7a7a");
        }
        if (targetSrc.isFile()) {
            FilesUtil.zipFile(targetSrc, zipSrc, zipName);
        } else if (targetSrc.isDirectory()) {
            FilesUtil.zipDirectory(targetSrc, zipSrc, zipName);
        }
    }

    public static OutputStream zip(String targetSrc, OutputStream outputStream) throws IOException {
        if (StrUtils.isNull((Object)targetSrc)) {
            throw new IOException("\u5e26\u538b\u7f29\u6587\u4ef6\u4e3a\u7a7a");
        }
        return FilesUtil.zip(new File(targetSrc), outputStream);
    }

    public static OutputStream zip(File targetSrc, OutputStream outputStream) throws IOException {
        if (targetSrc == null || !targetSrc.exists()) {
            throw new IOException("\u5e26\u538b\u7f29\u6587\u4ef6\u4e3a\u7a7a");
        }
        if (targetSrc.isFile()) {
            FilesUtil.zipFile(targetSrc, outputStream);
        } else if (targetSrc.isDirectory()) {
            FilesUtil.zipDirectory(targetSrc, outputStream);
        }
        return outputStream;
    }

    public static InputStream zipToInputStream(String targetSrc) throws IOException {
        if (StrUtils.isNull((Object)targetSrc)) {
            throw new IOException("\u5e26\u538b\u7f29\u6587\u4ef6\u4e3a\u7a7a");
        }
        return FilesUtil.zipToInputStream(new File(targetSrc));
    }

    /*
     * Exception decompiling
     */
    public static InputStream zipToInputStream(File targetSrc) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static InputStream zip(List<String> paths, List<InputStream> inputStreams) throws IOException {
        if (ObjectUtils.isEmpty(paths) || ObjectUtils.isEmpty(inputStreams)) {
            throw new IllegalArgumentException("Paths or inputStreams is empty !");
        }
        if (paths.size() != inputStreams.size()) {
            throw new IllegalArgumentException("Paths length is not equals to inputStreams length !");
        }
        return FilesUtil.zip(paths.toArray(new String[0]), inputStreams.toArray(new InputStream[0]));
    }

    /*
     * Exception decompiling
     */
    public static InputStream zip(String[] paths, InputStream[] inputStreams) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void zip(OutputStream outputStream, String[] paths, InputStream[] inputStreams) throws IOException {
        if (ObjectUtils.isEmpty((Object[])paths) || ObjectUtils.isEmpty((Object[])inputStreams)) {
            throw new IllegalArgumentException("Paths or inputStreams is empty !");
        }
        if (paths.length != inputStreams.length) {
            throw new IllegalArgumentException("Paths length is not equals to inputStreams length !");
        }
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            for (int i = 0; i < paths.length; ++i) {
                zipOutputStream.putNextEntry(new ZipEntry(paths[i]));
                byte[] bytes = new byte[4096];
                try {
                    int read;
                    while ((read = inputStreams[i].read(bytes)) != -1) {
                        zipOutputStream.write(bytes, 0, read);
                    }
                    zipOutputStream.closeEntry();
                    continue;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                finally {
                    if (inputStreams[i] != null) {
                        inputStreams[i].close();
                    }
                }
            }
        }
    }

    private static void zipFile(File targetSrc, File zipSrc, String zipName) throws IOException {
        if (!zipSrc.exists()) {
            zipSrc.mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(zipSrc.getAbsolutePath() + File.separator + zipName);){
            FilesUtil.zipFile(targetSrc, fileOutputStream);
        }
    }

    private static void zipDirectory(File targetSrc, File zipSrc, String zipName) throws IOException {
        if (!zipSrc.exists()) {
            zipSrc.mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(zipSrc.getAbsolutePath() + File.separator + zipName);){
            FilesUtil.zipDirectory(targetSrc, fileOutputStream);
        }
    }

    private static void zipFile(File targetSrc, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IOException("outputStream\u4e3a\u7a7a");
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        FilesUtil.zipFile(targetSrc, zipOutputStream);
    }

    private static void zipDirectory(File targetSrc, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IOException("outputStream\u4e3a\u7a7a");
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        FilesUtil.zipDirectory(targetSrc, zipOutputStream);
    }

    private static void zipFile(File targetSrc, ZipOutputStream zipOutputStream) throws IOException {
        try {
            FilesUtil.zipFile(targetSrc, "", zipOutputStream);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
    }

    private static void zipDirectory(File targetSrc, ZipOutputStream zipOutputStream) throws IOException {
        try {
            FilesUtil.zipDirectory(targetSrc, "", zipOutputStream);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
    }

    private static void zipFile(File targetSrc, String prefixPath, ZipOutputStream zipOutputStream) throws IOException {
        if (targetSrc == null || !targetSrc.isFile()) {
            throw new IOException("zipOutputStream\u4e3a\u7a7a");
        }
        if (zipOutputStream == null) {
            throw new IOException("zipOutputStream\u4e3a\u7a7a");
        }
        byte[] bytes = new byte[4096];
        zipOutputStream.putNextEntry(new ZipEntry(prefixPath + File.separator + targetSrc.getName()));
        try (FileInputStream fileInputStream = new FileInputStream(targetSrc);){
            int read;
            while ((read = fileInputStream.read(bytes)) != -1) {
                zipOutputStream.write(bytes, 0, read);
            }
            zipOutputStream.closeEntry();
        }
    }

    private static void zipDirectory(File targetSrc, String prefixPath, ZipOutputStream zipOutputStream) throws IOException {
        if (targetSrc == null || !targetSrc.exists()) {
            throw new IOException("\u5f85\u538b\u7f29\u76ee\u5f55\u4e0d\u5b58\u5728");
        }
        Object[] files = targetSrc.listFiles();
        if (ObjectUtils.isEmpty((Object[])files)) {
            return;
        }
        if (zipOutputStream == null) {
            throw new IOException("zipOutputStream\u4e3a\u7a7a");
        }
        for (Object file : files) {
            if (((File)file).isFile()) {
                FilesUtil.zipFile((File)file, prefixPath, zipOutputStream);
                continue;
            }
            FilesUtil.zipDirectory((File)file, prefixPath + File.separator + ((File)file).getName(), zipOutputStream);
        }
    }

    public static boolean delFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            Ulog.debug((String)(fileName + " \u6587\u4ef6\u4e0d\u5b58\u5728!"));
            return true;
        }
        if (file.isFile()) {
            return FilesUtil.deleteFile(fileName);
        }
        return FilesUtil.deleteDirectory(fileName);
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            if (file.delete()) {
                Ulog.debug((String)("\u5220\u9664\u6587\u4ef6 " + fileName + " \u6210\u529f!"));
                return true;
            }
            Ulog.debug((String)("\u5220\u9664\u6587\u4ef6 " + fileName + " \u5931\u8d25!"));
            return false;
        }
        Ulog.debug((String)(fileName + " \u6587\u4ef6\u4e0d\u5b58\u5728!"));
        return true;
    }

    public static boolean deleteDirectory(String dirName) {
        File dirFile;
        String dirNames = dirName;
        if (!dirNames.endsWith(File.separator)) {
            dirNames = dirNames + File.separator;
        }
        if (!(dirFile = new File(dirNames)).exists() || !dirFile.isDirectory()) {
            Ulog.debug((String)(dirNames + " \u76ee\u5f55\u4e0d\u5b58\u5728!"));
            return true;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = FilesUtil.deleteFile(files[i].getAbsolutePath())) : files[i].isDirectory() && !(flag = FilesUtil.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            Ulog.debug((String)"\u5220\u9664\u76ee\u5f55\u5931\u8d25!");
            return false;
        }
        if (dirFile.delete()) {
            Ulog.debug((String)("\u5220\u9664\u76ee\u5f55 " + dirName + " \u6210\u529f!"));
            return true;
        }
        Ulog.debug((String)("\u5220\u9664\u76ee\u5f55 " + dirName + " \u5931\u8d25!"));
        return false;
    }

    public static boolean createFile(String descFileName) {
        File file = new File(descFileName);
        if (file.exists()) {
            Ulog.debug((String)("\u6587\u4ef6 " + descFileName + " \u5df2\u5b58\u5728!"));
            return false;
        }
        if (descFileName.endsWith(File.separator)) {
            Ulog.debug((String)(descFileName + " \u4e3a\u76ee\u5f55\uff0c\u4e0d\u80fd\u521b\u5efa\u76ee\u5f55!"));
            return false;
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            Ulog.debug((String)"\u521b\u5efa\u6587\u4ef6\u6240\u5728\u7684\u76ee\u5f55\u5931\u8d25!");
            return false;
        }
        try {
            if (file.createNewFile()) {
                Ulog.debug((String)(descFileName + " \u6587\u4ef6\u521b\u5efa\u6210\u529f!"));
                return true;
            }
            Ulog.debug((String)(descFileName + " \u6587\u4ef6\u521b\u5efa\u5931\u8d25!"));
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            Ulog.debug((String)(descFileName + " \u6587\u4ef6\u521b\u5efa\u5931\u8d25!"));
            return false;
        }
    }

    public static boolean createDirectory(String descDirName) {
        File descDir;
        String descDirNames = descDirName;
        if (!descDirNames.endsWith(File.separator)) {
            descDirNames = descDirNames + File.separator;
        }
        if ((descDir = new File(descDirNames)).exists()) {
            Ulog.debug((String)("\u76ee\u5f55 " + descDirNames + " \u5df2\u5b58\u5728!"));
            return false;
        }
        if (descDir.mkdirs()) {
            Ulog.debug((String)("\u76ee\u5f55 " + descDirNames + " \u521b\u5efa\u6210\u529f!"));
            return true;
        }
        Ulog.debug((String)("\u76ee\u5f55 " + descDirNames + " \u521b\u5efa\u5931\u8d25!"));
        return false;
    }

    public static void writeToFile(String fileName, String content, boolean append) {
        try {
            FilesUtil.write((File)new File(fileName), (CharSequence)content, (String)"utf-8", (boolean)append);
            Ulog.debug((String)("\u6587\u4ef6 " + fileName + " \u5199\u5165\u6210\u529f!"));
        }
        catch (IOException e) {
            Ulog.debug((String)("\u6587\u4ef6 " + fileName + " \u5199\u5165\u5931\u8d25! " + e.getMessage()));
        }
    }

    public static void writeToFile(String fileName, String content, String encoding, boolean append) {
        try {
            FilesUtil.write((File)new File(fileName), (CharSequence)content, (String)encoding, (boolean)append);
            Ulog.debug((String)("\u6587\u4ef6 " + fileName + " \u5199\u5165\u6210\u529f!"));
        }
        catch (IOException e) {
            Ulog.debug((String)("\u6587\u4ef6 " + fileName + " \u5199\u5165\u5931\u8d25! " + e.getMessage()));
        }
    }

    public static List<String> unZip(File srcFile, String destDirPath) throws RuntimeException {
        ArrayList<String> filesName = new ArrayList<String>();
        long start = System.currentTimeMillis();
        if (!srcFile.exists()) {
            throw new RuntimeException(srcFile.getPath() + "\u6240\u6307\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(srcFile, Charset.forName("GBK"));
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                filesName.add(entry.getName());
                System.out.println("\u89e3\u538b\u6587\u4ef6:" + entry.getName());
                if (entry.isDirectory()) {
                    String dirPath = destDirPath + "/" + entry.getName();
                    File dir = new File(dirPath);
                    dir.mkdirs();
                    continue;
                }
                File targetFile = new File(destDirPath + "/" + entry.getName());
                if (!targetFile.getParentFile().exists()) {
                    targetFile.getParentFile().mkdirs();
                }
                targetFile.createNewFile();
                InputStream is = zipFile.getInputStream(entry);
                FileOutputStream fos = new FileOutputStream(targetFile);
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
                fos.close();
                is.close();
            }
            long end = System.currentTimeMillis();
            System.out.println("\u89e3\u538b\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (end - start) + " ms");
        }
        catch (Exception e) {
            throw new RuntimeException("unzip error from ZipUtils", e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return filesName;
    }

    public static List<File> unZipFiles(File sourceFile, String descDir) throws IOException {
        ArrayList<File> returnList = new ArrayList<File>();
        File descDirFile = new File(descDir);
        if (!descDirFile.exists()) {
            descDirFile.mkdirs();
        }
        ZipFile zip = new ZipFile(sourceFile, Charset.forName("GBK"));
        String orgMkdirs = "";
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String zipEntryName = entry.getName();
            String outPath = (descDir + "/" + zipEntryName).replaceAll("\\*", "/");
            File file = new File(outPath.substring(0, outPath.lastIndexOf(47)));
            if (!file.exists()) {
                file.mkdirs();
            }
            orgMkdirs = outPath.substring(0, outPath.lastIndexOf(47));
            if (new File(outPath).isDirectory()) continue;
            File endFile = new File(outPath);
            returnList.add(endFile);
            try {
                InputStream in = zip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream out = new FileOutputStream(outPath);
                    Throwable throwable2 = null;
                    try {
                        int len;
                        byte[] buf1 = new byte[1024];
                        while ((len = in.read(buf1)) > 0) {
                            ((OutputStream)out).write(buf1, 0, len);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                Ulog.error((String)"\u89e3\u538b\u5931\u8d25!");
                Ulog.error((String)e.getMessage());
            }
        }
        zip.close();
        return returnList;
    }

    public static Return unzipFile(MultipartFile file, String path) {
        String fileName = file.getOriginalFilename();
        long fileSize = file.getSize();
        Return msg = FilesUtil.checkFile(fileName, fileSize);
        try {
            File destFile = new File(path);
            if (!destFile.exists()) {
                destFile.mkdirs();
            }
            com.uniapis.utils.FileUtils.unzip((InputStream)file.getInputStream(), (String)path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return msg;
    }

    public static Return checkFile(String fileName, long fileSize) {
        String suffix;
        Return msg = new Return();
        if (fileName.indexOf(".") < 0) {
            msg.setFailMsg(new Message("6030004", "\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[.zip]\u7684\u6587\u4ef6"));
        }
        if (ALLOW_SUFFIX.indexOf(suffix = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase()) == -1) {
            msg.setFailMsg(new Message("6030004", "\u53ea\u80fd\u4e0a\u4f20\u6269\u5c55\u540d\u4e3a[.zip]\u7684\u6587\u4ef6"));
        }
        if (fileSize <= 0L) {
            msg.setFailMsg(new Message("6030004", "\u6587\u4ef6\u5fc5\u987b\u5927\u4e8e0KB"));
        }
        return msg;
    }

    public static void getAllFiles(File dir, List<File> file) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FilesUtil.getAllFiles(files[i], file);
                continue;
            }
            String name = files[i].getName();
            if (name.endsWith(".json")) {
                File file1 = files[i];
                file.add(file1);
            }
            Ulog.info((Object)files[i]);
        }
    }

    public static void getAllFiles(File dir, List<File> jsonList, List<File> fileList) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FilesUtil.getAllFiles(files[i], jsonList, fileList);
                continue;
            }
            String name = files[i].getName();
            if (name.endsWith(".json")) {
                File file1 = files[i];
                jsonList.add(file1);
            }
            String suffix = name.substring(name.lastIndexOf(".") + 1);
            List<String> fileSuffixList = Arrays.asList(FILE_SUFFIX.split(","));
            if (fileSuffixList.contains(suffix)) {
                File file1 = files[i];
                fileList.add(file1);
            }
            Ulog.info((Object)files[i]);
        }
    }
}

